/*
 * $Id: st-stream-view.h,v 1.12 2004/01/05 19:44:10 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_STREAM_VIEW_H
#define _ST_STREAM_VIEW_H

#include <gtk/gtk.h>
#include "st-browser-tab.h"
#include "st-stream-menu-items.h"

#define ST_TYPE_STREAM_VIEW		(st_stream_view_get_type())
#define ST_STREAM_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_STREAM_VIEW, STStreamView))
#define ST_STREAM_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_STREAM_VIEW, STStreamViewClass))
#define ST_IS_STREAM_VIEW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_STREAM_VIEW))
#define ST_IS_STREAM_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_STREAM_VIEW))
#define ST_STREAM_VIEW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_STREAM_VIEW, STStreamViewClass))

typedef struct
{
  GtkTreeView		view;

  STBrowserTab		*tab;			/* public, the parent tab */
  GtkListStore		*store;

  GtkWidget		*column_menu;
  GtkWidget		*columns_menu;		/* public */

  guint			selection_changed_hid;

  STStreamMenuItems	*menu_items;
} STStreamView;

typedef struct
{
  GtkTreeViewClass	parent_class;
} STStreamViewClass;

GType		st_stream_view_get_type		   (void);
GtkWidget	*st_stream_view_new		   (STBrowserTab  *tab);
void		st_stream_view_append_streams	   (STStreamView  *view,
						    GList	  *streams);
void		st_stream_view_clear		   (STStreamView  *view);
void		st_stream_view_update_sensitivity  (STStreamView  *view);

#endif /* _ST_STREAM_VIEW_H */
