/*
 * $Id: st-plugin.c,v 1.7 2004/01/05 19:44:10 jylefort Exp $
 *
 * Copyright (c) 2002, 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <glib.h>
#include <gmodule.h>
#include "gettext.h"
#include "st-plugin.h"
#include "st-plugins.h"

/*** variable declarations ***************************************************/

/* FIXME: ugly, remove it when we'll change st_handlers_add() */
const char *st_plugin_current;		/* plugin being loaded */

/*** implementation **********************************************************/

gboolean
st_plugin_load (const char *filename, GError **err)
{
  GModule *module;
  STPluginInitCallback *cb;
  GError *init_err = NULL;
  
  g_return_val_if_fail(filename != NULL, FALSE);

  if (! (module = g_module_open(filename, 0)))
    {
      g_set_error(err, 0, 0, "%s", g_module_error());
      return FALSE;
    }
  
  if (! g_module_symbol(module, "plugin_init", (gpointer *) &cb))
    {
      g_set_error(err, 0, 0, _("unable to find plugin_init()"));
      return FALSE;
    }
  
  st_plugin_current = filename;

  if (! (*cb)(&init_err))
    {
      g_set_error(err, 0, 0, _("unable to initialize: %s"), init_err->message);
      g_error_free(init_err);
      return FALSE;
    }
  
  st_plugin_current = NULL;
  
  /*
   * FIXME: this is just a quick kludge to be able to list the loaded plugins
   * from the about window. At the next API break, we must introduce
   * the STPlugin object.
   */
  st_plugins_list = g_slist_append(st_plugins_list, g_strdup(filename));

  return TRUE;
}
