/*
 * $Id: st-browser-window.h,v 1.15 2004/01/27 14:16:42 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_BROWSER_WINDOW_H
#define _ST_BROWSER_WINDOW_H

#include <gtk/gtk.h>
#include "st-browser-tab.h"
#include "st-handler.h"

#define ST_TYPE_BROWSER_WINDOW			(st_browser_window_get_type())
#define ST_BROWSER_WINDOW(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_BROWSER_WINDOW, STBrowserWindow))
#define ST_BROWSER_WINDOW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_BROWSER_WINDOW, STBrowserWindowClass))
#define ST_IS_BROWSER_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_BROWSER_WINDOW))
#define ST_IS_BROWSER_WINDOW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_BROWSER_WINDOW))
#define ST_BROWSER_WINDOW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_BROWSER_WINDOW, STBrowserWindowClass))

typedef struct
{
  GtkWindow		window;

  GtkAccelGroup		*accel_group;		/* public */

  GtkWidget		*box;

  GtkWidget		*menubar;		/* public */
  GtkWidget		*toolbar;		/* public */
  GtkWidget		*notebook;
  GtkWidget		*statusbox;

  guint			switch_page_id;

  GSList		*tabs;
  STBrowserTab		*tab;			/* currently selected tab */
} STBrowserWindow;

typedef struct
{
  GtkWindowClass	parent_class;
} STBrowserWindowClass;

GType		st_browser_window_get_type	(void);
GtkWidget	*st_browser_window_new		(void);

void st_browser_window_update_title		(STBrowserWindow *window);
void st_browser_window_update_visibility	(STBrowserWindow *window);
void st_browser_window_update_toolbar_style	(STBrowserWindow *window);
void st_browser_window_update_toolbar_size	(STBrowserWindow *window);
void st_browser_window_update_sensitivity	(STBrowserWindow *window);

void st_browser_window_set_tab_from_handler	(STBrowserWindow *window,
						 STHandler	 *handler);

void st_browser_window_previous_tab		(STBrowserWindow *window);
void st_browser_window_next_tab			(STBrowserWindow *window);

void st_browser_window_abort_all		(STBrowserWindow *window);

#endif /* _ST_BROWSER_WINDOW_H */
