/*
 * $Id: sgtk-message-dialog.c,v 1.10 2004/01/05 19:44:09 jylefort Exp $
 *
 * Copyright (c) 2003 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <gtk/gtk.h>
#include "sgtk-message-dialog.h"
#include "sgtk-hig.h"

/*** function declarations ***************************************************/

static void sgtk_message_dialog_init (sGtkMessageDialog *dialog);

/*** implementation **********************************************************/

GType
sgtk_message_dialog_get_type (void)
{
  static GType message_dialog_type = 0;
  
  if (! message_dialog_type)
    {
      static const GTypeInfo message_dialog_info = {
	sizeof(sGtkMessageDialogClass),
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	sizeof(sGtkMessageDialog),
	0,
	(GInstanceInitFunc) sgtk_message_dialog_init,
      };
      
      message_dialog_type = g_type_register_static(SGTK_TYPE_ALERT_DIALOG,
						   "sGtkMessageDialog",
						   &message_dialog_info,
						   0);
    }

  return message_dialog_type;
}

static void
sgtk_message_dialog_init (sGtkMessageDialog *dialog)
{
  dialog->label = gtk_label_new(NULL);
  gtk_misc_set_alignment(GTK_MISC(dialog->label),
			 SGTK_HIG_ALERT_LABEL_X_ALIGN,
			 SGTK_HIG_ALERT_LABEL_Y_ALIGN);

  gtk_label_set_use_markup(GTK_LABEL(dialog->label), TRUE);
  gtk_label_set_selectable(GTK_LABEL(dialog->label), TRUE);
  gtk_label_set_line_wrap(GTK_LABEL(dialog->label), TRUE);

  gtk_box_pack_start(GTK_BOX(SGTK_ALERT_DIALOG(dialog)->hbox), dialog->label, TRUE, TRUE, 0);
  gtk_widget_show(dialog->label);
}

GtkWidget *
sgtk_message_dialog_new (GtkWindow *parent,
			 const char *stock_id,
			 const char *primary,
			 const char *secondary)
{
  sGtkMessageDialog *dialog;
  GString *message;

  dialog = g_object_new(SGTK_TYPE_MESSAGE_DIALOG, NULL);

  if (parent)
    gtk_window_set_transient_for(GTK_WINDOW(dialog), parent);

  if (stock_id)
    gtk_image_set_from_stock(GTK_IMAGE(SGTK_ALERT_DIALOG(dialog)->image),
			     stock_id,
			     GTK_ICON_SIZE_DIALOG);

  message = g_string_new(NULL);

  if (primary)
    g_string_printf(message,
		    "<span weight=\"bold\" size=\"larger\">%s</span>",
		    primary);

  if (secondary)
    {
      if (primary)
	g_string_append(message, "\n\n");

      g_string_append(message, secondary);
    }

  gtk_label_set_markup(GTK_LABEL(dialog->label), message->str);
  g_string_free(message, TRUE);

  return GTK_WIDGET(dialog);
}
