dnl Copyright (c) 2003, 2004 Jean-Yves Lefort
dnl All rights reserved.
dnl
dnl Redistribution and use in source and binary forms, with or without
dnl modification, are permitted provided that the following conditions
dnl are met:
dnl 1. Redistributions of source code must retain the above copyright
dnl    notice, this list of conditions and the following disclaimer.
dnl 2. Redistributions in binary form must reproduce the above copyright
dnl    notice, this list of conditions and the following disclaimer in the
dnl    documentation and/or other materials provided with the distribution.
dnl 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
dnl    may be used to endorse or promote products derived from this software
dnl    without specific prior written permission.
dnl 
dnl THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
dnl CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
dnl INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
dnl MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
dnl DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
dnl BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
dnl EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
dnl TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
dnl DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
dnl ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
dnl OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
dnl OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
dnl POSSIBILITY OF SUCH DAMAGE.
dnl 
divert(-1)
dnl ***
dnl *** the support m4 functions...
dnl ***

changequote([, ])

define(STC_SELF, streamtuner-theme-convert)

dnl STC_ERROR_IF_SUCCEED(TEST, MESSAGE)
define(STC_ERROR_IF_SUCCEED,
[if $1; then
	echo "STC_SELF: $2"
	exit 1
fi])

dnl STC_ERROR_IF_FAIL(TEST, MESSAGE)
define(STC_ERROR_IF_FAIL,
[if $1; then :; else
	echo "STC_SELF: $2"
	exit 1
fi])

dnl STC_FIND_SINGLE(VARIABLE, NAME)
define(STC_FIND_SINGLE,
[test -f "$indir/$2.png" && $1="$indir/$2.png"
test -f "$indir/$2-prelight.png" && $1_prelight="$indir/$2-prelight.png"])

dnl STC_FIND(VARIABLE, GALEON-NAME, STREAMTUNER-NAME)
define(STC_FIND,
[$1=
$1_prelight=
STC_FIND_SINGLE([$1], [$2])
STC_FIND_SINGLE([$1], [$3])])

dnl STC_CONVERT(VARIABLE, STOCK-NAME)
define(STC_CONVERT,
[if test -z "$$1"; then :; else
	cp -f "$$1" "$gtkdir/$2.png"
	cat <<EOF >> "$gtkrc"
	stock[["$2"]] =
	{
EOF

	if test -z "$$1_prelight"; then
		cat <<EOF >> "$gtkrc"
		{ "$2.png",		*, *,		* }
	}
EOF
	else
		cp -f "$$1_prelight" "$gtkdir/$2-prelight.png"
		cat <<EOF >> "$gtkrc"
		{ "$2.png",		*, *,		* },
		{ "$2-prelight.png",	*, PRELIGHT,	* }
	}
EOF
	fi
fi])

divert()dnl
dnl ***
dnl *** ...and the sh script
dnl ***
# !/bin/sh
#
# streamtuner-theme-convert
# A script converting streamtuner and Galeon themes to GTK+ themes.
#
# Generated automatically from streamtuner-theme-convert.m4.
# Do not edit this file directly.
#
# Copyright (c) 2003, 2004 Jean-Yves Lefort
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

if test $# -ne 2; then
	echo "Usage: STC_SELF SOURCE_DIRECTORY TARGET_DIRECTORY"
	exit 1
fi

indir="$1"
outdir="$2"

gtkdir="$outdir/gtk-2.0"
gtkrc="$gtkdir/gtkrc"

# sanity checks

STC_ERROR_IF_FAIL(test -e "$indir", [$indir not found])
STC_ERROR_IF_FAIL(test -d "$indir", [$indir is not a directory])
STC_ERROR_IF_SUCCEED(test -e "$outdir", [$outdir exists, refusing to overwrite])

# find images

STC_FIND(img_tune_in, Forward, tune_in)
STC_FIND(img_record, New, record)
STC_FIND(img_browse, Home, browse)

# convert theme

STC_ERROR_IF_FAIL(mkdir -p "$gtkdir", [unable to create $gtkdir])

cat <<EOF > "$gtkrc"
style "streamtuner"
{
EOF

STC_CONVERT(img_tune_in, st-tune-in)
STC_CONVERT(img_record, st-record)
STC_CONVERT(img_browse, st-browse)

cat <<EOF >> "$gtkrc"
}

widget_class "*" style "streamtuner"
EOF
