import straw
import gnome.vfs

def export(title, list, fname):
    opml = straw.OPML.OPML()
    opml['title'] = title
    for feed in list:
        o = straw.OPML.Outline()
        o['text'] = feed.title.encode('utf-8')
        o['description'] = feed.channel_description.encode('utf-8')
        o['htmlUrl'] = feed.channel_link
        o['language'] = 'unknown'
        o['title'] = feed.channel_title.encode('utf-8')
        o['type'] = 'rss'
        o['version'] = 'RSS'
        o['xmlUrl'] = feed.access_info[0]
        opml.outlines.append(o)
    f = gnome.vfs.create(fname, gnome.vfs.OPEN_WRITE, 0)
    f.write('<?xml version="1.0"?>\n')
    opml.output(f)
    f.close()


