# dunno if this really makes any sense performance-wise, but it's a nice
# abstraction

cvs_id = "$Id: QueueDict.py,v 1.6 2003/11/04 00:18:28 jmalonzo Exp $"

class QDIterator:
    def __init__(self, qd):
        self._qd = qd
        self._index = -1

    def __iter__(self):
        return self

    def next(self):
        self._index += 1
        if self._index < self._qd.queue_size:
            return self._qd.get_item_by_index(self._index)
        else:
            raise StopIteration

class QueueDict(dict):
    def __init__(self):
        dict.__init__(self)
        self._queue = []
        self._qsize = 0
        self._reverse = 0

    def set_item(self, key, value):
        deletee = None
        if dict.has_key(self, key):
            deletee = self.__getitem__(key)
            dict.__setitem__(self, key, value)
            self._queue.remove(key)
            self._queue.append(key)
        else:
            dict.__setitem__(self, key, value)
            self._queue.append(key)
            self._qsize += 1
        return deletee

    def cut(self, point):
        remove_items = []
        remove_ids = self._queue[:-point]
        for r in remove_ids:
            remove_items.append(self[r])
            dict.__delitem__(self, r)
        self._queue = self._queue[-point:]
        self._qsize = len(self._queue)
        return remove_items

    def __setitem__(self, key, value):
        raise NotImplementedException, "use set_item"

    def __delitem__(self, key):
        dict.__delitem__(self, key)
        self._qsize -= 1
        self._queue.remove(key)

    def index(self, key):
        return self._queue.index(key)

    def get_item_by_index(self, index):
        if self._reverse:
            return self[self._queue[self._qsize - index - 1]]
        return self[self._queue[index]]

    def get_first_item(self):
        if not self._queue:
            return None
        if self._reverse:
            return self[self._queue[-1]]
        return self[self._queue[0]]

    def get_last_item(self):
        if not self._queue:
            return None
        if self._reverse:
            return self[self._queue[0]]
        return self[self._queue[-1]]

    def get_queue_size(self):
        return self._qsize

    queue_size = property(get_queue_size, None, None, "")

    def set_reverse(self, reverse):
        self._reverse = reverse

    def __iter__(self):
        return QDIterator(self)

# naive implementation, do binary search some other time
class OrderedKeyDict(QueueDict):
    def get_next_larger_key(self, key):
        i = self._queue.index(key) + 1
        id = None
        if i < len(self._queue):
            id = self._queue[i]
        return id

    def get_next_smaller_key(self, key):
        i = self._queue.index(key)
        id = None
        if i > 0:
            id = self._queue[i - 1]
        return id

# all this subclassing is getting a bit silly
class FeedQD(OrderedKeyDict):
    def cut(self, point):
        remove_items = []
        nq = []
        try:
            nonsticky = 0
            loop = range(len(self._queue))
            loop.reverse()
            for qi in loop:
                fid = self._queue[qi]
                feed = self[fid]
                if feed.sticky:
                    nq.append(fid)
                else:
                    if nonsticky < point:
                        nq.append(fid)
                        nonsticky += 1
                    else:
                        remove_items.append(feed)
                        dict.__delitem__(self, fid)
            nq.reverse()
            self._queue = nq
            self._qsize = len(self._queue)
        except Exception, ex:
            raise ex
        return remove_items
