cvs_id = "$Id: OPMLImport.py,v 1.3 2003/03/16 09:30:56 juri Exp $"

import OPML

class BlogListEntry(object):
    __slots__ = ('text', 'type', 'url', 'xmlurl', 'description', 'language',
                 'title', 'version')

    def __init__(self):
        self.xmlurl = None
        self.description = None
        self.language = None
        self.title = None
        self.version = None

def _find_entries(outline):
    entries = []
    for c in outline.children:
        entries += _find_entries(c)
    type = outline.get('type', '')
    text = outline.get('text', '')
    e = None
    if type == 'link':
        url = outline.get('url', '')
        if url != '':
            e = BlogListEntry()
            e.type = type
            e.text = text
            e.url = url
    elif type == 'rss':
        url = outline.get('htmlUrl', '')
        xmlurl = outline.get('xmlUrl', '')
        if url != '' and xmlurl != '':
            e = BlogListEntry()
            e.type = type
            e.text = text
            e.url = url
            e.xmlurl = xmlurl
            e.description = outline.get('description', '')
            e.language = outline.get('language', '')
            e.title = outline.get('title', '')
            e.version = outline.get('version', '')
    if e is not None:
        entries[0:0] = [e]
    return entries

def find_entries(outlines):
    entries = []
    for o in outlines:
        entries += _find_entries(o)
    return entries

def read(stream):
    try:
        o = OPML.parse(stream)
    except ValueError:
        return None
    entries = find_entries(o.outlines)
    ret = []
    edict = {}
    for e in entries:
        ek = (e.text, e.type, e.url)
        edict[ek] = edict.get(ek, 0) + 1
        if edict[ek] < 2:
            ret.append(e)
    return ret

