cvs_id = "$Id: ImageCache.py,v 1.18 2003/11/03 17:59:18 juri Exp $"

import straw

from weakref import WeakValueDictionary
import traceback
from error import log, logtb, logparam

STATUS_IMAGE_WAITING = None
STATUS_IMAGE_BROKEN = None

class Cache(straw.SignalEmitter):
    """Image cache with explicit reference counting."""
    def __init__(self):
        straw.SignalEmitter.__init__(self)
        self.initialize_slots(straw.ImageUpdatedSignal)
        # self.__cache contains items of the form [Image, refcount]
        self.__cache = {}

    def __getitem__(self, key):
        return self.__cache[key][0]
     
    def add_refer(self, key, restore = False, item = None):
        if key not in self.__cache:
            if not restore:
                # fetch image
                image = Image(key, Image.WAITING)
                ic = ImageConsumer(image)
                headers = {}
                if item and item.feed:
                    headers['Referer'] = item.feed.location
                try:
                    straw.URLFetch.connection_manager.request(
                        key, ic,
                        priority=straw.NetworkConstants.PRIORITY_IMAGE,
                        headers=headers)
                except straw.URLFetch.RequestSchemeException, e:
                    ic.http_failed(e)
                except Exception, e:
                    logtb("something went wrong: ", str(e))
                    ic.http_failed(e)
                self.__cache[key] = [image, 1]
            else:
                image = Image(key, Image.DATA_IN_DB)
                self.__cache[key] = [image, 1]
        else:
            self.__cache[key][1] += 1

    def remove_refer(self, key):
        self.__cache[key][1] -= 1
        if self.__cache[key][1] == 0:
            image = self.__cache[key]
            del self.__cache[key]
            self.emit_signal(straw.ImageUpdatedSignal(self, key, None))

    def image_updated(self, url, data):
        self.emit_signal(straw.ImageUpdatedSignal(self, url, data))

    def set_image(self, url, image):
        count = 0
        pair = self.__cache.get(url, None)
        if pair is not None:
            count = pair[1]
        self.__cache[url] = [image, count + 1]

class Image:
    WAITING = 1
    DATA_IN_DB = 2
    FAILED = 3

    def __init__(self, url, status = DATA_IN_DB):
        self.url = url
        self.status = status

    def get_data(self):
        if self.status == self.WAITING:
            return STATUS_IMAGE_WAITING
        elif self.status == self.DATA_IN_DB:
            data = self.read_data()
            if data is None:
                self.status = self.FAILED
                return STATUS_IMAGE_BROKEN
            return data
        else:
            return STATUS_IMAGE_BROKEN

    def set_data(self, data):
        cache.image_updated(self.url, data)
        self.status = self.DATA_IN_DB

    def set_failed(self):
        self.status = self.FAILED

    def read_data(self):
        return straw.main._itemstore.read_image(self.url)

    def _return_id(self):
        return "%d %s" % (id(self), self.url)

cache = Cache()

class ImageConsumer:
    def __init__(self, imobj):
        self._imobj = imobj
    
    def http_results(self, status, headers, data):
        if status[1] == 200:
            self._imobj.set_data(data)
        else:
            self._imobj.set_failed()

    def http_failed(self, exception):
        self._imobj.set_failed()

def initialize():
    global STATUS_IMAGE_WAITING
    global STATUS_IMAGE_BROKEN
    STATUS_IMAGE_WAITING = open(
        straw.main._libdir + "/image-waiting.png").read()
    STATUS_IMAGE_BROKEN = open(
        straw.main._libdir + "/image-broken.png").read()
