#!/usr/bin/python

import unittest
import sys
import time

sys.path.insert(0, '../src')
import lib as straw

class LookupTestCase(unittest.TestCase):
    def setUp(self):
        self.lm = straw.LookupManager.get_instance()
        self.timeout = 10
        self.extraNames = (
            'www.simiandesign.com', 'blogs.werken.com', 'boingboing.net',
            'www.bigredswitch.com', 'www.cityofsound.com',
            'online.effbot.org', 'www.euro-cscl.org', 'freshmeat.net',
            'toulouse.amber.org', 'kottke.org')

    def _callback(self, name, ip, data=None):
        self.response = (name, ip)

    def testGoodARecord(self):
        self.response = None
        self.lm.lookup('www.google.com', self._callback)
        now = time.time()
        while not self.response:
            assert time.time() - now < self.timeout, 'Lookup timed out'
            self.lm.poll(1)
        assert self.response[1] is not None

    def testBadARecord(self):
        self.response = None
        # this has, at least at some point, returned a cname even though
        # asked for an a record
        self.lm.lookup('www.morestuff4less.com', self._callback)
        now = time.time()
        while not self.response:
            assert time.time() - now < self.timeout, 'Lookup timed out'
            self.lm.poll(1)
        assert self.response[1] is not None

    def testInvalidDomain(self):
        self.response = None
        self.lm.lookup('www.sdkfskdjjfsd.xcv', self._callback)
        now = time.time()
        while not self.response:
            assert time.time() - now < self.timeout, 'Lookup timed out'
            self.lm.poll(1)
        assert self.response[1] is None

    def _callback_multiple(self, name, ip, data=None):
        self.multiple_responses[name] = (name, ip)

    def testExtraNames(self):
        self.multiple_responses = {}
        for n in self.extraNames:
            self.multiple_responses[n] = None
            self.lm.lookup(n, self._callback_multiple)
        now = time.time()
        timeout = self.timeout * len(self.extraNames)
        while None in self.multiple_responses.values():
            assert time.time() - now < self.timeout, 'Lookup timed out'
            self.lm.poll(1)
        assert None not in self.multiple_responses.values()

def suite():
    suite = unittest.TestSuite()
    suite.addTest(LookupTestCase('testGoodARecord'))
    suite.addTest(LookupTestCase('testBadARecord'))
    suite.addTest(LookupTestCase('testInvalidDomain'))
    suite.addTest(LookupTestCase('testExtraNames'))
    return suite

if __name__ == '__main__':
    unittest.main()

                  
