"""
Modified by Jan Alonzo <jmalonzo@spaceants.org>.
Date: 28/09/2003

This is from Seth Nickell's gnome-blog.
http://www.gnome.org/~seth/gnome-blog

"""
import gtk
import straw

class HIGAlert(gtk.Dialog):
    def __init__(self, primaryText, secondaryText, parent=None, flags=0, buttons=None, status=None, 
                 icon=gtk.STOCK_DIALOG_ERROR):
        gtk.Dialog.__init__(self, '', parent, flags, buttons)

        self.set_border_width(6)
        self.set_has_separator(gtk.FALSE)
        self.set_resizable(gtk.FALSE)

        self.vbox.set_spacing(12)

        hbox = gtk.HBox()
        hbox.set_spacing(12)
        hbox.set_border_width(6)

        image = gtk.Image()
        image.set_from_stock(icon, gtk.ICON_SIZE_DIALOG)
        alignment = gtk.Alignment(yalign=0.0)
        alignment.add(image)
        hbox.pack_start(alignment, expand=gtk.FALSE)

        vbox = gtk.VBox()
        vbox.set_spacing(12)

        primaryLabel = gtk.Label("")
        primaryLabel.set_use_markup(gtk.TRUE)
        primaryLabel.set_markup('<span weight="bold" size="larger">%s</span>\n' % (primaryText))
        primaryLabel.set_line_wrap(gtk.TRUE)
        primaryLabel.set_alignment(0.0, 0.0)
        primaryLabel.set_selectable(gtk.TRUE)

        secondaryLabel = gtk.Label("")
        secondaryLabel.set_use_markup(gtk.TRUE)
        secondaryLabel.set_markup(secondaryText)
        secondaryLabel.set_line_wrap(gtk.TRUE)
        secondaryLabel.set_alignment(0.0, 0.0)
        secondaryLabel.set_selectable(gtk.TRUE)

        vbox.pack_start(primaryLabel)
        vbox.pack_start(secondaryLabel)

        if status is not None:
            onlineCheck = gtk.CheckButton(label=_("I would like to go online now"))
            onlineCheck.connect("toggled", self.online_check_toggled)
            vbox.pack_end(onlineCheck)

        hbox.pack_end(vbox)
        hbox.show_all()

        self.vbox.add(hbox)

    def online_check_toggled(self, *args):
        config = straw.Config.get_instance()
        config.offline = not config.offline

def reportError(primaryText, secondaryText):
    alert = HIGAlert(primaryText, secondaryText,
                     buttons = (gtk.STOCK_OK, gtk.RESPONSE_OK))
    alert.run()
    alert.hide()

def reportOfflineStatus(primaryText, secondaryText, feed=None):
    def response(*args):
        if not straw.Config.get_instance().offline:
            poll_manager = straw.PollManager.get_instance()
            if feed is not None:
                poll_manager.poll(feed)
            else:
                poll_manager.poll()

    alert = HIGAlert(primaryText, secondaryText, buttons=(gtk.STOCK_OK,gtk.RESPONSE_OK), status="offline")
    alert.connect('response', response)
    alert.run()
    alert.hide()

def confirmDelete(primaryText, secondaryText):
    alert = HIGAlert(primaryText, secondaryText,
        buttons = (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_DELETE, gtk.RESPONSE_YES), icon=gtk.STOCK_DIALOG_WARNING)
    response = alert.run()
    alert.hide()
    return response
