cvs_id = "$Id: error.py,v 1.5 2003/10/16 20:15:51 juri Exp $"

import sys
import traceback

stream = sys.stderr

def log(*args):
    caller = traceback.extract_stack()[-2]
    _log(caller, *args)

def _log(caller = None, *args):
    if caller is None:
        caller = traceback.extract_stack()[-2]
    stream.write("%s:%d:%s: " % (caller[0], caller[1], caller[2]))
    for a in args:
        if type(a) is not type(''):
            a = repr(a)
        stream.write(a)
    stream.write("\n")

def logtb(*args):
    _log(traceback.extract_stack()[-2], *args)
    l = traceback.format_list(traceback.extract_stack()[:-1])
    for e in l:
        stream.write(e)

def logparam(locals, *vars):
    logargs = []
    for v in vars:
        logargs.append(v + ": " + str(locals[v]))
    _log(traceback.extract_stack()[-2], ", ".join(logargs))
    
