cvs_id = "$Id: SubscribeDialog.py,v 1.34 2003/11/08 14:46:07 juri Exp $"

import gobject
import gtk
import traceback 
import straw
from error import log
from xml.sax import saxutils


def set_busy_cursor():
    rw = gtk.gdk.get_default_root_window()
    rw.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
    while gtk.events_pending():
        gtk.mainiteration(gtk.FALSE)
          

def set_ready_cursor():
    rw = gtk.gdk.get_default_root_window()
    rw.set_cursor(gtk.gdk.Cursor(gtk.gdk.LEFT_PTR))
    while gtk.events_pending():
        gtk.mainiteration(gtk.FALSE)

class SubscribeDialog:
    COLUMN_SUBSCRIBE = 0
    COLUMN_TITLE = 1
    COLUMN_FEED = 2
    COLUMN_PARSEDSUMMARY = 3
    COLUMN_STATUS_FLAG = 4
    COLUMN_URL = 5

    def __init__(self, xml):
        self._window = xml.get_widget("subscribe_dialog")
        self._window.set_transient_for(straw.main_window.get_window())

        self._find_assistant = xml.get_widget("find_assistant")
        self._start_page = xml.get_widget("start_page")
        self._location_page = xml.get_widget("location_page")
        self._last_page = xml.get_widget("last_page")
        self._subscribe_site_entry = xml.get_widget("subscribe_site_entry")
        self._multiple_feed_page = xml.get_widget("multiple_feed_page")
        self._subscribe_multiple_match_view = xml.get_widget("subscribe_multiple_match_view")

        nameFuncMap = {}

        for key in dir(self.__class__):
            if key[:3] == 'on_':
                nameFuncMap[key] = getattr(self, key)

        xml.signal_autoconnect(nameFuncMap)

        model = gtk.ListStore(gobject.TYPE_OBJECT, gobject.TYPE_STRING,
                              gobject.TYPE_PYOBJECT, gobject.TYPE_PYOBJECT, 
                              gobject.TYPE_BOOLEAN, gobject.TYPE_STRING)

        self._subscribe_multiple_match_view.set_model(model)
        self.create_columns(self._subscribe_multiple_match_view)

        self._feeds = {}
        self.reset_fields()

    def on_start_page_prepare(self, *args):
        self._start_page.emit_stop_by_name("prepare")
        self._find_assistant.set_buttons_sensitive(gtk.FALSE, gtk.TRUE, gtk.TRUE, gtk.TRUE)
    
    def on_start_page_next(self, *args):
        self._find_assistant.set_page(self._location_page)
        return gtk.TRUE

    def on_start_page_cancel(self, *args):
        self.hide()

    def on_location_page_prepare(self, *args):
        self._location_page.emit_stop_by_name("prepare")
        if not self._url:
            self._url = ""
        self._subscribe_site_entry.set_text(self._url)
        self._subscribe_site_entry.grab_focus()
        self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.FALSE, gtk.TRUE, gtk.TRUE)
        if self._url and not self._err:
            self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.TRUE, gtk.TRUE, gtk.TRUE)
            
    def on_location_page_next(self, widget, data):
        gtk.timeout_add(1, self.location_page_forward)
        return gtk.TRUE

    def on_location_page_cancel(self, *args):
        self.hide()

    def on_multiple_feed_page_cancel(self, *args):
        self.hide()
  
    def on_multiple_feed_page_prepare(self, *args):
        self._multiple_feed_page.emit_stop_by_name("prepare")
        self.display_feed_choices()
        next = gtk.TRUE
        if len(self._feeds) == 0:
          next = gtk.FALSE
        self._find_assistant.set_buttons_sensitive(gtk.TRUE, next, gtk.TRUE, gtk.TRUE)
    
    def on_multiple_feed_page_next(self, *args):
        self._find_assistant.set_page(self._last_page)
        return gtk.TRUE

    def on_last_page_prepare(self, *args):
        self._last_page.emit_stop_by_name("prepare")
        title = ""
        text = ""
        if self._err:
            title, text = self._err
        else:
            title = _("Feed Found")
            if (len(self._feeds) == 1):
                for f in self._feeds:
                    feed, ps = self._feeds[f]

                text = _("Press the Apply button if you want to subscribe to the feed below.\n\n")
                text += _("Title: %s \n") % feed.title

                if feed.channel_description != "":
                    text += _("Description: %s \n") % feed.channel_description
            else:
                text = _("Press the Apply button if you want to subscribe to the following feeds:\n\n")
                iter = self._feeds.itervalues()
                for f in self._feeds:
                    text += _("\t%s\n") % iter.next()[0].title

        self._last_page.set_title(title)
        self._last_page.set_text(text)
        self._find_assistant.set_show_finish(gtk.TRUE)
        self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.TRUE, gtk.TRUE, gtk.TRUE)

    def on_last_page_back(self, widget, data):
        self._find_assistant.set_show_finish(gtk.FALSE)
        if (not self._err) and (len(self._found_feeds) > 1):
            self._find_assistant.set_page(self._multiple_feed_page)
        else:
            self._find_assistant.set_page(self._location_page)
        return gtk.TRUE

    def on_last_page_finish(self, *args):
        self._find_assistant.set_show_finish(gtk.FALSE)
        for feed, ps in self._feeds.itervalues():
            straw.FeedList.get_instance().append(feed)
            feed.router.route_all(None, ps)
            feed.poll_done()
        self.hide()

    def on_last_page_cancel(self, *args):
        self._find_assistant.set_show_finish(gtk.FALSE)
        self.hide()

    def on_subscribe_site_entry_changed(self, *args):
        gtk.timeout_add(1, self.entry_changed)

    def entry_changed(self):
        text = self._subscribe_site_entry.get_text().strip()
        if text == "":
            self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.FALSE, gtk.TRUE, gtk.TRUE)
        else:
            self._find_assistant.set_buttons_sensitive(gtk.TRUE, gtk.TRUE, gtk.TRUE, gtk.TRUE)

    def on_subscribe_site_entry_key_press_event(self, widget, event):
        if event.keyval == gtk.keysyms.Return:
            gtk.timeout_add(1, self.location_page_forward)
            return gtk.TRUE

    def location_page_forward(self):
        url = self._subscribe_site_entry.get_text().strip()
        if self._url != url or (len(self._found_feeds) < 1 and not self._err):
            self._find_assistant.set_buttons_sensitive(gtk.FALSE, gtk.FALSE, gtk.FALSE, gtk.FALSE)
            set_busy_cursor()
            self._feeds.clear()
            self._found_feeds = self.find_site(url)
            self._url = url
            set_ready_cursor()

        num_found = len(self._found_feeds)
            
        if num_found > 1:
            self._find_assistant.set_page(self._multiple_feed_page)
            return
        elif num_found == 1:
            feed = self._found_feeds[0][0]
            summary = self._found_feeds[0][1]
            self.add_feed(feed, summary)
            
        self._find_assistant.set_page(self._last_page)

    def on_subscribe_dialog_delete_event(self, *args):
        self.hide()
        return gtk.TRUE

    def show(self, url=""):
        self._url = url
        self._start_page.show()
        self._last_page.show()
        self._window.show()

    def hide(self):
        self._find_assistant.set_page(self._start_page)
        self.reset_fields()
        self._window.hide()
        self._start_page.hide()
        self._last_page.hide()

    def reset_fields(self):
        self._url = ""
        self._feeds.clear()
        self._err = None
        self._found_feeds = []

    def create_columns(self, treeview):
        renderer = gtk.CellRendererToggle()
        column = gtk.TreeViewColumn(_('Subscribe'), renderer,
                                    active=self.COLUMN_STATUS_FLAG)
        treeview.append_column(column)
        renderer.connect('toggled', self.sticky_toggled)

        cname= _('Title')
        cnum = self.COLUMN_TITLE
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn(cname, renderer, markup = cnum)
        treeview.append_column(column)

    def sticky_toggled(self, cell, path):
        model = self._subscribe_multiple_match_view.get_model()
        iter = model.get_iter((int(path),))
        feed = model.get_value(iter, self.COLUMN_FEED)
        ps = model.get_value(iter, self.COLUMN_PARSEDSUMMARY)
        sticky = not model.get_value(iter, self.COLUMN_STATUS_FLAG)
        model.set(iter, self.COLUMN_STATUS_FLAG, sticky)

        next = gtk.TRUE
        if feed.id in self._feeds:
            self.remove_feed(feed.id)
            if len(self._feeds) < 1:
                next = gtk.FALSE
        else:
            self.add_feed(feed, ps)

        self._find_assistant.set_buttons_sensitive(gtk.TRUE, next, gtk.TRUE, gtk.TRUE)
        return gtk.TRUE


    def add_feed(self, feed, summary):
        self._feeds[feed.id] = (feed, summary)

    def remove_feed(self, id):
        del self._feeds[id]

    def parse_feed(self, data, feed):
        parsed = straw.SummaryParser.parse(data, feed)
        return parsed

    def display_feed_choices(self):
        model = self._subscribe_multiple_match_view.get_model()
        model.clear()
        for feed, ps in self._found_feeds:
            iter = model.append()
            escaped_text = "<b>%s</b>\n%s" % (saxutils.escape(feed.title), saxutils.escape(feed.channel_description))
            escaped_text = "%s\n%s" % (escaped_text.strip(), saxutils.escape(feed.access_info[0]))
            model.set(iter, self.COLUMN_TITLE, escaped_text,
                      self.COLUMN_FEED, feed, self.COLUMN_PARSEDSUMMARY, ps,
                      self.COLUMN_STATUS_FLAG, feed.id in self._feeds,
                      self.COLUMN_URL, feed.access_info[0])

    def find_site(self, site):
        self._err = None
        found = []

        try:
            found = straw.rssfinder.getFeeds(site)
        except IOError, e:
            self._err = (_("Feed Not Found"),
                         (_("No feed was found in %s. Please make sure you typed the correct location.") % site))

        except Exception, e:
            log("caught an exception: ", e)
            traceback.print_exc()
            self._err = (_("Fatal Error"),
                         _("A fatal error occurred while processing this operation. Please report it to the maintainer. Error: %s") % e)

        if self._err: return []

        if len(found) < 1:
            self._err = (_("Feed Not Found"),
                        (_("No feed was found in %s. Please make sure you typed the correct location.") % site))
            return []

        try:
            feeds = []
            for url, data in found:
                feed = straw.create_new_feed("temporary feed", url)
                ps = self.parse_feed(data, feed)
                feed.title = straw.utils.convert_entities(ps.title).strip()
                feed.channel_description = straw.utils.convert_entities(ps.description).strip()
                feeds.append((feed, ps))
            return feeds
        except Exception, e:
            log("parse_feed: caught exception ", e)
            traceback.print_exc()
            self._err = (_("Fatal Error"),
                         _("A fatal error occurred while processing this operation. Please report it to the maintainer. Error: %s") % e)
            return []

