cvs_id = "$Id: StrawURLOpener.py,v 1.4 2003/07/14 15:54:49 juri Exp $"

from urllib import FancyURLopener, URLopener
import gzip
try:
    from cStringIO import StringIO
except:
    from StringIO import StringIO
import straw

class StrawURLOpener(FancyURLopener):
    def __init__(self, username = None, password = None, *args):
        self.version = "Straw/%s" % straw.VERSION
        self._username = username
        self._password = password
        FancyURLopener.__init__(self, *args)
        self.addheader('Accept-encoding', 'gzip')
        return

    def prompt_user_password(host, realm):
        return (self._username, self._password)

    def http_error_default(self, url, fp, errcode, errmsg, headers):
        URLopener.http_error_default(self, url, fp, errcode, errmsg, headers)

    def readurl(self, url):
        handle = self.open(url)
        info = handle.info()
        data = handle.read()
        if info.getheader('content-encoding') == 'gzip':
            data = gzip.GzipFile(fileobj = StringIO(data)).read()
        handle.close()
        return info, data
