cvs_id = "$Id: PreferencesDialog.py,v 1.19 2003/11/08 14:46:07 juri Exp $"

import gobject
import gtk
import gnome
import gnome.ui
import pango

import straw

class PreferencesDialog:
    SEC_PER_MINUTE = 60
    COLUMN_TITLE = 0
    COLUMN_LOC = 1
    #COLUMN_USER = 2
    #COLUMN_PASSWORD = 3
    COLUMN_EDITABLE = 4
    COLUMN_ID = 5


    def __init__(self, xml):
        config = straw.Config.get_instance()
        feedlist = straw.FeedList.get_instance()
        feedlist.signal_connect(straw.FeedsChangedSignal,self.feeds_changed)
        self._window = xml.get_widget('preferences_dialog')
        self._window.set_transient_for(straw.main_window.get_window())

        model = self.create_model()
        self.display_feeds(model, feedlist)
        treeview = xml.get_widget('feeds_configuration_treeview')
        treeview.set_model(model)
        treeview.set_rules_hint(gtk.TRUE)
        treeview.set_search_column(0)
        treesel = treeview.get_selection()
        treesel.set_mode(gtk.SELECTION_MULTIPLE)
        self._treeview = treeview
        self.create_columns(treeview)

        poll_frequency = int(config.poll_frequency/self.SEC_PER_MINUTE)
        items_stored = int(config.number_of_items_stored)

        xml.get_widget('poll_frequency_spin').set_value(poll_frequency)
        xml.get_widget('number_of_items_spin').set_value(items_stored)
        xml.get_widget(['item_order_oldest',
                        'item_order_newest'][config.item_order]).set_active(1)

        nameFuncMap = {}
        for key in dir(self.__class__):
            if key[:3] == 'on_':
                nameFuncMap[key] = getattr(self, key)
        xml.signal_autoconnect(nameFuncMap)
        return

    def show(self, *args):
        self._window.present()
        return

    def hide(self, *args):
        self._window.hide()

    def on_preferences_dialog_delete_event(self, *args):
        self.hide()
        return gtk.TRUE

    def on_preferences_close_button_clicked(self, button):
        self.hide()
        return

    def on_poll_frequency_spin_focus_out_event(self, spin, data):
        straw.Config.get_instance().poll_frequency = int(spin.get_value() * self.SEC_PER_MINUTE)

    def on_number_of_items_spin_focus_out_event(self, spin, data):
        straw.Config.get_instance().number_of_items_stored = int(spin.get_value())

    def on_item_order_newest_toggled(self, radio):
        config = straw.Config.get_instance()
        config.item_order = not config.item_order

    def on_item_order_oldest_toggled(self, radio):
        pass

    def feeds_changed(self, signal):
        self.display_feeds(self._treeview.get_model(),
                           straw.FeedList.get_instance())

    def display_feeds(self, model, feeds):
        fc = 0
        mlines = len(model)
        while fc < mlines and fc < len(feeds):
            feed = feeds[fc]
            if model[fc][self.COLUMN_ID] != feed.id:
                iter = model.get_iter((fc,))
                model.set(iter, self.COLUMN_TITLE, feed.title,
                          self.COLUMN_LOC, feed.access_info[0],
                          #self.COLUMN_USER, feed.access_info[1],
                          #self.COLUMN_PASSWORD, feed.access_info[2],
                          self.COLUMN_EDITABLE, gtk.TRUE,
                          self.COLUMN_ID, feed.id)
            fc += 1
        if fc < mlines:
            treeiter = model.get_iter((fc,))
            while treeiter:
                next_iter = model.iter_next(treeiter)
                model.remove(treeiter)
                treeiter = next_iter
        else:
            while fc < len(feeds):
                feed = feeds[fc]
                iter = model.append()
                model.set(iter, self.COLUMN_TITLE, feed.title,
                          self.COLUMN_LOC, feed.access_info[0],
                          #self.COLUMN_USER, feed.access_info[1],
                          #self.COLUMN_PASSWORD, feed.access_info[2],
                          self.COLUMN_EDITABLE, gtk.TRUE,
                          self.COLUMN_ID, feed.id)
                fc += 1
        return

    def on_add_feed_button_clicked(self, button):
        self.add_feed(self._treeview.get_model())
        return

    def _get_selected(self):
        selected = []
        def foreach_selected(model, path, iter, *data):
            selected.append(path[0])
        selection = self._treeview.get_selection()
        selection.selected_foreach(foreach_selected)
        return selected

    def on_delete_feed_button_clicked(self, *args):
        model = self._treeview.get_model()
        selected = self._get_selected()
        selected.sort()
        i = 0
        for s in selected:
            s -= i
            i += 1
            iter = model.get_iter(s)
            model.remove(iter)
            del straw.FeedList.get_instance()[s]

    def on_move_feed_up_button_clicked(self, *args):
        selected = self._get_selected()
        selection = self._treeview.get_selection()
        if len(selected) and selected[0] > 0:
            straw.FeedList.get_instance().reorder(selected, -1)
            selection.unselect_all()
            for p in selected:
                selection.select_path(p-1)
        return

    def on_move_feed_down_button_clicked(self, *args):
        selected = self._get_selected()
        selection = self._treeview.get_selection()
        feeds = straw.FeedList.get_instance()
        if len(selected) and selected[-1] < len(feeds) - 1:
            feeds.reorder(selected, 1)
            selection.unselect_all()
            for p in selected:
                selection.select_path(p+1)
        return

    def on_sort_feeds_ascending_button_clicked(self, *args):
        selected = self._get_selected()
        straw.FeedList.get_instance().sort(selected)

    def add_feed(self, model):
        iter = model.append()
        s = straw.create_new_feed("New name")
        straw.FeedList.get_instance().append(s)
        return

    def cell_edited(self, cell, path_string, text, (model, column)):
        iter = model.get_iter_from_string(path_string)
        if not iter:
            return
        path = model.get_path(iter)
        model.set(iter, column, text)

        feeds = straw.FeedList.get_instance()
        url, user, pw = feeds[path[0]].access_info

        if column == self.COLUMN_TITLE:
            feeds[path[0]].title = text
        elif column == self.COLUMN_LOC:
            feeds[path[0]].access_info = (text, user, pw)
        #elif column == self.COLUMN_USER:
        #    straw.config.feeds[path[0]].access_info = (url, text, pw)
        #elif column == self.COLUMN_PASSWORD:
        #    straw.config.feeds[path[0]].access_info = (url, user, text)
        return

    def create_model(self):
        store = gtk.ListStore(
            gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,
            gobject.TYPE_STRING, gobject.TYPE_BOOLEAN, gobject.TYPE_INT)
        return store

    def create_columns(self, treeview):
        model = treeview.get_model()

        # all columns are editable text fields
        renderer = gtk.CellRendererText()
        renderer.connect('edited', self.cell_edited, (model, 0))
        column = gtk.TreeViewColumn(_('Title'), renderer,
                                    text=self.COLUMN_TITLE,
                                    editable=self.COLUMN_EDITABLE)
        column.set_resizable(gtk.TRUE)
        column.set_reorderable(gtk.TRUE)
        #column.set_sort_column_id(0)
        #column.set_sort_order('ascending')
        #column.set_sort_indicator(gtk.TRUE)
        treeview.append_column(column)

        renderer = gtk.CellRendererText()
        renderer.connect('edited', self.cell_edited, (model, 1))
        column = gtk.TreeViewColumn(_('Location'), renderer,
                                    text=self.COLUMN_LOC,
                                    editable=self.COLUMN_EDITABLE)
        treeview.append_column(column)

        #renderer = gtk.CellRendererText()
        #renderer.connect('edited', self.cell_edited, (model, 2))
        #column = gtk.TreeViewColumn(_('Username'), renderer,
        #                            text=self.COLUMN_USER,
        #                            editable=self.COLUMN_EDITABLE)
        #treeview.append_column(column)

        #renderer = gtk.CellRendererText()
        #renderer.connect('edited', self.cell_edited, (model, 3))
        #column = gtk.TreeViewColumn(_('Password'), renderer,
        #                            text=self.COLUMN_PASSWORD,
        #                            editable=self.COLUMN_EDITABLE)
        #treeview.append_column(column)

        return
