cvs_id = "$Id: PollManager.py,v 1.40 2003/11/09 20:07:12 juri Exp $"

import straw
import time
import gtk
import socket

class PollManager:
    def __init__(self):
        self.pollers = []

    def start_polling_loop(self):
        gtk.timeout_add(straw.NetworkConstants.POLL_INTERVAL, self.maybe_poll)

    def maybe_poll(self):
        self.poll_network()
        config = straw.Config.get_instance()
        time_diff = int(time.time()) - config.last_poll

        if config.poll_frequency > 0 and not config.offline and time_diff > config.poll_frequency:
            self.poll()

        gtk.timeout_add(straw.NetworkConstants.POLL_INTERVAL, self.maybe_poll)

    def poll(self, feed = None):
        config = straw.Config.get_instance()
        if config.offline:
            if feed is not None:
                e_title = _("Unable to Poll %s") % feed.title
                e_body = _("You are currently offline. You have to be online to be able to poll this feed.")
                straw.hig_alert.reportOfflineStatus(e_title, e_body, feed)
            else:
                e_title = "Unable to Poll Feeds"
                e_body = "You are currently offline. You have to be online to be able to poll feeds."
                straw.hig_alert.reportOfflineStatus(e_title, e_body)

            return 0

        if feed:
            feeds = [feed]
        else:
            feeds = straw.FeedList.get_instance()
            config.last_poll = int(time.time())

        straw.MessageManager.get_instance().post_message(_("Polling feeds..."))

        for f in feeds:
            self.pollers.append(f)
            p = Poller(f, self)
            p.poll()

    def poll_network(self):
        try:
            straw.URLFetch.connection_manager.poll(straw.NetworkConstants.POLL_TIMEOUT)
        except socket.error:
            straw.hig_alert.reportError("Poll Error","Cannot connect to feed.")

    def poller_finished(self, feed):
        self.pollers.remove(feed)

class Poller:
    def __init__(self, feed, pm):
        self._feed = feed
        self._pm = pm

    def poll(self):
        url, user, pw = self._feed.get_access_info()
        parsed = None

        headers = {}
        if self._feed.previous_etag is not None:
            headers['If-None-Match'] = self._feed.previous_etag
        try:
            pc = straw.URLFetch.connection_manager.request(
                url, self, headers, user, pw,
                priority=straw.NetworkConstants.PRIORITY_RSS)
            self._feed.router.start_polling()
        except Exception, e:
            self.http_failed(e)

    def http_results(self, status, header, data):
        success = self.update_feed(status, header, data)
        mm = straw.MessageManager.get_instance()
        if success:
            mm.post_message(_("Parsing data of %s done.") % self._feed.title)
        else:
            mm.post_message(_("Parsing data of %s failed.") % self._feed.title)
        self._feed.poll_done()
        self._pm.poller_finished(self._feed)

    def update_feed(self, status, header, data):
        
        straw.MessageManager.get_instance().post_message(
            _("Parsing data for feed %s...") % self._feed.title)

        if status is None:
            self._feed.router.set_error(_("The feed returned no data."))
            return 0
        elif status[1] == 304:
            self._feed.router.route_no_data()
            return 1
        elif status[1] == 410 or status[1] == 404:
            self._feed.router.set_error(_("Straw was unable to find the feed."))
            return 0
        elif status[1] != 200 and status[1] > 299:
            self._feed.router.set_error(_("Polling feed resulted in abnormal status '%s' (code %d)") % (status[2], status[1]))
            return 0

        parsed = ""

        try:
            parsed = straw.SummaryParser.parse(data, self._feed)
        except Exception, e:
            self._feed.error = _("Unknown exception when parsing RSS: %s") % str(e)
            return 0

        self._feed.router.route_all(header, parsed)
        return 1

    def http_failed(self, exception):
        if isinstance(exception, socket.error):
            err = exception.args[1]
        else:
            err = str(exception)
        self._feed.router.set_error(err)
        straw.MessageManager.get_instance().post_message(
            _("Polling of feed %s failed") % self._feed.title)
        self._feed.poll_done()
        self._pm.poller_finished(self._feed)

    def http_permanent_redirect(self, location):
        (oldloc, u, p) = self._feed.access_info
        self._feed.access_info = (location, u, p)

pollmanager_instance = None

def get_instance():
    global pollmanager_instance
    if pollmanager_instance is None:
        pollmanager_instance = PollManager()
    return pollmanager_instance
