cvs_id = "$Id: Main.py,v 1.44 2003/11/10 02:54:24 jmalonzo Exp $"

import straw

import os
import sys

import pygtk
pygtk.require('2.0')

import gettext
import gnome
import gnome.ui
import gobject
import gtk
import gtkhtml2
import pango
import locale
from gtk import glade
import getopt
from error import log


class Main:
    def __init__(self):
        lname = straw.APPNAME.lower()
        gnome.program_init(lname, straw.VERSION)
        straw.main = self
        try:
            self._setlocale()
            localedir = find_locale_dir()
            gettext.bindtextdomain(lname, localedir)
            gettext.textdomain(lname)
            gettext.install(lname, localedir, unicode=1)
            glade.bindtextdomain(lname, localedir)
        except IOError:
            def broken_gettext_workaround(s):
                return s
            __builtins__.__dict__['_'] = broken_gettext_workaround
        libdir = find_lib_dir()
        self._libdir = libdir
        xmlfile = find_glade_file(libdir)
        straw.ImageCache.initialize()
        self._image_loader = ImageLoader(libdir)
        self._visible_feed = None
        self._visible_item = None
        config = straw.Config.get_instance()
        feedlist = straw.FeedList.get_instance()
        if config.first_time:
            self.import_opml(
                os.path.join(libdir, "default_subscriptions.opml"))
        else:
            feedlist.load_data()

        try:
            optlist, args = getopt.getopt(sys.argv[1:], '', ['offline'])
            if '--offline' in [o[0] for o in optlist]:
                config.offline = 1
        except getopt.GetoptError, e:
            log("Error parsing the command line: ", e)


        self._feed_properties_dialog = straw.FeedPropertiesDialog(
            glade.XML(xmlfile, 'feed_properties_dialog',
                      gettext.textdomain()))
        straw.main_window = straw.MainWindow(
            glade.XML(xmlfile, "straw_main", gettext.textdomain()))
        self.update_feeds(feedlist)
        feedlist.signal_connect(
            straw.FeedsChangedSignal, self.feeds_changed)
        self._itemstore = straw.ItemStore()
        self.restore_feeds(self._itemstore)
        self._preferences_dialog = straw.PreferencesDialog(
            glade.XML(xmlfile, "preferences_dialog",
                      gettext.textdomain()))
        self._subscribe_dialog = straw.SubscribeDialog(
            glade.XML(xmlfile, 'subscribe_dialog',
                      gettext.textdomain()))
        self._find_dialog = straw.FindDialog(
            glade.XML(xmlfile, 'find_dialog',
                      gettext.textdomain()))
        self._export_subscriptions_dialog = straw.ExportSubscriptionsDialog(
            glade.XML(xmlfile, 'export_subscriptions_dialog',
                      gettext.textdomain()))
        self._import_subscriptions_dialog = straw.ImportSubscriptionsDialog(
            glade.XML(xmlfile, 'import_subscriptions_dialog',
                      gettext.textdomain()))
        straw.PollManager.get_instance().start_polling_loop()
        self._itemstore.start()
        self._feed_selection_enabled = 1
        self.display_feeds()
        return

    def _setlocale(self):
        try:
            # get current locale
            locale.setlocale(locale.LC_ALL, '')
        except (locale.Error, Exception):
            # default to 'C'
            locale.setlocale(locale.LC_ALL)

    def restore_feeds(self, itemstore):
        feedlist = straw.FeedList.get_instance()
        for f in feedlist:
            f.restore_items(itemstore.read_feed_items(f))

    # called when FeedsChangedSignal is sent
    def feeds_changed(self, signal):
        self.update_feeds(signal.sender)
        return

    def update_feeds(self, feeds):
        straw.main_window.display_feeds(straw.FeedList.get_instance(), self._visible_feed)
        return

    def display_feeds(self):
        straw.main_window.display_feeds(straw.FeedList.get_instance(), self._visible_feed)
        return

    def get_visible_feed(self):
        return self._visible_feed

    def mark_as_read(self, feed = None):
        if feed is None:
            feed = self._visible_feed
        feed.mark_all_read()

    def display_feed(self, feed, select_first = 1):
        if self._feed_selection_enabled and self._visible_feed != feed:
            self._visible_feed = feed
            if feed.number_of_items == 0:
                straw.main_window.display_empty_feed(feed)
            else:
                straw.main_window.display_feed(feed, select_first)
            return 1
        else:
            return 0

    def display_item_unselected(self, item):
        if item and item is not self._visible_item:
            if item.feed is not self._visible_feed:
                straw.main_window.display_feed_unselected(item.feed)
            straw.main_window.display_item_unselected(item)
            straw.DashboardFrontend.get_instance().item_changed(item)

    def display_item(self, item):
        if item and item is not self._visible_item:
            if item.feed is not self._visible_feed:
                straw.main_window.display_feed_unselected(item.feed)
            self._visible_item = item
            item.seen = 1
            straw.main_window.display_item(item)
            straw.DashboardFrontend.get_instance().item_changed(item)

    def get_next_item(self, item = None):
        feeds = straw.FeedList.get_instance()
        if item is None:
            item = self._visible_item
        if item is None:
            if not len(feeds):
                return None
            feed = feeds[0]
            return feed.get_first_item()
        feed = item.feed
        ni = feed.get_next_item(item)
        if ni is not None:
            return ni
        else:
            feed_idx = feeds.index(feed)
            fi = 1
            while fi <= len(feeds):
                item = feeds[
                    (feed_idx + fi) % len(feeds)].get_first_item()
                if item is not None:
                    return item
                fi += 1
            return None

    def display_next_item(self, item = None):
        self.display_item_unselected(self.get_next_item(item))

    def get_next_unread_item(self, item = None):
        current = item
        while 1:
            item = self.get_next_item(item)
            # so we can check if we have gone around even if the user didn't
            # have anything selected
            if current is None:
                current = item
            if item is None:
                return None
            if not item.seen:
                return item
            if item is current:
                return None

    def display_next_unread_item(self, item = None):
        item = self.get_next_unread_item(
            [item, self._visible_item][item is None])
        if item:
            self.display_item_unselected(item)

    def get_previous_item(self, item = None):
        feeds = straw.FeedList.get_instance()
        if item is None:
            item = self._visible_item
        if item is None:
            if not len(feeds):
                return None
            feed = feeds[-1]
            return feed.get_last_item()
        feed = item.feed
        ni = feed.get_previous_item(item)
        if ni is not None:
            return ni
        else:
            feed_idx = feeds.index(feed)
            fd = 1
            while fd <= len(feeds):
                item = feeds[
                    (feed_idx - fd) % len(feeds)].get_last_item()
                if item is not None:
                    return item
                fd += 1
            return None

    def display_previous_item(self, item = None):
        self.display_item_unselected(self.get_previous_item(item))

    def get_next_feed(self, item = None):
        feeds = straw.FeedList.get_instance()
        feed = None
        if item is None:
            item = self._visible_item
        if item is None:
            if len(feeds):
                feed = feeds[0]
        else:
            feed = item.feed
            feed_idx = feeds.index(feed)
            if feed_idx < len(feeds) - 1:
                feed_idx += 1
            else:
                feed_idx = 0
            feed = feeds[feed_idx]
        return feed

    def display_next_unread_feed(self, item = None):
        feed = self.get_next_feed(item)
        item = feed.get_first_item()
        if item.seen:
            item = self.get_next_unread_item(item)
        if item:
            self.display_item_unselected(item)

    def display_next_feed(self, item = None):
        feed = self.get_next_feed(item)
        item = feed.get_first_item()
        if item:
            self.display_item_unselected(item)

    def get_previous_feed(self, item = None):
        feeds = straw.FeedList.get_instance()
        feed = None
        if item is None:
            item = self._visible_item
        if item is None:
            if len(feeds):
                feed = feeds[0]
        else:
            feed = item.feed
            feed_idx = feeds.index(feed)
            if feed_idx > 0:
                feed_idx -= 1
            else:
                feed_idx = len(feeds) - 1
            feed = feeds[feed_idx]
        return feed

    def display_previous_feed(self, item = None):
        feed = self.get_previous_feed(item)
        item = feed.get_first_item()
        if item:
            self.display_item_unselected(item)

    def is_visible_item(self, item):
        return item is self._visible_item

    def show_preferences_dialog(self):
        self._preferences_dialog.show()

    def show_subscribe_dialog(self, url=None):
        self._subscribe_dialog.show(url)

    def show_find_dialog(self):
        self._find_dialog.show()

    def show_export_subscriptions_dialog(self):
        self._export_subscriptions_dialog.show()

    def show_import_subscriptions_dialog(self):
        self._import_subscriptions_dialog.show()

    def show_feed_properties_dialog(self):
        self._feed_properties_dialog.display_properties(self._visible_feed)
        self._feed_properties_dialog.show()

    def enable_feed_selection(self):
        straw.main_window.enable_feed_selection()

    def disable_feed_selection(self):
        straw.main_window.disable_feed_selection()

    def mainloop(self):
        gtk.main()

    def quit(self):
        gtk.mainquit()
        self._itemstore.stop()
        return

    def show_image(self, widget, image):
        self._image_loader.show(widget, image)

    def import_opml(self, filename):
        opml = straw.OPMLImport.read(open(filename))
        if opml is not None:
            feeds = straw.FeedList.get_instance()
            current_feeds = {}
            error = 0
            for feed in feeds:
                current_feeds[feed.access_info[0]] = 1
            for b in opml:
                if current_feeds.has_key(b.xmlurl):
                    continue
                if b.type == "rss":
                    feeds.append(
                        straw.create_new_feed(b.title, b.xmlurl))
                else:
                    error = 1

            if error:
                straw.hig_alert.reportError(
                    _("Warning: Not All Feeds Have Been Added"),
                    (_("Some feeds in the file %s were not added because they are not RSS feeds.") % filename))

        return


class ImageLoader:
    def __init__(self, libdir):
        self.libdir = libdir

    def show(self, widget, image):
        fn = os.path.join(self.libdir, image + ".png")
        widget.set_from_file(fn)

def find_lib_dir():
    if os.environ.has_key("STRAW_DATA"):
        return os.environ["STRAW_DATA"]
    h, t = os.path.split(os.path.split(os.path.abspath(sys.argv[0]))[0])
    if t == 'bin':
        fp = os.path.join(h, 'share', 'straw')
        if os.path.isdir(fp):
            return fp
        fp = os.path.join(h, 'lib', 'straw')
        if os.path.isdir(fp):
            return fp
    raise "FileNotFoundError", "couldn't find Straw data directory"

def find_locale_dir():
    h, t = os.path.split(os.path.split(os.path.abspath(sys.argv[0]))[0])
    if t == 'bin':
        fp = os.path.join(h, 'share', 'locale')
        if os.path.isdir(fp):
            return fp
    raise "FileNotFoundError", "couldn't find locale data directory"

def find_glade_file(libdir):
    xmlfile = None
    if os.environ.has_key("STRAW_GLADE"):
        return os.environ["STRAW_GLADE"]
    fp = os.path.join(libdir, 'straw.glade')
    if os.path.isfile(fp):
        return fp
    raise "FileNotFoundError", "couldn't find straw.glade"

