cvs_id = "$Id: ImportSubscriptionsDialog.py,v 1.3 2003/03/16 11:48:19 juri Exp $"

import straw
import gtk

class ImportSubscriptionsDialog:
    def __init__(self, xml):
        self._window = xml.get_widget('import_subscriptions_dialog')
        self._window.set_transient_for(straw.main_window.get_window())
        self._error_dialog = None
        nameFuncMap = {}
        for key in dir(self.__class__):
            if key[:3] == 'on_':
                nameFuncMap[key] = getattr(self, key)
        xml.signal_autoconnect(nameFuncMap)

    def show(self):
        self._window.show()
        self._window.present()

    def hide(self, *args):
        if self._error_dialog:
            self._error_dialog.destroy()
            self._error_dialog = None
        self._window.hide()

    def on_import_ok_clicked(self, *args):
        filename = self._window.get_filename()
        if self.import_opml(filename):
            self.hide()

    def on_import_cancel_clicked(self, *args):
        self.hide()

    def on_import_subscriptions_dialog_close(self, *args):
        self.hide()

    def import_opml(self, filename):
        try:
            straw.main.import_opml(filename)
        except Exception, ex:
            self._error_dialog = gtk.MessageDialog(
                self._window, gtk.DIALOG_DESTROY_WITH_PARENT,
                gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE,
                _("Error reading OPML file: %s") % str(ex))
            self._error_dialog.show()
            self._error_dialog.connect("response", self.hide)
            return None
        return 1

