
import gtk, straw

class FeedPropertiesDialog:
    def __init__(self, xml):
        self._window = xml.get_widget('feed_properties_dialog')

        self._title = xml.get_widget('properties_title_entry')
        self._location = xml.get_widget('properties_location_entry')
        self._username = xml.get_widget('properties_username_entry')
        self._password = xml.get_widget('properties_password_entry')
        self._restore_button = xml.get_widget('properties_reset_button')

        self._auth_box = xml.get_widget('feed_properties_auth_vbox')
        self._sens_vbox = xml.get_widget('properties_sensitivity_vbox')

        self._title_default = ''
        self._url_default = ''
        self._un_default = ''
        self._pw_default = ''

        self._size_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        self._size_group.add_widget(xml.get_widget('properties_title_label'))
        self._size_group.add_widget(xml.get_widget('properties_location_label'))
        self._size_group.add_widget(xml.get_widget('properties_username_label'))
        self._size_group.add_widget(xml.get_widget('properties_password_label'))

        nameFuncMap = {}
        for key in dir(self.__class__):
            if key[:3] == 'on_':
                nameFuncMap[key] = getattr(self, key)
        xml.signal_autoconnect(nameFuncMap)


    def show(self, *args):
        self._restore_button.set_sensitive(gtk.FALSE)
        self._window.set_transient_for(straw.main_window.get_window())
        self._window.present()

    def hide(self, *args):
        self._window.hide()

    def on_feed_properties_dialog_delete_event(self, *args):
        self.hide()
        return gtk.TRUE

    def on_feed_properties_close_button_clicked(self, *args):
        self.hide()
        return

    def display_properties(self, feed):
        self._feed = feed
        self._title_default = feed.title
        loc, un, pw = feed.access_info
        self._url_default = loc
        self._un_default = un
        self._pw_default = pw
        self._window.set_title(_("%s Properties") % feed.title)
        self._title.set_text(feed.title)
        self._location.set_text(feed.access_info[0])

        if un:
            self._username.set_text(un)
            self._password.set_text(pw)

    def restore_defaults(self):
        self._feed.title = self._title_default
        self._feed.access_info = (
            self._url_default, self._un_default, self._pw_default)
        self._title.set_text(self._title_default)
        self._location.set_text(self._url_default)
        self._username.set_text(self._un_default)
        self._password.set_text(self._pw_default)
        self._restore_button.set_sensitive(gtk.FALSE)

    def on_properties_edit_check_toggled(self, widget):
        mode = widget.get_active()
        self._sens_vbox.set_sensitive(mode)

    def on_properties_title_entry_insert_text(self, *args):
        self._restore_button.set_sensitive(gtk.TRUE)

    def on_properties_title_entry_delete_text(self, *args):
        self._restore_button.set_sensitive(gtk.TRUE)

    def on_properties_title_entry_focus_out_event(self, widget, *args):
        self._feed.title = widget.get_text().strip()

    def on_properties_location_entry_insert_text(self, *args):
        self._restore_button.set_sensitive(gtk.TRUE)

    def on_properties_location_entry_delete_text(self, *args):
        self._restore_button.set_sensitive(gtk.TRUE)

    def on_properties_location_entry_focus_out_event(self, widget, *args):
        loc, username, pw = self._feed.access_info
        self._feed.access_info = (widget.get_text().strip(), username, pw)

    def on_properties_username_entry_insert_text(self, *args):
        self._restore_button.set_sensitive(gtk.TRUE)

    def on_properties_username_entry_delete_text(self, *args):
        self._restore_button.set_sensitive(gtk.FALSE)

    def on_properties_username_entry_focus_out_event(self, widget, *args):
        loc, username, pw = self._feed.access_info
        self._feed.access_info = (loc, widget.get_text().strip(), pw)

    def on_properties_password_entry_insert_text(self, *args):
        self._restore_button.set_sensitive(gtk.TRUE)

    def on_properties_password_entry_delete_text(self, *args):
        self._restore_button.set_sensitive(gtk.FALSE)

    def on_properties_password_entry_focus_out_event(self, widget, *args):
        loc, username, pw = self._feed.access_info
        self._feed.access_info = (loc, username, widget.get_text().strip())

    def on_properties_reset_button_clicked(self, *args):
        self.restore_defaults()
