cvs_id = "$Id: FeedItems.py,v 1.6 2003/11/07 16:39:28 juri Exp $"

import straw
from error import log, logtb

class FeedItems(object):
    def __init__(self, feed):
        self._feed = feed
        self._items = straw.FeedQD()
        self._idseq = 0
        config = straw.Config.get_instance()
        self._items.set_reverse(config.item_order)
        self._reverse = config.item_order
        self._number_of_items = 0
        self._number_of_unread = 0
        config.signal_connect(straw.ItemOrderChangedSignal,
                              self.item_order_changed)

    def get_number_of_unread(self):
        return self._number_of_unread

    def set_number_of_unread(self, n):
        self._number_of_unread = n

    def get_number_of_items(self):
        return self._number_of_items

    def set_number_of_items(self, n):
        self._number_of_items = n

    number_of_unread = property(get_number_of_unread, set_number_of_unread, None, "")
    number_of_items = property(get_number_of_items, set_number_of_items, None, "")

    def item_order_changed(self, event):
        self._items.set_reverse(event.sender.item_order)
        self._reverse = event.sender.item_order
        self._feed.signal_refresh_display()

    def next_id(self):
        self._idseq += 1
        id = self._idseq
        return id

    def set_reverse(self, value):
        self._items.set_reverse(value)

    def add_items(self, new_items):
        really_new, deleted = self._add_items(new_items)
        self.number_of_items = len(self._items)
        self.number_of_unread = len([item for item in self._items.values() if not item.seen])
        for d in deleted:
            d.clean_up()
            if d not in really_new:
                self._feed.signal_deleted_item(d)
        really_new = [ r for r in really_new if r not in deleted ]
        if len(really_new) > 0:
            self._feed.signal_new_items(really_new)
        
    def restore_items(self, new_items):
        accepted, deleted = self._add_items(new_items)
        self.number_of_items = len(self._items)
        self.number_of_unread = len([item for item in self._items.values() if not item.seen])
        accepted = [a for a in accepted if a not in deleted]
        ids = [i.id for i in new_items]
        if len(ids) > 0:
            self._idseq = max(ids)
        self._feed.signal_added_items(new_items)

    def _add_items(self, items):
        old = 0
        accepted = []
        for nitem in items:
            for id, item in self._items.items():
                if item.title == nitem.title and item.description == nitem.description:
                    old = 1
                    self._items.set_item(id, item)
                    break
                elif item.guid is not None and item.guid is not "" and item.guid == nitem.guid:
                    nitem.id = item.id
                    self._items.set_item(id, nitem)
                    nitem.signal_connect(straw.ItemReadSignal,
                                         self.item_read)
                    nitem.signal_connect(straw.ItemStickySignal,
                                         self._feed.forward_signal)
                    nitem.feed = self._feed
                    accepted.append(nitem)
                    old = 1
                    break
            if not old:
                if nitem.id is None:
                    # XXX
                    nitem.id = self.next_id()
                self._items.set_item(nitem.id, nitem)
                nitem.signal_connect(straw.ItemReadSignal,
                                     self.item_read)
                nitem.signal_connect(straw.ItemStickySignal,
                                     self._feed.forward_signal)
                nitem.feed = self._feed
                accepted.append(nitem)
            old = 0
        removed = self._items.cut(straw.Config.get_instance().number_of_items_stored)
        return (accepted, removed)

    def item_read(self, signal):
        self.number_of_unread = self.number_of_unread - 1
        self._feed.forward_signal(signal)

    def get_items(self):
        ilist = []
        for item in self._items:
            ilist.append(item)
        return ilist
        
    def get_next_item(self, item):
        if self._reverse:
            id = self._items.get_next_smaller_key(item.id)
        else:
            id = self._items.get_next_larger_key(item.id)
        return self._items.get(id, None)

    def get_previous_item(self, item):
        if self._reverse:
            id = self._items.get_next_larger_key(item.id)
        else:
            id = self._items.get_next_smaller_key(item.id)
        return self._items.get(id, None)

    def get_first_item(self):
        return self._items.get_first_item()

    def get_last_item(self):
        return self._items.get_last_item()

    def get_item(self, id):
        return self._items[id]

    def get_item_index(self, item):
        idx = self._items.index(item.id)
        if self._reverse:
            idx = len(self._items) - idx -1
            return idx
        return idx

    def mark_all_read(self):
        changed = []
        i = 0
        for item in self._items:
            if item.set_seen_quiet():
                changed.append((i, item))
            i += 1
        self.number_of_unread = 0
        self._feed.signal_all_items_read(changed)
        return
