cvs_id = "$Id: ExportSubscriptionsDialog.py,v 1.8 2003/11/08 14:46:07 juri Exp $"

import straw

class ExportSubscriptionsDialog:
    def __init__(self, xml):
        self._window = xml.get_widget('export_subscriptions_dialog')
        self._window.set_transient_for(straw.main_window.get_window())
        self._window.set_filename('mySubscriptions.opml')
        nameFuncMap = {}
        for key in dir(self.__class__):
            if key[:3] == 'on_':
                nameFuncMap[key] = getattr(self, key)
        xml.signal_autoconnect(nameFuncMap)

    def show(self):
        self._window.show()
        self._window.present()

    def hide(self):
        self._window.hide()

    def on_export_ok_clicked(self, *args):
        filename = self._window.get_filename()
        straw.OPMLExport.export(straw.FeedList.get_instance(), filename)
        self.hide()

    def on_export_cancel_clicked(self, *args):
        self.hide()
