cvs_id = "$Id: Event.py,v 1.14 2003/10/16 20:20:55 juri Exp $"

import traceback
import sys

def find_bases(klass, d = {}):
    for b in klass.__bases__:
        if issubclass(b, BaseSignal):
            d[b] = 1
            find_bases(b, d)
    return d.keys()

class BaseSignal:
    def __init__(self, sender):
        self.sender = sender
        return

class SignalEmitter:
    def __init__(self):
        self._slots = {}

    def initialize_slots(self, *signals):
        for s in signals:
            self._slots[s] = {}
            bs = find_bases(s)
            for k in bs:
                self._slots[k] = {}

    def signal_connect(self, signal, handler, data = None):
        self._slots[signal][handler] = data
        return

    def signal_disconnect(self, signal, handler):
        del self._slots[signal][handler]
        return

    def emit_signal(self, signal):
        # huh, what? suddenly if i don't specify second argument, the resuls
        # are all weird
        sclasses = find_bases(signal.__class__, {})
        sclasses.append(signal.__class__)
        for sc in sclasses:
            for handler, data in self._slots.get(sc, {}).items():
                if data is not None:
                    args = (signal, data)
                else:
                    args = (signal,)
                try:
                    apply(handler, args)
                except Exception, ex:
                    sys.stderr.write("Caught an exception when trying to "
                                     "call a signal handler for "
                                     "signal %s\n" %
                                     str(signal))
                    traceback.print_exc()


class ConfigOptionSignal(BaseSignal):
    pass

class LocalConfigOptionSignal(ConfigOptionSignal):
    pass

class FeedsChangedSignal(LocalConfigOptionSignal):
    pass

class NumberOfItemsStoredChangedSignal(LocalConfigOptionSignal):
    pass

class ItemOrderChangedSignal(LocalConfigOptionSignal):
    pass

class LastPollChangedSignal(LocalConfigOptionSignal):
    pass

class BlogURLChangedSignal(LocalConfigOptionSignal):
    pass

class MainWindowSizeChangedSignal(LocalConfigOptionSignal):
    pass

class OfflineModeChangedSignal(LocalConfigOptionSignal):
    pass

class MainPanePositionChangedSignal(LocalConfigOptionSignal):
    pass

class SubPanePositionChangedSignal(LocalConfigOptionSignal):
    pass

class RefreshFeedDisplaySignal(BaseSignal):
    pass

class FindInterruptSignal(BaseSignal):
    pass

class FeedPolledSignal(BaseSignal):
    pass

class FeedStatusChangedSignal(BaseSignal):
    pass

class ItemsAddedSignal(BaseSignal):
    def __init__(self, sender, items):
        BaseSignal.__init__(self, sender)
        self.items = items

class ItemDeletedSignal(BaseSignal):
    def __init__(self, sender, item):
        BaseSignal.__init__(self, sender)
        self.item = item

class NewItemsSignal(BaseSignal):
    def __init__(self, sender, items):
        BaseSignal.__init__(self, sender)
        self.items = items

class ItemReadSignal(BaseSignal):
    pass

class ItemStickySignal(BaseSignal):
    pass

class AllItemsReadSignal(BaseSignal):
    def __init__(self, sender, changed):
        BaseSignal.__init__(self, sender)
        self.changed = changed

class ImageUpdatedSignal(BaseSignal):
    def __init__(self, sender, url, data):
        BaseSignal.__init__(self, sender)
        self.url = url
        self.data = data

if __name__ == '__main__':
    print find_bases(ItemReadSignal)
