# Copyright (C) 2012, 2013 Julian Marchant <onpon4@riseup.net>
# 
# This file is part of the Pygame SGE.
# 
# The Pygame SGE is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# The Pygame SGE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the Pygame SGE.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import division
from __future__ import absolute_import
from __future__ import print_function
from __future__ import unicode_literals

import sys
import os

import pygame


__all__ = [u'IMPLEMENTATION', u'ALIGN_LEFT', u'ALIGN_CENTER', u'ALIGN_RIGHT',
           u'ALIGN_TOP', u'ALIGN_MIDDLE', u'ALIGN_BOTTOM', u'BLEND_NORMAL',
           u'BLEND_RGB', u'BLEND_ALPHA', u'BLEND_ADD', u'BLEND_SUBTRACT',
           u'BLEND_MULTIPLY', u'BLEND_SCREEN', u'BLEND_MINIMUM', u'BLEND_MAXIMUM',
           u'BLEND_RGBA_ADD', u'BLEND_RGBA_SUBTRACT', u'BLEND_RGBA_MULTIPLY',
           u'BLEND_RGBA_SCREEN', u'BLEND_RGBA_MINIMUM', u'BLEND_RGBA_MAXIMUM',
           u'BLEND_RGB_ADD', u'BLEND_RGB_SUBTRACT', u'BLEND_RGB_MULTIPLY',
           u'BLEND_RGB_SCREEN', u'BLEND_RGB_MINIMUM', u'BLEND_RGB_MAXIMUM',
           u'PROGRAM_DIR', u'COLORS', u'COLOR_NAMES', u'KEYS', u'KEY_NAMES',
           u'MOUSE_BUTTONS', u'MOUSE_BUTTON_NAMES', u'DEBUG']

PROGRAM_DIR = os.path.dirname(sys.argv[0])
DEBUG = True
if DEBUG:
    print(u"SGE Art of Debugging enabled.")

COLORS = {u'white': u'#ffffff', u'silver': u'#c0c0c0', u'gray': u'#808080',
          u'black': u'#000000', u'red': u'#ff0000', u'maroon': u'#800000',
          u'yellow': u'#ffff00', u'olive': u'#808000', u'lime': u'#00ff00',
          u'green': u'#008000', u'aqua': u'#00ffff', u'teal': u'#008080',
          u'blue': u'#0000ff', u'navy': u'#000080', u'fuchsia': u'#ff00ff',
          u'purple': u'#800080'}
COLOR_NAMES = {}
for pair in COLORS.items():
    COLOR_NAMES[pair[1]] = pair[0]

KEYS = {u"0": pygame.K_0, u"1": pygame.K_1, u"2": pygame.K_2, u"3": pygame.K_3,
        u"4": pygame.K_4, u"5": pygame.K_5, u"6": pygame.K_6, u"7": pygame.K_7,
        u"8": pygame.K_8, u"9": pygame.K_9, u"a": pygame.K_a, u"b": pygame.K_b,
        u"c": pygame.K_c, u"d": pygame.K_d, u"e": pygame.K_e, u"f": pygame.K_f,
        u"g": pygame.K_g, u"h": pygame.K_h, u"i": pygame.K_i, u"j": pygame.K_j,
        u"k": pygame.K_k, u"l": pygame.K_l, u"m": pygame.K_m, u"n": pygame.K_n,
        u"o": pygame.K_o, u"p": pygame.K_p, u"q": pygame.K_q, u"r": pygame.K_r,
        u"s": pygame.K_s, u"t": pygame.K_t, u"u": pygame.K_u, u"v": pygame.K_v,
        u"w": pygame.K_w, u"x": pygame.K_x, u"y": pygame.K_y, u"z": pygame.K_z,
        u"alt_left": pygame.K_LALT, u"alt_right": pygame.K_RALT,
        u"ampersand": pygame.K_AMPERSAND, u"apostrophe": pygame.K_QUOTE,
        u"asterisk": pygame.K_ASTERISK, u"at": pygame.K_AT,
        u"backslash": pygame.K_BACKSLASH, u"backspace": pygame.K_BACKSPACE,
        u"backtick": pygame.K_BACKQUOTE, u"bracket_left": pygame.K_LEFTBRACKET,
        u"bracket_right": pygame.K_RIGHTBRACKET, u"break": pygame.K_BREAK,
        u"caps_lock": pygame.K_CAPSLOCK, u"caret": pygame.K_CARET,
        u"clear": pygame.K_CLEAR, u"colon": pygame.K_COLON,
        u"comma": pygame.K_COMMA, u"ctrl_left": pygame.K_LCTRL,
        u"ctrl_right": pygame.K_RCTRL, u"delete": pygame.K_DELETE,
        u"dollar": pygame.K_DOLLAR, u"down": pygame.K_DOWN, u"end": pygame.K_END,
        u"enter": pygame.K_RETURN, u"equals": pygame.K_EQUALS,
        u"escape": pygame.K_ESCAPE, u"euro": pygame.K_EURO,
        u"exclamation": pygame.K_EXCLAIM, u"f1": pygame.K_F1, u"f2": pygame.K_F2,
        u"f3": pygame.K_F3, u"f4": pygame.K_F4, u"f5": pygame.K_F5,
        u"f6": pygame.K_F6, u"f7": pygame.K_F7, u"f8": pygame.K_F8,
        u"f9": pygame.K_F9, u"f10": pygame.K_F10, u"f11": pygame.K_F11,
        u"f12": pygame.K_F12, u"greater_than": pygame.K_GREATER,
        u"hash": pygame.K_HASH, u"help": pygame.K_HELP, u"home": pygame.K_HOME,
        u"hyphen": pygame.K_MINUS, u"insert": pygame.K_INSERT,
        u"kp_0": pygame.K_KP0, u"kp_1": pygame.K_KP1, u"kp_2": pygame.K_KP2,
        u"kp_3": pygame.K_KP3, u"kp_4": pygame.K_KP4, u"kp_5": pygame.K_KP5,
        u"kp_6": pygame.K_KP6, u"kp_7": pygame.K_KP7, u"kp_8": pygame.K_KP8,
        u"kp_9": pygame.K_KP9, u"kp_divide": pygame.K_KP_DIVIDE,
        u"kp_enter": pygame.K_KP_ENTER, u"kp_equals": pygame.K_KP_EQUALS,
        u"kp_minus": pygame.K_KP_MINUS, u"kp_multiply": pygame.K_KP_MULTIPLY,
        u"kp_plus": pygame.K_KP_PLUS, u"kp_point": pygame.K_KP_PERIOD,
        u"left": pygame.K_LEFT, u"less_than": pygame.K_LESS,
        u"menu": pygame.K_MENU, u"meta_left": pygame.K_LMETA,
        u"meta_right": pygame.K_RMETA, u"mode": pygame.K_MODE,
        u"num_lock": pygame.K_NUMLOCK, u"pagedown": pygame.K_PAGEDOWN,
        u"pageup": pygame.K_PAGEUP, u"parenthesis_left": pygame.K_LEFTPAREN,
        u"parenthesis_right": pygame.K_RIGHTPAREN, u"pause": pygame.K_PAUSE,
        u"period": pygame.K_PERIOD, u"plus": pygame.K_PLUS,
        u"power": pygame.K_POWER, u"print_screen": pygame.K_PRINT,
        u"question": pygame.K_QUESTION, u"quote": pygame.K_QUOTEDBL,
        u"right": pygame.K_RIGHT, u"scroll_lock": pygame.K_SCROLLOCK,
        u"semicolon": pygame.K_SEMICOLON, u"shift_left": pygame.K_LSHIFT,
        u"shift_right": pygame.K_RSHIFT, u"slash": pygame.K_SLASH,
        u"space": pygame.K_SPACE, u"super_left": pygame.K_LSUPER,
        u"super_right": pygame.K_RSUPER, u"sysrq": pygame.K_SYSREQ,
        u"tab": pygame.K_TAB, u"underscore": pygame.K_UNDERSCORE,
        u"up": pygame.K_UP}
KEY_NAMES = {}
for pair in KEYS.items():
    KEY_NAMES[pair[1]] = pair[0]

MOUSE_BUTTONS = {u"left": 1, u"right": 3, u"middle": 2, u"wheel_up": 4,
                 u"wheel_down": 5, u"wheel_left": 6, u"wheel_right": 7}
MOUSE_BUTTON_NAMES = {}
for pair in MOUSE_BUTTONS.items():
    MOUSE_BUTTON_NAMES[pair[1]] = pair[0]

IMPLEMENTATION = u"Pygame SGE"

ALIGN_LEFT = 2
ALIGN_CENTER = 3
ALIGN_RIGHT = 1
ALIGN_TOP = 8
ALIGN_MIDDLE = 12
ALIGN_BOTTOM = 4

BLEND_NORMAL = 0
BLEND_RGB = 1
BLEND_ALPHA = 2
BLEND_ADD = 4
BLEND_SUBTRACT = 8
BLEND_MULTIPLY = 12
BLEND_SCREEN = 16
BLEND_MINIMUM = 20
BLEND_MAXIMUM = 24

BLEND_RGBA_ADD = BLEND_RGB | BLEND_ALPHA | BLEND_ADD
BLEND_RGBA_SUBTRACT = BLEND_RGB | BLEND_ALPHA | BLEND_SUBTRACT
BLEND_RGBA_MULTIPLY = BLEND_RGB | BLEND_ALPHA | BLEND_MULTIPLY
BLEND_RGBA_SCREEN = BLEND_RGB | BLEND_ALPHA | BLEND_SCREEN
BLEND_RGBA_MINIMUM = BLEND_RGB | BLEND_ALPHA | BLEND_MINIMUM
BLEND_RGBA_MAXIMUM = BLEND_RGB | BLEND_ALPHA | BLEND_MAXIMUM

BLEND_RGB_ADD = BLEND_RGB | BLEND_ADD
BLEND_RGB_SUBTRACT = BLEND_RGB | BLEND_SUBTRACT
BLEND_RGB_MULTIPLY = BLEND_RGB | BLEND_MULTIPLY
BLEND_RGB_SCREEN = BLEND_RGB | BLEND_SCREEN
BLEND_RGB_MINIMUM = BLEND_RGB | BLEND_MINIMUM
BLEND_RGB_MAXIMUM = BLEND_RGB | BLEND_MAXIMUM
