/* zone.h -- a series of timezone names and principal lat/lons.
 *
 * Extracted from /usr/share/zoneinfo/zone.tab, version 1.23 by Paul
 * Eggert <eggert@twinsun.com> (1996-08-05), using the following
 * little Perl script:
 * 
 * #! /usr/bin/perl -Wn
 * if (m/[A-Z]{2}\t([+-][0-9]{2})([0-9]{2})([+-][0-9]{3})([0-9]{2})\t(\S*)/) {
 *     printf "{ %+8.4f, %+9.4f, \"%s\" },\n", $1 + $2/60., $3 + $4/60., $5;
 * } elsif (m/[A-Z]{2}\t([+-][0-9]{2})([0-9]{2})([0-9]{2})([+-][0-9]{3})([0-9]{2})([0-9]{2})\t(\S*)/) {
 *     printf "{ %+8.4f, %+9.4f, \"%s\" },\n", $1 + $2/60. + $3/3600., $4 + $5/60. + $6/3600., $7;
 * }
 */

struct zone_t
{
  double lat; double lon; char *name;
};

static struct zone_t
zone[] =
  {
    { +42.5000,   +1.5167, "Europe/Andorra" },
    { +25.3000,  +55.3000, "Asia/Dubai" },
    { +34.5167,  +69.2000, "Asia/Kabul" },
    { +17.0500,  -60.2000, "America/Antigua" },
    { +18.2000,  -62.9333, "America/Anguilla" },
    { +41.3333,  +19.8333, "Europe/Tirane" },
    { +40.1833,  +44.5000, "Asia/Yerevan" },
    { +12.1833,  -69.0000, "America/Curacao" },
    {  -7.2000,  +13.2333, "Africa/Luanda" },
    { -76.1667, +166.6000, "Antarctica/McMurdo" },
    { -90.0000,   +0.0000, "Antarctica/South_Pole" },
    { -63.2000,  -63.9000, "Antarctica/Palmer" },
    { -66.4000,  +62.8833, "Antarctica/Mawson" },
    { -67.4167,  +77.9667, "Antarctica/Davis" },
    { -65.7167, +110.5167, "Antarctica/Casey" },
    { -77.6000, +106.9000, "Antarctica/Vostok" },
    { -65.3333, +140.0167, "Antarctica/DumontDUrville" },
    { -68.9939,  +39.5900, "Antarctica/Syowa" },
    { -33.4000,  -57.5500, "America/Buenos_Aires" },
    { -31.0500,  -59.3333, "America/Rosario" },
    { -30.6000,  -63.8167, "America/Cordoba" },
    { -23.8167,  -64.7000, "America/Jujuy" },
    { -27.5333,  -64.2167, "America/Catamarca" },
    { -31.1167,  -67.1833, "America/Mendoza" },
    { -13.7333, -169.3000, "Pacific/Pago_Pago" },
    { +48.2167,  +16.3333, "Europe/Vienna" },
    { -30.4500, +159.0833, "Australia/Lord_Howe" },
    { -41.1167, +147.3167, "Australia/Hobart" },
    { -36.1833, +144.9667, "Australia/Melbourne" },
    { -32.1333, +151.2167, "Australia/Sydney" },
    { -30.0500, +141.4500, "Australia/Broken_Hill" },
    { -26.5333, +153.0333, "Australia/Brisbane" },
    { -19.7333, +149.0000, "Australia/Lindeman" },
    { -33.0833, +138.5833, "Australia/Adelaide" },
    { -11.5333, +130.8333, "Australia/Darwin" },
    { -30.0500, +115.8500, "Australia/Perth" },
    { +12.5000,  -67.0333, "America/Aruba" },
    { +40.3833,  +49.8500, "Asia/Baku" },
    { +43.8667,  +18.4167, "Europe/Sarajevo" },
    { +13.1000,  -58.3833, "America/Barbados" },
    { +23.7167,  +90.4167, "Asia/Dhaka" },
    { +50.8333,   +4.3333, "Europe/Brussels" },
    { +12.3667,   -0.4833, "Africa/Ouagadougou" },
    { +42.6833,  +23.3167, "Europe/Sofia" },
    { +26.3833,  +50.5833, "Asia/Bahrain" },
    {  -2.6167,  +29.3667, "Africa/Bujumbura" },
    {  +6.4833,   +2.6167, "Africa/Porto-Novo" },
    { +32.2833,  -63.2333, "Atlantic/Bermuda" },
    {  +4.9333, +114.9167, "Asia/Brunei" },
    { -15.5000,  -67.8500, "America/La_Paz" },
    {  -2.1500,  -31.5833, "America/Noronha" },
    {  -0.5500,  -47.5167, "America/Belem" },
    {  -2.2833,  -37.5000, "America/Fortaleza" },
    {  -7.9500,  -33.1000, "America/Recife" },
    {  -6.8000,  -47.8000, "America/Araguaina" },
    {  -8.3333,  -34.2833, "America/Maceio" },
    { -22.4667,  -45.3833, "America/Sao_Paulo" },
    { -14.4167,  -55.9167, "America/Cuiaba" },
    {  -7.2333,  -62.1000, "America/Porto_Velho" },
    {  +2.8167,  -59.3333, "America/Boa_Vista" },
    {  -2.8667,  -59.9833, "America/Manaus" },
    {  -5.3333,  -68.1333, "America/Eirunepe" },
    {  -8.0333,  -66.2000, "America/Rio_Branco" },
    { +25.0833,  -76.6500, "America/Nassau" },
    { +27.4667,  +89.6500, "Asia/Thimphu" },
    { -24.2500,  +25.9167, "Africa/Gaborone" },
    { +53.9000,  +27.5667, "Europe/Minsk" },
    { +17.5000,  -87.8000, "America/Belize" },
    { +47.5667,  -51.2833, "America/St_Johns" },
    { +44.6500,  -62.4000, "America/Halifax" },
    { +46.2000,  -58.0500, "America/Glace_Bay" },
    { +53.3333,  -59.5833, "America/Goose_Bay" },
    { +45.5167,  -72.4333, "America/Montreal" },
    { +49.0167,  -87.7333, "America/Nipigon" },
    { +48.3833,  -88.7500, "America/Thunder_Bay" },
    { +66.1333,  -64.2667, "America/Pangnirtung" },
    { +63.7333,  -67.5333, "America/Iqaluit" },
    { +62.7500,  -91.8333, "America/Rankin_Inlet" },
    { +49.8833,  -96.8500, "America/Winnipeg" },
    { +48.7167,  -93.5167, "America/Rainy_River" },
    { +69.0500, -104.9167, "America/Cambridge_Bay" },
    { +50.4000, -103.3500, "America/Regina" },
    { +50.2833, -106.1667, "America/Swift_Current" },
    { +53.5500, -112.5333, "America/Edmonton" },
    { +62.4500, -113.6500, "America/Yellowknife" },
    { +68.4167, -112.5000, "America/Inuvik" },
    { +59.7667, -119.7667, "America/Dawson_Creek" },
    { +49.2667, -122.8833, "America/Vancouver" },
    { +60.7167, -134.9500, "America/Whitehorse" },
    { +64.0667, -138.5833, "America/Dawson" },
    { -11.8333,  +96.9167, "Indian/Cocos" },
    {  -3.7000,  +15.3000, "Africa/Kinshasa" },
    { -10.3333,  +27.4667, "Africa/Lubumbashi" },
    {  +4.3667,  +18.5833, "Africa/Bangui" },
    {  -3.7333,  +15.2833, "Africa/Brazzaville" },
    { +47.3833,   +8.5333, "Europe/Zurich" },
    {  +5.3167,   -3.9667, "Africa/Abidjan" },
    { -20.7667, -158.2333, "Pacific/Rarotonga" },
    { -32.5500,  -69.3333, "America/Santiago" },
    { -26.8333, -108.5500, "Pacific/Easter" },
    {  +4.0500,   +9.7000, "Africa/Douala" },
    { +45.7500, +126.6833, "Asia/Harbin" },
    { +31.2333, +121.4667, "Asia/Shanghai" },
    { +29.5667, +106.5833, "Asia/Chungking" },
    { +43.8000,  +87.5833, "Asia/Urumqi" },
    { +39.4833,  +75.9833, "Asia/Kashgar" },
    {  +4.6000,  -73.9167, "America/Bogota" },
    {  +9.9333,  -83.9167, "America/Costa_Rica" },
    { +23.1333,  -81.6333, "America/Havana" },
    { +14.9167,  -22.4833, "Atlantic/Cape_Verde" },
    {  -9.5833, +105.7167, "Indian/Christmas" },
    { +35.1667,  +33.3667, "Asia/Nicosia" },
    { +50.0833,  +14.4333, "Europe/Prague" },
    { +52.5000,  +13.3667, "Europe/Berlin" },
    { +11.6000,  +43.1500, "Africa/Djibouti" },
    { +55.6667,  +12.5833, "Europe/Copenhagen" },
    { +15.3000,  -60.6000, "America/Dominica" },
    { +18.4667,  -68.1000, "America/Santo_Domingo" },
    { +36.7833,   +3.0500, "Africa/Algiers" },
    {  -1.8333,  -78.1667, "America/Guayaquil" },
    {  +0.9000,  -88.4000, "Pacific/Galapagos" },
    { +59.4167,  +24.7500, "Europe/Tallinn" },
    { +30.0500,  +31.2500, "Africa/Cairo" },
    { +27.1500,  -12.8000, "Africa/El_Aaiun" },
    { +15.3333,  +38.8833, "Africa/Asmera" },
    { +40.4000,   -2.3167, "Europe/Madrid" },
    { +35.8833,   -4.6833, "Africa/Ceuta" },
    { +28.1000,  -14.6000, "Atlantic/Canary" },
    {  +9.0333,  +38.7000, "Africa/Addis_Ababa" },
    { +60.1667,  +24.9667, "Europe/Helsinki" },
    { -17.8667, +178.4167, "Pacific/Fiji" },
    { -50.3000,  -56.1500, "Atlantic/Stanley" },
    {  +9.5167, +138.1333, "Pacific/Yap" },
    {  +7.4167, +151.7833, "Pacific/Truk" },
    {  +6.9667, +158.2167, "Pacific/Ponape" },
    {  +5.3167, +162.9833, "Pacific/Kosrae" },
    { +62.0167,   -5.2333, "Atlantic/Faeroe" },
    { +48.8667,   +2.3333, "Europe/Paris" },
    {  +0.3833,   +9.4500, "Africa/Libreville" },
    { +51.4750,   +0.3125, "Europe/London" },
    { +54.5833,   -4.0833, "Europe/Belfast" },
    { +12.0500,  -60.2500, "America/Grenada" },
    { +41.7167,  +44.8167, "Asia/Tbilisi" },
    {  +4.9333,  -51.6667, "America/Cayenne" },
    {  +5.5500,   +0.2167, "Africa/Accra" },
    { +36.1333,   -4.6500, "Europe/Gibraltar" },
    { +70.5000,  -21.7500, "America/Scoresbysund" },
    { +64.1833,  -50.2667, "America/Godthab" },
    { +76.5667,  -67.2167, "America/Thule" },
    { +13.4667,  -15.3500, "Africa/Banjul" },
    {  +9.5167,  -12.2833, "Africa/Conakry" },
    { +16.2333,  -60.4667, "America/Guadeloupe" },
    {  +3.7500,   +8.7833, "Africa/Malabo" },
    { +37.9667,  +23.7167, "Europe/Athens" },
    { -53.7333,  -35.4667, "Atlantic/South_Georgia" },
    { +14.6333,  -89.4833, "America/Guatemala" },
    { +13.4667, +144.7500, "Pacific/Guam" },
    { +11.8500,  -14.4167, "Africa/Bissau" },
    {  +6.8000,  -57.8333, "America/Guyana" },
    { +22.2833, +114.1500, "Asia/Hong_Kong" },
    { +14.1000,  -86.7833, "America/Tegucigalpa" },
    { +45.8000,  +15.9667, "Europe/Zagreb" },
    { +18.5333,  -71.6667, "America/Port-au-Prince" },
    { +47.5000,  +19.0833, "Europe/Budapest" },
    {  -5.8333, +106.8000, "Asia/Jakarta" },
    {  +0.0333, +109.3333, "Asia/Pontianak" },
    {  -4.8833, +119.4000, "Asia/Ujung_Pandang" },
    {  -1.4667, +140.7000, "Asia/Jayapura" },
    { +53.3333,   -5.7500, "Europe/Dublin" },
    { +31.7667,  +35.2333, "Asia/Jerusalem" },
    { +22.5333,  +88.3667, "Asia/Calcutta" },
    {  -6.6667,  +72.4167, "Indian/Chagos" },
    { +33.3500,  +44.4167, "Asia/Baghdad" },
    { +35.6667,  +51.4333, "Asia/Tehran" },
    { +64.1500,  -20.1500, "Atlantic/Reykjavik" },
    { +41.9000,  +12.4833, "Europe/Rome" },
    { +18.0000,  -75.2000, "America/Jamaica" },
    { +31.9500,  +35.9333, "Asia/Amman" },
    { +35.6544, +139.7447, "Asia/Tokyo" },
    {  -0.7167,  +36.8167, "Africa/Nairobi" },
    { +42.9000,  +74.6000, "Asia/Bishkek" },
    { +11.5500, +104.9167, "Asia/Phnom_Penh" },
    {  +1.4167, +173.0000, "Pacific/Tarawa" },
    {  -2.8667, -170.9167, "Pacific/Enderbury" },
    {  +1.8667, -156.6667, "Pacific/Kiritimati" },
    { -10.3167,  +43.2667, "Indian/Comoro" },
    { +17.3000,  -61.2833, "America/St_Kitts" },
    { +39.0167, +125.7500, "Asia/Pyongyang" },
    { +37.5500, +126.9667, "Asia/Seoul" },
    { +29.3333,  +47.9833, "Asia/Kuwait" },
    { +19.3000,  -80.6167, "America/Cayman" },
    { +43.2500,  +76.9500, "Asia/Almaty" },
    { +50.2833,  +57.1667, "Asia/Aqtobe" },
    { +44.5167,  +50.2667, "Asia/Aqtau" },
    { +17.9667, +102.6000, "Asia/Vientiane" },
    { +33.8833,  +35.5000, "Asia/Beirut" },
    { +14.0167,  -61.0000, "America/St_Lucia" },
    { +47.1500,   +9.5167, "Europe/Vaduz" },
    {  +6.9333,  +79.8500, "Asia/Colombo" },
    {  +6.3000,   -9.2167, "Africa/Monrovia" },
    { -28.5333,  +27.5000, "Africa/Maseru" },
    { +54.6833,  +25.3167, "Europe/Vilnius" },
    { +49.6000,   +6.1500, "Europe/Luxembourg" },
    { +56.9500,  +24.1000, "Europe/Riga" },
    { +32.9000,  +13.1833, "Africa/Tripoli" },
    { +33.6500,   -6.4167, "Africa/Casablanca" },
    { +43.7000,   +7.3833, "Europe/Monaco" },
    { +47.0000,  +28.8333, "Europe/Chisinau" },
    { -17.0833,  +47.5167, "Indian/Antananarivo" },
    {  +7.1500, +171.2000, "Pacific/Majuro" },
    {  +9.0833, +167.3333, "Pacific/Kwajalein" },
    { +41.9833,  +21.4333, "Europe/Skopje" },
    { +12.6500,   -8.0000, "Africa/Bamako" },
    { +14.7667,   -2.9833, "Africa/Timbuktu" },
    { +16.7833,  +96.1667, "Asia/Rangoon" },
    { +47.9167, +106.8833, "Asia/Ulaanbaatar" },
    { +48.0167,  +91.6500, "Asia/Hovd" },
    { +48.0667, +114.5000, "Asia/Choibalsan" },
    { +22.2333, +113.5833, "Asia/Macao" },
    { +15.2000, +145.7500, "Pacific/Saipan" },
    { +14.6000,  -60.9167, "America/Martinique" },
    { +18.1000,  -14.0500, "Africa/Nouakchott" },
    { +16.7333,  -61.7833, "America/Montserrat" },
    { +35.9000,  +14.5167, "Europe/Malta" },
    { -19.8333,  +57.5000, "Indian/Mauritius" },
    {  +4.1667,  +73.5000, "Indian/Maldives" },
    { -14.2167,  +35.0000, "Africa/Blantyre" },
    { +19.4000,  -98.8500, "America/Mexico_City" },
    { +21.0833,  -85.2333, "America/Cancun" },
    { +20.9667,  -88.3833, "America/Merida" },
    { +25.6667,  -99.6833, "America/Monterrey" },
    { +23.2167, -105.5833, "America/Mazatlan" },
    { +28.6333, -105.9167, "America/Chihuahua" },
    { +29.0667, -109.0333, "America/Hermosillo" },
    { +32.5333, -116.9833, "America/Tijuana" },
    {  +3.1667, +101.7000, "Asia/Kuala_Lumpur" },
    {  +1.5500, +110.3333, "Asia/Kuching" },
    { -24.0333,  +32.5833, "Africa/Maputo" },
    { -21.4333,  +17.1000, "Africa/Windhoek" },
    { -21.7333, +165.5000, "Pacific/Noumea" },
    { +13.5167,   +2.1167, "Africa/Niamey" },
    { -28.9500, +167.9667, "Pacific/Norfolk" },
    {  +6.4500,   +3.4000, "Africa/Lagos" },
    { +12.1500,  -85.7167, "America/Managua" },
    { +52.3667,   +4.9000, "Europe/Amsterdam" },
    { +59.9167,  +10.7500, "Europe/Oslo" },
    { +27.7167,  +85.3167, "Asia/Katmandu" },
    {  +0.5167, +166.9167, "Pacific/Nauru" },
    { -18.9833, +169.9167, "Pacific/Niue" },
    { -35.1333, +174.7667, "Pacific/Auckland" },
    { -42.0833, -175.5000, "Pacific/Chatham" },
    { +23.6000,  +58.5833, "Asia/Muscat" },
    {  +8.9667,  -78.4667, "America/Panama" },
    { -11.9500,  -76.9500, "America/Lima" },
    { -16.4667, -148.4333, "Pacific/Tahiti" },
    {  -9.0000, -138.5000, "Pacific/Marquesas" },
    { -22.8667, -133.0500, "Pacific/Gambier" },
    {  -8.5000, +147.1667, "Pacific/Port_Moresby" },
    { +14.5833, +121.0000, "Asia/Manila" },
    { +24.8667,  +67.0500, "Asia/Karachi" },
    { +52.2500,  +21.0000, "Europe/Warsaw" },
    { +47.0500,  -55.6667, "America/Miquelon" },
    { -24.9333, -129.9167, "Pacific/Pitcairn" },
    { +18.4683,  -65.8939, "America/Puerto_Rico" },
    { +31.5000,  +34.4667, "Asia/Gaza" },
    { +38.7167,   -8.8667, "Europe/Lisbon" },
    { +32.6333,  -15.1000, "Atlantic/Madeira" },
    { +37.7333,  -24.3333, "Atlantic/Azores" },
    {  +7.3333, +134.4833, "Pacific/Palau" },
    { -24.7333,  -56.3333, "America/Asuncion" },
    { +25.2833,  +51.5333, "Asia/Qatar" },
    { -19.1333,  +55.4667, "Indian/Reunion" },
    { +44.4333,  +26.1000, "Europe/Bucharest" },
    { +54.7167,  +20.5000, "Europe/Kaliningrad" },
    { +55.7500,  +37.5833, "Europe/Moscow" },
    { +53.2000,  +50.1500, "Europe/Samara" },
    { +56.8500,  +60.6000, "Asia/Yekaterinburg" },
    { +55.0000,  +73.4000, "Asia/Omsk" },
    { +55.0333,  +82.9167, "Asia/Novosibirsk" },
    { +56.0167,  +92.8333, "Asia/Krasnoyarsk" },
    { +52.2667, +104.3333, "Asia/Irkutsk" },
    { +62.0000, +129.6667, "Asia/Yakutsk" },
    { +43.1667, +131.9333, "Asia/Vladivostok" },
    { +59.5667, +150.8000, "Asia/Magadan" },
    { +53.0167, +158.6500, "Asia/Kamchatka" },
    { +64.7500, +177.4833, "Asia/Anadyr" },
    {  -0.0500,  +30.0667, "Africa/Kigali" },
    { +24.6333,  +46.7167, "Asia/Riyadh" },
    {  -8.4667, +160.2000, "Pacific/Guadalcanal" },
    {  -3.3333,  +55.4667, "Indian/Mahe" },
    { +15.6000,  +32.5333, "Africa/Khartoum" },
    { +59.3333,  +18.0500, "Europe/Stockholm" },
    {  +1.2833, +103.8500, "Asia/Singapore" },
    { -14.0833,   -4.3000, "Atlantic/St_Helena" },
    { +46.0500,  +14.5167, "Europe/Ljubljana" },
    { +78.0000,  +16.0000, "Arctic/Longyearbyen" },
    { +70.9833,   -7.9167, "Atlantic/Jan_Mayen" },
    { +48.1500,  +17.1167, "Europe/Bratislava" },
    {  +8.5000,  -12.7500, "Africa/Freetown" },
    { +43.9167,  +12.4667, "Europe/San_Marino" },
    { +14.6667,  -16.5667, "Africa/Dakar" },
    {  +2.0667,  +45.3667, "Africa/Mogadishu" },
    {  +5.8333,  -54.8333, "America/Paramaribo" },
    {  +0.3333,   +6.7333, "Africa/Sao_Tome" },
    { +13.7000,  -88.8000, "America/El_Salvador" },
    { +33.5000,  +36.3000, "Asia/Damascus" },
    { -25.7000,  +31.1000, "Africa/Mbabane" },
    { +21.4667,  -70.8667, "America/Grand_Turk" },
    { +12.1167,  +15.0500, "Africa/Ndjamena" },
    { -48.6472,  +70.2175, "Indian/Kerguelen" },
    {  +6.1333,   +1.2167, "Africa/Lome" },
    { +13.7500, +100.5167, "Asia/Bangkok" },
    { +38.5833,  +68.8000, "Asia/Dushanbe" },
    {  -8.6333, -170.7667, "Pacific/Fakaofo" },
    { +37.9500,  +58.3833, "Asia/Ashgabat" },
    { +36.8000,  +10.1833, "Africa/Tunis" },
    { -20.8333, +175.1667, "Pacific/Tongatapu" },
    {  -7.4500, +125.5833, "Asia/Dili" },
    { +41.0167,  +28.9667, "Europe/Istanbul" },
    { +10.6500,  -60.4833, "America/Port_of_Spain" },
    {  -7.4833, +179.2167, "Pacific/Funafuti" },
    { +25.0500, +121.5000, "Asia/Taipei" },
    {  -5.2000,  +39.2833, "Africa/Dar_es_Salaam" },
    { +50.4333,  +30.5167, "Europe/Kiev" },
    { +48.6167,  +22.3000, "Europe/Uzhgorod" },
    { +47.8333,  +35.1667, "Europe/Zaporozhye" },
    { +44.9500,  +34.1000, "Europe/Simferopol" },
    {  +0.3167,  +32.4167, "Africa/Kampala" },
    { +17.0000, -167.5000, "Pacific/Johnston" },
    { +28.2167, -176.6333, "Pacific/Midway" },
    { +19.2833, +166.6167, "Pacific/Wake" },
    { +40.7142,  -73.9936, "America/New_York" },
    { +42.3314,  -82.9542, "America/Detroit" },
    { +38.2542,  -84.2406, "America/Louisville" },
    { +36.8297,  -83.1508, "America/Kentucky/Monticello" },
    { +39.7683,  -85.8419, "America/Indianapolis" },
    { +38.3756,  -85.6553, "America/Indiana/Marengo" },
    { +41.2958,  -85.3750, "America/Indiana/Knox" },
    { +38.7478,  -84.9328, "America/Indiana/Vevay" },
    { +41.8500,  -86.3500, "America/Chicago" },
    { +45.1078,  -86.3858, "America/Menominee" },
    { +39.7392, -103.0158, "America/Denver" },
    { +43.6136, -115.7975, "America/Boise" },
    { +36.7856, -107.3136, "America/Shiprock" },
    { +33.4483, -111.9267, "America/Phoenix" },
    { +34.0522, -117.7572, "America/Los_Angeles" },
    { +61.2181, -148.0997, "America/Anchorage" },
    { +58.3019, -133.5803, "America/Juneau" },
    { +59.5469, -138.2728, "America/Yakutat" },
    { +64.5011, -164.5936, "America/Nome" },
    { +51.8800, -175.3419, "America/Adak" },
    { +21.3069, -156.1417, "Pacific/Honolulu" },
    { -33.1167,  -55.8167, "America/Montevideo" },
    { +39.6667,  +66.8000, "Asia/Samarkand" },
    { +41.3333,  +69.3000, "Asia/Tashkent" },
    { +41.9000,  +12.4500, "Europe/Vatican" },
    { +13.1500,  -60.7667, "America/St_Vincent" },
    { +10.5000,  -65.0667, "America/Caracas" },
    { +18.4500,  -63.3833, "America/Tortola" },
    { +18.3500,  -63.0667, "America/St_Thomas" },
    { +10.7500, +106.6667, "Asia/Saigon" },
    { -16.3333, +168.4167, "Pacific/Efate" },
    { -12.7000, -175.8333, "Pacific/Wallis" },
    { -12.1667, -170.2667, "Pacific/Apia" },
    { +12.7500,  +45.2000, "Asia/Aden" },
    { -11.2167,  +45.2333, "Indian/Mayotte" },
    { +44.8333,  +20.5000, "Europe/Belgrade" },
    { -25.7500,  +28.0000, "Africa/Johannesburg" },
    { -14.5833,  +28.2833, "Africa/Lusaka" },
    { -16.1667,  +31.0500, "Africa/Harare" },
    { 0, 0, NULL }
  };
