/* utils -- assorted utility routines.
 *
 * Copyright (C) 2001 John Kodis <kodis@jagunet.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef UTILS_H
#define UTILS_H

#include <config.h>
#include <fcc.h>

#include <stdio.h>
#include <stdlib.h>

extern char *prog_name;

const char *optchars;
struct option const *long_options;

int emit_tsv(void);
int emit_details(band_enum *band, off_t *fac_off, off_t *eng_off);

int sort_add_keys(Search *search, char *key_str);

int process_option(Search *search, int c, char *optarg);
void print_ingest_progress(char *fn, int recs, int entries, int alloc);

#ifdef __GNUC__
#  define FORMAT_PRINTF_1_2  __attribute__((format(printf, 1, 2)))
#else
#  define FORMAT_PRINTF_1_2
#endif
void warn(char *fmt, ...) FORMAT_PRINTF_1_2;
void debug(char *fmt, ...) FORMAT_PRINTF_1_2;
void fatal(char *fmt, ...) FORMAT_PRINTF_1_2;

char *fstrdup(const char *s);
void *fmalloc(size_t len);
void *fmalloc0(size_t len);
void *frealloc(void *mem, size_t len);

int streq(const char *s1, const char *s2);
int split(char **field, int f_max, char *line, char sep);
char *skipbl(char *s0);
char *capitalize(char *s0);
char *callsign_normalize(char *call);

const char *rad2point(double rad);
double deg2rad(double degrees);
double rad2deg(double radians);
double tdiff(struct timeval *t0, struct timeval *t1);

int search_set_location(Search *search, char *str);
int search_set_distance(Search *search, const char *s);
int search_set_corf(Search *search, const char *s0);
int search_set_keep(Search *search, const char *s0);
void search_dump(Search *search, FILE *s);

void gc(double lat0, double lon0, double lat1, double lon1,
  double *arc, double *head);

#endif
