# Paths.pm -- variables with the paths to various directories and programs.
#
# Copyright (C) 2001-2003, John Kodis <john@kodis.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

package Paths;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw( $prefix $details_url $plot_dir_url $plot_dir );


# host -- hostname of the web server.  This can be left as
# localhost if you're only interested in serving web pages locally to
# the web server.

my $host = "localhost";


# project -- the name of the web directory used for the station
# information project.  This could be a virtual web server.

my $project = "station-info";


# plot_dir -- the absolute path to the directory used to hold
# radiation pattern plot files.  This directory must allow read access
# for the web server process and write access for the web server
# cgi-bin scripts.  Frequently, this will mean that this directory
# should belong to the apache or nobody groups and have group read and
# write permissions.

my $doc_root = "/var/www/html";
$plot_dir = "$doc_root/$project/plot";


# plot_dir_url -- the prefix used to form the URL of the radiation
# plot file directory, $plot_dir, described above.

$plot_dir_url = "http://$host/$project/plot";


# details_url -- the full URL to the details.cgi script.

$details_url = "http://$host/cgi-bin/$project/details.cgi";


# prefix -- the build prefix used when configuring the makefiles.  If
# no prefix was explicitly specified, this will have defaulted to
# /usr/local.

$prefix = "/usr/local";


1;
