/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

static GnomeUIInfo file_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_PRINT_ITEM (on_print_activate, NULL),
  GNOMEUIINFO_MENU_PREFERENCES_ITEM (on_preferences_activate, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (on_exit_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo help_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("_Help"),
    NULL,
    (gpointer) on_help_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_MENU_ABOUT_ITEM (on_about_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo menubar_uiinfo[] =
{
  GNOMEUIINFO_MENU_FILE_TREE (file_menu_uiinfo),
  GNOMEUIINFO_MENU_HELP_TREE (help_menu_uiinfo),
  GNOMEUIINFO_END
};

GtkWidget*
create_station_info (void)
{
  GtkWidget *station_info;
  GtkWidget *dock;
  GtkWidget *app_vbox;
  GtkWidget *table;
  GtkWidget *location_label;
  GtkWidget *dist_label;
  GtkWidget *corf_label;
  GtkWidget *band_label;
  GtkWidget *options_label;
  GtkWidget *display_label;
  GtkWidget *location_combo_entry;
  GtkWidget *location_entry;
  GtkWidget *band_hbox;
  GtkWidget *am_checkbutton;
  GtkWidget *fm_checkbutton;
  GtkWidget *tv_checkbutton;
  GtkWidget *options_hbox;
  GtkWidget *new_checkbutton;
  GtkWidget *old_checkbutton;
  GtkWidget *anc_checkbutton;
  GtkWidget *display_hbox;
  GtkWidget *keep_combo_entry;
  GtkWidget *keep_entry;
  GSList *display_hbox_group = NULL;
  GtkWidget *strongest_radiobutton;
  GtkWidget *nearest_radiobutton;
  GtkWidget *distance_combo_entry;
  GtkWidget *distance_entry;
  GtkWidget *corf_combo_entry;
  GtkWidget *corf_entry;
  GtkWidget *search_button;
  GtkWidget *scrolledwindow;
  GtkWidget *clist;
  GtkWidget *corf_column_label;
  GtkWidget *service_status_column_label;
  GtkWidget *callsign_column_label;
  GtkWidget *power_column_label;
  GtkWidget *distance_column_label;
  GtkWidget *heading_column_label;
  GtkWidget *location_column_label;
  GtkWidget *appbar;

  station_info = gnome_app_new ("Station Info", _("Station Info"));
  gtk_object_set_data (GTK_OBJECT (station_info), "station_info", station_info);

  dock = GNOME_APP (station_info)->dock;
  gtk_widget_ref (dock);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "dock", dock,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dock);

  gnome_app_create_menus (GNOME_APP (station_info), menubar_uiinfo);

  gtk_widget_ref (menubar_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "file",
                            menubar_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file_menu_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "print",
                            file_menu_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file_menu_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "preferences",
                            file_menu_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file_menu_uiinfo[2].widget);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "separator2",
                            file_menu_uiinfo[2].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (file_menu_uiinfo[3].widget);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "exit",
                            file_menu_uiinfo[3].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (menubar_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "help",
                            menubar_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (help_menu_uiinfo[0].widget);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "help",
                            help_menu_uiinfo[0].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  gtk_widget_ref (help_menu_uiinfo[1].widget);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "about",
                            help_menu_uiinfo[1].widget,
                            (GtkDestroyNotify) gtk_widget_unref);

  app_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (app_vbox);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "app_vbox", app_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (app_vbox);
  gnome_app_set_contents (GNOME_APP (station_info), app_vbox);

  table = gtk_table_new (7, 2, FALSE);
  gtk_widget_ref (table);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "table", table,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (app_vbox), table, FALSE, FALSE, 0);

  location_label = gtk_label_new (_("Location"));
  gtk_widget_ref (location_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "location_label", location_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (location_label);
  gtk_table_attach (GTK_TABLE (table), location_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (location_label), 0, 0.5);

  dist_label = gtk_label_new (_("Distance"));
  gtk_widget_ref (dist_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "dist_label", dist_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (dist_label);
  gtk_table_attach (GTK_TABLE (table), dist_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (dist_label), 0, 0.5);

  corf_label = gtk_label_new (_("Freq/Chan"));
  gtk_widget_ref (corf_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "corf_label", corf_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (corf_label);
  gtk_table_attach (GTK_TABLE (table), corf_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (corf_label), 0, 0.5);

  band_label = gtk_label_new (_("Band"));
  gtk_widget_ref (band_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "band_label", band_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (band_label);
  gtk_table_attach (GTK_TABLE (table), band_label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (band_label), 0, 0.5);

  options_label = gtk_label_new (_("Options"));
  gtk_widget_ref (options_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "options_label", options_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (options_label);
  gtk_table_attach (GTK_TABLE (table), options_label, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (options_label), 0, 0.5);

  display_label = gtk_label_new (_("Display"));
  gtk_widget_ref (display_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "display_label", display_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (display_label);
  gtk_table_attach (GTK_TABLE (table), display_label, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (display_label), 0, 0.5);

  location_combo_entry = gnome_entry_new (NULL);
  gtk_widget_ref (location_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "location_combo_entry", location_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (location_combo_entry);
  gtk_table_attach (GTK_TABLE (table), location_combo_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  location_entry = gnome_entry_gtk_entry (GNOME_ENTRY (location_combo_entry));
  gtk_widget_ref (location_entry);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "location_entry", location_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (location_entry);

  band_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (band_hbox);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "band_hbox", band_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (band_hbox);
  gtk_table_attach (GTK_TABLE (table), band_hbox, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  am_checkbutton = gtk_check_button_new_with_label (_("AM"));
  gtk_widget_ref (am_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "am_checkbutton", am_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (am_checkbutton);
  gtk_box_pack_start (GTK_BOX (band_hbox), am_checkbutton, FALSE, FALSE, 0);

  fm_checkbutton = gtk_check_button_new_with_label (_("FM"));
  gtk_widget_ref (fm_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "fm_checkbutton", fm_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fm_checkbutton);
  gtk_box_pack_start (GTK_BOX (band_hbox), fm_checkbutton, FALSE, FALSE, 0);

  tv_checkbutton = gtk_check_button_new_with_label (_("TV"));
  gtk_widget_ref (tv_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "tv_checkbutton", tv_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tv_checkbutton);
  gtk_box_pack_start (GTK_BOX (band_hbox), tv_checkbutton, FALSE, FALSE, 0);

  options_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (options_hbox);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "options_hbox", options_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (options_hbox);
  gtk_table_attach (GTK_TABLE (table), options_hbox, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  new_checkbutton = gtk_check_button_new_with_label (_("New"));
  gtk_widget_ref (new_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "new_checkbutton", new_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (new_checkbutton);
  gtk_box_pack_start (GTK_BOX (options_hbox), new_checkbutton, FALSE, FALSE, 0);

  old_checkbutton = gtk_check_button_new_with_label (_("Old"));
  gtk_widget_ref (old_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "old_checkbutton", old_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (old_checkbutton);
  gtk_box_pack_start (GTK_BOX (options_hbox), old_checkbutton, FALSE, FALSE, 0);

  anc_checkbutton = gtk_check_button_new_with_label (_("Ancilliary"));
  gtk_widget_ref (anc_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "anc_checkbutton", anc_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (anc_checkbutton);
  gtk_box_pack_start (GTK_BOX (options_hbox), anc_checkbutton, FALSE, FALSE, 0);

  display_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (display_hbox);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "display_hbox", display_hbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (display_hbox);
  gtk_table_attach (GTK_TABLE (table), display_hbox, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  keep_combo_entry = gnome_entry_new (NULL);
  gtk_widget_ref (keep_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "keep_combo_entry", keep_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (keep_combo_entry);
  gtk_box_pack_start (GTK_BOX (display_hbox), keep_combo_entry, TRUE, TRUE, 0);

  keep_entry = gnome_entry_gtk_entry (GNOME_ENTRY (keep_combo_entry));
  gtk_widget_ref (keep_entry);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "keep_entry", keep_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (keep_entry);

  strongest_radiobutton = gtk_radio_button_new_with_label (display_hbox_group, _("Strongest"));
  display_hbox_group = gtk_radio_button_group (GTK_RADIO_BUTTON (strongest_radiobutton));
  gtk_widget_ref (strongest_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "strongest_radiobutton", strongest_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (strongest_radiobutton);
  gtk_box_pack_start (GTK_BOX (display_hbox), strongest_radiobutton, FALSE, FALSE, 0);

  nearest_radiobutton = gtk_radio_button_new_with_label (display_hbox_group, _("Nearest"));
  display_hbox_group = gtk_radio_button_group (GTK_RADIO_BUTTON (nearest_radiobutton));
  gtk_widget_ref (nearest_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "nearest_radiobutton", nearest_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (nearest_radiobutton);
  gtk_box_pack_start (GTK_BOX (display_hbox), nearest_radiobutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (nearest_radiobutton), TRUE);

  distance_combo_entry = gnome_entry_new (NULL);
  gtk_widget_ref (distance_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "distance_combo_entry", distance_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (distance_combo_entry);
  gtk_table_attach (GTK_TABLE (table), distance_combo_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  distance_entry = gnome_entry_gtk_entry (GNOME_ENTRY (distance_combo_entry));
  gtk_widget_ref (distance_entry);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "distance_entry", distance_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (distance_entry);

  corf_combo_entry = gnome_entry_new (NULL);
  gtk_widget_ref (corf_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "corf_combo_entry", corf_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (corf_combo_entry);
  gtk_table_attach (GTK_TABLE (table), corf_combo_entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  corf_entry = gnome_entry_gtk_entry (GNOME_ENTRY (corf_combo_entry));
  gtk_widget_ref (corf_entry);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "corf_entry", corf_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (corf_entry);

  search_button = gtk_button_new_with_label (_("Search"));
  gtk_widget_ref (search_button);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "search_button", search_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_button);
  gtk_table_attach (GTK_TABLE (table), search_button, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "scrolledwindow", scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow);
  gtk_box_pack_start (GTK_BOX (app_vbox), scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clist = gtk_clist_new (7);
  gtk_widget_ref (clist);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "clist", clist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), clist);
  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 1, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 2, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 3, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 4, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 5, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist), 6, 80);
  gtk_clist_column_titles_show (GTK_CLIST (clist));

  corf_column_label = gtk_label_new (_("Channel"));
  gtk_widget_ref (corf_column_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "corf_column_label", corf_column_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (corf_column_label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 0, corf_column_label);
  GTK_WIDGET_SET_FLAGS (corf_column_label, GTK_CAN_FOCUS);

  service_status_column_label = gtk_label_new (_("Service\nStatus"));
  gtk_widget_ref (service_status_column_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "service_status_column_label", service_status_column_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (service_status_column_label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 1, service_status_column_label);

  callsign_column_label = gtk_label_new (_("Callsign"));
  gtk_widget_ref (callsign_column_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "callsign_column_label", callsign_column_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (callsign_column_label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 2, callsign_column_label);

  power_column_label = gtk_label_new (_("Power"));
  gtk_widget_ref (power_column_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "power_column_label", power_column_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (power_column_label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 3, power_column_label);

  distance_column_label = gtk_label_new (_("Distance"));
  gtk_widget_ref (distance_column_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "distance_column_label", distance_column_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (distance_column_label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 4, distance_column_label);

  heading_column_label = gtk_label_new (_("Heading"));
  gtk_widget_ref (heading_column_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "heading_column_label", heading_column_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (heading_column_label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 5, heading_column_label);

  location_column_label = gtk_label_new (_("Location"));
  gtk_widget_ref (location_column_label);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "location_column_label", location_column_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (location_column_label);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 6, location_column_label);
  gtk_label_set_justify (GTK_LABEL (location_column_label), GTK_JUSTIFY_LEFT);

  appbar = gnome_appbar_new (TRUE, TRUE, GNOME_PREFERENCES_NEVER);
  gtk_widget_ref (appbar);
  gtk_object_set_data_full (GTK_OBJECT (station_info), "appbar", appbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (appbar);
  gnome_app_set_statusbar (GNOME_APP (station_info), appbar);

  gtk_signal_connect (GTK_OBJECT (station_info), "destroy",
                      GTK_SIGNAL_FUNC (on_station_info_destroy),
                      NULL);
  gnome_app_install_menu_hints (GNOME_APP (station_info), menubar_uiinfo);
  gtk_signal_connect (GTK_OBJECT (strongest_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_strongest_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (nearest_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_nearest_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_button), "clicked",
                      GTK_SIGNAL_FUNC (on_search_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (clist), "click_column",
                      GTK_SIGNAL_FUNC (on_clist_click_column),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (clist), "button_release_event",
                      GTK_SIGNAL_FUNC (on_clist_button_release_event),
                      NULL);

  gtk_widget_grab_focus (corf_column_label);
  return station_info;
}

GtkWidget*
create_splash (void)
{
  GtkWidget *splash;
  GtkWidget *splash_dialog_vbox;
  GtkWidget *splash_scrolledwindow;
  GtkWidget *splash_clist;
  GtkWidget *database_label;
  GtkWidget *records_label;
  GtkWidget *splash_dialog_action_area;
  GtkWidget *splash_okay_button;

  splash = gnome_dialog_new (_("Station Info: loading databases..."), NULL);
  gtk_object_set_data (GTK_OBJECT (splash), "splash", splash);
  gtk_widget_set_usize (splash, 240, 320);
  GTK_WIDGET_SET_FLAGS (splash, GTK_CAN_FOCUS);
  GTK_WINDOW (splash)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_policy (GTK_WINDOW (splash), TRUE, TRUE, TRUE);
  gnome_dialog_set_close (GNOME_DIALOG (splash), TRUE);

  splash_dialog_vbox = GNOME_DIALOG (splash)->vbox;
  gtk_object_set_data (GTK_OBJECT (splash), "splash_dialog_vbox", splash_dialog_vbox);
  gtk_widget_show (splash_dialog_vbox);

  splash_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (splash_scrolledwindow);
  gtk_object_set_data_full (GTK_OBJECT (splash), "splash_scrolledwindow", splash_scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (splash_scrolledwindow);
  gtk_box_pack_start (GTK_BOX (splash_dialog_vbox), splash_scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (splash_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  splash_clist = gtk_clist_new (2);
  gtk_widget_ref (splash_clist);
  gtk_object_set_data_full (GTK_OBJECT (splash), "splash_clist", splash_clist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (splash_clist);
  gtk_container_add (GTK_CONTAINER (splash_scrolledwindow), splash_clist);
  gtk_clist_set_column_width (GTK_CLIST (splash_clist), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (splash_clist), 1, 80);
  gtk_clist_column_titles_show (GTK_CLIST (splash_clist));

  database_label = gtk_label_new (_("Database"));
  gtk_widget_ref (database_label);
  gtk_object_set_data_full (GTK_OBJECT (splash), "database_label", database_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (database_label);
  gtk_clist_set_column_widget (GTK_CLIST (splash_clist), 0, database_label);

  records_label = gtk_label_new (_("Records"));
  gtk_widget_ref (records_label);
  gtk_object_set_data_full (GTK_OBJECT (splash), "records_label", records_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (records_label);
  gtk_clist_set_column_widget (GTK_CLIST (splash_clist), 1, records_label);
  gtk_label_set_justify (GTK_LABEL (records_label), GTK_JUSTIFY_RIGHT);

  splash_dialog_action_area = GNOME_DIALOG (splash)->action_area;
  gtk_object_set_data (GTK_OBJECT (splash), "splash_dialog_action_area", splash_dialog_action_area);
  gtk_widget_show (splash_dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (splash_dialog_action_area), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (splash_dialog_action_area), 8);

  gnome_dialog_append_button (GNOME_DIALOG (splash), GNOME_STOCK_BUTTON_OK);
  splash_okay_button = GTK_WIDGET (g_list_last (GNOME_DIALOG (splash)->buttons)->data);
  gtk_widget_ref (splash_okay_button);
  gtk_object_set_data_full (GTK_OBJECT (splash), "splash_okay_button", splash_okay_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (splash_okay_button);
  GTK_WIDGET_SET_FLAGS (splash_okay_button, GTK_CAN_DEFAULT);

  return splash;
}

GtkWidget*
create_location_msgbox (void)
{
  GtkWidget *location_msgbox;
  GtkWidget *dialog_vbox2;
  GtkWidget *button4;
  GtkWidget *dialog_action_area2;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  location_msgbox = gnome_message_box_new (_("Location is invalid."),
                              GNOME_MESSAGE_BOX_ERROR,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (location_msgbox)->action_area), GNOME_DIALOG (location_msgbox)->buttons->data);
  GNOME_DIALOG (location_msgbox)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (location_msgbox), "location_msgbox", location_msgbox);
  gtk_window_set_title (GTK_WINDOW (location_msgbox), _("Station Info: Error"));
  gtk_window_set_policy (GTK_WINDOW (location_msgbox), FALSE, FALSE, FALSE);

  dialog_vbox2 = GNOME_DIALOG (location_msgbox)->vbox;
  gtk_object_set_data (GTK_OBJECT (location_msgbox), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  gnome_dialog_append_button (GNOME_DIALOG (location_msgbox), GNOME_STOCK_BUTTON_OK);
  button4 = GTK_WIDGET (g_list_last (GNOME_DIALOG (location_msgbox)->buttons)->data);
  gtk_widget_ref (button4);
  gtk_object_set_data_full (GTK_OBJECT (location_msgbox), "button4", button4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button4);
  GTK_WIDGET_SET_FLAGS (button4, GTK_CAN_DEFAULT);

  dialog_action_area2 = GNOME_DIALOG (location_msgbox)->action_area;
  gtk_widget_ref (dialog_action_area2);
  gtk_object_set_data_full (GTK_OBJECT (location_msgbox), "dialog_action_area2", dialog_action_area2,
                            (GtkDestroyNotify) gtk_widget_unref);

  return location_msgbox;
}

GtkWidget*
create_distance_msgbox (void)
{
  GtkWidget *distance_msgbox;
  GtkWidget *dialog_vbox3;
  GtkWidget *button5;
  GtkWidget *dialog_action_area3;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  distance_msgbox = gnome_message_box_new (_("Distance is invalid."),
                              GNOME_MESSAGE_BOX_ERROR,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (distance_msgbox)->action_area), GNOME_DIALOG (distance_msgbox)->buttons->data);
  GNOME_DIALOG (distance_msgbox)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (distance_msgbox), "distance_msgbox", distance_msgbox);
  gtk_window_set_title (GTK_WINDOW (distance_msgbox), _("Station Info: Error"));
  gtk_window_set_policy (GTK_WINDOW (distance_msgbox), FALSE, FALSE, FALSE);

  dialog_vbox3 = GNOME_DIALOG (distance_msgbox)->vbox;
  gtk_object_set_data (GTK_OBJECT (distance_msgbox), "dialog_vbox3", dialog_vbox3);
  gtk_widget_show (dialog_vbox3);

  gnome_dialog_append_button (GNOME_DIALOG (distance_msgbox), GNOME_STOCK_BUTTON_OK);
  button5 = GTK_WIDGET (g_list_last (GNOME_DIALOG (distance_msgbox)->buttons)->data);
  gtk_widget_ref (button5);
  gtk_object_set_data_full (GTK_OBJECT (distance_msgbox), "button5", button5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button5);
  GTK_WIDGET_SET_FLAGS (button5, GTK_CAN_DEFAULT);

  dialog_action_area3 = GNOME_DIALOG (distance_msgbox)->action_area;
  gtk_widget_ref (dialog_action_area3);
  gtk_object_set_data_full (GTK_OBJECT (distance_msgbox), "dialog_action_area3", dialog_action_area3,
                            (GtkDestroyNotify) gtk_widget_unref);

  return distance_msgbox;
}

GtkWidget*
create_corf_msgbox (void)
{
  GtkWidget *corf_msgbox;
  GtkWidget *dialog_vbox4;
  GtkWidget *button6;
  GtkWidget *dialog_action_area4;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  corf_msgbox = gnome_message_box_new (_("Channel or frequency is invalid."),
                              GNOME_MESSAGE_BOX_ERROR,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (corf_msgbox)->action_area), GNOME_DIALOG (corf_msgbox)->buttons->data);
  GNOME_DIALOG (corf_msgbox)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (corf_msgbox), "corf_msgbox", corf_msgbox);
  gtk_window_set_title (GTK_WINDOW (corf_msgbox), _("Station Info: Error"));
  gtk_window_set_policy (GTK_WINDOW (corf_msgbox), FALSE, FALSE, FALSE);

  dialog_vbox4 = GNOME_DIALOG (corf_msgbox)->vbox;
  gtk_object_set_data (GTK_OBJECT (corf_msgbox), "dialog_vbox4", dialog_vbox4);
  gtk_widget_show (dialog_vbox4);

  gnome_dialog_append_button (GNOME_DIALOG (corf_msgbox), GNOME_STOCK_BUTTON_OK);
  button6 = GTK_WIDGET (g_list_last (GNOME_DIALOG (corf_msgbox)->buttons)->data);
  gtk_widget_ref (button6);
  gtk_object_set_data_full (GTK_OBJECT (corf_msgbox), "button6", button6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button6);
  GTK_WIDGET_SET_FLAGS (button6, GTK_CAN_DEFAULT);

  dialog_action_area4 = GNOME_DIALOG (corf_msgbox)->action_area;
  gtk_widget_ref (dialog_action_area4);
  gtk_object_set_data_full (GTK_OBJECT (corf_msgbox), "dialog_action_area4", dialog_action_area4,
                            (GtkDestroyNotify) gtk_widget_unref);

  return corf_msgbox;
}

GtkWidget*
create_need_data_msgbox (void)
{
  GtkWidget *need_data_msgbox;
  GtkWidget *dialog_vbox5;
  GtkWidget *button9;
  GtkWidget *dialog_action_area5;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  need_data_msgbox = gnome_message_box_new (_("Database files not found.\n\nYou must run station-info-db-fetch\nto retrieve a copy of the FCC database\nfiles in order to continue."),
                              GNOME_MESSAGE_BOX_ERROR,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (need_data_msgbox)->action_area), GNOME_DIALOG (need_data_msgbox)->buttons->data);
  GNOME_DIALOG (need_data_msgbox)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (need_data_msgbox), "need_data_msgbox", need_data_msgbox);
  gtk_window_set_title (GTK_WINDOW (need_data_msgbox), _("Station Info: Error"));
  gtk_window_set_policy (GTK_WINDOW (need_data_msgbox), FALSE, FALSE, FALSE);

  dialog_vbox5 = GNOME_DIALOG (need_data_msgbox)->vbox;
  gtk_object_set_data (GTK_OBJECT (need_data_msgbox), "dialog_vbox5", dialog_vbox5);
  gtk_widget_show (dialog_vbox5);

  gnome_dialog_append_button (GNOME_DIALOG (need_data_msgbox), GNOME_STOCK_BUTTON_OK);
  button9 = GTK_WIDGET (g_list_last (GNOME_DIALOG (need_data_msgbox)->buttons)->data);
  gtk_widget_ref (button9);
  gtk_object_set_data_full (GTK_OBJECT (need_data_msgbox), "button9", button9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button9);
  GTK_WIDGET_SET_FLAGS (button9, GTK_CAN_DEFAULT);

  dialog_action_area5 = GNOME_DIALOG (need_data_msgbox)->action_area;
  gtk_widget_ref (dialog_action_area5);
  gtk_object_set_data_full (GTK_OBJECT (need_data_msgbox), "dialog_action_area5", dialog_action_area5,
                            (GtkDestroyNotify) gtk_widget_unref);

  return need_data_msgbox;
}

GtkWidget*
create_keep_msgbox (void)
{
  GtkWidget *keep_msgbox;
  GtkWidget *dialog_vbox6;
  GtkWidget *button10;
  GtkWidget *dialog_action_area6;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  keep_msgbox = gnome_message_box_new (_("The number of stations to\nkeep in the display is invalid."),
                              GNOME_MESSAGE_BOX_ERROR,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (keep_msgbox)->action_area), GNOME_DIALOG (keep_msgbox)->buttons->data);
  GNOME_DIALOG (keep_msgbox)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (keep_msgbox), "keep_msgbox", keep_msgbox);
  gtk_window_set_title (GTK_WINDOW (keep_msgbox), _("Station Info: Error"));
  gtk_window_set_policy (GTK_WINDOW (keep_msgbox), FALSE, FALSE, FALSE);

  dialog_vbox6 = GNOME_DIALOG (keep_msgbox)->vbox;
  gtk_object_set_data (GTK_OBJECT (keep_msgbox), "dialog_vbox6", dialog_vbox6);
  gtk_widget_show (dialog_vbox6);

  gnome_dialog_append_button (GNOME_DIALOG (keep_msgbox), GNOME_STOCK_BUTTON_OK);
  button10 = GTK_WIDGET (g_list_last (GNOME_DIALOG (keep_msgbox)->buttons)->data);
  gtk_widget_ref (button10);
  gtk_object_set_data_full (GTK_OBJECT (keep_msgbox), "button10", button10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button10);
  GTK_WIDGET_SET_FLAGS (button10, GTK_CAN_DEFAULT);

  dialog_action_area6 = GNOME_DIALOG (keep_msgbox)->action_area;
  gtk_widget_ref (dialog_action_area6);
  gtk_object_set_data_full (GTK_OBJECT (keep_msgbox), "dialog_action_area6", dialog_action_area6,
                            (GtkDestroyNotify) gtk_widget_unref);

  return keep_msgbox;
}

GtkWidget*
create_sorry_msgbox (void)
{
  GtkWidget *sorry_msgbox;
  GtkWidget *dialog_vbox7;
  GtkWidget *button11;
  GtkWidget *dialog_action_area7;

  /* We create it with an OK button, and then remove the button, to work
     around a bug in gnome-libs. */
  sorry_msgbox = gnome_message_box_new (_("Sorry...\nThat feature hasn't been implemented yet."),
                              GNOME_MESSAGE_BOX_INFO,
                              GNOME_STOCK_BUTTON_OK, NULL);
  gtk_container_remove (GTK_CONTAINER (GNOME_DIALOG (sorry_msgbox)->action_area), GNOME_DIALOG (sorry_msgbox)->buttons->data);
  GNOME_DIALOG (sorry_msgbox)->buttons = NULL;
  gtk_object_set_data (GTK_OBJECT (sorry_msgbox), "sorry_msgbox", sorry_msgbox);
  gtk_window_set_title (GTK_WINDOW (sorry_msgbox), _("Station Info: Sorry..."));
  gtk_window_set_policy (GTK_WINDOW (sorry_msgbox), FALSE, FALSE, FALSE);

  dialog_vbox7 = GNOME_DIALOG (sorry_msgbox)->vbox;
  gtk_object_set_data (GTK_OBJECT (sorry_msgbox), "dialog_vbox7", dialog_vbox7);
  gtk_widget_show (dialog_vbox7);

  gnome_dialog_append_button (GNOME_DIALOG (sorry_msgbox), GNOME_STOCK_BUTTON_OK);
  button11 = GTK_WIDGET (g_list_last (GNOME_DIALOG (sorry_msgbox)->buttons)->data);
  gtk_widget_ref (button11);
  gtk_object_set_data_full (GTK_OBJECT (sorry_msgbox), "button11", button11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button11);
  GTK_WIDGET_SET_FLAGS (button11, GTK_CAN_DEFAULT);

  dialog_action_area7 = GNOME_DIALOG (sorry_msgbox)->action_area;
  gtk_widget_ref (dialog_action_area7);
  gtk_object_set_data_full (GTK_OBJECT (sorry_msgbox), "dialog_action_area7", dialog_action_area7,
                            (GtkDestroyNotify) gtk_widget_unref);

  return sorry_msgbox;
}

GtkWidget*
create_about (void)
{
  const gchar *authors[] = {
    "John Kodis, kodis@jagunet.com",
    NULL
  };
  GtkWidget *about;

  about = gnome_about_new ("Station Info", VERSION,
                        _("Copyright 2001, John Kodis"),
                        authors,
                        "",
                        NULL);
  gtk_object_set_data (GTK_OBJECT (about), "about", about);

  return about;
}

GtkWidget*
create_details_window (void)
{
  GtkWidget *details_window;
  GtkWidget *details_vbox;
  GtkWidget *details_label;
  GtkWidget *hseparator5;
  GtkWidget *details_clist;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *hseparator6;
  GtkWidget *scrolledwindow3;
  GtkWidget *pattern_canvas;
  GtkWidget *hseparator7;
  GtkWidget *hbuttonbox2;
  GtkWidget *details_close_button;

  details_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (details_window), "details_window", details_window);
  gtk_window_set_title (GTK_WINDOW (details_window), _("Station Info: Details"));

  details_vbox = gtk_vbox_new (FALSE, 8);
  gtk_widget_ref (details_vbox);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "details_vbox", details_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (details_vbox);
  gtk_container_add (GTK_CONTAINER (details_window), details_vbox);

  details_label = gtk_label_new (_("Details"));
  gtk_widget_ref (details_label);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "details_label", details_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (details_label);
  gtk_box_pack_start (GTK_BOX (details_vbox), details_label, TRUE, TRUE, 8);

  hseparator5 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator5);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "hseparator5", hseparator5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator5);
  gtk_box_pack_start (GTK_BOX (details_vbox), hseparator5, FALSE, FALSE, 0);

  details_clist = gtk_clist_new (2);
  gtk_widget_ref (details_clist);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "details_clist", details_clist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (details_clist);
  gtk_box_pack_start (GTK_BOX (details_vbox), details_clist, TRUE, TRUE, 0);
  gtk_clist_set_column_width (GTK_CLIST (details_clist), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (details_clist), 1, 80);
  gtk_clist_column_titles_show (GTK_CLIST (details_clist));

  label5 = gtk_label_new (_("Parameter"));
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_clist_set_column_widget (GTK_CLIST (details_clist), 0, label5);

  label6 = gtk_label_new (_("Value"));
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_clist_set_column_widget (GTK_CLIST (details_clist), 1, label6);

  hseparator6 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator6);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "hseparator6", hseparator6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator6);
  gtk_box_pack_start (GTK_BOX (details_vbox), hseparator6, FALSE, FALSE, 0);

  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow3);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "scrolledwindow3", scrolledwindow3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow3);
  gtk_box_pack_start (GTK_BOX (details_vbox), scrolledwindow3, TRUE, TRUE, 0);
  gtk_widget_set_usize (scrolledwindow3, -2, 210);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  gtk_widget_push_visual (gdk_imlib_get_visual ());
  gtk_widget_push_colormap (gdk_imlib_get_colormap ());
  pattern_canvas = gnome_canvas_new ();
  gtk_widget_pop_colormap ();
  gtk_widget_pop_visual ();
  gtk_widget_ref (pattern_canvas);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "pattern_canvas", pattern_canvas,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pattern_canvas);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), pattern_canvas);
  gnome_canvas_set_scroll_region (GNOME_CANVAS (pattern_canvas), -1, -1, 2, 1);
  gnome_canvas_set_pixels_per_unit (GNOME_CANVAS (pattern_canvas), 100);

  hseparator7 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator7);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "hseparator7", hseparator7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator7);
  gtk_box_pack_start (GTK_BOX (details_vbox), hseparator7, FALSE, FALSE, 0);

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox2);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "hbuttonbox2", hbuttonbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox2);
  gtk_box_pack_start (GTK_BOX (details_vbox), hbuttonbox2, FALSE, FALSE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox2), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox2), 8);

  details_close_button = gnome_stock_button (GNOME_STOCK_BUTTON_CLOSE);
  gtk_widget_ref (details_close_button);
  gtk_object_set_data_full (GTK_OBJECT (details_window), "details_close_button", details_close_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (details_close_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), details_close_button);
  GTK_WIDGET_SET_FLAGS (details_close_button, GTK_CAN_DEFAULT);

  return details_window;
}

