/**
 * some stuff for treating arrays ( mainly to use 1dim arrays as 2dim ones for 
 * avoiding the buggy way c++ handles those kinds of arrays)
 * @version 18.09.2007
 * @author Michael J. Beer (mibeer@uni-osnabrueck.de)
 * Copyright (C) 2007 Michael Beer 
 */
/*      
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef ARRAY_H_
#define ARRAY_H_

/** 
 * Map a 2-dimensional array to an 1-dimensional one
 * @param array the 1dim. array ot be treated as 2-dim 
 * @param len length of one line 
 * @param x 1st index
 * @param y 2nd index
 * @return the value at pos [x][y]
 */
#define ARRAY_2D(array, len, x, y) (array[x * len + y])

/////////////////////////////////////////////////////////
// SIZED_ARRAY stuff


/**
 * Maps a 2D array to an 1D one using the first two entries as length & height
 * @param array 1d array 
 * @param x 1st index
 * @param y 2nd index
 */
#define SIZED_ARRAY_2D(array, x, y) (array[2 + x * array[0] + y])

/** 
 * gives length in 1st dim. of array
 * @param array the array
 */
#define SIZED_ARRAY_LENGTH(array) (array[0])

/**
 * gives height of array (2nd   dim) 
 * @param array the array
 */
#define SIZED_ARRAY_HEIGHT(array) (array[1])

/**
 * print out a 2d - array
 * @param stream the ostream to print at
 * @param array the array to be printed ( need cast to (storageType *)
 * @param x the length of the array
 * @param y the width pf the array
 */
template<class storageType> void print(::std::ostream &stream, storageType *array,
    size_t x, size_t y)
  {
    for (size_t line = 0; line < x; line++)
      {
        for (size_t col = 0; col < y; col++)
          {
            stream << ARRAY_2D(array, y, line, col)<< " ";
          }
        stream << ::std::endl;
      }
    stream << ::std::endl;
  }
;

/**
 * for simplifying output of testsuites
 * prints out the name of the test and wether it passed or failed
 * @param test_name name of the test
 * @param expr to be evaluated as true / false ( the "test")
 */
void TEST(char *test_name, bool expr);


/**
 * Macro to get the abs of a comparable
 * @val the number to calculate the abs of
 * @return the abs value of val
 */
inline double absolute(double val)
  {
    return (val < 0) ? -val : val;
  }
;

#endif /*ARRAY_H_*/
