/**
 * Provides the Simple Algebra Framework
 * @version 26.09.2007
 * @author Michael J. Beer (mibeer@uni-osnabrueck.de)
 * Copyright (C) 2007 Michael Beer 
 */
/*      
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
// TODO : CHECK

#ifndef __SAF_H__
#define __SAF_H__


// include everything

#include "config.h"
#include "DenseVector.h"
#include "SparseVector.h"
#include "MathVector.h"
#include "Matrix.h"

namespace STAF
{


/////////////////////////////////////////////////////////////////
// some typedefs for widely used variants

template<class storageType> struct DenseMatrix
  {
    typedef STAF::Matrix<STAF::DenseVector<storageType>, storageType> Type;
  };

template<class storageType> struct SparseMatrix
  {
    typedef STAF::Matrix<STAF::SparseVector<storageType>, storageType> Type;
  };

typedef STAF::Matrix<STAF::DenseVector<double>, double> DoubleDenseMatrix;
typedef STAF::Matrix<STAF::SparseVector<double>, double> DoubleSparseMatrix;


//////////////////////////////////////////////////////////////////
// some typedefs for widely used variants of MathVector

template<class storageType> struct DenseMathVector
  {
    typedef STAF::MathVector<STAF::DenseVector<storageType>, storageType> Type;
  };

template<class storageType> struct SparseMathVector
  {
    typedef STAF::MathVector<STAF::SparseVector<storageType>, storageType> Type;
  };

typedef STAF::MathVector<STAF::DenseVector<double>, double> DoubleDenseMathVec;
typedef STAF::MathVector<STAF::SparseVector<double>, double> DoubleSparseMathVec;

}
;
#endif
