/**
 * test suite for the matrix class
 * tests operating on very small matrices only
 * larger matrices are handleable but more comlpex
 * functions have not been tested to work with bigger ones
 * ( they should though)
 * @version 18.09.2007
 * @author Michael J. Beer (mibeer@uni-osnabrueck.de)
 * Copyright (C) 2007 Michael Beer 
 */
/*      
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

/* no real need for that, as matix includes that header as well,
 but SHOULD work despite that */
#include <iostream>
// #include <vector>
#include "staf.h"
#include "utils.h"


using namespace std;
using namespace STAF;

// properties of the test matrices
#define MAX_COL   (size_t)3
#define MAX_LINE  (size_t)3

typedef Matrix<DenseVector<float>, float> TMatrix;

// the two testmatrices 

float tst_1[MAX_COL * MAX_LINE] =
  { 1, 0, 4, 2, 7, 6, 4, 2, 9 };

float tst_2[MAX_COL * MAX_LINE] =
  { 4, 7, 7, 1, 3, 0, 5, 8, 2 };

float tst_3[2 * 3] =
  { 1, 2, 3, 4, 5, 6 };

float tst_4[3 * 2] =
  { 1, 4, 2, 5, 3, 6 };

float erg_a[MAX_COL * MAX_LINE] =
  { 5, 7, 11, 3, 10, 6, 9, 10, 11 };

float erg_m[MAX_COL * MAX_LINE] =
  { 24, 39, 15, 45, 83, 26, 63, 106, 46 };

float erg_34[2 * 2] =
  { 14, 32, 32, 77 };

/**
 * compare two matrices without the use of Matrix.operator==()
 */

/**
 * returns the matrix given as parameter for testing the copycxonstructor
 */
TMatrix identity(TMatrix m)
  {
    return m;
  }
;

/**
 * calls some access routines in order to check their correctness
 * returns success or failure
 */
bool checkAccess(TMatrix m)
  {
    size_t lines = m.getNoLines();
    size_t cols = m.getNoCols();

    for (size_t l = 0; l < lines; l++)
      {
        for (size_t c = 0; c < cols; c++)
          {
            m.setValue(l, c, l);
          }
      }

    for (size_t l = 0; l < lines; l++)
      {
        for (size_t c = 0; c < cols; c++)
          {
            if (! (m.getValue(l, c) == l))
              {
                return false;
              }
          }
      }

    return true;
  }
;

/**
 * compare two matrices without the use of Matrix.operator==()
 */
bool compareMatrices(TMatrix &m1, TMatrix &m2)
  {
    for (unsigned int line = 0; line < MAX_LINE; line++)
      {

        for (unsigned int col = 0; col < MAX_COL; col++)
          {
            if (m1.getValue(line, col) != m2.getValue(line, col))
              {
                return false;
              }
          }
      }
    return true;
  }
;

int matrixTest()
  {

    /////////////////////////////////////////////////
    // create matrices for testing

    cout << "matrix m1 is created..."<<endl;

    TMatrix m1(MAX_LINE, MAX_COL);

    cout << "Dimension m1: "<< m1.getNoLines() << " x "<< m1.getNoCols()<< endl;

    // init these with some numbersy
    for (unsigned int line = 0; line < MAX_LINE; line++)
      {
        for (unsigned int col = 0; col < MAX_COL; col++)
          {
            m1.setValue(line, col, tst_1[line * MAX_COL + col]);
            cout << m1.getValue(line, col) << " ";
          }
        cout << endl;
      }
    cout << endl << endl;

    cout << "matrix m2 is created..."<< endl;

    TMatrix m2(MAX_LINE, MAX_COL);

    cout << "Dimension m2: "<< m2.getNoLines() << " x "<< m2.getNoCols()<< endl;

    for (unsigned int line = 0; line < MAX_LINE; line++)
      {

        for (unsigned int col = 0; col < MAX_COL; col++)
          {
            m2.setValue(line, col, tst_2[line *MAX_COL + col]);
            cout << m2.getValue(line, col) << " ";
          }
        cout << endl;
      }

    cout << endl << endl;

    TMatrix *m3;

    ///////////////////////////////////////////////////////
    // test constructors
    cout << "testing constructors"<< endl <<endl;

    ///////////////////////////////////////////////////////
    // constructor(size_t, size_t)
    m3 = new TMatrix(18, 7);
    TEST("constructor(lines, cols)", ( (m3->getNoLines() == 18)
        && (m3->getNoCols() == 7)));
    delete m3;

    ///////////////////////////////////////////////////////
    // constructor(size_t, size_t, filling)
    m3 = new TMatrix(18, 7, 17);
    TEST("constructor(lines, cols, filling)", ( (m3->getNoLines() == 18)
        && (m3->getNoCols() == 7)&& (m3->getValue(1, 5) == 17)&& (m3->getValue(
        11, 2) == 17)));
    delete m3;

    ///////////////////////////////////////////////////////
    // copy-const test
    m3 = new TMatrix(m1);
    TEST("copy-constructor test 1", compareMatrices(m1, *m3));
    TMatrix idMatrix = identity(*m3);
    TEST("copy-constructor test 2", compareMatrices(m1, idMatrix));
    delete m3;

    ///////////////////////////////////////////////////////
    // basic functions
    m3 = new TMatrix(10000, 8000);
    cout << endl << endl << "testing basic functions"<< endl << endl;
    TEST("setValue() / getValue() test", checkAccess(*m3));
    TEST("getNoLines() test", (m3->getNoLines() == 10000));
    TEST("getNoCols test", (m3->getNoCols() == 8000));
    delete m3;

    ///////////////////////////////////////////////////////
    // equal size
    cout << endl << endl << "testing compareSize()";
    TEST("compareSize() test 1 (equal)", m1.equalSize(m2));

    m3 = new TMatrix(MAX_LINE-1, MAX_COL, (double)0);
    TEST("compareSize() test 2 (unequal)", !(m1.equalSize(*m3) ));
    delete m3;

    m3 = new TMatrix(MAX_LINE, MAX_COL-1, (double)0);
    TEST("compareSize() test 3 (unequal)", !(m1.equalSize(*m3) ));
    delete m3;

    m3 = new TMatrix(MAX_LINE-3, MAX_COL-2, (double)0);
    TEST("compareSize() test 4 (unequal)", !(m1.equalSize(*m3) ));
    delete m3;

    ///////////////////////////////////////////////////////
    // operator tests
    cout << endl << endl << "testing overloaded operators"<< endl << endl;

    idMatrix = m2;
    TEST("operator=(Matrix)", compareMatrices(m2, idMatrix));
    m3 = new TMatrix(m1);

    TEST("operator==(Matrix) test 1 (equal)", m1 == *m3);
    TEST("operator==(Matrix) test 2 (unequal)", !(m1 == m2));

    delete m3;

    ///////////////////////////////////////////////////////
    // assign(array) test
    cout << endl << endl << "testing array - conversion"<< endl << endl;

    m3 = new TMatrix(MAX_LINE, MAX_COL);
    m3->assign(tst_1);
    TEST("assign(array) test 1 (square matrix)", compareMatrices(*m3, m1));

    //delete m3;
    //m3 = new TMatrix(3, 2);
    //m3->assign(tst_4);
    //TEST("assign(array) test 2 ((non - square matrix)", false);

    delete m3;

    ///////////////////////////////////////////////////////
    // addition test
    cout << endl <<endl << "arithmetic tests"<< endl <<endl;

    m3 = new TMatrix(MAX_LINE, MAX_COL);
    m3->assign(erg_a);
    TMatrix *solution = new TMatrix(m1 + m2);
    TEST("addition test", compareMatrices(*solution, *m3));
    delete solution;

    ////////////////////////////////////////////////////////
    // subtraction test

    ////////////////////////////////////////////////////////
    // multiplication tests
    m3->assign(erg_m);
    solution = new TMatrix(m1 * m2);
    TEST("multiplication test 1 (square matrices)", compareMatrices(*m3,
        *solution));
    delete solution;
    delete m3;

    solution = new TMatrix(2, 2);
    solution->assign(erg_34);

    m3 = new TMatrix(2, 3);
    m3->assign(tst_3);
    TMatrix *m4 = new TMatrix(3, 2);
    m4->assign(tst_4);
    TMatrix *m5 = new TMatrix(2, 2);
    m5->assign((*m3) * (*m4));
    TEST("multiplication test 2 (non - square matrices)", (*m5) == (*solution));
    //delete m4;
    delete m5;

    delete m3;
    delete solution;

    DenseVector<float> *vec = new DenseVector<float>(3);
    vec->assign(0, 1);
    vec->assign(1, 2);
    vec->assign(2, 3);

    DenseVector<float> *sol = new DenseVector<float>(3);
    sol->assign(0, 13);
    sol->assign(1, 34);
    sol->assign(2, 35);

    DenseVector<float> *sol_calc = new DenseVector<float>(m1 * (*vec));
    TEST("multiplication test 3 (matrix * vector)", (*sol) == (*sol_calc));
    delete sol_calc;
    delete vec;
    delete sol;

    /////////////////////////////////////////////////////////////
    // division test

    m3 = new TMatrix((*m4) * 4.0);
    bool result = true;
    for (unsigned int line = 0; line < m4->getNoLines(); line++)
      {
        for (unsigned int col = 0; col < m4->getNoCols(); col++)
          {
            if (m3->getValue(line, col) != m4->getValue(line, col) * 4.0)
              {
                result = false;
                break; // doesnt break the loops completely 
                // but who cares about in thsi case?
              }

          }
      }
    TEST("multiplication test 4 (matrix * scalar)", result);
    delete m3;

    m3 = new TMatrix((*m4) / 4.0);
    result = true;
    for (unsigned int line = 0; line < m4->getNoLines(); line++)
      {
        for (unsigned int col = 0; col < m4->getNoCols(); col++)
          {
            if (m3->getValue(line, col) != m4->getValue(line, col) / 4.0)
              {
                result = false;
                break; // compare to above...
              }

          }
      }
    TEST("multiplication test 5 (matrix / scalar)", result);

    delete m3;
    delete m4;

    return 0;

  }
