/*      
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
Copyright (C) 2007 Michael Beer
*/

/**
 * Configuration stuff
 */

#ifndef CONFIG_H_
#define CONFIG_H_


/**
 * Defines how small the difference in between two numbers should be to recognize them as equal
 */
#define MIN_DIFFERENCE (double) 0.000001

/**
 * configuring the test environment
 */
#define PERFORM_BASEVECTOR_TESTS
#define PERFORM_MATHVECTOR_TESTS
#define PERFORM_MATRIX_TESTS

/** 
 * Should cleaner but slower design of matrix using virtual functions 
 * be enabled ?
 */
#define USE_VIRTUAL_FUNCTIONS

/**
 * should the MathVector::piNorm() try to avoid overflow of double type 
 * by calculating the p - Norm of the normalized ( using p1Norm() ) vector and afterwards 
 * rescale it rather than calculate the p - Norm directly? 
 */
#define PINORM_AVOID_OVERFLOW 





#ifdef DEBUG
#define USE_VIRTUAL_FUNCTIONS
#endif

#endif /*CONFIG_H_*/
