/**
 * Representation of a sparsely populated vector
 * using a linked list as implementation
 * slower but in case of sparsely populated vectors
 * less memory - consuming than DenseVector
 * @version 19.09.2007
 * @author Michael J. Beer (mibeer@uni-osnabrueck.de)
 * Copyright (C) 2007 Michael Beer 
 */
/*      
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef SPARSEVECTOR_H_
#define SPARSEVECTOR_H_

#ifdef USE_VIRTUAL_FUNCTIONS
#include "BaseVector.h"
#endif


namespace STAF
{
  
#ifdef USE_VIRTUAL_FUNCTIONS
template<class storageType> class SparseVector : virtual public BaseVector<storageType>
#else
/**
 * Representation of a sparsely populated vector
 * using a linked list as implementation
 * slower but in case of sparsely populated vectors
 * less memory - consuming than DenseVector
 * @see Matrix
 * @see baseVector
 * @see USE_VIRTUAL_FUNCTIONS
 */
// TODO: impement it!
template<class storageType> SparseVector
#endif
  {
  public:

      /**
       * creates a denseVector object with given length
       * @param len desired length
       */
      SparseVector<storageType>(size_t len)
  #ifdef USE_VIRTUAL_FUNCTIONS
      :
        BaseVector<storageType>(len)
  #endif
        {

                  }
      ;

      /**
       * creates a denseVector object with given length and inits all entries
       * @param len desired length
       * @param filling the initial filling of the entries
       */
      SparseVector<storageType>(size_t len, storageType filling)
  #ifdef      USE_VIRTUAL_FUNCTIONS
      :
        BaseVector<storageType>(len)
  #endif
        {
        }
      ;

      /**
       * Copyconstructor
       * @param vec the BaseVector object to be copied into this 
       */
      SparseVector<storageType>(const BaseVector<storageType>& vec)
      : BaseVector<storageType>(vec)
        {
        }
      ;

      /**
       * cleans up
       */
      ~SparseVector<storageType>()
        {
        }
      ;

      /**
       * returns length of the vector
       * @return Length
       */
      size_t size(void) const
        {
          return 0;
        }
      ;

      /** 
       * returns desired entry
       * @param no number of the entry
       * @return the entrie s value
       */
      storageType at(const unsigned int no) const
        {
        }
      ;

      /**
       * sets desired entry to value
       * @param no number of desierd entry
       * @value the new value
       */
      void assign(const unsigned int no, const storageType value)
        {
        }
      ;

      /**
       * compares this with another vector entry by entry
       * @param vec the other vector
       * @return true if equal, false elsewise
       */
      bool operator==(const BaseVector<storageType> &vec) const
        {
        }
      ;

  protected:

      /**
       * must be implemented acc. to BaseVector
       */
      void destroy(void)
        {
        }
      ;

      /**
       * must be implemented acc. to BaseVector
       */
      void resize(size_t n)
        {
        }
      ;

      storageType *entries;

      size_t length;

  }
;

}
;
#endif /*SPARSEVECTOR_H_*/
