#!/usr/bin/env python

# this file is srend_namelist_tiles.py

# NOTE: OpenMP is optional below

# build tiles  : mpif90 Srend.F90 -O3 -fopenmp -c
#              : gcc sleep.c -c
#              : mpif90 srend_namelist_tiles.F90 Srend.o sleep.o -O3 -fopenmp -o srend_namelist_tiles

# set threads  : export OMP_NUM_THREADS=4 ! or 1, or 2, ...

import os

def call_srend_namelist(in_Vdim,e1,e2,e3,v1,v2,v3,u1,u2,u3,in_alpha,in_beta,
                  in_clipx0,in_clipx1,in_clipy0,in_clipy1,in_clipz0,in_clipz1,
                  pt1,pt2,pt3,in_pt_r,in_clip0,in_clip1,
                  in_perspective,in_dt,
                  in_bytedata_filename,
                  in_XN,in_YN,in_ZN,in_Bd,in_iX,in_iY,in_iZ,
                  in_W,in_H,in_filename_stringin,
                  in_tiles_right,in_tiles_down,in_TARGid):

   fout = open("namelist.srend","w") # open a namelist.srend file for writing
   fout.write(' &namelist_srend\n')

# ----- variables to pass to srend_render
   fout.write(' srend_nV = 1,\n')
   fout.write(' srend_nV_out = 2,\n')
   fout.write(' srend_Vdim = '+str(in_Vdim)+',\n') 
   fout.write(' srend_E = '+str(e1)+','+str(e2)+','+str(e3)+',\n')
   fout.write(' srend_V = '+str(v1)+','+str(v2)+','+str(v3)+',\n')
   fout.write(' srend_U = '+str(u1)+','+str(u2)+','+str(u3)+',\n')
   fout.write(' srend_alpha = '+str(in_alpha)+',\n')
   fout.write(' srend_beta = '+str(in_beta)+',\n')
   fout.write(' srend_eyeright = 0.0,\n')
   fout.write(' srend_clipx0 = '+str(in_clipx0)+',\n')
   fout.write(' srend_clipx1 = '+str(in_clipx1)+',\n')
   fout.write(' srend_clipy0 = '+str(in_clipy0)+',\n')
   fout.write(' srend_clipy1 = '+str(in_clipy1)+',\n')
   fout.write(' srend_clipz0 = '+str(in_clipz0)+',\n')
   fout.write(' srend_clipz1 = '+str(in_clipz1)+',\n')
   fout.write(' srend_pclip1 = 180.0,\n')
   fout.write(' srend_pt = '+str(pt1)+','+str(pt2)+','+str(pt3)+',\n')
   fout.write(' srend_pt_r = '+str(in_pt_r)+',\n')
   fout.write(' srend_clip0 = '+str(in_clip0)+',\n')
   fout.write(' srend_clip1 = '+str(in_clip1)+',\n')
   fout.write(' srend_nsh = 1,\n')
   fout.write(' srend_perspective = '+str(in_perspective)+',\n')
   fout.write(' srend_srendtype = 0,\n')
   fout.write(' srend_dt = '+str(in_dt)+',\n')
   fout.write(' srend_bytedata_filename = "'+in_bytedata_filename+'",\n')
   fout.write(' srend_XN = '+str(in_XN)+',\n')
   fout.write(' srend_YN = '+str(in_YN)+',\n')
   fout.write(' srend_ZN = '+str(in_ZN)+',\n')
   fout.write(' srend_Bd = '+str(in_Bd)+',\n')
   fout.write(' srend_iX = '+str(in_iX)+',\n')
   fout.write(' srend_iY = '+str(in_iY)+',\n')
   fout.write(' srend_iZ = '+str(in_iZ)+',\n')
   fout.write(' srend_W = '+str(in_W)+',\n')
   fout.write(' srend_H = '+str(in_H)+',\n')
   fout.write(' srend_nR = 1,\n')
   fout.write(' srend_cotab_offset = 1,\n')
   fout.write(' srend_filenames = "'+in_filename_stringin+'",\n')
   fout.write(' srend_tiles_right = '+str(in_tiles_right)+',\n')
   fout.write(' srend_tiles_down = '+str(in_tiles_down)+',\n')
   fout.write(' /\n\n')
   
   fout.write(' &namelist_srend_targid\n')
   fout.write(' srend_TARGid = ')
   for i in in_TARGid:
      fout.write(str(in_TARGid[i])+',')
   fout.write('\n')

   fout.write(' /\n')
   fout.close()

   np = in_iX*in_iY*in_iZ
   os.system('mpirun -np '+str(np)+' ./srend_namelist_tiles')
   
# batch converty to jpg for ipynb display
   os.system('mogrify -format jpg srend_result_*.ppm; rm srend_result*.ppm')
   
#   pid = os.fork
#   if pid == 0:
#      os.execl('./srend_exec_namelist','')
#   else:
#      os.wait
      
#dump() # test

# render, a very long parameter list .. which we will not be calling
'''
   srend.__srend_MOD_srend_render(byref(nV_in),byref(nV_out),byref(Vdim),byref(E),
      byref(V),byref(U),byref(Alpha), byref(Beta),byref(EyeRight),
      byref(clipx0),byref(clipx1),byref(clipy0),byref(clipy1),
      byref(clipz0),byref(clipz1),byref(pclip1),byref(pt),byref(pt_r),
      byref(clip0),byref(clip1),byref(nsh),
      byref(perspective),byref(srendtype),byref(dt),
      byref(bytedata),byref(XN),byref(YN),byref(ZN),byref(Bd),byref(iNX),
      byref(iNY),byref(iNZ),byref(W),byref(H),byref(nR),
      byref(offset_cotab),filenames,byref(tiles_right),byref(tiles_down),
      byref(TARGid) )
'''


'''
def dump():
   in_Vdim=39
   e1=0.5;e2=0.5;e3=1.0
   v1=0.0;v2=0.0;v3=-1.0
   u1=0.0;u2=1.0;u3=0.0
   in_alpha=60.0;in_beta=60.0
   in_clipx0=-10.0;in_clipx1=10.0
   in_clipy0=-10.0;in_clipy1=10.0
   in_clipz0=-10.0;in_clipz1=10.0
   pt1=0.5;pt2=0.5;pt3=0.5;in_pt_r=1.0
   in_clip0=0.5;in_clip1=1.0
   in_perspective=1
   in_dt=0.5
   in_bytedata_filename='nucleon.raw'
   in_XN=39;in_YN=39;in_ZN=39;in_Bd=1
   in_iNX=0;in_iNY=0;in_iNZ=0
   in_W=256;in_H=256
   in_filename_stringin='srend_result.png,'
'''
      
# done
