#ifdef SRENDERING
module module_srend

contains

subroutine srend_render_wrap(grid, nV)

USE OMP_LIB
USE module_domain
USE module_domain_type
USE module_comm_dm
USE module_dm, ONLY : &
              local_communicator, mytask, ntasks, ntasks_x, ntasks_y & ! MPI rank info
             ,local_communicator_periodic, wrf_dm_maxval 
USE module_state_description  ! frame
USE module_model_constants    ! share
USE module_configure
USE Srend

IMPLICIT NONE

   TYPE(domain) , TARGET :: grid
   TYPE (grid_config_rec_type)              :: config_flags ! TW
   integer :: nV ! if nV < 0, follow with MPI_finalize(MPI_COMM_WORLD)
   integer :: finalize ! 0 keep going, 1 MPI_finalize
   
   INTEGER :: ids , ide , jds , jde , kds , kde , &
              ims , ime , jms , jme , kms , kme , &
              ips , ipe , jps , jpe , kps , kpe
   INTEGER :: imsx, imex, jmsx, jmex, kmsx, kmex,    &
              ipsx, ipex, jpsx, jpex, kpsx, kpex,    &
              imsy, imey, jmsy, jmey, kmsy, kmey,    &
              ipsy, ipey, jpsy, jpey, kpsy, kpey
              
   REAL , DIMENSION(:,:,:,:),allocatable :: moist

   integer,dimension(:),allocatable,save :: Step
   
   integer :: i,j,k, kk
   character*1, dimension(:,:,:), allocatable,save :: dat ! volume data
   
   real :: x, y
   
   real,save :: E(1:3),V(1:3),U(1:3)
   real,save :: Alpha,Beta,EyeRight,EyeConverge
   real,save :: clipx0,clipx1,clipy0,clipy1,clipz0,clipz1
   real,save :: pt(1:3), pt_r
   real,save :: clip0,clip1
   real,save :: pclip1,dt
   character*200,save :: filenames
   character*200 :: pass_filenames, num_filenames
   integer,save :: n_rgb_knot, n_alpha_knot
   character*256,save :: alpha_knot(1:32), rgb_knot(1:32)

   integer :: myid, numprocs, ierr ! MPI rank
! ----------- end declarations ---------------------------------------

   if(.NOT. grid%srend_on .OR. grid%srend_dom .ne. grid%id) return

! keep track of the pass 
   if( .NOT. allocated(Step) ) then ! will be done by grid%id = 1
      allocate( Step(0:1) )
      Step(0) = 1  ! initial value, nothing solved as yet
      Step(1) = grid%srend_frequency ! trigger, every srend_frequency
      
! We need to get arrays for all grids here
      CALL model_to_grid_config_rec ( grid%id , model_config_rec , config_flags ) ! TW
      E(1:3) = model_config_rec%srend_E(1:3)
      V(1:3) = model_config_rec%srend_V(1:3)
      U(1:3) = model_config_rec%srend_U(1:3)
      
      pt(1:3) = model_config_rec%srend_pt(1:3)
      pt_r = grid%srend_pt_r
   
      n_alpha_knot = grid%srend_n_alpha_knot
      do i=1,n_alpha_knot
      alpha_knot(i) = model_config_rec%srend_alpha_knot(i)
      end do
   
      n_rgb_knot = grid%srend_n_rgb_knot
      do i=1,n_rgb_knot
         rgb_knot(i) = model_config_rec%srend_rgb_knot(i)
      end do
   
! this must be 200 characters long for srend
      filenames(1:200) = grid%srend_filenames(1:200)

! possibly, convert real*8 to real*4 as required for srend
      Alpha = grid%srend_Alpha
      Beta = grid%srend_Beta
      EyeRight = 0.0
      EyeConverge = 0.0
      clip0 = grid%srend_clip0
      clip1 = grid%srend_clip1
      pclip1 = grid%srend_pclip1
      dt = grid%srend_dt
      
      clipx0 = grid%srend_clipx0
      clipx1 = grid%srend_clipx1
      clipy0 = grid%srend_clipy0
      clipy1 = grid%srend_clipy1
      clipz0 = grid%srend_clipz0
      clipz1 = grid%srend_clipz1
   else !if(grid%id .eq. 1) then ! ?????????????????????
      Step(0) = Step(0) + 1
   end if
   
#ifdef SREND_NOMPI
   print *,'step0=',Step(0),'nV=',nV
#else
   print *,'mytask=',mytask,'step0=',Step(0),'nV=',nV
#endif
   
! we render image only every Step(1) = srend_solv_per calls
   if( mod(Step(0)-1,Step(1)) == 0) then
   
! create filename
      write(num_filenames,'(I6.6)') 1+ (Step(0)-1)/Step(1)
      pass_filenames(1:200) = filenames
      i = index(pass_filenames(1:200),'######')
      do while(i>0)
        pass_filenames(i:i+5) = num_filenames(1:6)
        i = index(pass_filenames(i+6:200),'######')
      end do

! get indices
      CALL get_ijk_from_grid (  grid ,                   &
                          ids, ide, jds, jde, kds, kde,    &
                          ims, ime, jms, jme, kms, kme,    &
                          ips, ipe, jps, jpe, kps, kpe,    &
                          imsx, imex, jmsx, jmex, kmsx, kmex,    &
                          ipsx, ipex, jpsx, jpex, kpsx, kpex,    &
                          imsy, imey, jmsy, jmey, kmsy, kmey,    &
                          ipsy, ipey, jpsy, jpey, kpsy, kpey )
                          
! do this for moist vars: qv, qc, etc. as avail by mp_physics scheme
! WRF does this by automatic arrays, here directly
   if( .NOT. allocated(moist) ) allocate( moist(ims:ime,kms:kme,jms:jme,num_moist) )

! get boundaries -----------------
#include "HALO_EM_MOIST_E_3.inc"

! load up dat array with scaled bytes with a boundary of 1
   if(.not. allocated(dat) ) allocate( dat(ips-1:ipe+1,jps-1:jpe+1,kps-1:kpe+1) )
   do j=jps-1,jpe+1
   do k=kps-1,kpe+1
   do i=ips-1,ipe+1
        if(k .eq. kps-1) then
          x = (grid%moist(i,kps,j,P_QC) + grid%moist(i,kps,j,P_QR) )
        else if( k .ge. kpe-1) then ! nothing at kpe
          x = (grid%moist(i,kpe-1,j,P_QC) + grid%moist(i,kpe-1,j,P_QR) )
        else
          x = (grid%moist(i,k,j,P_QC) + grid%moist(i,k,j,P_QR) )
        endif
        
        if ( x .le. .00001) then
           y = 5.0
        else
           x = x * 1000.0
           y = 5.0 + 245.0 * x / sqrt(x**2 + 1.0)
        end if
        dat(i,j,k) = achar(floor(y))
   end do
   end do
   end do

!$OMP parallel default(shared)
      call srend_render(                                &
        nV, nV+1,                                       & ! view number: nV and nV_out
        ide-ids+1,                                      & ! Vdim, ignore passed namelist srend_Vdim for now
        E,V,U,                                          & ! view vectors: E=Eye, V=view vector, U=up vector
        Alpha, Beta,                                    & ! alpha = angle span across, beta = angle span vertical 
        EyeRight,                                       & ! stereo offsets : EyeRight, EyeConverge
        clipx0,clipx1,clipy0,clipy1,clipz0,clipz1,      & ! clipping planes perpendicular to axis, near=0 and far=1  
        pclip1,                                         & ! polar far clipping angle off of Ev=view vector
        pt, pt_r,                                       & ! center(x,y,z) and radius of sphere to clip about
        clip0,clip1,                                    & ! near and far clipping sphere radii
        1,                                              & ! number of shells
        grid%srend_perspective,                         & ! perspective: 1=on, 0=off=spherical
        0,                                              & ! srend type = 0 for standard (1,2,3 = npol, equatorial, spole)
        dt,                                             & ! sampling increment dt in cell width units
        dat,                                            & ! data array of bytes
        ipe-ips+1,jpe-jps+1,kpe-kps+1,                  & ! data array x,y,z, dims
        1,                                              & ! boundary bd=1 of data array
        ips-1,jps-1,0,                                  & ! offset x,y,z pt location
        grid%srend_W,grid%srend_H,                      & ! W, H in pixels for sampling
        1,                                              & ! nR
        (/1/),                                          & ! off_cotab
        n_alpha_knot, alpha_knot,                       & ! alpha keys to build color table
        n_rgb_knot, rgb_knot,                           & ! rgb keys to build color table
        pass_filenames,                                 & ! filenames for image writing
        grid%srend_tiles_right, grid%srend_tiles_down,  & ! tiling for output : requires ImageMagick convert
        (/0/) )                                           ! MPI rank for finish target
!$OMP end parallel

#ifndef SREND_NOMPI
      if(mytask ==0) then
        call srend_finish(nV+1,ntasks)
     end if
#endif 

   end if ! render on this time step

end subroutine srend_render_wrap

end module module_srend

!ifdef SRENDERING
#endif
