#!/bin/bash
# These are needed for WRF 3.8, perhaps others in the NCAR code family.
# Your user directory (/home/user/) and location for WRF and LIBRARIES
# will probably be different, so adjust names and paths.  For below
# environment setup, this is what is expected:
# /home/user/wrf/wrf.sh  (this file)
#                WRFV3/
#                LIBRARIES/grib2/
#                          mpich/
#                          netcdf/
# run it like this in the working directory /home/user/wrf/: . wrf.sh
export DIR=/home/user/wrf/LIBRARIES
export NETCDF=$DIR/netcdf
export NETCDF_LIB=$DIR/netcdf/lib
export NETCDF_INC=$DIR/netcdf/include

export JASPERLIB=$DIR/grib2/lib
export JASPERINC=$DIR/grib2/include

export LDFLAGS=-L$DIR/grib2/lib
export CPPFLAGS=-I$DIR/grib2/include

export PATH=$DIR/mpich/bin:$DIR/netcdf/bin:$PATH

export FC=gfortran
export CC=gcc
export CXX=g++
export FCFLAGS=-m64
export FFLAGS=-m64
export F77=gfortran
# export DM_FC=mpif90
# export DM_CC=mpicc




