/* source: http://sqlzoo.net/ with permission by Andrew Cumming
 *
 * The "Neeps" database includes details of all teaching events in the
 * School of Computing at Napier University in Semester 1 of the
 * 2000/2001 academic year.
 * 
 */

SET search_path TO sqltutor;

--- createneeps, 1, 50
drop table teaches cascade;
drop table attends cascade;
drop table staff   cascade;
drop table student cascade ;
drop table occurs  cascade;
drop table event   cascade;
drop table modle   cascade;
drop table room    cascade;
drop table week    cascade;

create table week (
   id char(2) NOT NULL
  ,wkstart date 
  ,primary key (id)
  );
create table room(
   id varchar(20) NOT NULL
  ,name varchar(50)
  ,capacity integer
  ,parent varchar(20)
  ,primary key(id)
  ,foreign key(parent) references room(id)
  );
create table modle(
   id varchar(20) NOT NULL
  ,name varchar(50)
  ,primary key (id)
  );
create table event(
   id varchar(20) NOT NULL
  ,modle varchar(20)
  ,kind char(1)
  ,dow varchar(15)
  ,tod char(5)
  ,duration integer
  ,room varchar(20)
  ,primary key(id)
  ,foreign key (room) references room(id)
  ,foreign key (modle) references modle(id)
  );	
create table occurs(
   event varchar(20) not null
  ,week varchar(20) not null
  ,primary key(event,week)
  ,foreign key (event) references event(id)
  );
create table student(
   id varchar(20) not null
  ,name varchar(50)
  ,sze integer
  ,parent varchar(20)
  ,primary key(id)
  ,foreign key (parent) references student(id)
  );
create table staff (
   id varchar(20) not null
  ,name varchar(50)
  ,primary key(id)
  );
create table attends (
   student varchar(20) not null
  ,event   varchar(20) not null
  ,foreign key (student) references student(id)
  ,foreign key (event)   references event(id)
  ,primary key (student,event)
  );
create table teaches (
   staff   varchar(20) not null
  ,event   varchar(20) not null
  ,foreign key (staff) references staff(id)
  ,foreign key (event)   references event(id)
  ,primary key (staff,event)
  );


BEGIN;

--- tabweek, 1, 50
insert into week values ('01',DATE '2000-10-02');
insert into week values ('02',DATE '2000-10-09');
insert into week values ('03',DATE '2000-10-16');
insert into week values ('04',DATE '2000-10-23');
insert into week values ('05',DATE '2000-10-30');
insert into week values ('06',DATE '2000-11-06');
insert into week values ('07',DATE '2000-11-13');
insert into week values ('08',DATE '2000-11-20');
insert into week values ('09',DATE '2000-11-27');
insert into week values ('10',DATE '2000-12-04');
insert into week values ('11',DATE '2000-12-11');
insert into week values ('12',DATE '2000-12-18');
insert into week values ('13',DATE '2001-01-08');
insert into week values ('14',DATE '2001-01-15');
insert into week values ('15',DATE '2001-01-22');
--- tabroom, 1, 50
insert into room values ('co.117+118',NULL,32,NULL);
insert into room values ('co.117',NULL,16,'co.117+118');
insert into room values ('co.118',NULL,16,'co.117+118');
insert into room values ('co.B7',NULL,40,NULL);
insert into room values ('co.G75+G76',NULL,32,NULL);
insert into room values ('co.G74',NULL,12,NULL);
insert into room values ('co.G75',NULL,16,'co.G75+G76');
insert into room values ('co.G76',NULL,16,'co.G75+G76');
insert into room values ('co.G78+G82',NULL,64,NULL);
insert into room values ('co.G78',NULL,24,'co.G78+G82');
insert into room values ('co.G82',NULL,40,'co.G78+G82');
insert into room values ('co.LB42+LB46',NULL,73,NULL);
insert into room values ('co.LB42',NULL,31,'co.LB42+LB46');
insert into room values ('co.LB46',NULL,42,'co.LB42+LB46');
insert into room values ('co.LB47',NULL,40,NULL);
insert into room values ('co.LB56',NULL,20,NULL);
insert into room values ('cr.131',NULL,40,NULL);
insert into room values ('cr.132',NULL,68,NULL);
insert into room values ('cr.135',NULL,21,NULL);
insert into room values ('cr.201',NULL,31,NULL);
insert into room values ('cr.202',NULL,45,NULL);
insert into room values ('cr.203',NULL,30,NULL);
insert into room values ('cr.204',NULL,30,NULL);
insert into room values ('cr.B1',NULL,120,NULL);
insert into room values ('cr.B10',NULL,45,NULL);
insert into room values ('cr.B11',NULL,25,NULL);
insert into room values ('cr.B12',NULL,27,NULL);
insert into room values ('cr.B13',NULL,27,NULL);
insert into room values ('cr.B2',NULL,60,NULL);
insert into room values ('cr.B8',NULL,40,NULL);
insert into room values ('cr.B9',NULL,20,NULL);
insert into room values ('cr.G116',NULL,40,NULL);
insert into room values ('cr.G116+G90',NULL,64,NULL);
insert into room values ('cr.G2',NULL,20,NULL);
insert into room values ('cr.G3',NULL,15,NULL);
insert into room values ('cr.G6',NULL,28,NULL);
insert into room values ('cr.G80',NULL,30,NULL);
insert into room values ('cr.G90',NULL,24,NULL);
insert into room values ('cr.G90(m)',NULL,48,NULL);
insert into room values ('cr.G90(m)a',NULL,24,NULL);
insert into room values ('cr.G90(m)b',NULL,15,NULL);
insert into room values ('cr.G90+116',NULL,56,NULL);
insert into room values ('cr.G90A',NULL,12,NULL);
insert into room values ('cr.G90B',NULL,12,NULL);
insert into room values ('cr.SMH',NULL,200,NULL);
--- tabmodle, 1, 50
insert into modle values ('co12001','Rapid Application Development');
insert into modle values ('co12002','Software Development 1A');
insert into modle values ('co12003','Professional Skills');
insert into modle values ('co12004','Applications Workshop');
insert into modle values ('co12005','Software Development 1B');
insert into modle values ('co12006','Computer Systems');
insert into modle values ('co12008','Word Processing and Spreadsheets Elective');
insert into modle values ('co12009','Information Systems 1a');
insert into modle values ('co12010','Software Development C');
insert into modle values ('co12011','Software Development in C');
insert into modle values ('co12012','Using Electronic Communication Effectively');
insert into modle values ('co12021','Using Electronic Communication Effectively');
insert into modle values ('co2.cs22006',NULL);
insert into modle values ('co22001','Database Systems');
insert into modle values ('co22002','Software Development');
insert into modle values ('co22003','Computer Systems');
insert into modle values ('co22004','Software Engineering');
insert into modle values ('co22005','Human Computer Interaction');
insert into modle values ('co22006','Algorithms and Data Structures');
insert into modle values ('co22007','Web Development');
insert into modle values ('co22008','Introduction to Databases');
insert into modle values ('co22009','Software Development (Bridging)');
insert into modle values ('co22020','Window NT Elective');
insert into modle values ('co22022','Programming C++');
insert into modle values ('co32001','Very Large Databases');
insert into modle values ('co32002','Customer Centred Design');
insert into modle values ('co32003','Multimedia Technology');
insert into modle values ('co32004','Multimedia Development Methods');
insert into modle values ('co32005','Multimedia Systems Design');
insert into modle values ('co32006','Computer Networks and Distributed Systems');
insert into modle values ('co32007','Design Patterns');
insert into modle values ('co32008','Computer Interfacing');
insert into modle values ('co32010','Network Operating Systems');
insert into modle values ('co32011','Visual Components and Systems Integration');
insert into modle values ('co32013','Embedded Systems');
insert into modle values ('co32014','Computers and Innovation Process');
insert into modle values ('co32015','Frameworks');
insert into modle values ('co32016','Group Project');
insert into modle values ('co32017','Internet Programming');
insert into modle values ('co32018','Internet Programming 3');
insert into modle values ('co32020','Professional Studies');
insert into modle values ('co32021','Group Project');
insert into modle values ('co32023','Systems Engineering 3');
insert into modle values ('co32993','Human Computer Interaction 3');
insert into modle values ('co32M19','Management of Industrial Organisations');
insert into modle values ('co32XX5','Systems Engineering 3');
insert into modle values ('co42001','Virtual Environments');
insert into modle values ('co42002','Multimedia Technology');
insert into modle values ('co42004','Media Computing');
insert into modle values ('co42005','Computer Supported Cooperative Working');
--- tabmodle, 51, 50
insert into modle values ('co42006','Human Computer Interaction 4');
insert into modle values ('co42007','Evolutionary Computing');
insert into modle values ('co42008',NULL);
insert into modle values ('co42009','Object Oriented Databases');
insert into modle values ('co42010','Languages and Algorithms');
insert into modle values ('co42011','Computers and Society');
insert into modle values ('co42012','Software Architectures');
insert into modle values ('co42013','Safety Critical Systems');
insert into modle values ('co42014','Software Management');
insert into modle values ('co42015','Advanced Distributed Systems');
insert into modle values ('co42018','Real Time Software Engineering');
insert into modle values ('co42019','Project');
insert into modle values ('co42022','Internet Application Development');
insert into modle values ('co71021','Research Skills');
insert into modle values ('co71022','Distributed Systems');
insert into modle values ('co72001','Introduction to Software Development');
insert into modle values ('co72002','Computer Systems');
insert into modle values ('co72003','Application Development');
insert into modle values ('co72004','Software Development');
insert into modle values ('co72005','Internet Multimedia');
insert into modle values ('co72006','Object Oriented Software Technology 1');
insert into modle values ('co72010','Database systems');
insert into modle values ('co72011','Interactivity and the Internet');
insert into modle values ('co72012','COBOL');
insert into modle values ('co72016','Distributed Systems');
insert into modle values ('co72017','Object Oriented Programming');
insert into modle values ('co72018','Software Development 2');
insert into modle values ('co72021','Object Oriented Software Technology');
insert into modle values ('co72026','Very Large Databases');
insert into modle values ('co72033','Human Computer Interaction');
insert into modle values ('co72MMT','Multimedia Technology');
insert into modle values ('coA6GD04','Using IT in Businesss DBWP');
insert into modle values ('coA6GF04','Business Information Management');
insert into modle values ('coh2451847','Microprocessor Fundamentals');
insert into modle values ('coh6412255','Project Management');
insert into modle values ('coh641255','Project Management');
insert into modle values ('coh7400350','Communications Skills');
insert into modle values ('coh8412465','Computer Applications');
insert into modle values ('coh8412475','Database');
insert into modle values ('coh8412505','IT Applications');
insert into modle values ('coh8412545','Multi User OS');
insert into modle values ('coh8412555','Multimedia Technology');
insert into modle values ('coh8412575','Providing Support to Users');
insert into modle values ('coh8412585','System Development Life Cycle');
insert into modle values ('coh8412595','Object Oriented Applications');
insert into modle values ('coh8412605','Standalone CS support');
insert into modle values ('coh8412615','Systems Development, Introduction');
insert into modle values ('coh8412625','Event Driven Language');
insert into modle values ('coh8412635','Procedural Languages COBOL');
insert into modle values ('coh8413618','Block Structured Programming');
--- tabmodle, 101, 50
insert into modle values ('coh8413638','4th Generation Environments');
insert into modle values ('coh8413758','OO Analysis and Design');
insert into modle values ('coh8520864','Engineering Programming');
insert into modle values ('coh8521005','Structured Systems Analysis and Design');
insert into modle values ('coh8560085',NULL);
insert into modle values ('coh8560095','Information Systems and Services');
--- tabevent, 1, 50
insert into event values ('co12004.L01','co12004','L','Wednesday','11:00',1,'cr.SMH');
insert into event values ('co12004.L02','co12004','L','Monday','17:00',1,'cr.B13');
insert into event values ('co12004.T01','co12004','T','Monday','11:00',2,'co.G78+G82');
insert into event values ('co12004.T02','co12004','T','Tuesday','15:00',2,'co.B7');
insert into event values ('co12004.T03','co12004','T','Tuesday','13:00',2,'co.G78+G82');
insert into event values ('co12004.T04','co12004','T','Wednesday','13:00',2,'co.LB42+LB46');
insert into event values ('co12004.T05','co12004','T','Wednesday','09:00',2,'co.117+118');
insert into event values ('co12004.T06','co12004','T','Tuesday','13:00',2,'co.LB47');
insert into event values ('co12005.L01','co12005','L','Monday','14:00',1,'cr.SMH');
insert into event values ('co12005.L02','co12005','L','Friday','10:00',1,'cr.SMH');
insert into event values ('co12005.T01','co12005','T','Tuesday','11:00',2,'co.G78+G82');
insert into event values ('co12005.T02','co12005','T','Monday','11:00',2,'cr.G90+116');
insert into event values ('co12005.T03','co12005','T','Tuesday','10:00',2,'co.LB47');
insert into event values ('co12005.T04','co12005','T','Wednesday','14:00',2,'co.B7');
insert into event values ('co12005.T05','co12005','T','Monday','15:00',2,'co.117+118');
insert into event values ('co12006.L01','co12006','L','Wednesday','10:00',1,'cr.SMH');
insert into event values ('co12006.L02','co12006','L','Thursday','09:00',2,'cr.G6');
insert into event values ('co12006.L03','co12006','L','Wednesday','13:00',1,'cr.SMH');
insert into event values ('co12006.T01','co12006','T','Tuesday','14:00',2,'co.LB42+LB46');
insert into event values ('co12006.T02','co12006','T','Thursday','13:00',2,'co.G82');
insert into event values ('co12006.T03','co12006','T','Monday','15:00',2,'co.LB47');
insert into event values ('co12006.T04','co12006','T','Monday','11:00',2,'co.LB42+LB46');
insert into event values ('co12006.T05','co12006','T','Monday','09:00',2,'co.117+118');
insert into event values ('co12006.T06','co12006','T','Thursday','14:00',2,'co.117+118');
insert into event values ('co12008.L01','co12008','L','Tuesday','11:00',2,'co.G74');
insert into event values ('co12008.T01','co12008','T','Monday','13:00',2,'cr.G90+116');
insert into event values ('co12008.T02','co12008','T','Friday','14:00',2,'cr.G90+116');
insert into event values ('co12011.L01','co12011','L','Monday','09:00',2,'cr.G3');
insert into event values ('co12011.T01','co12011','T','Thursday','13:00',2,'co.LB47');
insert into event values ('co12012.L01','co12012','L','Wednesday','12:00',1,'cr.B10');
insert into event values ('co12012.T01','co12012','T','Wednesday','13:00',2,'co.G75+G76');
insert into event values ('co22005.L01','co22005','L','Thursday','12:00',2,'cr.SMH');
insert into event values ('co22005.T01','co22005','T','Thursday','14:00',1,'cr.G116');
insert into event values ('co22005.T02','co22005','T','Wednesday','13:00',1,'co.B7');
insert into event values ('co22005.T03','co22005','T','Wednesday','11:00',1,'co.G78+G82');
insert into event values ('co22005.T04','co22005','T','Tuesday','09:00',1,'co.LB42+LB46');
insert into event values ('co22005.T05','co22005','T','Friday','09:00',1,'cr.B8');
insert into event values ('co22005.T06','co22005','T','Wednesday','11:00',1,'cr.B8');
insert into event values ('co22005.T07','co22005','T','Wednesday','14:00',1,'cr.B2');
insert into event values ('co22005.T08','co22005','T','Tuesday','11:00',1,'cr.B2');
insert into event values ('co22005.T09','co22005','T','Thursday','16:00',1,'co.G78+G82');
insert into event values ('co22005.T10','co22005','T','Friday','10:00',1,'cr.B13');
insert into event values ('co22006.L01','co22006','L','Friday','15:00',2,'cr.B1');
insert into event values ('co22006.L02','co22006','L','Thursday','10:00',1,'cr.G2');
insert into event values ('co22006.L03','co22006','L','Thursday','15:00',1,'cr.G3');
insert into event values ('co22006.T01','co22006','T','Monday','13:00',2,'co.LB47');
insert into event values ('co22006.T02','co22006','T','Monday','15:00',2,'co.LB46');
insert into event values ('co22006.T03','co22006','T','Monday','15:00',2,'cr.G90+116');
insert into event values ('co22006.T04','co22006','T','Wednesday','15:00',2,'co.G78+G82');
insert into event values ('co22007.L01','co22007','L','Monday','09:00',2,'cr.SMH');
--- tabevent, 51, 50
insert into event values ('co22007.T01','co22007','T','Friday','11:00',2,'co.LB47');
insert into event values ('co22007.T02','co22007','T','Monday','13:00',2,'co.B7');
insert into event values ('co22007.T03','co22007','T','Tuesday','10:00',2,'co.B7');
insert into event values ('co22007.T04','co22007','T','Tuesday','15:00',2,'co.LB47');
insert into event values ('co22007.T05','co22007','T','Thursday','17:00',1,'co.B7');
insert into event values ('co22007.T06','co22007','T','Thursday','14:00',2,'co.B7');
insert into event values ('co22008.L01','co22008','L','Thursday','15:00',2,NULL);
insert into event values ('co22008.L02','co22008','L','Tuesday','18:00',2,'cr.G3');
insert into event values ('co22008.T01','co22008','T','Tuesday','13:00',1,NULL);
insert into event values ('co22008.T02','co22008','T','Tuesday','20:00',1,'co.117');
insert into event values ('co22008.T03','co22008','T','Wednesday','09:00',1,NULL);
insert into event values ('co22008.T04','co22008','T','Tuesday','12:00',1,'co.117+118');
insert into event values ('co22008.T05','co22008','T','Thursday','17:00',1,NULL);
insert into event values ('co22009.L01','co22009','L','Wednesday','12:00',2,'cr.132');
insert into event values ('co22009.T01','co22009','T','Wednesday','15:00',2,'cr.G90+116');
insert into event values ('co22009.T02','co22009','T','Wednesday','09:00',2,'cr.G90');
insert into event values ('co22020.L01','co22020','L','Friday','13:00',2,'cr.B1');
insert into event values ('co22020.T01','co22020','T','Thursday','12:00',2,NULL);
insert into event values ('co22020.T02','co22020','T','Friday','15:00',2,NULL);
insert into event values ('co22020.T03','co22020','T','Tuesday','13:00',2,NULL);
insert into event values ('co22020.T04','co22020','T','Friday','11:00',2,'co.LB47');
insert into event values ('co22020.T05','co22020','T','Friday','09:00',2,NULL);
insert into event values ('co22022.L01','co22022','L','Friday','10:00',2,'cr.B8');
insert into event values ('co22022.T01','co22022','T','Friday','09:00',1,'cr.G90+116');
insert into event values ('co32003.L01','co32003','L','Tuesday','13:00',2,'cr.G6');
insert into event values ('co32003.T01','co32003','T','Friday','11:00',1,'co.G78+G82');
insert into event values ('co32005.L01','co32005','L','Friday','15:00',2,'cr.B2');
insert into event values ('co32005.T04','co32005','T','Wednesday','10:00',1,'co.B7');
insert into event values ('co32005.T05','co32005','T','Thursday','12:00',1,'co.LB46');
insert into event values ('co32011.L01','co32011','L','Thursday','11:00',1,'cr.SMH');
insert into event values ('co32011.L02','co32011','L','Thursday','13:00',1,'cr.B1');
insert into event values ('co32011.T01','co32011','T','Thursday','12:00',1,'co.G75+G76');
insert into event values ('co32011.T02','co32011','T','Tuesday','10:00',1,'co.G78+G82');
insert into event values ('co32011.T03','co32011','T','Tuesday','11:00',1,'co.LB42+LB46');
insert into event values ('co32014.L01','co32014','L','Tuesday','14:00',2,'cr.B1');
insert into event values ('co32014.T01','co32014','T','Wednesday','09:00',1,'cr.G80');
insert into event values ('co32014.T02','co32014','T','Monday','16:00',1,'cr.131');
insert into event values ('co32014.T03','co32014','T','Tuesday','16:00',1,'cr.B13');
insert into event values ('co32015.L01','co32015','L','Tuesday','13:00',2,'cr.204');
insert into event values ('co32015.T01','co32015','T','Friday','14:00',1,'co.117+118');
insert into event values ('co32016.L01','co32016','L','Tuesday','12:00',1,'cr.B1');
insert into event values ('co32018.L01','co32018','L','Tuesday','09:00',2,'cr.132');
insert into event values ('co32018.T01','co32018','T','Friday','13:00',1,'cr.G90+116');
insert into event values ('co32021.L01','co32021','L','Wednesday','09:00',1,'cr.132');
insert into event values ('co32023.L01','co32023','L','Monday','11:00',2,'cr.B11');
insert into event values ('co32023.T01','co32023','T','Wednesday','12:00',1,'cr.G3');
insert into event values ('co42001.L01','co42001','L','Wednesday','14:00',2,'cr.G6');
insert into event values ('co42001.T01','co42001','T','Thursday','16:00',1,'co.LB42+LB46');
insert into event values ('co42002.L01','co42002','L','Tuesday','15:00',2,'cr.131');
insert into event values ('co42002.T01','co42002','T','Tuesday','13:00',1,'co.B7');
--- tabevent, 101, 50
insert into event values ('co42005.L01','co42005','L','Tuesday','10:00',2,'cr.131');
insert into event values ('co42005.T01','co42005','T','Thursday','15:00',1,'co.LB47');
insert into event values ('co42009.L01','co42009','L','Monday','14:00',2,'cr.B8');
insert into event values ('co42009.T01','co42009','T','Friday','13:00',1,'co.117+118');
insert into event values ('co42010.L01','co42010','L','Thursday','15:00',2,'cr.132');
insert into event values ('co42010.T01','co42010','T','Tuesday','12:00',1,'cr.G90+116');
insert into event values ('co42010.T02','co42010','T','Thursday','17:00',1,'co.117+118');
insert into event values ('co42013.L01','co42013','L','Thursday','09:00',2,'cr.B2');
insert into event values ('co42013.T01','co42013','T','Thursday','11:00',1,'co.G78+G82');
insert into event values ('co42015.L01','co42015','L','Tuesday','16:00',2,'cr.G80');
insert into event values ('co42015.T01','co42015','T','Thursday','10:00',1,'co.G75+G76');
insert into event values ('co42019.L01','co42019','L','Friday','16:00',1,'cr.SMH');
insert into event values ('co42022.L01','co42022','L','Thursday','13:00',2,'cr.B9');
insert into event values ('co42022.T01','co42022','T','Thursday','11:00',1,'co.117+118');
insert into event values ('co72002.L01','co72002','L','Monday','10:00',2,'cr.B12');
insert into event values ('co72002.T01','co72002','T','Monday','12:00',1,'co.LB47');
insert into event values ('co72003.L01','co72003','L','Monday','14:00',2,'cr.B12');
insert into event values ('co72003.T01','co72003','T','Monday','16:00',1,'co.LB42');
insert into event values ('co72004.L01','co72004','L','Thursday','13:00',2,'cr.203');
insert into event values ('co72004.T01','co72004','T','Thursday','15:00',1,'cr.G116');
insert into event values ('co72006.L01','co72006','L','Wednesday','09:00',2,'cr.B11');
insert into event values ('co72006.T01','co72006','T','Wednesday','12:00',1,'co.G75+G76');
insert into event values ('co72011.L01','co72011','L','Monday','15:00',2,'cr.SMH');
insert into event values ('co72011.T01','co72011','T','Friday','09:00',1,'co.B7');
insert into event values ('co72011.T02','co72011','T','Monday','13:00',1,'co.LB46');
insert into event values ('co72011.T03','co72011','T','Thursday','13:00',1,'co.LB46');
insert into event values ('co72011.T04','co72011','T','Monday','14:00',1,'co.LB46');
insert into event values ('co72011.T05','co72011','T','Friday','09:00',1,'cr.B10');
insert into event values ('co72011.T06','co72011','T','Monday','13:00',1,'cr.B10');
insert into event values ('co72011.T07','co72011','T','Thursday','13:00',1,'cr.B10');
insert into event values ('co72011.T08','co72011','T','Monday','14:00',1,'cr.B10');
insert into event values ('co72011.T09','co72011','T','Friday','13:00',1,'co.LB47');
insert into event values ('co72012.L01','co72012','L','Thursday','09:00',2,'cr.B1');
insert into event values ('co72012.T01','co72012','T','Friday','12:00',1,'co.LB42+LB46');
insert into event values ('co72012.T02','co72012','T','Wednesday','12:00',1,'cr.G90+116');
insert into event values ('co72012.T03','co72012','T','Thursday','12:00',1,'co.G78+G82');
insert into event values ('co72013.L01','co72010','L','Wednesday','14:00',2,'cr.SMH');
insert into event values ('co72013.L02','co72010','L','Tuesday','09:00',2,'cr.B8');
insert into event values ('co72013.T01','co72010','T','Wednesday','09:00',1,'co.B7');
insert into event values ('co72013.T02','co72010','T','Tuesday','12:00',1,'co.LB42+LB46');
insert into event values ('co72013.T03','co72010','T','Tuesday','11:00',1,'co.G75+G76');
insert into event values ('co72013.T04','co72010','T','Wednesday','16:00',1,'co.LB42+LB46');
insert into event values ('co72013.T05','co72010','T','Thursday','10:00',1,'co.LB42+LB46');
insert into event values ('co72013.T06','co72010','T','Wednesday','13:00',1,'co.117+118');
insert into event values ('co72016.L01','co72016','L','Tuesday','10:00',2,'cr.B13');
insert into event values ('co72016.T01','co72016','T','Tuesday','09:00',1,'co.G75+G76');
insert into event values ('co72017.L01','co72017','L','Tuesday','10:00',2,'cr.202');
insert into event values ('co72017.T01','co72017','T','Friday','11:00',1,'co.G75+G76');
insert into event values ('co72018.L01','co72018','L','Thursday','11:00',2,'cr.B1');
insert into event values ('co72018.T01','co72018','T','Thursday','10:00',1,'co.G78+G82');
--- tabevent, 151, 50
insert into event values ('co72018.T02','co72018','T','Monday','12:00',1,'co.B7');
insert into event values ('co72021.L01','co72021','L','Tuesday','13:00',2,'cr.SMH');
insert into event values ('co72021.T01','co72021','T','Monday','14:00',1,'co.LB42');
insert into event values ('co72023.L01','co72005','L','Friday','14:00',2,'cr.SMH');
insert into event values ('co72023.L02','co72005','L','Tuesday','18:00',2,'cr.131');
insert into event values ('co72023.T01','co72005','T','Thursday','14:00',1,'co.LB46');
insert into event values ('co72023.T02','co72005','T','Thursday','16:00',1,'co.B7');
insert into event values ('co72023.T03','co72005','T','Thursday','11:00',1,'co.B7');
insert into event values ('co72023.T04','co72005','T','Friday','16:00',1,'co.B7');
insert into event values ('co72023.T05','co72005','T','Friday','17:00',1,'co.B7');
insert into event values ('co72023.T06','co72005','T','Tuesday','20:00',1,'co.B7');
insert into event values ('co72026.L01','co72026','L','Monday','15:00',2,'cr.G6');
insert into event values ('co72026.L02','co72026','L','Tuesday','18:00',2,'cr.201');
insert into event values ('co72026.T01','co72026','T','Monday','13:00',1,'co.117+118');
insert into event values ('co72026.T02','co72026','T','Tuesday','20:00',1,'co.LB42');
insert into event values ('co72033.L01','co72033','L','Tuesday','14:00',2,'cr.132');
insert into event values ('co72033.T01','co72033','T','Tuesday','16:00',1,'co.G78+G82');
insert into event values ('coh2451.L01','coh2451847','L','Wednesday','11:00',1,'cr.B13');
insert into event values ('coh2451.T01','coh2451847','T','Wednesday','09:00',2,NULL);
insert into event values ('coh6412255.L01','coh6412255','L','Monday','09:00',1,'cr.204');
insert into event values ('coh6412255.T01','coh6412255','T','Wednesday','15:00',2,'cr.B10');
insert into event values ('coh8412555.L01','coh8412555','L','Wednesday','09:00',1,'cr.B2');
insert into event values ('coh8412555.L02','coh8412555','L','Thursday','09:00',1,'cr.G80');
insert into event values ('coh8412555.T01','coh8412555','T','Thursday','16:00',2,'cr.G90+116');
insert into event values ('coh8412555.T02','coh8412555','T','Tuesday','09:00',2,'co.117+118');
insert into event values ('coh8412575.L01','coh8412575','L','Wednesday','11:00',2,'cr.B2');
insert into event values ('coh8412575.T01','coh8412575','T','Tuesday','14:00',2,'co.G75+G76');
insert into event values ('coh8412575.T02','coh8412575','T','Monday','11:00',2,'co.117+118');
insert into event values ('coh8412585.L01','coh8412585','L','Wednesday','12:00',1,'cr.SMH');
insert into event values ('coh8412585.T01','coh8412585','T','Tuesday','16:00',2,'co.117');
insert into event values ('coh8412585.T02','coh8412585','T','Monday','14:00',2,'cr.G2');
insert into event values ('coh8412585.T03','coh8412585','T','Tuesday','09:00',2,'cr.G2');
insert into event values ('coh8412605.L01','coh8412605','L','Wednesday','14:00',2,'cr.B1');
insert into event values ('coh8412605.T01','coh8412605','T','Wednesday','16:00',2,'co.117+118');
insert into event values ('coh8412605.T02','coh8412605','T','Tuesday','15:00',2,'co.117+118');
insert into event values ('coh8412605.T03','coh8412605','T','Friday','14:00',2,'co.G78+G82');
insert into event values ('coh8412615.L01','coh8412615','L','Friday','09:00',1,'cr.B1');
insert into event values ('coh8412615.T01','coh8412615','T','Friday','15:00',2,'co.G75+G76');
insert into event values ('coh8412615.T02','coh8412615','T','Thursday','15:00',2,'co.G75+G76');
insert into event values ('coh8412615.T03','coh8412615','T','Tuesday','11:00',2,'co.117+118');
insert into event values ('coh8412615.T04','coh8412615','T','Tuesday','14:00',2,'cr.203');
insert into event values ('coh8412615.T05','coh8412615','T','Wednesday','16:00',2,'cr.B12');
insert into event values ('coh8412615.T06','coh8412615','T','Monday','16:00',2,'cr.G2');
insert into event values ('coh8412635.L01','coh8412635','L','Thursday','14:00',1,'cr.B1');
insert into event values ('coh8412635.L02','coh8412635','L','Friday','12:00',1,'cr.B1');
insert into event values ('coh8412635.T01','coh8412635','T','Monday','15:00',2,'co.G78+G82');
insert into event values ('coh8412635.T02','coh8412635','T','Friday','10:00',2,'co.117+118');
insert into event values ('coh8412635.T03','coh8412635','T','Thursday','11:00',2,'co.LB47');
insert into event values ('coh8412635.T04','coh8412635','T','Tuesday','10:00',2,'cr.G90+116');
insert into event values ('coh8412635.T05','coh8412635','T','Friday','15:00',2,'co.LB47');
--- tabevent, 201, 50
insert into event values ('coh8412635.T06','coh8412635','T','Tuesday','14:00',2,'cr.G90');
insert into event values ('coh8521005.L01','coh8521005','L','Thursday','11:00',1,'cr.G80');
insert into event values ('coh8521005.T01','coh8521005','T','Friday','13:00',2,'cr.G6');
insert into event values ('coh8521005.T02','coh8521005','T','Friday','10:00',2,'cr.G2');
insert into event values ('coh8560095.L01','coh8560095','L','Thursday','17:00',1,'cr.B1');
insert into event values ('coh8560095.T01','coh8560095','T','Thursday','15:00',2,'cr.G6');
insert into event values ('coh8560095.T02','coh8560095','T','Thursday','11:00',2,'cr.G6');
insert into event values ('coh8560095.T03','coh8560095','T','Wednesday','10:00',2,'cr.B9');
--- taboccurs, 1, 50
insert into occurs values ('co32016.L01','11');
insert into occurs values ('co32016.L01','12');
insert into occurs values ('co32016.L01','13');
insert into occurs values ('co32018.L01','01');
insert into occurs values ('co32018.L01','02');
insert into occurs values ('co32018.L01','03');
insert into occurs values ('co32018.L01','04');
insert into occurs values ('co32018.L01','05');
insert into occurs values ('co32018.L01','06');
insert into occurs values ('co32018.L01','07');
insert into occurs values ('co32018.L01','08');
insert into occurs values ('co32018.L01','10');
insert into occurs values ('co32018.L01','11');
insert into occurs values ('co32018.L01','12');
insert into occurs values ('co32018.L01','13');
insert into occurs values ('co32018.T01','01');
insert into occurs values ('co32018.T01','02');
insert into occurs values ('co32018.T01','03');
insert into occurs values ('co32018.T01','04');
insert into occurs values ('co32018.T01','05');
insert into occurs values ('co32018.T01','06');
insert into occurs values ('co32018.T01','07');
insert into occurs values ('co32018.T01','08');
insert into occurs values ('co32018.T01','10');
insert into occurs values ('co32018.T01','11');
insert into occurs values ('co32018.T01','12');
insert into occurs values ('co32018.T01','13');
insert into occurs values ('co32021.L01','01');
insert into occurs values ('co32021.L01','02');
insert into occurs values ('co32021.L01','03');
insert into occurs values ('co32021.L01','04');
insert into occurs values ('co32021.L01','05');
insert into occurs values ('co32021.L01','06');
insert into occurs values ('co32021.L01','07');
insert into occurs values ('co32021.L01','08');
insert into occurs values ('co32021.L01','10');
insert into occurs values ('co32021.L01','11');
insert into occurs values ('co32021.L01','12');
insert into occurs values ('co32021.L01','13');
insert into occurs values ('co32023.L01','01');
insert into occurs values ('co32023.L01','02');
insert into occurs values ('co32023.L01','03');
insert into occurs values ('co32023.L01','04');
insert into occurs values ('co32023.L01','05');
insert into occurs values ('co32023.L01','06');
insert into occurs values ('co32023.L01','07');
insert into occurs values ('co32023.L01','08');
insert into occurs values ('co32023.L01','10');
insert into occurs values ('co32023.L01','11');
insert into occurs values ('co32023.L01','12');
--- taboccurs, 51, 50
insert into occurs values ('co32023.L01','13');
insert into occurs values ('co32023.T01','01');
insert into occurs values ('co32023.T01','02');
insert into occurs values ('co32023.T01','03');
insert into occurs values ('co32023.T01','04');
insert into occurs values ('co32023.T01','05');
insert into occurs values ('co32023.T01','06');
insert into occurs values ('co32023.T01','07');
insert into occurs values ('co32023.T01','08');
insert into occurs values ('co32023.T01','10');
insert into occurs values ('co32023.T01','11');
insert into occurs values ('co32023.T01','12');
insert into occurs values ('co32023.T01','13');
insert into occurs values ('co42001.L01','01');
insert into occurs values ('co42001.L01','02');
insert into occurs values ('co42001.L01','03');
insert into occurs values ('co42001.L01','04');
insert into occurs values ('co42001.L01','05');
insert into occurs values ('co42001.L01','06');
insert into occurs values ('co42001.L01','07');
insert into occurs values ('co42001.L01','08');
insert into occurs values ('co42001.L01','10');
insert into occurs values ('co42001.L01','11');
insert into occurs values ('co42001.L01','12');
insert into occurs values ('co42001.L01','13');
insert into occurs values ('co42001.T01','01');
insert into occurs values ('co42001.T01','02');
insert into occurs values ('co42001.T01','03');
insert into occurs values ('co42001.T01','04');
insert into occurs values ('co42001.T01','05');
insert into occurs values ('co42001.T01','06');
insert into occurs values ('co42001.T01','07');
insert into occurs values ('co42001.T01','08');
insert into occurs values ('co42001.T01','10');
insert into occurs values ('co42001.T01','11');
insert into occurs values ('co42001.T01','12');
insert into occurs values ('co42001.T01','13');
insert into occurs values ('co42002.L01','01');
insert into occurs values ('co42002.L01','02');
insert into occurs values ('co42002.L01','03');
insert into occurs values ('co42002.L01','04');
insert into occurs values ('co42002.L01','05');
insert into occurs values ('co42002.L01','06');
insert into occurs values ('co42002.L01','07');
insert into occurs values ('co42002.L01','08');
insert into occurs values ('co42002.L01','10');
insert into occurs values ('co42002.L01','11');
insert into occurs values ('co42002.L01','12');
insert into occurs values ('co42002.L01','13');
insert into occurs values ('co42002.T01','01');
--- taboccurs, 101, 50
insert into occurs values ('co42002.T01','02');
insert into occurs values ('co42002.T01','03');
insert into occurs values ('co42002.T01','04');
insert into occurs values ('co42002.T01','05');
insert into occurs values ('co42002.T01','06');
insert into occurs values ('co42002.T01','07');
insert into occurs values ('co42002.T01','08');
insert into occurs values ('co42002.T01','10');
insert into occurs values ('co42002.T01','11');
insert into occurs values ('co42002.T01','12');
insert into occurs values ('co42002.T01','13');
insert into occurs values ('co42005.L01','01');
insert into occurs values ('co42005.L01','02');
insert into occurs values ('co42005.L01','03');
insert into occurs values ('co42005.L01','04');
insert into occurs values ('co42005.L01','05');
insert into occurs values ('co42005.L01','06');
insert into occurs values ('co42005.L01','07');
insert into occurs values ('co42005.L01','08');
insert into occurs values ('co42005.L01','10');
insert into occurs values ('co42005.L01','11');
insert into occurs values ('co42005.L01','12');
insert into occurs values ('co42005.L01','13');
insert into occurs values ('co42005.T01','01');
insert into occurs values ('co42005.T01','02');
insert into occurs values ('co42005.T01','03');
insert into occurs values ('co42005.T01','04');
insert into occurs values ('co42005.T01','05');
insert into occurs values ('co42005.T01','06');
insert into occurs values ('co42005.T01','07');
insert into occurs values ('co42005.T01','08');
insert into occurs values ('co42005.T01','10');
insert into occurs values ('co42005.T01','11');
insert into occurs values ('co42005.T01','12');
insert into occurs values ('co42005.T01','13');
insert into occurs values ('co42009.L01','01');
insert into occurs values ('co42009.L01','02');
insert into occurs values ('co42009.L01','03');
insert into occurs values ('co42009.L01','04');
insert into occurs values ('co42009.L01','05');
insert into occurs values ('co42009.L01','06');
insert into occurs values ('co42009.L01','07');
insert into occurs values ('co42009.L01','08');
insert into occurs values ('co42009.L01','10');
insert into occurs values ('co42009.L01','11');
insert into occurs values ('co42009.L01','12');
insert into occurs values ('co42009.L01','13');
insert into occurs values ('co42009.T01','01');
insert into occurs values ('co42009.T01','02');
insert into occurs values ('co42009.T01','03');
--- taboccurs, 151, 50
insert into occurs values ('co42009.T01','04');
insert into occurs values ('co42009.T01','05');
insert into occurs values ('co42009.T01','06');
insert into occurs values ('co42009.T01','07');
insert into occurs values ('co42009.T01','08');
insert into occurs values ('co42009.T01','10');
insert into occurs values ('co42009.T01','11');
insert into occurs values ('co42009.T01','12');
insert into occurs values ('co42009.T01','13');
insert into occurs values ('co42010.L01','01');
insert into occurs values ('co42010.L01','02');
insert into occurs values ('co42010.L01','03');
insert into occurs values ('co42010.L01','04');
insert into occurs values ('co42010.L01','05');
insert into occurs values ('co42010.L01','06');
insert into occurs values ('co42010.L01','07');
insert into occurs values ('co42010.L01','08');
insert into occurs values ('co42010.T01','01');
insert into occurs values ('co42010.T01','02');
insert into occurs values ('co42010.T01','03');
insert into occurs values ('co42010.T01','04');
insert into occurs values ('co42010.T01','05');
insert into occurs values ('co42010.T01','06');
insert into occurs values ('co42010.T01','07');
insert into occurs values ('co42010.T01','08');
insert into occurs values ('co42010.T01','10');
insert into occurs values ('co42010.T01','11');
insert into occurs values ('co42010.T01','12');
insert into occurs values ('co42010.T01','13');
insert into occurs values ('co42010.T02','01');
insert into occurs values ('co42010.T02','02');
insert into occurs values ('co42010.T02','03');
insert into occurs values ('co42010.T02','04');
insert into occurs values ('co42010.T02','05');
insert into occurs values ('co42010.T02','06');
insert into occurs values ('co42010.T02','07');
insert into occurs values ('co42010.T02','08');
insert into occurs values ('co42010.T02','10');
insert into occurs values ('co42010.T02','11');
insert into occurs values ('co42010.T02','12');
insert into occurs values ('co42010.T02','13');
insert into occurs values ('co42013.L01','01');
insert into occurs values ('co42013.L01','02');
insert into occurs values ('co42013.L01','03');
insert into occurs values ('co42013.L01','04');
insert into occurs values ('co42013.L01','05');
insert into occurs values ('co42013.L01','06');
insert into occurs values ('co42013.L01','07');
insert into occurs values ('co42013.L01','08');
insert into occurs values ('co42013.L01','10');
--- taboccurs, 201, 50
insert into occurs values ('co42013.L01','11');
insert into occurs values ('co42013.L01','12');
insert into occurs values ('co42013.L01','13');
insert into occurs values ('co42013.T01','01');
insert into occurs values ('co42013.T01','02');
insert into occurs values ('co42013.T01','03');
insert into occurs values ('co42013.T01','04');
insert into occurs values ('co42013.T01','05');
insert into occurs values ('co42013.T01','06');
insert into occurs values ('co42013.T01','07');
insert into occurs values ('co42013.T01','08');
insert into occurs values ('co42013.T01','10');
insert into occurs values ('co42013.T01','11');
insert into occurs values ('co42013.T01','12');
insert into occurs values ('co42013.T01','13');
insert into occurs values ('co42015.L01','01');
insert into occurs values ('co42015.L01','02');
insert into occurs values ('co42015.L01','03');
insert into occurs values ('co42015.L01','04');
insert into occurs values ('co42015.L01','05');
insert into occurs values ('co42015.L01','06');
insert into occurs values ('co42015.L01','07');
insert into occurs values ('co42015.L01','08');
insert into occurs values ('co42015.L01','10');
insert into occurs values ('co42015.L01','11');
insert into occurs values ('co42015.L01','12');
insert into occurs values ('co42015.L01','13');
insert into occurs values ('co42015.T01','01');
insert into occurs values ('co42015.T01','02');
insert into occurs values ('co42015.T01','03');
insert into occurs values ('co42015.T01','04');
insert into occurs values ('co42015.T01','05');
insert into occurs values ('co42015.T01','06');
insert into occurs values ('co42015.T01','07');
insert into occurs values ('co42015.T01','08');
insert into occurs values ('co42015.T01','10');
insert into occurs values ('co42015.T01','11');
insert into occurs values ('co42015.T01','12');
insert into occurs values ('co42015.T01','13');
insert into occurs values ('co42019.L01','01');
insert into occurs values ('co42019.L01','02');
insert into occurs values ('co42019.L01','03');
insert into occurs values ('co42019.L01','04');
insert into occurs values ('co42022.L01','01');
insert into occurs values ('co42022.L01','02');
insert into occurs values ('co42022.L01','03');
insert into occurs values ('co42022.L01','04');
insert into occurs values ('co42022.L01','05');
insert into occurs values ('co42022.L01','06');
insert into occurs values ('co42022.L01','07');
--- taboccurs, 251, 50
insert into occurs values ('co42022.L01','08');
insert into occurs values ('co42022.L01','10');
insert into occurs values ('co42022.L01','11');
insert into occurs values ('co42022.L01','12');
insert into occurs values ('co42022.L01','13');
insert into occurs values ('co42022.T01','01');
insert into occurs values ('co42022.T01','02');
insert into occurs values ('co42022.T01','03');
insert into occurs values ('co42022.T01','04');
insert into occurs values ('co42022.T01','05');
insert into occurs values ('co42022.T01','06');
insert into occurs values ('co42022.T01','07');
insert into occurs values ('co42022.T01','08');
insert into occurs values ('co42022.T01','10');
insert into occurs values ('co42022.T01','11');
insert into occurs values ('co42022.T01','12');
insert into occurs values ('co42022.T01','13');
insert into occurs values ('co72002.L01','01');
insert into occurs values ('co72002.L01','02');
insert into occurs values ('co72002.L01','03');
insert into occurs values ('co72002.L01','04');
insert into occurs values ('co72002.L01','05');
insert into occurs values ('co72002.L01','06');
insert into occurs values ('co72002.L01','07');
insert into occurs values ('co72002.L01','08');
insert into occurs values ('co72002.L01','10');
insert into occurs values ('co72002.L01','11');
insert into occurs values ('co72002.L01','12');
insert into occurs values ('co72002.L01','13');
insert into occurs values ('co72002.T01','01');
insert into occurs values ('co72002.T01','02');
insert into occurs values ('co72002.T01','03');
insert into occurs values ('co72002.T01','04');
insert into occurs values ('co72002.T01','05');
insert into occurs values ('co72002.T01','06');
insert into occurs values ('co72002.T01','07');
insert into occurs values ('co72002.T01','08');
insert into occurs values ('co72002.T01','10');
insert into occurs values ('co72002.T01','11');
insert into occurs values ('co72002.T01','12');
insert into occurs values ('co72002.T01','13');
insert into occurs values ('co72003.L01','01');
insert into occurs values ('co72003.L01','02');
insert into occurs values ('co72003.L01','03');
insert into occurs values ('co72003.L01','04');
insert into occurs values ('co72003.L01','05');
insert into occurs values ('co72003.L01','06');
insert into occurs values ('co72003.L01','07');
insert into occurs values ('co72003.L01','08');
insert into occurs values ('co72003.L01','10');
--- taboccurs, 301, 50
insert into occurs values ('co72003.L01','11');
insert into occurs values ('co72003.L01','12');
insert into occurs values ('co72003.L01','13');
insert into occurs values ('co72003.T01','01');
insert into occurs values ('co72003.T01','02');
insert into occurs values ('co72003.T01','03');
insert into occurs values ('co72003.T01','04');
insert into occurs values ('co72003.T01','05');
insert into occurs values ('co72003.T01','06');
insert into occurs values ('co72003.T01','07');
insert into occurs values ('co72003.T01','08');
insert into occurs values ('co72003.T01','10');
insert into occurs values ('co72003.T01','11');
insert into occurs values ('co72003.T01','12');
insert into occurs values ('co72003.T01','13');
insert into occurs values ('co72004.L01','01');
insert into occurs values ('co72004.L01','02');
insert into occurs values ('co72004.L01','03');
insert into occurs values ('co72004.L01','04');
insert into occurs values ('co72004.L01','05');
insert into occurs values ('co72004.L01','06');
insert into occurs values ('co72004.L01','07');
insert into occurs values ('co72004.L01','08');
insert into occurs values ('co72004.L01','10');
insert into occurs values ('co72004.L01','11');
insert into occurs values ('co72004.L01','12');
insert into occurs values ('co72004.L01','13');
insert into occurs values ('co72004.T01','01');
insert into occurs values ('co72004.T01','02');
insert into occurs values ('co72004.T01','03');
insert into occurs values ('co72004.T01','04');
insert into occurs values ('co72004.T01','05');
insert into occurs values ('co72004.T01','06');
insert into occurs values ('co72004.T01','07');
insert into occurs values ('co72004.T01','08');
insert into occurs values ('co72004.T01','10');
insert into occurs values ('co72004.T01','11');
insert into occurs values ('co72004.T01','12');
insert into occurs values ('co72004.T01','13');
insert into occurs values ('co72006.L01','01');
insert into occurs values ('co72006.L01','02');
insert into occurs values ('co72006.L01','03');
insert into occurs values ('co72006.L01','04');
insert into occurs values ('co72006.L01','05');
insert into occurs values ('co72006.L01','06');
insert into occurs values ('co72006.L01','07');
insert into occurs values ('co72006.L01','08');
insert into occurs values ('co72006.L01','10');
insert into occurs values ('co72006.L01','11');
insert into occurs values ('co72006.L01','12');
--- taboccurs, 351, 50
insert into occurs values ('co72006.L01','13');
insert into occurs values ('co72006.T01','01');
insert into occurs values ('co72006.T01','02');
insert into occurs values ('co72006.T01','03');
insert into occurs values ('co72006.T01','04');
insert into occurs values ('co72006.T01','05');
insert into occurs values ('co72006.T01','06');
insert into occurs values ('co72006.T01','07');
insert into occurs values ('co72006.T01','08');
insert into occurs values ('co72006.T01','10');
insert into occurs values ('co72006.T01','11');
insert into occurs values ('co72006.T01','12');
insert into occurs values ('co72006.T01','13');
insert into occurs values ('co72011.L01','01');
insert into occurs values ('co72011.L01','02');
insert into occurs values ('co72011.L01','03');
insert into occurs values ('co72011.L01','04');
insert into occurs values ('co72011.L01','05');
insert into occurs values ('co72011.L01','06');
insert into occurs values ('co72011.L01','07');
insert into occurs values ('co72011.L01','08');
insert into occurs values ('co72011.L01','10');
insert into occurs values ('co72011.L01','11');
insert into occurs values ('co72011.L01','12');
insert into occurs values ('co72011.L01','13');
insert into occurs values ('co72011.T01','01');
insert into occurs values ('co72011.T01','02');
insert into occurs values ('co72011.T01','03');
insert into occurs values ('co72011.T02','01');
insert into occurs values ('co72011.T02','02');
insert into occurs values ('co72011.T02','03');
insert into occurs values ('co72011.T03','01');
insert into occurs values ('co72011.T03','02');
insert into occurs values ('co72011.T03','03');
insert into occurs values ('co72011.T04','01');
insert into occurs values ('co72011.T04','02');
insert into occurs values ('co72011.T04','03');
insert into occurs values ('co72011.T05','04');
insert into occurs values ('co72011.T05','05');
insert into occurs values ('co72011.T05','06');
insert into occurs values ('co72011.T05','07');
insert into occurs values ('co72011.T05','08');
insert into occurs values ('co72011.T05','10');
insert into occurs values ('co72011.T05','11');
insert into occurs values ('co72011.T05','12');
insert into occurs values ('co72011.T05','13');
insert into occurs values ('co72011.T06','04');
insert into occurs values ('co72011.T06','05');
insert into occurs values ('co72011.T06','06');
insert into occurs values ('co72011.T06','07');
--- taboccurs, 401, 50
insert into occurs values ('co72011.T06','08');
insert into occurs values ('co72011.T06','10');
insert into occurs values ('co72011.T06','11');
insert into occurs values ('co72011.T06','12');
insert into occurs values ('co72011.T06','13');
insert into occurs values ('co72011.T07','04');
insert into occurs values ('co72011.T07','05');
insert into occurs values ('co72011.T07','06');
insert into occurs values ('co72011.T07','07');
insert into occurs values ('co72011.T07','08');
insert into occurs values ('co72011.T07','10');
insert into occurs values ('co72011.T07','11');
insert into occurs values ('co72011.T07','12');
insert into occurs values ('co72011.T07','13');
insert into occurs values ('co72011.T08','04');
insert into occurs values ('co72011.T08','05');
insert into occurs values ('co72011.T08','06');
insert into occurs values ('co72011.T08','07');
insert into occurs values ('co72011.T08','08');
insert into occurs values ('co72011.T08','10');
insert into occurs values ('co72011.T08','11');
insert into occurs values ('co72011.T08','12');
insert into occurs values ('co72011.T08','13');
insert into occurs values ('co72011.T09','01');
insert into occurs values ('co72011.T09','02');
insert into occurs values ('co72011.T09','03');
insert into occurs values ('co72012.L01','01');
insert into occurs values ('co72012.L01','02');
insert into occurs values ('co72012.L01','03');
insert into occurs values ('co72012.L01','04');
insert into occurs values ('co72012.L01','05');
insert into occurs values ('co72012.L01','06');
insert into occurs values ('co72012.L01','07');
insert into occurs values ('co72012.L01','08');
insert into occurs values ('co72012.L01','10');
insert into occurs values ('co72012.L01','11');
insert into occurs values ('co72012.L01','12');
insert into occurs values ('co72012.L01','13');
insert into occurs values ('co72012.T01','01');
insert into occurs values ('co72012.T01','02');
insert into occurs values ('co72012.T01','03');
insert into occurs values ('co72012.T01','04');
insert into occurs values ('co72012.T01','05');
insert into occurs values ('co72012.T01','06');
insert into occurs values ('co72012.T01','07');
insert into occurs values ('co72012.T01','08');
insert into occurs values ('co72012.T01','10');
insert into occurs values ('co72012.T01','11');
insert into occurs values ('co72012.T01','12');
insert into occurs values ('co72012.T01','13');
--- taboccurs, 451, 50
insert into occurs values ('co72012.T02','01');
insert into occurs values ('co72012.T02','02');
insert into occurs values ('co72012.T02','03');
insert into occurs values ('co72012.T02','04');
insert into occurs values ('co72012.T02','05');
insert into occurs values ('co72012.T02','06');
insert into occurs values ('co72012.T02','07');
insert into occurs values ('co72012.T02','08');
insert into occurs values ('co72012.T02','10');
insert into occurs values ('co72012.T02','11');
insert into occurs values ('co72012.T02','12');
insert into occurs values ('co72012.T02','13');
insert into occurs values ('co72012.T03','01');
insert into occurs values ('co72012.T03','02');
insert into occurs values ('co72012.T03','03');
insert into occurs values ('co72012.T03','04');
insert into occurs values ('co72012.T03','05');
insert into occurs values ('co72012.T03','06');
insert into occurs values ('co72012.T03','07');
insert into occurs values ('co72012.T03','08');
insert into occurs values ('co72012.T03','10');
insert into occurs values ('co72012.T03','11');
insert into occurs values ('co72012.T03','12');
insert into occurs values ('co72012.T03','13');
insert into occurs values ('co72013.L01','01');
insert into occurs values ('co72013.L01','02');
insert into occurs values ('co72013.L01','03');
insert into occurs values ('co72013.L01','04');
insert into occurs values ('co72013.L01','05');
insert into occurs values ('co72013.L01','06');
insert into occurs values ('co72013.L01','07');
insert into occurs values ('co72013.L01','08');
insert into occurs values ('co72013.L01','10');
insert into occurs values ('co72013.L01','11');
insert into occurs values ('co72013.L01','12');
insert into occurs values ('co72013.L01','13');
insert into occurs values ('co72013.L02','01');
insert into occurs values ('co72013.L02','02');
insert into occurs values ('co72013.L02','03');
insert into occurs values ('co72013.L02','04');
insert into occurs values ('co72013.L02','05');
insert into occurs values ('co72013.L02','06');
insert into occurs values ('co72013.L02','07');
insert into occurs values ('co72013.L02','08');
insert into occurs values ('co72013.L02','10');
insert into occurs values ('co72013.L02','11');
insert into occurs values ('co72013.L02','12');
insert into occurs values ('co72013.L02','13');
insert into occurs values ('co72013.T01','01');
insert into occurs values ('co72013.T01','02');
--- taboccurs, 501, 50
insert into occurs values ('co72013.T01','03');
insert into occurs values ('co72013.T01','04');
insert into occurs values ('co72013.T01','05');
insert into occurs values ('co72013.T01','06');
insert into occurs values ('co72013.T01','07');
insert into occurs values ('co72013.T01','08');
insert into occurs values ('co72013.T01','10');
insert into occurs values ('co72013.T01','11');
insert into occurs values ('co72013.T01','12');
insert into occurs values ('co72013.T01','13');
insert into occurs values ('co72013.T02','01');
insert into occurs values ('co72013.T02','02');
insert into occurs values ('co72013.T02','03');
insert into occurs values ('co72013.T02','04');
insert into occurs values ('co72013.T02','05');
insert into occurs values ('co72013.T02','06');
insert into occurs values ('co72013.T02','07');
insert into occurs values ('co72013.T02','08');
insert into occurs values ('co72013.T02','10');
insert into occurs values ('co72013.T02','11');
insert into occurs values ('co72013.T02','12');
insert into occurs values ('co72013.T02','13');
insert into occurs values ('co72013.T03','01');
insert into occurs values ('co72013.T03','02');
insert into occurs values ('co72013.T03','03');
insert into occurs values ('co72013.T03','04');
insert into occurs values ('co72013.T03','05');
insert into occurs values ('co72013.T03','06');
insert into occurs values ('co72013.T03','07');
insert into occurs values ('co72013.T03','08');
insert into occurs values ('co72013.T03','10');
insert into occurs values ('co72013.T03','11');
insert into occurs values ('co72013.T03','12');
insert into occurs values ('co72013.T03','13');
insert into occurs values ('co72013.T04','01');
insert into occurs values ('co72013.T04','02');
insert into occurs values ('co72013.T04','03');
insert into occurs values ('co72013.T04','04');
insert into occurs values ('co72013.T04','05');
insert into occurs values ('co72013.T04','06');
insert into occurs values ('co72013.T04','07');
insert into occurs values ('co72013.T04','08');
insert into occurs values ('co72013.T04','10');
insert into occurs values ('co72013.T04','11');
insert into occurs values ('co72013.T04','12');
insert into occurs values ('co72013.T04','13');
insert into occurs values ('co72013.T05','01');
insert into occurs values ('co72013.T05','02');
insert into occurs values ('co72013.T05','03');
insert into occurs values ('co72013.T05','04');
--- taboccurs, 551, 50
insert into occurs values ('co72013.T05','05');
insert into occurs values ('co72013.T05','06');
insert into occurs values ('co72013.T05','07');
insert into occurs values ('co72013.T05','08');
insert into occurs values ('co72013.T05','10');
insert into occurs values ('co72013.T05','11');
insert into occurs values ('co72013.T05','12');
insert into occurs values ('co72013.T05','13');
insert into occurs values ('co72013.T06','01');
insert into occurs values ('co72013.T06','02');
insert into occurs values ('co72013.T06','03');
insert into occurs values ('co72013.T06','04');
insert into occurs values ('co72013.T06','05');
insert into occurs values ('co72013.T06','06');
insert into occurs values ('co72013.T06','07');
insert into occurs values ('co72013.T06','08');
insert into occurs values ('co72013.T06','10');
insert into occurs values ('co72013.T06','11');
insert into occurs values ('co72013.T06','12');
insert into occurs values ('co72013.T06','13');
insert into occurs values ('co72016.L01','01');
insert into occurs values ('co72016.L01','02');
insert into occurs values ('co72016.L01','03');
insert into occurs values ('co72016.L01','04');
insert into occurs values ('co72016.L01','05');
insert into occurs values ('co72016.L01','06');
insert into occurs values ('co72016.L01','07');
insert into occurs values ('co72016.L01','08');
insert into occurs values ('co72016.L01','10');
insert into occurs values ('co72016.L01','11');
insert into occurs values ('co72016.L01','12');
insert into occurs values ('co72016.L01','13');
insert into occurs values ('co72016.T01','01');
insert into occurs values ('co72016.T01','02');
insert into occurs values ('co72016.T01','03');
insert into occurs values ('co72016.T01','04');
insert into occurs values ('co72016.T01','05');
insert into occurs values ('co72016.T01','06');
insert into occurs values ('co72016.T01','07');
insert into occurs values ('co72016.T01','08');
insert into occurs values ('co72016.T01','10');
insert into occurs values ('co72016.T01','11');
insert into occurs values ('co72016.T01','12');
insert into occurs values ('co72016.T01','13');
insert into occurs values ('co72017.L01','01');
insert into occurs values ('co72017.L01','02');
insert into occurs values ('co72017.L01','03');
insert into occurs values ('co72017.L01','04');
insert into occurs values ('co72017.L01','05');
insert into occurs values ('co72017.L01','06');
--- taboccurs, 601, 50
insert into occurs values ('co72017.L01','07');
insert into occurs values ('co72017.L01','08');
insert into occurs values ('co72017.L01','10');
insert into occurs values ('co72017.L01','11');
insert into occurs values ('co72017.L01','12');
insert into occurs values ('co72017.L01','13');
insert into occurs values ('co72017.T01','01');
insert into occurs values ('co72017.T01','02');
insert into occurs values ('co72017.T01','03');
insert into occurs values ('co72017.T01','04');
insert into occurs values ('co72017.T01','05');
insert into occurs values ('co72017.T01','06');
insert into occurs values ('co72017.T01','07');
insert into occurs values ('co72017.T01','08');
insert into occurs values ('co72017.T01','10');
insert into occurs values ('co72017.T01','11');
insert into occurs values ('co72017.T01','12');
insert into occurs values ('co72017.T01','13');
insert into occurs values ('co72018.L01','01');
insert into occurs values ('co72018.L01','02');
insert into occurs values ('co72018.L01','03');
insert into occurs values ('co72018.L01','04');
insert into occurs values ('co72018.L01','05');
insert into occurs values ('co72018.L01','06');
insert into occurs values ('co72018.L01','07');
insert into occurs values ('co72018.L01','08');
insert into occurs values ('co72018.L01','10');
insert into occurs values ('co72018.L01','11');
insert into occurs values ('co72018.L01','12');
insert into occurs values ('co72018.L01','13');
insert into occurs values ('co72018.T01','01');
insert into occurs values ('co72018.T01','02');
insert into occurs values ('co72018.T01','03');
insert into occurs values ('co72018.T01','04');
insert into occurs values ('co72018.T01','05');
insert into occurs values ('co72018.T01','06');
insert into occurs values ('co72018.T01','07');
insert into occurs values ('co72018.T01','08');
insert into occurs values ('co72018.T01','10');
insert into occurs values ('co72018.T01','11');
insert into occurs values ('co72018.T01','12');
insert into occurs values ('co72018.T01','13');
insert into occurs values ('co72018.T02','01');
insert into occurs values ('co72018.T02','02');
insert into occurs values ('co72018.T02','03');
insert into occurs values ('co72018.T02','04');
insert into occurs values ('co72018.T02','05');
insert into occurs values ('co72018.T02','06');
insert into occurs values ('co72018.T02','07');
insert into occurs values ('co72018.T02','08');
--- taboccurs, 651, 50
insert into occurs values ('co72018.T02','10');
insert into occurs values ('co72018.T02','11');
insert into occurs values ('co72018.T02','12');
insert into occurs values ('co72018.T02','13');
insert into occurs values ('co72021.L01','01');
insert into occurs values ('co72021.L01','02');
insert into occurs values ('co72021.L01','03');
insert into occurs values ('co72021.L01','04');
insert into occurs values ('co72021.L01','05');
insert into occurs values ('co72021.L01','06');
insert into occurs values ('co72021.L01','07');
insert into occurs values ('co72021.L01','08');
insert into occurs values ('co72021.L01','10');
insert into occurs values ('co72021.L01','11');
insert into occurs values ('co72021.L01','12');
insert into occurs values ('co72021.L01','13');
insert into occurs values ('co72021.T01','01');
insert into occurs values ('co72021.T01','02');
insert into occurs values ('co72021.T01','03');
insert into occurs values ('co72021.T01','04');
insert into occurs values ('co72021.T01','05');
insert into occurs values ('co72021.T01','06');
insert into occurs values ('co72021.T01','07');
insert into occurs values ('co72021.T01','08');
insert into occurs values ('co72021.T01','10');
insert into occurs values ('co72021.T01','11');
insert into occurs values ('co72021.T01','12');
insert into occurs values ('co72021.T01','13');
insert into occurs values ('co72023.L01','10');
insert into occurs values ('co72023.L01','11');
insert into occurs values ('co72023.L01','12');
insert into occurs values ('co72023.L01','13');
insert into occurs values ('co72023.L02','01');
insert into occurs values ('co72023.L02','02');
insert into occurs values ('co72023.L02','03');
insert into occurs values ('co72023.L02','04');
insert into occurs values ('co72023.L02','05');
insert into occurs values ('co72023.L02','06');
insert into occurs values ('co72023.L02','07');
insert into occurs values ('co72023.L02','08');
insert into occurs values ('co72023.L02','10');
insert into occurs values ('co72023.L02','11');
insert into occurs values ('co72023.L02','12');
insert into occurs values ('co72023.L02','13');
insert into occurs values ('co72023.T01','01');
insert into occurs values ('co72023.T01','02');
insert into occurs values ('co72023.T01','03');
insert into occurs values ('co72023.T01','04');
insert into occurs values ('co72023.T01','05');
insert into occurs values ('co72023.T01','06');
--- taboccurs, 701, 50
insert into occurs values ('co72023.T01','07');
insert into occurs values ('co72023.T01','08');
insert into occurs values ('co72023.T01','10');
insert into occurs values ('co72023.T01','11');
insert into occurs values ('co72023.T01','12');
insert into occurs values ('co72023.T01','13');
insert into occurs values ('co72023.T02','01');
insert into occurs values ('co72023.T02','02');
insert into occurs values ('co72023.T02','03');
insert into occurs values ('co72023.T02','04');
insert into occurs values ('co72023.T02','05');
insert into occurs values ('co72023.T02','06');
insert into occurs values ('co72023.T02','07');
insert into occurs values ('co72023.T02','08');
insert into occurs values ('co72023.T02','10');
insert into occurs values ('co72023.T02','11');
insert into occurs values ('co72023.T02','12');
insert into occurs values ('co72023.T02','13');
insert into occurs values ('co72023.T03','01');
insert into occurs values ('co72023.T03','02');
insert into occurs values ('co72023.T03','03');
insert into occurs values ('co72023.T03','04');
insert into occurs values ('co72023.T03','05');
insert into occurs values ('co72023.T03','06');
insert into occurs values ('co72023.T03','07');
insert into occurs values ('co72023.T03','08');
insert into occurs values ('co12004.L01','01');
insert into occurs values ('co12004.L01','02');
insert into occurs values ('co12004.L01','03');
insert into occurs values ('co12004.L01','04');
insert into occurs values ('co12004.L01','05');
insert into occurs values ('co12004.L01','06');
insert into occurs values ('co12004.L01','07');
insert into occurs values ('co12004.L01','08');
insert into occurs values ('co12004.L01','10');
insert into occurs values ('co12004.L01','11');
insert into occurs values ('co12004.L01','12');
insert into occurs values ('co12004.L01','13');
insert into occurs values ('co12004.L02','01');
insert into occurs values ('co12004.L02','02');
insert into occurs values ('co12004.L02','03');
insert into occurs values ('co12004.L02','04');
insert into occurs values ('co12004.L02','05');
insert into occurs values ('co12004.L02','06');
insert into occurs values ('co12004.L02','07');
insert into occurs values ('co12004.L02','08');
insert into occurs values ('co12004.L02','10');
insert into occurs values ('co12004.L02','11');
insert into occurs values ('co12004.L02','12');
insert into occurs values ('co12004.L02','13');
--- taboccurs, 751, 50
insert into occurs values ('co12004.T01','01');
insert into occurs values ('co12004.T01','02');
insert into occurs values ('co12004.T01','03');
insert into occurs values ('co12004.T01','04');
insert into occurs values ('co12004.T01','05');
insert into occurs values ('co12004.T01','06');
insert into occurs values ('co12004.T01','07');
insert into occurs values ('co12004.T01','08');
insert into occurs values ('co12004.T01','10');
insert into occurs values ('co12004.T01','11');
insert into occurs values ('co12004.T01','12');
insert into occurs values ('co12004.T01','13');
insert into occurs values ('co12004.T02','01');
insert into occurs values ('co12004.T02','02');
insert into occurs values ('co12004.T02','03');
insert into occurs values ('co12004.T02','04');
insert into occurs values ('co12004.T02','05');
insert into occurs values ('co12004.T02','06');
insert into occurs values ('co12004.T02','07');
insert into occurs values ('co12004.T02','08');
insert into occurs values ('co12004.T02','10');
insert into occurs values ('co12004.T02','11');
insert into occurs values ('co12004.T02','12');
insert into occurs values ('co12004.T02','13');
insert into occurs values ('co12004.T03','01');
insert into occurs values ('co12004.T03','02');
insert into occurs values ('co12004.T03','03');
insert into occurs values ('co12004.T03','04');
insert into occurs values ('co12004.T03','05');
insert into occurs values ('co12004.T03','06');
insert into occurs values ('co12004.T03','07');
insert into occurs values ('co12004.T03','08');
insert into occurs values ('co12004.T03','10');
insert into occurs values ('co12004.T03','11');
insert into occurs values ('co12004.T03','12');
insert into occurs values ('co12004.T03','13');
insert into occurs values ('co12004.T04','01');
insert into occurs values ('co12004.T04','02');
insert into occurs values ('co12004.T04','03');
insert into occurs values ('co12004.T04','04');
insert into occurs values ('co12004.T04','05');
insert into occurs values ('co12004.T04','06');
insert into occurs values ('co12004.T04','07');
insert into occurs values ('co12004.T04','08');
insert into occurs values ('co12004.T04','10');
insert into occurs values ('co12004.T04','11');
insert into occurs values ('co12004.T04','12');
insert into occurs values ('co12004.T04','13');
insert into occurs values ('co12004.T05','01');
insert into occurs values ('co12004.T05','02');
--- taboccurs, 801, 50
insert into occurs values ('co12004.T05','03');
insert into occurs values ('co12004.T05','04');
insert into occurs values ('co12004.T05','05');
insert into occurs values ('co12004.T05','06');
insert into occurs values ('co12004.T05','07');
insert into occurs values ('co12004.T05','08');
insert into occurs values ('co12004.T05','10');
insert into occurs values ('co12004.T05','11');
insert into occurs values ('co12004.T05','12');
insert into occurs values ('co12004.T05','13');
insert into occurs values ('co12004.T06','01');
insert into occurs values ('co12004.T06','02');
insert into occurs values ('co12004.T06','03');
insert into occurs values ('co12004.T06','04');
insert into occurs values ('co12004.T06','05');
insert into occurs values ('co12004.T06','06');
insert into occurs values ('co12004.T06','07');
insert into occurs values ('co12004.T06','08');
insert into occurs values ('co12004.T06','10');
insert into occurs values ('co12004.T06','11');
insert into occurs values ('co12004.T06','12');
insert into occurs values ('co12004.T06','13');
insert into occurs values ('co12005.L01','01');
insert into occurs values ('co12005.L01','02');
insert into occurs values ('co12005.L01','03');
insert into occurs values ('co12005.L01','04');
insert into occurs values ('co12005.L01','05');
insert into occurs values ('co12005.L01','06');
insert into occurs values ('co12005.L01','07');
insert into occurs values ('co12005.L01','08');
insert into occurs values ('co12005.L01','10');
insert into occurs values ('co12005.L01','11');
insert into occurs values ('co12005.L01','12');
insert into occurs values ('co12005.L01','13');
insert into occurs values ('co12005.L02','01');
insert into occurs values ('co12005.L02','02');
insert into occurs values ('co12005.L02','03');
insert into occurs values ('co12005.L02','04');
insert into occurs values ('co12005.L02','05');
insert into occurs values ('co12005.L02','06');
insert into occurs values ('co12005.L02','07');
insert into occurs values ('co12005.L02','08');
insert into occurs values ('co12005.L02','10');
insert into occurs values ('co12005.L02','11');
insert into occurs values ('co12005.L02','12');
insert into occurs values ('co12005.L02','13');
insert into occurs values ('co12005.T01','01');
insert into occurs values ('co12005.T01','02');
insert into occurs values ('co12005.T01','03');
insert into occurs values ('co12005.T01','04');
--- taboccurs, 851, 50
insert into occurs values ('co12005.T01','05');
insert into occurs values ('co12005.T01','06');
insert into occurs values ('co12005.T01','07');
insert into occurs values ('co12005.T01','08');
insert into occurs values ('co12005.T01','10');
insert into occurs values ('co12005.T01','11');
insert into occurs values ('co12005.T01','12');
insert into occurs values ('co12005.T01','13');
insert into occurs values ('co12005.T02','01');
insert into occurs values ('co12005.T02','02');
insert into occurs values ('co12005.T02','03');
insert into occurs values ('co12005.T02','04');
insert into occurs values ('co12005.T02','05');
insert into occurs values ('co12005.T02','06');
insert into occurs values ('co12005.T02','07');
insert into occurs values ('co12005.T02','08');
insert into occurs values ('co12005.T02','10');
insert into occurs values ('co12005.T02','11');
insert into occurs values ('co12005.T02','12');
insert into occurs values ('co12005.T02','13');
insert into occurs values ('co12005.T03','01');
insert into occurs values ('co12005.T03','02');
insert into occurs values ('co12005.T03','03');
insert into occurs values ('co12005.T03','04');
insert into occurs values ('co12005.T03','05');
insert into occurs values ('co12005.T03','06');
insert into occurs values ('co12005.T03','07');
insert into occurs values ('co12005.T03','08');
insert into occurs values ('co12005.T03','10');
insert into occurs values ('co12005.T03','11');
insert into occurs values ('co12005.T03','12');
insert into occurs values ('co12005.T03','13');
insert into occurs values ('co12005.T04','01');
insert into occurs values ('co12005.T04','02');
insert into occurs values ('co12005.T04','03');
insert into occurs values ('co12005.T04','04');
insert into occurs values ('co12005.T04','05');
insert into occurs values ('co12005.T04','06');
insert into occurs values ('co12005.T04','07');
insert into occurs values ('co12005.T04','08');
insert into occurs values ('co12005.T04','10');
insert into occurs values ('co12005.T04','11');
insert into occurs values ('co12005.T04','12');
insert into occurs values ('co12005.T04','13');
insert into occurs values ('co12005.T05','01');
insert into occurs values ('co12005.T05','02');
insert into occurs values ('co12005.T05','03');
insert into occurs values ('co12005.T05','04');
insert into occurs values ('co12005.T05','05');
insert into occurs values ('co12005.T05','06');
--- taboccurs, 901, 50
insert into occurs values ('co12005.T05','07');
insert into occurs values ('co12005.T05','08');
insert into occurs values ('co12005.T05','10');
insert into occurs values ('co12005.T05','11');
insert into occurs values ('co12005.T05','12');
insert into occurs values ('co12005.T05','13');
insert into occurs values ('co12006.L01','01');
insert into occurs values ('co12006.L01','02');
insert into occurs values ('co12006.L01','03');
insert into occurs values ('co12006.L01','04');
insert into occurs values ('co12006.L01','05');
insert into occurs values ('co12006.L01','06');
insert into occurs values ('co12006.L01','07');
insert into occurs values ('co12006.L01','08');
insert into occurs values ('co12006.L01','10');
insert into occurs values ('co12006.L01','11');
insert into occurs values ('co12006.L01','12');
insert into occurs values ('co12006.L01','13');
insert into occurs values ('co12006.L02','01');
insert into occurs values ('co12006.L02','02');
insert into occurs values ('co12006.L02','03');
insert into occurs values ('co12006.L02','04');
insert into occurs values ('co12006.L02','05');
insert into occurs values ('co12006.L02','06');
insert into occurs values ('co12006.L02','07');
insert into occurs values ('co12006.L02','08');
insert into occurs values ('co12006.L02','10');
insert into occurs values ('co12006.L02','11');
insert into occurs values ('co12006.L02','12');
insert into occurs values ('co12006.L02','13');
insert into occurs values ('co12006.L03','01');
insert into occurs values ('co12006.L03','02');
insert into occurs values ('co12006.L03','03');
insert into occurs values ('co12006.L03','04');
insert into occurs values ('co12006.L03','05');
insert into occurs values ('co12006.L03','06');
insert into occurs values ('co12006.L03','07');
insert into occurs values ('co12006.L03','08');
insert into occurs values ('co12006.L03','10');
insert into occurs values ('co12006.L03','11');
insert into occurs values ('co12006.L03','12');
insert into occurs values ('co12006.L03','13');
insert into occurs values ('co12006.T01','01');
insert into occurs values ('co12006.T01','02');
insert into occurs values ('co12006.T01','03');
insert into occurs values ('co12006.T01','04');
insert into occurs values ('co12006.T01','05');
insert into occurs values ('co12006.T01','06');
insert into occurs values ('co12006.T01','07');
insert into occurs values ('co12006.T01','08');
--- taboccurs, 951, 50
insert into occurs values ('co12006.T01','10');
insert into occurs values ('co12006.T01','11');
insert into occurs values ('co12006.T01','12');
insert into occurs values ('co12006.T01','13');
insert into occurs values ('co12006.T02','01');
insert into occurs values ('co12006.T02','02');
insert into occurs values ('co12006.T02','03');
insert into occurs values ('co12006.T02','04');
insert into occurs values ('co12006.T02','05');
insert into occurs values ('co12006.T02','06');
insert into occurs values ('co12006.T02','07');
insert into occurs values ('co12006.T02','08');
insert into occurs values ('co12006.T02','10');
insert into occurs values ('co12006.T02','11');
insert into occurs values ('co12006.T02','12');
insert into occurs values ('co12006.T02','13');
insert into occurs values ('co12006.T03','01');
insert into occurs values ('co12006.T03','02');
insert into occurs values ('co12006.T03','03');
insert into occurs values ('co12006.T03','04');
insert into occurs values ('co12006.T03','05');
insert into occurs values ('co12006.T03','06');
insert into occurs values ('co12006.T03','07');
insert into occurs values ('co12006.T03','08');
insert into occurs values ('co12006.T03','10');
insert into occurs values ('co12006.T03','11');
insert into occurs values ('co12006.T03','12');
insert into occurs values ('co12006.T03','13');
insert into occurs values ('co12006.T04','01');
insert into occurs values ('co12006.T04','02');
insert into occurs values ('co12006.T04','03');
insert into occurs values ('co12006.T04','04');
insert into occurs values ('co12006.T04','05');
insert into occurs values ('co12006.T04','06');
insert into occurs values ('co12006.T04','07');
insert into occurs values ('co12006.T04','08');
insert into occurs values ('co12006.T04','10');
insert into occurs values ('co12006.T04','11');
insert into occurs values ('co12006.T04','12');
insert into occurs values ('co12006.T04','13');
insert into occurs values ('co12006.T05','01');
insert into occurs values ('co12006.T05','02');
insert into occurs values ('co12006.T05','03');
insert into occurs values ('co12006.T05','04');
insert into occurs values ('co12006.T05','05');
insert into occurs values ('co12006.T05','06');
insert into occurs values ('co12006.T05','07');
insert into occurs values ('co12006.T05','08');
insert into occurs values ('co12006.T05','10');
insert into occurs values ('co12006.T05','11');
--- taboccurs, 1001, 50
insert into occurs values ('co12006.T05','12');
insert into occurs values ('co12006.T05','13');
insert into occurs values ('co12006.T06','01');
insert into occurs values ('co12006.T06','02');
insert into occurs values ('co12006.T06','03');
insert into occurs values ('co12006.T06','04');
insert into occurs values ('co12006.T06','05');
insert into occurs values ('co12006.T06','06');
insert into occurs values ('co12006.T06','07');
insert into occurs values ('co12006.T06','08');
insert into occurs values ('co12006.T06','10');
insert into occurs values ('co12006.T06','11');
insert into occurs values ('co12006.T06','12');
insert into occurs values ('co12006.T06','13');
insert into occurs values ('co12008.L01','01');
insert into occurs values ('co12008.L01','02');
insert into occurs values ('co12008.L01','03');
insert into occurs values ('co12008.L01','04');
insert into occurs values ('co12008.L01','05');
insert into occurs values ('co12008.L01','06');
insert into occurs values ('co12008.L01','07');
insert into occurs values ('co12008.L01','08');
insert into occurs values ('co12008.L01','10');
insert into occurs values ('co12008.L01','11');
insert into occurs values ('co12008.L01','12');
insert into occurs values ('co12008.L01','13');
insert into occurs values ('co12008.T01','01');
insert into occurs values ('co12008.T01','02');
insert into occurs values ('co12008.T01','03');
insert into occurs values ('co12008.T01','04');
insert into occurs values ('co12008.T01','05');
insert into occurs values ('co12008.T01','06');
insert into occurs values ('co12008.T01','07');
insert into occurs values ('co12008.T01','08');
insert into occurs values ('co12008.T01','10');
insert into occurs values ('co12008.T01','11');
insert into occurs values ('co12008.T01','12');
insert into occurs values ('co12008.T01','13');
insert into occurs values ('co12008.T02','01');
insert into occurs values ('co12008.T02','02');
insert into occurs values ('co12008.T02','03');
insert into occurs values ('co12008.T02','04');
insert into occurs values ('co12008.T02','05');
insert into occurs values ('co12008.T02','06');
insert into occurs values ('co12008.T02','07');
insert into occurs values ('co12008.T02','08');
insert into occurs values ('co12008.T02','10');
insert into occurs values ('co12008.T02','11');
insert into occurs values ('co12008.T02','12');
insert into occurs values ('co12008.T02','13');
--- taboccurs, 1051, 50
insert into occurs values ('co12011.L01','01');
insert into occurs values ('co12011.L01','02');
insert into occurs values ('co12011.L01','03');
insert into occurs values ('co12011.L01','04');
insert into occurs values ('co12011.L01','05');
insert into occurs values ('co12011.L01','06');
insert into occurs values ('co12011.L01','07');
insert into occurs values ('co12011.L01','08');
insert into occurs values ('co12011.L01','10');
insert into occurs values ('co12011.L01','11');
insert into occurs values ('co12011.L01','12');
insert into occurs values ('co12011.L01','13');
insert into occurs values ('co12011.T01','01');
insert into occurs values ('co12011.T01','02');
insert into occurs values ('co12011.T01','03');
insert into occurs values ('co12011.T01','04');
insert into occurs values ('co12011.T01','05');
insert into occurs values ('co12011.T01','06');
insert into occurs values ('co12011.T01','07');
insert into occurs values ('co12011.T01','08');
insert into occurs values ('co12011.T01','10');
insert into occurs values ('co12011.T01','11');
insert into occurs values ('co12011.T01','12');
insert into occurs values ('co12011.T01','13');
insert into occurs values ('co12012.L01','01');
insert into occurs values ('co12012.L01','02');
insert into occurs values ('co12012.L01','03');
insert into occurs values ('co12012.L01','04');
insert into occurs values ('co12012.L01','05');
insert into occurs values ('co12012.L01','06');
insert into occurs values ('co12012.L01','07');
insert into occurs values ('co12012.L01','08');
insert into occurs values ('co12012.L01','10');
insert into occurs values ('co12012.L01','11');
insert into occurs values ('co12012.L01','12');
insert into occurs values ('co12012.L01','13');
insert into occurs values ('co12012.T01','01');
insert into occurs values ('co12012.T01','02');
insert into occurs values ('co12012.T01','03');
insert into occurs values ('co12012.T01','04');
insert into occurs values ('co12012.T01','05');
insert into occurs values ('co12012.T01','06');
insert into occurs values ('co12012.T01','07');
insert into occurs values ('co12012.T01','08');
insert into occurs values ('co12012.T01','10');
insert into occurs values ('co12012.T01','11');
insert into occurs values ('co12012.T01','12');
insert into occurs values ('co12012.T01','13');
insert into occurs values ('co22005.L01','01');
insert into occurs values ('co22005.L01','02');
--- taboccurs, 1101, 50
insert into occurs values ('co22005.L01','03');
insert into occurs values ('co22005.L01','04');
insert into occurs values ('co22005.L01','05');
insert into occurs values ('co22005.L01','06');
insert into occurs values ('co22005.L01','07');
insert into occurs values ('co22005.L01','08');
insert into occurs values ('co22005.L01','10');
insert into occurs values ('co22005.L01','11');
insert into occurs values ('co22005.L01','12');
insert into occurs values ('co22005.L01','13');
insert into occurs values ('co22005.T01','01');
insert into occurs values ('co22005.T01','02');
insert into occurs values ('co22005.T01','03');
insert into occurs values ('co22005.T01','04');
insert into occurs values ('co22005.T01','05');
insert into occurs values ('co22005.T01','06');
insert into occurs values ('co22005.T01','07');
insert into occurs values ('co22005.T01','08');
insert into occurs values ('co22005.T01','10');
insert into occurs values ('co22005.T01','11');
insert into occurs values ('co22005.T01','12');
insert into occurs values ('co22005.T01','13');
insert into occurs values ('co22005.T02','01');
insert into occurs values ('co22005.T02','02');
insert into occurs values ('co22005.T02','03');
insert into occurs values ('co22005.T02','04');
insert into occurs values ('co22005.T02','05');
insert into occurs values ('co22005.T02','06');
insert into occurs values ('co22005.T02','07');
insert into occurs values ('co22005.T02','08');
insert into occurs values ('co22005.T02','10');
insert into occurs values ('co22005.T02','11');
insert into occurs values ('co22005.T02','12');
insert into occurs values ('co22005.T02','13');
insert into occurs values ('co22005.T03','01');
insert into occurs values ('co22005.T03','02');
insert into occurs values ('co22005.T03','03');
insert into occurs values ('co22005.T03','04');
insert into occurs values ('co22005.T03','05');
insert into occurs values ('co22005.T03','06');
insert into occurs values ('co22005.T03','07');
insert into occurs values ('co22005.T03','08');
insert into occurs values ('co22005.T03','10');
insert into occurs values ('co22005.T03','11');
insert into occurs values ('co22005.T03','12');
insert into occurs values ('co22005.T03','13');
insert into occurs values ('co22005.T04','01');
insert into occurs values ('co22005.T04','02');
insert into occurs values ('co22005.T04','03');
insert into occurs values ('co22005.T04','04');
--- taboccurs, 1151, 50
insert into occurs values ('co22005.T04','05');
insert into occurs values ('co22005.T04','06');
insert into occurs values ('co22005.T04','07');
insert into occurs values ('co22005.T04','08');
insert into occurs values ('co22005.T04','10');
insert into occurs values ('co22005.T04','11');
insert into occurs values ('co22005.T04','12');
insert into occurs values ('co22005.T04','13');
insert into occurs values ('co22005.T05','01');
insert into occurs values ('co22005.T05','02');
insert into occurs values ('co22005.T05','03');
insert into occurs values ('co22005.T05','04');
insert into occurs values ('co22005.T05','05');
insert into occurs values ('co22005.T05','06');
insert into occurs values ('co22005.T05','07');
insert into occurs values ('co22005.T05','08');
insert into occurs values ('co22005.T05','10');
insert into occurs values ('co22005.T05','11');
insert into occurs values ('co22005.T05','12');
insert into occurs values ('co22005.T05','13');
insert into occurs values ('co22005.T06','01');
insert into occurs values ('co22005.T06','02');
insert into occurs values ('co22005.T06','03');
insert into occurs values ('co22005.T06','04');
insert into occurs values ('co22005.T06','05');
insert into occurs values ('co22005.T06','06');
insert into occurs values ('co22005.T06','07');
insert into occurs values ('co22005.T06','08');
insert into occurs values ('co22005.T06','10');
insert into occurs values ('co22005.T06','11');
insert into occurs values ('co22005.T06','12');
insert into occurs values ('co22005.T06','13');
insert into occurs values ('co22005.T07','01');
insert into occurs values ('co22005.T07','02');
insert into occurs values ('co22005.T07','03');
insert into occurs values ('co22005.T07','04');
insert into occurs values ('co22005.T07','05');
insert into occurs values ('co22005.T07','06');
insert into occurs values ('co22005.T07','07');
insert into occurs values ('co22005.T07','08');
insert into occurs values ('co22005.T07','10');
insert into occurs values ('co22005.T07','11');
insert into occurs values ('co22005.T07','12');
insert into occurs values ('co22005.T07','13');
insert into occurs values ('co22005.T08','01');
insert into occurs values ('co22005.T08','02');
insert into occurs values ('co22005.T08','03');
insert into occurs values ('co22005.T08','04');
insert into occurs values ('co22005.T08','05');
insert into occurs values ('co22005.T08','06');
--- taboccurs, 1201, 50
insert into occurs values ('co22005.T08','07');
insert into occurs values ('co22005.T08','08');
insert into occurs values ('co22005.T08','10');
insert into occurs values ('co22005.T08','11');
insert into occurs values ('co22005.T08','12');
insert into occurs values ('co22005.T08','13');
insert into occurs values ('co22005.T09','01');
insert into occurs values ('co22005.T09','02');
insert into occurs values ('co22005.T09','03');
insert into occurs values ('co22005.T09','04');
insert into occurs values ('co22005.T09','05');
insert into occurs values ('co22005.T09','06');
insert into occurs values ('co22005.T09','07');
insert into occurs values ('co22005.T09','08');
insert into occurs values ('co22005.T09','10');
insert into occurs values ('co22005.T09','11');
insert into occurs values ('co22005.T09','12');
insert into occurs values ('co22005.T09','13');
insert into occurs values ('co22005.T10','01');
insert into occurs values ('co22005.T10','02');
insert into occurs values ('co22005.T10','03');
insert into occurs values ('co22005.T10','04');
insert into occurs values ('co22005.T10','05');
insert into occurs values ('co22005.T10','06');
insert into occurs values ('co22005.T10','07');
insert into occurs values ('co22005.T10','08');
insert into occurs values ('co22005.T10','10');
insert into occurs values ('co22005.T10','11');
insert into occurs values ('co22005.T10','12');
insert into occurs values ('co22005.T10','13');
insert into occurs values ('co22006.L01','01');
insert into occurs values ('co22006.L01','02');
insert into occurs values ('co22006.L01','03');
insert into occurs values ('co22006.L01','04');
insert into occurs values ('co22006.L01','05');
insert into occurs values ('co22006.L01','06');
insert into occurs values ('co22006.L01','07');
insert into occurs values ('co22006.L01','08');
insert into occurs values ('co22006.L01','10');
insert into occurs values ('co22006.L01','11');
insert into occurs values ('co22006.L01','12');
insert into occurs values ('co22006.L01','13');
insert into occurs values ('co22006.L02','01');
insert into occurs values ('co22006.L02','02');
insert into occurs values ('co22006.L02','03');
insert into occurs values ('co22006.L02','04');
insert into occurs values ('co22006.L02','05');
insert into occurs values ('co22006.L02','06');
insert into occurs values ('co22006.L02','07');
insert into occurs values ('co22006.L02','08');
--- taboccurs, 1251, 50
insert into occurs values ('co22006.L02','10');
insert into occurs values ('co22006.L02','11');
insert into occurs values ('co22006.L02','12');
insert into occurs values ('co22006.L02','13');
insert into occurs values ('co22006.L03','01');
insert into occurs values ('co22006.L03','02');
insert into occurs values ('co22006.L03','03');
insert into occurs values ('co22006.L03','04');
insert into occurs values ('co22006.L03','05');
insert into occurs values ('co22006.L03','06');
insert into occurs values ('co22006.L03','07');
insert into occurs values ('co22006.L03','08');
insert into occurs values ('co22006.L03','10');
insert into occurs values ('co22006.L03','11');
insert into occurs values ('co22006.L03','12');
insert into occurs values ('co22006.L03','13');
insert into occurs values ('co22006.T01','01');
insert into occurs values ('co22006.T01','02');
insert into occurs values ('co22006.T01','03');
insert into occurs values ('co22006.T01','04');
insert into occurs values ('co22006.T01','05');
insert into occurs values ('co22006.T01','06');
insert into occurs values ('co22006.T01','07');
insert into occurs values ('co22006.T01','08');
insert into occurs values ('co22006.T01','10');
insert into occurs values ('co22006.T01','11');
insert into occurs values ('co22006.T01','12');
insert into occurs values ('co22006.T01','13');
insert into occurs values ('co22006.T02','01');
insert into occurs values ('co22006.T02','02');
insert into occurs values ('co22006.T02','03');
insert into occurs values ('co22006.T02','04');
insert into occurs values ('co22006.T02','05');
insert into occurs values ('co22006.T02','06');
insert into occurs values ('co22006.T02','07');
insert into occurs values ('co22006.T02','08');
insert into occurs values ('co22006.T02','10');
insert into occurs values ('co22006.T02','11');
insert into occurs values ('co22006.T02','12');
insert into occurs values ('co22006.T02','13');
insert into occurs values ('co22006.T03','01');
insert into occurs values ('co22006.T03','02');
insert into occurs values ('co22006.T03','03');
insert into occurs values ('co22006.T03','04');
insert into occurs values ('co22006.T03','05');
insert into occurs values ('co22006.T03','06');
insert into occurs values ('co22006.T03','07');
insert into occurs values ('co22006.T03','08');
insert into occurs values ('co22006.T03','10');
insert into occurs values ('co22006.T03','11');
--- taboccurs, 1301, 50
insert into occurs values ('co22006.T03','12');
insert into occurs values ('co22006.T03','13');
insert into occurs values ('co22006.T04','01');
insert into occurs values ('co22006.T04','02');
insert into occurs values ('co22006.T04','03');
insert into occurs values ('co22006.T04','04');
insert into occurs values ('co22006.T04','05');
insert into occurs values ('co22006.T04','06');
insert into occurs values ('co22006.T04','07');
insert into occurs values ('co22006.T04','08');
insert into occurs values ('co22006.T04','10');
insert into occurs values ('co22006.T04','11');
insert into occurs values ('co22006.T04','12');
insert into occurs values ('co22006.T04','13');
insert into occurs values ('co22007.L01','01');
insert into occurs values ('co22007.L01','02');
insert into occurs values ('co22007.L01','03');
insert into occurs values ('co22007.L01','04');
insert into occurs values ('co22007.L01','05');
insert into occurs values ('co22007.L01','06');
insert into occurs values ('co22007.L01','07');
insert into occurs values ('co22007.L01','08');
insert into occurs values ('co22007.L01','10');
insert into occurs values ('co22007.L01','11');
insert into occurs values ('co22007.L01','12');
insert into occurs values ('co22007.L01','13');
insert into occurs values ('co22007.T01','01');
insert into occurs values ('co22007.T01','02');
insert into occurs values ('co22007.T01','03');
insert into occurs values ('co22007.T01','04');
insert into occurs values ('co22007.T01','05');
insert into occurs values ('co22007.T01','06');
insert into occurs values ('co22007.T01','07');
insert into occurs values ('co22007.T01','08');
insert into occurs values ('co22007.T01','10');
insert into occurs values ('co22007.T01','11');
insert into occurs values ('co22007.T01','12');
insert into occurs values ('co22007.T01','13');
insert into occurs values ('co22007.T02','01');
insert into occurs values ('co22007.T02','02');
insert into occurs values ('co22007.T02','03');
insert into occurs values ('co22007.T02','04');
insert into occurs values ('co22007.T02','05');
insert into occurs values ('co22007.T02','06');
insert into occurs values ('co22007.T02','07');
insert into occurs values ('co22007.T02','08');
insert into occurs values ('co22007.T02','10');
insert into occurs values ('co22007.T02','11');
insert into occurs values ('co22007.T02','12');
insert into occurs values ('co22007.T02','13');
--- taboccurs, 1351, 50
insert into occurs values ('co22007.T03','01');
insert into occurs values ('co22007.T03','02');
insert into occurs values ('co22007.T03','03');
insert into occurs values ('co22007.T03','04');
insert into occurs values ('co22007.T03','05');
insert into occurs values ('co22007.T03','06');
insert into occurs values ('co22007.T03','07');
insert into occurs values ('co22007.T03','08');
insert into occurs values ('co22007.T03','10');
insert into occurs values ('co22007.T03','11');
insert into occurs values ('co22007.T03','12');
insert into occurs values ('co22007.T03','13');
insert into occurs values ('co22007.T04','01');
insert into occurs values ('co22007.T04','02');
insert into occurs values ('co22007.T04','03');
insert into occurs values ('co22007.T04','04');
insert into occurs values ('co22007.T04','05');
insert into occurs values ('co22007.T04','06');
insert into occurs values ('co22007.T04','07');
insert into occurs values ('co22007.T04','08');
insert into occurs values ('co22007.T04','10');
insert into occurs values ('co22007.T04','11');
insert into occurs values ('co22007.T04','12');
insert into occurs values ('co22007.T04','13');
insert into occurs values ('co22007.T05','01');
insert into occurs values ('co22007.T05','02');
insert into occurs values ('co22007.T05','03');
insert into occurs values ('co22007.T05','04');
insert into occurs values ('co22007.T05','05');
insert into occurs values ('co22007.T05','06');
insert into occurs values ('co22007.T05','07');
insert into occurs values ('co22007.T05','08');
insert into occurs values ('co22007.T05','10');
insert into occurs values ('co22007.T05','11');
insert into occurs values ('co22007.T05','12');
insert into occurs values ('co22007.T05','13');
insert into occurs values ('co22007.T06','01');
insert into occurs values ('co22007.T06','02');
insert into occurs values ('co22007.T06','03');
insert into occurs values ('co22007.T06','04');
insert into occurs values ('co22007.T06','05');
insert into occurs values ('co22007.T06','06');
insert into occurs values ('co22007.T06','07');
insert into occurs values ('co22007.T06','08');
insert into occurs values ('co22007.T06','10');
insert into occurs values ('co22007.T06','11');
insert into occurs values ('co22007.T06','12');
insert into occurs values ('co22007.T06','13');
insert into occurs values ('co22008.L01','01');
insert into occurs values ('co22008.L01','02');
--- taboccurs, 1401, 50
insert into occurs values ('co22008.L01','03');
insert into occurs values ('co22008.L01','04');
insert into occurs values ('co22008.L01','05');
insert into occurs values ('co22008.L01','06');
insert into occurs values ('co22008.L01','07');
insert into occurs values ('co22008.L01','08');
insert into occurs values ('co22008.L01','10');
insert into occurs values ('co22008.L01','11');
insert into occurs values ('co22008.L01','12');
insert into occurs values ('co22008.L01','13');
insert into occurs values ('co22008.L02','01');
insert into occurs values ('co22008.L02','02');
insert into occurs values ('co22008.L02','03');
insert into occurs values ('co22008.L02','04');
insert into occurs values ('co22008.L02','05');
insert into occurs values ('co22008.L02','06');
insert into occurs values ('co22008.L02','07');
insert into occurs values ('co22008.L02','08');
insert into occurs values ('co22008.L02','10');
insert into occurs values ('co22008.L02','11');
insert into occurs values ('co22008.L02','12');
insert into occurs values ('co22008.L02','13');
insert into occurs values ('co22008.T01','01');
insert into occurs values ('co22008.T01','02');
insert into occurs values ('co22008.T01','03');
insert into occurs values ('co22008.T01','04');
insert into occurs values ('co22008.T01','05');
insert into occurs values ('co22008.T01','06');
insert into occurs values ('co22008.T01','07');
insert into occurs values ('co22008.T01','08');
insert into occurs values ('co22008.T01','10');
insert into occurs values ('co22008.T01','11');
insert into occurs values ('co22008.T01','12');
insert into occurs values ('co22008.T01','13');
insert into occurs values ('co22008.T02','01');
insert into occurs values ('co22008.T02','02');
insert into occurs values ('co22008.T02','03');
insert into occurs values ('co22008.T02','04');
insert into occurs values ('co22008.T02','05');
insert into occurs values ('co22008.T02','06');
insert into occurs values ('co22008.T02','07');
insert into occurs values ('co22008.T02','08');
insert into occurs values ('co22008.T02','10');
insert into occurs values ('co22008.T02','11');
insert into occurs values ('co22008.T02','12');
insert into occurs values ('co22008.T02','13');
insert into occurs values ('co22008.T03','01');
insert into occurs values ('co22008.T03','02');
insert into occurs values ('co22008.T03','03');
insert into occurs values ('co22008.T03','04');
--- taboccurs, 1451, 50
insert into occurs values ('co22008.T03','05');
insert into occurs values ('co22008.T03','06');
insert into occurs values ('co22008.T03','07');
insert into occurs values ('co22008.T03','08');
insert into occurs values ('co22008.T03','10');
insert into occurs values ('co22008.T03','11');
insert into occurs values ('co22008.T03','12');
insert into occurs values ('co22008.T03','13');
insert into occurs values ('co22008.T04','01');
insert into occurs values ('co22008.T04','02');
insert into occurs values ('co22008.T04','03');
insert into occurs values ('co22008.T04','04');
insert into occurs values ('co22008.T04','05');
insert into occurs values ('co22008.T04','06');
insert into occurs values ('co22008.T04','07');
insert into occurs values ('co22008.T04','08');
insert into occurs values ('co22008.T04','10');
insert into occurs values ('co22008.T04','11');
insert into occurs values ('co22008.T04','12');
insert into occurs values ('co22008.T04','13');
insert into occurs values ('co22008.T05','01');
insert into occurs values ('co22008.T05','02');
insert into occurs values ('co22008.T05','03');
insert into occurs values ('co22008.T05','04');
insert into occurs values ('co22008.T05','05');
insert into occurs values ('co22008.T05','06');
insert into occurs values ('co22008.T05','07');
insert into occurs values ('co22008.T05','08');
insert into occurs values ('co22008.T05','10');
insert into occurs values ('co22008.T05','11');
insert into occurs values ('co22008.T05','12');
insert into occurs values ('co22008.T05','13');
insert into occurs values ('co22009.L01','01');
insert into occurs values ('co22009.L01','02');
insert into occurs values ('co22009.L01','03');
insert into occurs values ('co22009.L01','04');
insert into occurs values ('co22009.L01','05');
insert into occurs values ('co22009.L01','06');
insert into occurs values ('co22009.L01','07');
insert into occurs values ('co22009.L01','08');
insert into occurs values ('co22009.L01','10');
insert into occurs values ('co22009.L01','11');
insert into occurs values ('co22009.L01','12');
insert into occurs values ('co22009.L01','13');
insert into occurs values ('co22009.T01','01');
insert into occurs values ('co22009.T01','02');
insert into occurs values ('co22009.T01','03');
insert into occurs values ('co22009.T01','04');
insert into occurs values ('co22009.T01','05');
insert into occurs values ('co22009.T01','06');
--- taboccurs, 1501, 50
insert into occurs values ('co22009.T01','07');
insert into occurs values ('co22009.T01','08');
insert into occurs values ('co22009.T01','10');
insert into occurs values ('co22009.T01','11');
insert into occurs values ('co22009.T01','12');
insert into occurs values ('co22009.T01','13');
insert into occurs values ('co22009.T02','01');
insert into occurs values ('co22009.T02','02');
insert into occurs values ('co22009.T02','03');
insert into occurs values ('co22009.T02','04');
insert into occurs values ('co22009.T02','05');
insert into occurs values ('co22009.T02','06');
insert into occurs values ('co22009.T02','07');
insert into occurs values ('co22009.T02','08');
insert into occurs values ('co22009.T02','10');
insert into occurs values ('co22009.T02','11');
insert into occurs values ('co22009.T02','12');
insert into occurs values ('co22009.T02','13');
insert into occurs values ('co22020.L01','01');
insert into occurs values ('co22020.L01','02');
insert into occurs values ('co22020.L01','03');
insert into occurs values ('co22020.L01','04');
insert into occurs values ('co22020.L01','05');
insert into occurs values ('co22020.L01','06');
insert into occurs values ('co22020.L01','07');
insert into occurs values ('co22020.L01','08');
insert into occurs values ('co22020.L01','10');
insert into occurs values ('co22020.L01','11');
insert into occurs values ('co22020.L01','12');
insert into occurs values ('co22020.L01','13');
insert into occurs values ('co22020.T01','01');
insert into occurs values ('co22020.T01','02');
insert into occurs values ('co22020.T01','03');
insert into occurs values ('co22020.T01','04');
insert into occurs values ('co22020.T01','05');
insert into occurs values ('co22020.T01','06');
insert into occurs values ('co22020.T01','07');
insert into occurs values ('co22020.T01','08');
insert into occurs values ('co22020.T01','10');
insert into occurs values ('co22020.T01','11');
insert into occurs values ('co22020.T01','12');
insert into occurs values ('co22020.T01','13');
insert into occurs values ('co22020.T02','01');
insert into occurs values ('co22020.T02','02');
insert into occurs values ('co22020.T02','03');
insert into occurs values ('co22020.T02','04');
insert into occurs values ('co22020.T02','05');
insert into occurs values ('co22020.T02','06');
insert into occurs values ('co22020.T02','07');
insert into occurs values ('co22020.T02','08');
--- taboccurs, 1551, 50
insert into occurs values ('co22020.T02','10');
insert into occurs values ('co22020.T02','11');
insert into occurs values ('co22020.T02','12');
insert into occurs values ('co22020.T02','13');
insert into occurs values ('co22020.T03','01');
insert into occurs values ('co22020.T03','02');
insert into occurs values ('co22020.T03','03');
insert into occurs values ('co22020.T03','04');
insert into occurs values ('co22020.T03','05');
insert into occurs values ('co22020.T03','06');
insert into occurs values ('co22020.T03','07');
insert into occurs values ('co22020.T03','08');
insert into occurs values ('co22020.T03','10');
insert into occurs values ('co22020.T03','11');
insert into occurs values ('co22020.T03','12');
insert into occurs values ('co22020.T03','13');
insert into occurs values ('co22020.T04','01');
insert into occurs values ('co22020.T04','02');
insert into occurs values ('co22020.T04','03');
insert into occurs values ('co22020.T04','04');
insert into occurs values ('co22020.T04','05');
insert into occurs values ('co22020.T04','06');
insert into occurs values ('co22020.T04','07');
insert into occurs values ('co22020.T04','08');
insert into occurs values ('co22020.T04','10');
insert into occurs values ('co22020.T04','11');
insert into occurs values ('co22020.T04','12');
insert into occurs values ('co22020.T04','13');
insert into occurs values ('co22020.T05','01');
insert into occurs values ('co22020.T05','02');
insert into occurs values ('co22020.T05','03');
insert into occurs values ('co22020.T05','04');
insert into occurs values ('co22020.T05','05');
insert into occurs values ('co22020.T05','06');
insert into occurs values ('co22020.T05','07');
insert into occurs values ('co22020.T05','08');
insert into occurs values ('co22020.T05','10');
insert into occurs values ('co22020.T05','11');
insert into occurs values ('co22020.T05','12');
insert into occurs values ('co22020.T05','13');
insert into occurs values ('co22022.L01','01');
insert into occurs values ('co22022.L01','02');
insert into occurs values ('co22022.L01','03');
insert into occurs values ('co22022.L01','04');
insert into occurs values ('co22022.L01','05');
insert into occurs values ('co22022.L01','06');
insert into occurs values ('co22022.L01','07');
insert into occurs values ('co22022.L01','08');
insert into occurs values ('co22022.L01','10');
insert into occurs values ('co22022.L01','11');
--- taboccurs, 1601, 50
insert into occurs values ('co22022.L01','12');
insert into occurs values ('co22022.L01','13');
insert into occurs values ('co22022.T01','01');
insert into occurs values ('co22022.T01','02');
insert into occurs values ('co22022.T01','03');
insert into occurs values ('co22022.T01','04');
insert into occurs values ('co22022.T01','05');
insert into occurs values ('co22022.T01','06');
insert into occurs values ('co22022.T01','07');
insert into occurs values ('co22022.T01','08');
insert into occurs values ('co22022.T01','10');
insert into occurs values ('co22022.T01','11');
insert into occurs values ('co22022.T01','12');
insert into occurs values ('co22022.T01','13');
insert into occurs values ('co32003.L01','01');
insert into occurs values ('co32003.L01','02');
insert into occurs values ('co32003.L01','03');
insert into occurs values ('co32003.L01','04');
insert into occurs values ('co32003.L01','05');
insert into occurs values ('co32003.L01','06');
insert into occurs values ('co32003.L01','07');
insert into occurs values ('co32003.L01','08');
insert into occurs values ('co32003.L01','10');
insert into occurs values ('co32003.L01','11');
insert into occurs values ('co32003.L01','12');
insert into occurs values ('co32003.L01','13');
insert into occurs values ('co32003.T01','01');
insert into occurs values ('co32003.T01','02');
insert into occurs values ('co32003.T01','03');
insert into occurs values ('co32003.T01','04');
insert into occurs values ('co32003.T01','05');
insert into occurs values ('co32003.T01','06');
insert into occurs values ('co32003.T01','07');
insert into occurs values ('co32003.T01','08');
insert into occurs values ('co32003.T01','10');
insert into occurs values ('co32003.T01','11');
insert into occurs values ('co32003.T01','12');
insert into occurs values ('co32003.T01','13');
insert into occurs values ('co32005.L01','01');
insert into occurs values ('co32005.L01','02');
insert into occurs values ('co32005.L01','03');
insert into occurs values ('co32005.L01','04');
insert into occurs values ('co32005.L01','05');
insert into occurs values ('co32005.L01','06');
insert into occurs values ('co32005.L01','07');
insert into occurs values ('co32005.L01','08');
insert into occurs values ('co32005.L01','10');
insert into occurs values ('co32005.L01','11');
insert into occurs values ('co32005.L01','12');
insert into occurs values ('co32005.L01','13');
--- taboccurs, 1651, 50
insert into occurs values ('co32005.T04','01');
insert into occurs values ('co32005.T04','02');
insert into occurs values ('co32005.T04','03');
insert into occurs values ('co32005.T04','04');
insert into occurs values ('co32005.T04','05');
insert into occurs values ('co32005.T04','06');
insert into occurs values ('co32005.T04','07');
insert into occurs values ('co32005.T04','08');
insert into occurs values ('co32005.T04','10');
insert into occurs values ('co32005.T04','11');
insert into occurs values ('co32005.T04','12');
insert into occurs values ('co32005.T04','13');
insert into occurs values ('co32005.T05','01');
insert into occurs values ('co32005.T05','02');
insert into occurs values ('co32005.T05','03');
insert into occurs values ('co32005.T05','04');
insert into occurs values ('co32005.T05','05');
insert into occurs values ('co32005.T05','06');
insert into occurs values ('co32005.T05','07');
insert into occurs values ('co32005.T05','08');
insert into occurs values ('co32005.T05','10');
insert into occurs values ('co32005.T05','11');
insert into occurs values ('co32005.T05','12');
insert into occurs values ('co32005.T05','13');
insert into occurs values ('co32011.L01','01');
insert into occurs values ('co32011.L01','02');
insert into occurs values ('co32011.L01','03');
insert into occurs values ('co32011.L01','04');
insert into occurs values ('co32011.L01','05');
insert into occurs values ('co32011.L01','06');
insert into occurs values ('co32011.L01','07');
insert into occurs values ('co32011.L01','08');
insert into occurs values ('co32011.L01','10');
insert into occurs values ('co32011.L01','11');
insert into occurs values ('co32011.L01','12');
insert into occurs values ('co32011.L01','13');
insert into occurs values ('co32011.L02','01');
insert into occurs values ('co32011.L02','02');
insert into occurs values ('co32011.L02','03');
insert into occurs values ('co32011.L02','04');
insert into occurs values ('co32011.L02','05');
insert into occurs values ('co32011.L02','06');
insert into occurs values ('co32011.L02','07');
insert into occurs values ('co32011.L02','08');
insert into occurs values ('co32011.L02','10');
insert into occurs values ('co32011.L02','11');
insert into occurs values ('co32011.L02','12');
insert into occurs values ('co32011.L02','13');
insert into occurs values ('co32011.T01','01');
insert into occurs values ('co32011.T01','02');
--- taboccurs, 1701, 50
insert into occurs values ('co32011.T01','03');
insert into occurs values ('co32011.T01','04');
insert into occurs values ('co32011.T01','05');
insert into occurs values ('co32011.T01','06');
insert into occurs values ('co32011.T01','07');
insert into occurs values ('co32011.T01','08');
insert into occurs values ('co32011.T01','10');
insert into occurs values ('co32011.T01','11');
insert into occurs values ('co32011.T01','12');
insert into occurs values ('co32011.T01','13');
insert into occurs values ('co32011.T02','01');
insert into occurs values ('co32011.T02','02');
insert into occurs values ('co32011.T02','03');
insert into occurs values ('co32011.T02','04');
insert into occurs values ('co32011.T02','05');
insert into occurs values ('co32011.T02','06');
insert into occurs values ('co32011.T02','07');
insert into occurs values ('co32011.T02','08');
insert into occurs values ('co32011.T02','10');
insert into occurs values ('co32011.T02','11');
insert into occurs values ('co32011.T02','12');
insert into occurs values ('co32011.T02','13');
insert into occurs values ('co32011.T03','01');
insert into occurs values ('co32011.T03','02');
insert into occurs values ('co32011.T03','03');
insert into occurs values ('co32011.T03','04');
insert into occurs values ('co32011.T03','05');
insert into occurs values ('co32011.T03','06');
insert into occurs values ('co32011.T03','07');
insert into occurs values ('co32011.T03','08');
insert into occurs values ('co32011.T03','10');
insert into occurs values ('co32011.T03','11');
insert into occurs values ('co32011.T03','12');
insert into occurs values ('co32011.T03','13');
insert into occurs values ('co32014.L01','01');
insert into occurs values ('co32014.L01','02');
insert into occurs values ('co32014.L01','03');
insert into occurs values ('co32014.L01','04');
insert into occurs values ('co32014.L01','05');
insert into occurs values ('co32014.L01','06');
insert into occurs values ('co32014.L01','07');
insert into occurs values ('co32014.L01','08');
insert into occurs values ('co32014.L01','10');
insert into occurs values ('co32014.L01','11');
insert into occurs values ('co32014.L01','12');
insert into occurs values ('co32014.L01','13');
insert into occurs values ('co32014.T01','01');
insert into occurs values ('co32014.T01','02');
insert into occurs values ('co32014.T01','03');
insert into occurs values ('co32014.T01','04');
--- taboccurs, 1751, 50
insert into occurs values ('co32014.T01','05');
insert into occurs values ('co32014.T01','06');
insert into occurs values ('co32014.T01','07');
insert into occurs values ('co32014.T01','08');
insert into occurs values ('co32014.T01','10');
insert into occurs values ('co32014.T01','11');
insert into occurs values ('co32014.T01','12');
insert into occurs values ('co32014.T01','13');
insert into occurs values ('co32014.T02','01');
insert into occurs values ('co32014.T02','02');
insert into occurs values ('co32014.T02','03');
insert into occurs values ('co32014.T02','04');
insert into occurs values ('co32014.T02','05');
insert into occurs values ('co32014.T02','06');
insert into occurs values ('co32014.T02','07');
insert into occurs values ('co32014.T02','08');
insert into occurs values ('co32014.T02','10');
insert into occurs values ('co32014.T02','11');
insert into occurs values ('co32014.T02','12');
insert into occurs values ('co32014.T02','13');
insert into occurs values ('co32014.T03','01');
insert into occurs values ('co32014.T03','02');
insert into occurs values ('co32014.T03','03');
insert into occurs values ('co32014.T03','04');
insert into occurs values ('co32014.T03','05');
insert into occurs values ('co32014.T03','06');
insert into occurs values ('co32014.T03','07');
insert into occurs values ('co32014.T03','08');
insert into occurs values ('co32014.T03','10');
insert into occurs values ('co32014.T03','11');
insert into occurs values ('co32014.T03','12');
insert into occurs values ('co32014.T03','13');
insert into occurs values ('co32015.L01','01');
insert into occurs values ('co32015.L01','02');
insert into occurs values ('co32015.L01','03');
insert into occurs values ('co32015.L01','04');
insert into occurs values ('co32015.L01','05');
insert into occurs values ('co32015.L01','06');
insert into occurs values ('co32015.L01','07');
insert into occurs values ('co32015.L01','08');
insert into occurs values ('co32015.L01','10');
insert into occurs values ('co32015.L01','11');
insert into occurs values ('co32015.L01','12');
insert into occurs values ('co32015.L01','13');
insert into occurs values ('co32015.T01','01');
insert into occurs values ('co32015.T01','02');
insert into occurs values ('co32015.T01','03');
insert into occurs values ('co32015.T01','04');
insert into occurs values ('co32015.T01','05');
insert into occurs values ('co32015.T01','06');
--- taboccurs, 1801, 50
insert into occurs values ('co32015.T01','07');
insert into occurs values ('co32015.T01','08');
insert into occurs values ('co32015.T01','10');
insert into occurs values ('co32015.T01','11');
insert into occurs values ('co32015.T01','12');
insert into occurs values ('co32015.T01','13');
insert into occurs values ('co32016.L01','01');
insert into occurs values ('co32016.L01','02');
insert into occurs values ('co32016.L01','03');
insert into occurs values ('co32016.L01','04');
insert into occurs values ('co32016.L01','05');
insert into occurs values ('co32016.L01','06');
insert into occurs values ('co32016.L01','07');
insert into occurs values ('co32016.L01','08');
insert into occurs values ('co32016.L01','10');
insert into occurs values ('co72023.T03','10');
insert into occurs values ('co72023.T03','11');
insert into occurs values ('co72023.T03','12');
insert into occurs values ('co72023.T03','13');
insert into occurs values ('co72023.T04','01');
insert into occurs values ('co72023.T04','02');
insert into occurs values ('co72023.T04','03');
insert into occurs values ('co72023.T04','04');
insert into occurs values ('co72023.T04','05');
insert into occurs values ('co72023.T04','06');
insert into occurs values ('co72023.T04','07');
insert into occurs values ('co72023.T04','08');
insert into occurs values ('co72023.T04','10');
insert into occurs values ('co72023.T04','11');
insert into occurs values ('co72023.T04','12');
insert into occurs values ('co72023.T04','13');
insert into occurs values ('co72023.T05','01');
insert into occurs values ('co72023.T05','02');
insert into occurs values ('co72023.T05','03');
insert into occurs values ('co72023.T05','04');
insert into occurs values ('co72023.T05','05');
insert into occurs values ('co72023.T05','06');
insert into occurs values ('co72023.T05','07');
insert into occurs values ('co72023.T05','08');
insert into occurs values ('co72023.T05','10');
insert into occurs values ('co72023.T05','11');
insert into occurs values ('co72023.T05','12');
insert into occurs values ('co72023.T05','13');
insert into occurs values ('co72023.T06','01');
insert into occurs values ('co72023.T06','02');
insert into occurs values ('co72023.T06','03');
insert into occurs values ('co72023.T06','04');
insert into occurs values ('co72023.T06','05');
insert into occurs values ('co72023.T06','06');
insert into occurs values ('co72023.T06','07');
--- taboccurs, 1851, 50
insert into occurs values ('co72023.T06','08');
insert into occurs values ('co72023.T06','10');
insert into occurs values ('co72023.T06','11');
insert into occurs values ('co72023.T06','12');
insert into occurs values ('co72023.T06','13');
insert into occurs values ('co72026.L01','01');
insert into occurs values ('co72026.L01','02');
insert into occurs values ('co72026.L01','03');
insert into occurs values ('co72026.L01','04');
insert into occurs values ('co72026.L01','05');
insert into occurs values ('co72026.L01','06');
insert into occurs values ('co72026.L01','07');
insert into occurs values ('co72026.L01','08');
insert into occurs values ('co72026.L01','10');
insert into occurs values ('co72026.L01','11');
insert into occurs values ('co72026.L01','12');
insert into occurs values ('co72026.L01','13');
insert into occurs values ('co72026.L02','01');
insert into occurs values ('co72026.L02','02');
insert into occurs values ('co72026.L02','03');
insert into occurs values ('co72026.L02','04');
insert into occurs values ('co72026.L02','05');
insert into occurs values ('co72026.L02','06');
insert into occurs values ('co72026.L02','07');
insert into occurs values ('co72026.L02','08');
insert into occurs values ('co72026.L02','10');
insert into occurs values ('co72026.L02','11');
insert into occurs values ('co72026.L02','12');
insert into occurs values ('co72026.L02','13');
insert into occurs values ('co72026.T01','01');
insert into occurs values ('co72026.T01','02');
insert into occurs values ('co72026.T01','03');
insert into occurs values ('co72026.T01','04');
insert into occurs values ('co72026.T01','05');
insert into occurs values ('co72026.T01','06');
insert into occurs values ('co72026.T01','07');
insert into occurs values ('co72026.T01','08');
insert into occurs values ('co72026.T01','10');
insert into occurs values ('co72026.T01','11');
insert into occurs values ('co72026.T01','12');
insert into occurs values ('co72026.T01','13');
insert into occurs values ('co72026.T02','01');
insert into occurs values ('co72026.T02','02');
insert into occurs values ('co72026.T02','03');
insert into occurs values ('co72026.T02','04');
insert into occurs values ('co72026.T02','05');
insert into occurs values ('co72026.T02','06');
insert into occurs values ('co72026.T02','07');
insert into occurs values ('co72026.T02','08');
insert into occurs values ('co72026.T02','10');
--- taboccurs, 1901, 50
insert into occurs values ('co72026.T02','11');
insert into occurs values ('co72026.T02','12');
insert into occurs values ('co72026.T02','13');
insert into occurs values ('co72033.L01','01');
insert into occurs values ('co72033.L01','02');
insert into occurs values ('co72033.L01','03');
insert into occurs values ('co72033.L01','04');
insert into occurs values ('co72033.L01','05');
insert into occurs values ('co72033.L01','06');
insert into occurs values ('co72033.L01','07');
insert into occurs values ('co72033.L01','08');
insert into occurs values ('co72033.L01','10');
insert into occurs values ('co72033.L01','11');
insert into occurs values ('co72033.L01','12');
insert into occurs values ('co72033.L01','13');
insert into occurs values ('co72033.T01','01');
insert into occurs values ('co72033.T01','02');
insert into occurs values ('co72033.T01','03');
insert into occurs values ('co72033.T01','04');
insert into occurs values ('co72033.T01','05');
insert into occurs values ('co72033.T01','06');
insert into occurs values ('co72033.T01','07');
insert into occurs values ('co72033.T01','08');
insert into occurs values ('co72033.T01','10');
insert into occurs values ('co72033.T01','11');
insert into occurs values ('co72033.T01','12');
insert into occurs values ('co72033.T01','13');
insert into occurs values ('coh2451.L01','01');
insert into occurs values ('coh2451.L01','02');
insert into occurs values ('coh2451.L01','03');
insert into occurs values ('coh2451.L01','04');
insert into occurs values ('coh2451.L01','05');
insert into occurs values ('coh2451.L01','06');
insert into occurs values ('coh2451.L01','07');
insert into occurs values ('coh2451.L01','08');
insert into occurs values ('coh2451.L01','10');
insert into occurs values ('coh2451.L01','11');
insert into occurs values ('coh2451.L01','12');
insert into occurs values ('coh2451.L01','13');
insert into occurs values ('coh2451.T01','01');
insert into occurs values ('coh2451.T01','02');
insert into occurs values ('coh2451.T01','03');
insert into occurs values ('coh2451.T01','04');
insert into occurs values ('coh2451.T01','05');
insert into occurs values ('coh2451.T01','06');
insert into occurs values ('coh2451.T01','07');
insert into occurs values ('coh2451.T01','08');
insert into occurs values ('coh2451.T01','10');
insert into occurs values ('coh2451.T01','11');
insert into occurs values ('coh2451.T01','12');
--- taboccurs, 1951, 50
insert into occurs values ('coh2451.T01','13');
insert into occurs values ('coh6412255.L01','01');
insert into occurs values ('coh6412255.L01','02');
insert into occurs values ('coh6412255.L01','03');
insert into occurs values ('coh6412255.L01','04');
insert into occurs values ('coh6412255.L01','05');
insert into occurs values ('coh6412255.L01','06');
insert into occurs values ('coh6412255.L01','07');
insert into occurs values ('coh6412255.L01','08');
insert into occurs values ('coh6412255.L01','10');
insert into occurs values ('coh6412255.L01','11');
insert into occurs values ('coh6412255.L01','12');
insert into occurs values ('coh6412255.L01','13');
insert into occurs values ('coh6412255.T01','01');
insert into occurs values ('coh6412255.T01','02');
insert into occurs values ('coh6412255.T01','03');
insert into occurs values ('coh6412255.T01','04');
insert into occurs values ('coh6412255.T01','05');
insert into occurs values ('coh6412255.T01','06');
insert into occurs values ('coh6412255.T01','07');
insert into occurs values ('coh6412255.T01','08');
insert into occurs values ('coh6412255.T01','10');
insert into occurs values ('coh6412255.T01','11');
insert into occurs values ('coh6412255.T01','12');
insert into occurs values ('coh6412255.T01','13');
insert into occurs values ('coh8412555.L01','01');
insert into occurs values ('coh8412555.L01','02');
insert into occurs values ('coh8412555.L01','03');
insert into occurs values ('coh8412555.L01','04');
insert into occurs values ('coh8412555.L01','05');
insert into occurs values ('coh8412555.L01','06');
insert into occurs values ('coh8412555.L01','07');
insert into occurs values ('coh8412555.L01','08');
insert into occurs values ('coh8412555.L01','10');
insert into occurs values ('coh8412555.L01','11');
insert into occurs values ('coh8412555.L01','12');
insert into occurs values ('coh8412555.L01','13');
insert into occurs values ('coh8412555.L02','01');
insert into occurs values ('coh8412555.L02','02');
insert into occurs values ('coh8412555.L02','03');
insert into occurs values ('coh8412555.L02','04');
insert into occurs values ('coh8412555.L02','05');
insert into occurs values ('coh8412555.L02','06');
insert into occurs values ('coh8412555.L02','07');
insert into occurs values ('coh8412555.L02','08');
insert into occurs values ('coh8412555.L02','10');
insert into occurs values ('coh8412555.L02','11');
insert into occurs values ('coh8412555.L02','12');
insert into occurs values ('coh8412555.L02','13');
insert into occurs values ('coh8412555.T01','01');
--- taboccurs, 2001, 50
insert into occurs values ('coh8412555.T01','02');
insert into occurs values ('coh8412555.T01','03');
insert into occurs values ('coh8412555.T01','04');
insert into occurs values ('coh8412555.T01','05');
insert into occurs values ('coh8412555.T01','06');
insert into occurs values ('coh8412555.T01','07');
insert into occurs values ('coh8412555.T01','08');
insert into occurs values ('coh8412555.T01','10');
insert into occurs values ('coh8412555.T01','11');
insert into occurs values ('coh8412555.T01','12');
insert into occurs values ('coh8412555.T01','13');
insert into occurs values ('coh8412555.T02','01');
insert into occurs values ('coh8412555.T02','02');
insert into occurs values ('coh8412555.T02','03');
insert into occurs values ('coh8412555.T02','04');
insert into occurs values ('coh8412555.T02','05');
insert into occurs values ('coh8412555.T02','06');
insert into occurs values ('coh8412555.T02','07');
insert into occurs values ('coh8412555.T02','08');
insert into occurs values ('coh8412555.T02','10');
insert into occurs values ('coh8412555.T02','11');
insert into occurs values ('coh8412555.T02','12');
insert into occurs values ('coh8412555.T02','13');
insert into occurs values ('coh8412575.L01','01');
insert into occurs values ('coh8412575.L01','02');
insert into occurs values ('coh8412575.L01','03');
insert into occurs values ('coh8412575.L01','04');
insert into occurs values ('coh8412575.L01','05');
insert into occurs values ('coh8412575.L01','06');
insert into occurs values ('coh8412575.L01','07');
insert into occurs values ('coh8412575.L01','08');
insert into occurs values ('coh8412575.L01','10');
insert into occurs values ('coh8412575.L01','11');
insert into occurs values ('coh8412575.L01','12');
insert into occurs values ('coh8412575.L01','13');
insert into occurs values ('coh8412575.T01','01');
insert into occurs values ('coh8412575.T01','02');
insert into occurs values ('coh8412575.T01','03');
insert into occurs values ('coh8412575.T01','04');
insert into occurs values ('coh8412575.T01','05');
insert into occurs values ('coh8412575.T01','06');
insert into occurs values ('coh8412575.T01','07');
insert into occurs values ('coh8412575.T01','08');
insert into occurs values ('coh8412575.T01','10');
insert into occurs values ('coh8412575.T01','11');
insert into occurs values ('coh8412575.T01','12');
insert into occurs values ('coh8412575.T01','13');
insert into occurs values ('coh8412575.T02','01');
insert into occurs values ('coh8412575.T02','02');
insert into occurs values ('coh8412575.T02','03');
--- taboccurs, 2051, 50
insert into occurs values ('coh8412575.T02','04');
insert into occurs values ('coh8412575.T02','05');
insert into occurs values ('coh8412575.T02','06');
insert into occurs values ('coh8412575.T02','07');
insert into occurs values ('coh8412575.T02','08');
insert into occurs values ('coh8412575.T02','10');
insert into occurs values ('coh8412575.T02','11');
insert into occurs values ('coh8412575.T02','12');
insert into occurs values ('coh8412575.T02','13');
insert into occurs values ('coh8412585.L01','01');
insert into occurs values ('coh8412585.L01','02');
insert into occurs values ('coh8412585.L01','03');
insert into occurs values ('coh8412585.L01','04');
insert into occurs values ('coh8412585.L01','05');
insert into occurs values ('coh8412585.L01','06');
insert into occurs values ('coh8412585.L01','07');
insert into occurs values ('coh8412585.L01','08');
insert into occurs values ('coh8412585.L01','10');
insert into occurs values ('coh8412585.L01','11');
insert into occurs values ('coh8412585.L01','12');
insert into occurs values ('coh8412585.L01','13');
insert into occurs values ('coh8412585.T01','01');
insert into occurs values ('coh8412585.T01','02');
insert into occurs values ('coh8412585.T01','03');
insert into occurs values ('coh8412585.T01','04');
insert into occurs values ('coh8412585.T01','05');
insert into occurs values ('coh8412585.T01','06');
insert into occurs values ('coh8412585.T01','07');
insert into occurs values ('coh8412585.T01','08');
insert into occurs values ('coh8412585.T01','10');
insert into occurs values ('coh8412585.T01','11');
insert into occurs values ('coh8412585.T01','12');
insert into occurs values ('coh8412585.T01','13');
insert into occurs values ('coh8412585.T02','01');
insert into occurs values ('coh8412585.T02','02');
insert into occurs values ('coh8412585.T02','03');
insert into occurs values ('coh8412585.T02','04');
insert into occurs values ('coh8412585.T02','05');
insert into occurs values ('coh8412585.T02','06');
insert into occurs values ('coh8412585.T02','07');
insert into occurs values ('coh8412585.T02','08');
insert into occurs values ('coh8412585.T02','10');
insert into occurs values ('coh8412585.T02','11');
insert into occurs values ('coh8412585.T02','12');
insert into occurs values ('coh8412585.T02','13');
insert into occurs values ('coh8412585.T03','01');
insert into occurs values ('coh8412585.T03','02');
insert into occurs values ('coh8412585.T03','03');
insert into occurs values ('coh8412585.T03','04');
insert into occurs values ('coh8412585.T03','05');
--- taboccurs, 2101, 50
insert into occurs values ('coh8412585.T03','06');
insert into occurs values ('coh8412585.T03','07');
insert into occurs values ('coh8412585.T03','08');
insert into occurs values ('coh8412585.T03','10');
insert into occurs values ('coh8412585.T03','11');
insert into occurs values ('coh8412585.T03','12');
insert into occurs values ('coh8412585.T03','13');
insert into occurs values ('coh8412605.L01','01');
insert into occurs values ('coh8412605.L01','02');
insert into occurs values ('coh8412605.L01','03');
insert into occurs values ('coh8412605.L01','04');
insert into occurs values ('coh8412605.L01','05');
insert into occurs values ('coh8412605.L01','06');
insert into occurs values ('coh8412605.L01','07');
insert into occurs values ('coh8412605.L01','08');
insert into occurs values ('coh8412605.L01','10');
insert into occurs values ('coh8412605.L01','11');
insert into occurs values ('coh8412605.L01','12');
insert into occurs values ('coh8412605.L01','13');
insert into occurs values ('coh8412605.T01','01');
insert into occurs values ('coh8412605.T01','02');
insert into occurs values ('coh8412605.T01','03');
insert into occurs values ('coh8412605.T01','04');
insert into occurs values ('coh8412605.T01','05');
insert into occurs values ('coh8412605.T01','06');
insert into occurs values ('coh8412605.T01','07');
insert into occurs values ('coh8412605.T01','08');
insert into occurs values ('coh8412605.T01','10');
insert into occurs values ('coh8412605.T01','11');
insert into occurs values ('coh8412605.T01','12');
insert into occurs values ('coh8412605.T01','13');
insert into occurs values ('coh8412605.T02','01');
insert into occurs values ('coh8412605.T02','02');
insert into occurs values ('coh8412605.T02','03');
insert into occurs values ('coh8412605.T02','04');
insert into occurs values ('coh8412605.T02','05');
insert into occurs values ('coh8412605.T02','06');
insert into occurs values ('coh8412605.T02','07');
insert into occurs values ('coh8412605.T02','08');
insert into occurs values ('coh8412605.T02','10');
insert into occurs values ('coh8412605.T02','11');
insert into occurs values ('coh8412605.T02','12');
insert into occurs values ('coh8412605.T02','13');
insert into occurs values ('coh8412605.T03','01');
insert into occurs values ('coh8412605.T03','02');
insert into occurs values ('coh8412605.T03','03');
insert into occurs values ('coh8412605.T03','04');
insert into occurs values ('coh8412605.T03','05');
insert into occurs values ('coh8412605.T03','06');
insert into occurs values ('coh8412605.T03','07');
--- taboccurs, 2151, 50
insert into occurs values ('coh8412605.T03','08');
insert into occurs values ('coh8412605.T03','10');
insert into occurs values ('coh8412605.T03','11');
insert into occurs values ('coh8412605.T03','12');
insert into occurs values ('coh8412605.T03','13');
insert into occurs values ('coh8412615.L01','01');
insert into occurs values ('coh8412615.L01','02');
insert into occurs values ('coh8412615.L01','03');
insert into occurs values ('coh8412615.L01','04');
insert into occurs values ('coh8412615.L01','05');
insert into occurs values ('coh8412615.L01','06');
insert into occurs values ('coh8412615.L01','07');
insert into occurs values ('coh8412615.L01','08');
insert into occurs values ('coh8412615.L01','10');
insert into occurs values ('coh8412615.L01','11');
insert into occurs values ('coh8412615.L01','12');
insert into occurs values ('coh8412615.L01','13');
insert into occurs values ('coh8412615.T01','01');
insert into occurs values ('coh8412615.T01','02');
insert into occurs values ('coh8412615.T01','03');
insert into occurs values ('coh8412615.T01','04');
insert into occurs values ('coh8412615.T01','05');
insert into occurs values ('coh8412615.T01','06');
insert into occurs values ('coh8412615.T01','07');
insert into occurs values ('coh8412615.T01','08');
insert into occurs values ('coh8412615.T01','10');
insert into occurs values ('coh8412615.T01','11');
insert into occurs values ('coh8412615.T01','12');
insert into occurs values ('coh8412615.T01','13');
insert into occurs values ('coh8412615.T02','01');
insert into occurs values ('coh8412615.T02','02');
insert into occurs values ('coh8412615.T02','03');
insert into occurs values ('coh8412615.T02','04');
insert into occurs values ('coh8412615.T02','05');
insert into occurs values ('coh8412615.T02','06');
insert into occurs values ('coh8412615.T02','07');
insert into occurs values ('coh8412615.T02','08');
insert into occurs values ('coh8412615.T02','10');
insert into occurs values ('coh8412615.T02','11');
insert into occurs values ('coh8412615.T02','12');
insert into occurs values ('coh8412615.T02','13');
insert into occurs values ('coh8412615.T03','01');
insert into occurs values ('coh8412615.T03','02');
insert into occurs values ('coh8412615.T03','03');
insert into occurs values ('coh8412615.T03','04');
insert into occurs values ('coh8412615.T03','05');
insert into occurs values ('coh8412615.T03','06');
insert into occurs values ('coh8412615.T03','07');
insert into occurs values ('coh8412615.T03','08');
insert into occurs values ('coh8412615.T03','10');
--- taboccurs, 2201, 50
insert into occurs values ('coh8412615.T03','11');
insert into occurs values ('coh8412615.T03','12');
insert into occurs values ('coh8412615.T03','13');
insert into occurs values ('coh8412615.T04','01');
insert into occurs values ('coh8412615.T04','02');
insert into occurs values ('coh8412615.T04','03');
insert into occurs values ('coh8412615.T04','04');
insert into occurs values ('coh8412615.T04','05');
insert into occurs values ('coh8412615.T04','06');
insert into occurs values ('coh8412615.T04','07');
insert into occurs values ('coh8412615.T04','08');
insert into occurs values ('coh8412615.T04','10');
insert into occurs values ('coh8412615.T04','11');
insert into occurs values ('coh8412615.T04','12');
insert into occurs values ('coh8412615.T04','13');
insert into occurs values ('coh8412615.T05','01');
insert into occurs values ('coh8412615.T05','02');
insert into occurs values ('coh8412615.T05','03');
insert into occurs values ('coh8412615.T05','04');
insert into occurs values ('coh8412615.T05','05');
insert into occurs values ('coh8412615.T05','06');
insert into occurs values ('coh8412615.T05','07');
insert into occurs values ('coh8412615.T05','08');
insert into occurs values ('coh8412615.T05','10');
insert into occurs values ('coh8412615.T05','11');
insert into occurs values ('coh8412615.T05','12');
insert into occurs values ('coh8412615.T05','13');
insert into occurs values ('coh8412615.T06','01');
insert into occurs values ('coh8412615.T06','02');
insert into occurs values ('coh8412615.T06','03');
insert into occurs values ('coh8412615.T06','04');
insert into occurs values ('coh8412615.T06','05');
insert into occurs values ('coh8412615.T06','06');
insert into occurs values ('coh8412615.T06','07');
insert into occurs values ('coh8412615.T06','08');
insert into occurs values ('coh8412615.T06','10');
insert into occurs values ('coh8412615.T06','11');
insert into occurs values ('coh8412615.T06','12');
insert into occurs values ('coh8412615.T06','13');
insert into occurs values ('coh8412635.L01','01');
insert into occurs values ('coh8412635.L01','02');
insert into occurs values ('coh8412635.L01','03');
insert into occurs values ('coh8412635.L01','04');
insert into occurs values ('coh8412635.L01','05');
insert into occurs values ('coh8412635.L01','06');
insert into occurs values ('coh8412635.L01','07');
insert into occurs values ('coh8412635.L01','08');
insert into occurs values ('coh8412635.L01','10');
insert into occurs values ('coh8412635.L01','11');
insert into occurs values ('coh8412635.L01','12');
--- taboccurs, 2251, 50
insert into occurs values ('coh8412635.L01','13');
insert into occurs values ('coh8412635.L02','01');
insert into occurs values ('coh8412635.L02','02');
insert into occurs values ('coh8412635.L02','03');
insert into occurs values ('coh8412635.L02','04');
insert into occurs values ('coh8412635.L02','05');
insert into occurs values ('coh8412635.L02','06');
insert into occurs values ('coh8412635.L02','07');
insert into occurs values ('coh8412635.L02','08');
insert into occurs values ('coh8412635.L02','10');
insert into occurs values ('coh8412635.L02','11');
insert into occurs values ('coh8412635.L02','12');
insert into occurs values ('coh8412635.L02','13');
insert into occurs values ('coh8412635.T01','01');
insert into occurs values ('coh8412635.T01','02');
insert into occurs values ('coh8412635.T01','03');
insert into occurs values ('coh8412635.T01','04');
insert into occurs values ('coh8412635.T01','05');
insert into occurs values ('coh8412635.T01','06');
insert into occurs values ('coh8412635.T01','07');
insert into occurs values ('coh8412635.T01','08');
insert into occurs values ('coh8412635.T01','10');
insert into occurs values ('coh8412635.T01','11');
insert into occurs values ('coh8412635.T01','12');
insert into occurs values ('coh8412635.T01','13');
insert into occurs values ('coh8412635.T02','01');
insert into occurs values ('coh8412635.T02','02');
insert into occurs values ('coh8412635.T02','03');
insert into occurs values ('coh8412635.T02','04');
insert into occurs values ('coh8412635.T02','05');
insert into occurs values ('coh8412635.T02','06');
insert into occurs values ('coh8412635.T02','07');
insert into occurs values ('coh8412635.T02','08');
insert into occurs values ('coh8412635.T02','10');
insert into occurs values ('coh8412635.T02','11');
insert into occurs values ('coh8412635.T02','12');
insert into occurs values ('coh8412635.T02','13');
insert into occurs values ('coh8412635.T03','01');
insert into occurs values ('coh8412635.T03','02');
insert into occurs values ('coh8412635.T03','03');
insert into occurs values ('coh8412635.T03','04');
insert into occurs values ('coh8412635.T03','05');
insert into occurs values ('coh8412635.T03','06');
insert into occurs values ('coh8412635.T03','07');
insert into occurs values ('coh8412635.T03','08');
insert into occurs values ('coh8412635.T03','10');
insert into occurs values ('coh8412635.T03','11');
insert into occurs values ('coh8412635.T03','12');
insert into occurs values ('coh8412635.T03','13');
insert into occurs values ('coh8412635.T04','01');
--- taboccurs, 2301, 50
insert into occurs values ('coh8412635.T04','02');
insert into occurs values ('coh8412635.T04','03');
insert into occurs values ('coh8412635.T04','04');
insert into occurs values ('coh8412635.T04','05');
insert into occurs values ('coh8412635.T04','06');
insert into occurs values ('coh8412635.T04','07');
insert into occurs values ('coh8412635.T04','08');
insert into occurs values ('coh8412635.T04','10');
insert into occurs values ('coh8412635.T04','11');
insert into occurs values ('coh8412635.T04','12');
insert into occurs values ('coh8412635.T04','13');
insert into occurs values ('coh8412635.T05','01');
insert into occurs values ('coh8412635.T05','02');
insert into occurs values ('coh8412635.T05','03');
insert into occurs values ('coh8412635.T05','04');
insert into occurs values ('coh8412635.T05','05');
insert into occurs values ('coh8412635.T05','06');
insert into occurs values ('coh8412635.T05','07');
insert into occurs values ('coh8412635.T05','08');
insert into occurs values ('coh8412635.T05','10');
insert into occurs values ('coh8412635.T05','11');
insert into occurs values ('coh8412635.T05','12');
insert into occurs values ('coh8412635.T05','13');
insert into occurs values ('coh8412635.T06','01');
insert into occurs values ('coh8412635.T06','02');
insert into occurs values ('coh8412635.T06','03');
insert into occurs values ('coh8412635.T06','04');
insert into occurs values ('coh8412635.T06','05');
insert into occurs values ('coh8412635.T06','06');
insert into occurs values ('coh8412635.T06','07');
insert into occurs values ('coh8412635.T06','08');
insert into occurs values ('coh8412635.T06','10');
insert into occurs values ('coh8412635.T06','11');
insert into occurs values ('coh8412635.T06','12');
insert into occurs values ('coh8412635.T06','13');
insert into occurs values ('coh8521005.L01','01');
insert into occurs values ('coh8521005.L01','02');
insert into occurs values ('coh8521005.L01','03');
insert into occurs values ('coh8521005.L01','04');
insert into occurs values ('coh8521005.L01','05');
insert into occurs values ('coh8521005.L01','06');
insert into occurs values ('coh8521005.L01','07');
insert into occurs values ('coh8521005.L01','08');
insert into occurs values ('coh8521005.L01','10');
insert into occurs values ('coh8521005.L01','11');
insert into occurs values ('coh8521005.L01','12');
insert into occurs values ('coh8521005.L01','13');
insert into occurs values ('coh8521005.T01','01');
insert into occurs values ('coh8521005.T01','02');
insert into occurs values ('coh8521005.T01','03');
--- taboccurs, 2351, 50
insert into occurs values ('coh8521005.T01','04');
insert into occurs values ('coh8521005.T01','05');
insert into occurs values ('coh8521005.T01','06');
insert into occurs values ('coh8521005.T01','07');
insert into occurs values ('coh8521005.T01','08');
insert into occurs values ('coh8521005.T01','10');
insert into occurs values ('coh8521005.T01','11');
insert into occurs values ('coh8521005.T01','12');
insert into occurs values ('coh8521005.T01','13');
insert into occurs values ('coh8521005.T02','01');
insert into occurs values ('coh8521005.T02','02');
insert into occurs values ('coh8521005.T02','03');
insert into occurs values ('coh8521005.T02','04');
insert into occurs values ('coh8521005.T02','05');
insert into occurs values ('coh8521005.T02','06');
insert into occurs values ('coh8521005.T02','07');
insert into occurs values ('coh8521005.T02','08');
insert into occurs values ('coh8521005.T02','10');
insert into occurs values ('coh8521005.T02','11');
insert into occurs values ('coh8521005.T02','12');
insert into occurs values ('coh8521005.T02','13');
insert into occurs values ('coh8560095.L01','01');
insert into occurs values ('coh8560095.L01','02');
insert into occurs values ('coh8560095.L01','03');
insert into occurs values ('coh8560095.L01','04');
insert into occurs values ('coh8560095.L01','05');
insert into occurs values ('coh8560095.L01','06');
insert into occurs values ('coh8560095.L01','07');
insert into occurs values ('coh8560095.L01','08');
insert into occurs values ('coh8560095.L01','10');
insert into occurs values ('coh8560095.L01','11');
insert into occurs values ('coh8560095.L01','12');
insert into occurs values ('coh8560095.L01','13');
insert into occurs values ('coh8560095.T01','01');
insert into occurs values ('coh8560095.T01','02');
insert into occurs values ('coh8560095.T01','03');
insert into occurs values ('coh8560095.T01','04');
insert into occurs values ('coh8560095.T01','05');
insert into occurs values ('coh8560095.T01','06');
insert into occurs values ('coh8560095.T01','07');
insert into occurs values ('coh8560095.T01','08');
insert into occurs values ('coh8560095.T01','10');
insert into occurs values ('coh8560095.T01','11');
insert into occurs values ('coh8560095.T01','12');
insert into occurs values ('coh8560095.T01','13');
insert into occurs values ('coh8560095.T02','01');
insert into occurs values ('coh8560095.T02','02');
insert into occurs values ('coh8560095.T02','03');
insert into occurs values ('coh8560095.T02','04');
insert into occurs values ('coh8560095.T02','05');
--- taboccurs, 2401, 50
insert into occurs values ('coh8560095.T02','06');
insert into occurs values ('coh8560095.T02','07');
insert into occurs values ('coh8560095.T02','08');
insert into occurs values ('coh8560095.T02','10');
insert into occurs values ('coh8560095.T02','11');
insert into occurs values ('coh8560095.T02','12');
insert into occurs values ('coh8560095.T02','13');
insert into occurs values ('coh8560095.T03','01');
insert into occurs values ('coh8560095.T03','02');
insert into occurs values ('coh8560095.T03','03');
insert into occurs values ('coh8560095.T03','04');
insert into occurs values ('coh8560095.T03','05');
insert into occurs values ('coh8560095.T03','06');
insert into occurs values ('coh8560095.T03','07');
insert into occurs values ('coh8560095.T03','08');
insert into occurs values ('coh8560095.T03','10');
insert into occurs values ('coh8560095.T03','11');
insert into occurs values ('coh8560095.T03','12');
insert into occurs values ('coh8560095.T03','13');
--- tabstudent, 1, 50
insert into student values ('co.12008.Ea','WP and SS Elective',50,NULL);
insert into student values ('co.12008.Eb','WP and SS Elective',50,NULL);
insert into student values ('co.12012.E','UEC Elective',32,NULL);
insert into student values ('co.22022.E','C++ Elective',40,NULL);
insert into student values ('co1.BAe','BAe',15,NULL);
insert into student values ('co1.CO','Computing 1st Year',150,NULL);
insert into student values ('co1.CO.a','Computing 1st Year a',20,'co1.CO');
insert into student values ('co1.CO.c','Computing 1st Year c',20,'co1.CO');
insert into student values ('co1.CO.d','Computing 1st Year d',20,'co1.CO');
insert into student values ('co1.CO.e','Computing 1st Year e',20,'co1.CO');
insert into student values ('co1.CO.f','Computing 1st Year f',20,'co1.CO');
insert into student values ('co1.CO.h','Computing 1st Year h',20,'co1.CO');
insert into student values ('co1.CO.i','Computing 1st Year i',20,'co1.CO');
insert into student values ('co1.CO.j','Computing 1st Year j',20,'co1.CO');
insert into student values ('co1.IS','BSc Information Systems 1st Year',40,NULL);
insert into student values ('co1.IS.a','BSc Information Systems 1st Year a',20,'co1.IS');
insert into student values ('co1.IS.b','BSc Information Systems 1st Year b',20,'co1.IS');
insert into student values ('co1.SE.pt','Software Engineering p/t 1',2,NULL);
insert into student values ('co2.CO','Computing 2nd Year',100,NULL);
insert into student values ('co2.CO.a','Computing 2nd Year a',20,'co2.CO');
insert into student values ('co2.CO.b','Computing 2nd Year b',20,'co2.CO');
insert into student values ('co2.CO.c','Computing 2nd Year c',20,'co2.CO');
insert into student values ('co2.CO.d','Computing 2nd Year d',20,'co2.CO');
insert into student values ('co2.CO.e','Computing 2nd Year e',20,'co2.CO');
insert into student values ('co2.CO.i','Computing 2nd Year Bridging',20,NULL);
insert into student values ('co2.CO.j','Computing 2nd Year Bridging',20,NULL);
insert into student values ('co2.CO.k','Computing 2nd Year Bridging',20,NULL);
insert into student values ('co2.IS','Information Systems 2nd Year',20,NULL);
insert into student values ('co2.NT.Ea','NT Elective',20,NULL);
insert into student values ('co2.NT.Eb','NT Elective',20,NULL);
insert into student values ('co2.NT.Ec','NT Elective',20,NULL);
insert into student values ('co2.NT.Ed','NT Elective',20,NULL);
insert into student values ('co2.NT.Ee','NT Elective',20,NULL);
insert into student values ('co2.SE.pt','Software Engineering p/t 2',10,NULL);
insert into student values ('co3.CO','BEng3 SoC year 3 (non SWE)',2,NULL);
insert into student values ('co3.DMM','DEBS 3 Multimedia',15,NULL);
insert into student values ('co3.DNC','DEBS Network Computing Year 3',27,NULL);
insert into student values ('co3.DST','DEBS 3 Software Technology',4,NULL);
insert into student values ('co3.IS','BSc3 Information Systems',0,NULL);
insert into student values ('co3.MM','BEng3 Multimedia (non SWE)',20,NULL);
insert into student values ('co3.ND','BEng3 Network and DS (non SWE)',15,NULL);
insert into student values ('co3.SE','BEng3 Software Engineering (non SWE)',35,NULL);
insert into student values ('co3.SE.pt','BEng3 Software Engineering p/t',5,NULL);
insert into student values ('co4.CO','BSc4 Computing',25,NULL);
insert into student values ('co4.DNC','DEBS 4 Network Computing',5,NULL);
insert into student values ('co4.IS','BSc4 Information Systems',5,NULL);
insert into student values ('co4.MM','BEng4 Multimedia Systems',22,NULL);
insert into student values ('co4.ND','BEng4 Network and Distributing Systems',5,NULL);
insert into student values ('co4.SE','BEng4 Software Engineering',30,NULL);
insert into student values ('co4.SE.pt','BEng4 Software Engineering p/t',5,NULL);
--- tabstudent, 51, 50
insert into student values ('co5.SE.pt','BEng5 Software Engineering p/t',5,NULL);
insert into student values ('coh.HND1','HND Year 1',80,NULL);
insert into student values ('coh.HND1a','HND Computing Year 1 a',20,'coh.HND1');
insert into student values ('coh.HND1b','HND Computing Year 1 b',20,'coh.HND1');
insert into student values ('coh.HND1c','HND Computing Year 1 c',20,'coh.HND1');
insert into student values ('coh.HND1d','HND Computing Year 1 d',20,'coh.HND1');
insert into student values ('coh.HND2','HND Computing Year 2',30,NULL);
insert into student values ('coh.HND2a','HND Computing Year 2 a',15,'coh.HND2');
insert into student values ('coh.HND2b','HND Computing Year 2 b',15,'coh.HND2');
insert into student values ('com.IS','PgD Information Systems',115,NULL);
insert into student values ('com.IS.a','PgD Information Systems a (HCI)',25,'com.IS');
insert into student values ('com.IS.b','PgD Information Systems b (DS)',15,'com.IS');
insert into student values ('com.IS.d','PgD Information Systems d (BT)',29,'com.IS');
insert into student values ('com.IS.e','PgD Information Systems e (OOP)',29,'com.IS');
insert into student values ('com.IS.th','PgD Information System pt. Thurs',5,NULL);
insert into student values ('com.IS.tu','PgD Information System pt. Tues',5,NULL);
insert into student values ('com.ITFS','PgD IT and Financial Services',25,NULL);
insert into student values ('com.ITeC','PgD IT and e-Commerce',25,NULL);
insert into student values ('com.ITeC.feb',NULL,20,NULL);
insert into student values ('com.ITeC.pt1','PgD IT and e-Commerce Oct pt',20,NULL);
insert into student values ('com.ITeC.pt2','PgD IT and e-Commerce',25,NULL);
insert into student values ('com.ITeC.z1','PgD IT and e-Commerce Oct evening',20,NULL);
insert into student values ('com.ITeC.z2','PgD IT and e-Commerce Feb evening',19,NULL);
insert into student values ('com.ITeC.z3','PgD IT and e-Commerce eve sem 3',20,NULL);
insert into student values ('com.MM','PgD Multimedia FT Oct',128,NULL);
insert into student values ('com.MM.a','PgD Multimedia a',32,'com.MM');
insert into student values ('com.MM.b','PgD Multimedia b',32,'com.MM');
insert into student values ('com.MM.c','PgD Multimedia c',32,'com.MM');
insert into student values ('com.MM.d','PgD Multimedia d',30,'com.MM');
insert into student values ('com.MM.feb','PgD Multimedia Feb intake',25,NULL);
insert into student values ('com.MM.pt1','PgD Multimedia pt sem 1',8,NULL);
insert into student values ('com.MM.pt2','PgD Multimedia p/t sem 2',4,NULL);
insert into student values ('com.MM.pt3','PgD Multimedia sem 3',8,NULL);
insert into student values ('com.MM.pt4','PgD Multimedia Oct. p/t sem 4',20,NULL);
insert into student values ('com.SE','PgD Software Engineering',35,NULL);
insert into student values ('com.SE.th','PgD Software Engineering pt th',5,NULL);
insert into student values ('com.SE.tu','PgD Software Engineering pt tu',5,NULL);
insert into student values ('com.ST','PgD Software Technology',45,NULL);
insert into student values ('com.ST.a','PgD Software Technology a (HCI)',10,'com.ST');
insert into student values ('com.ST.b','PgD Software Technology b (DS)',10,'com.ST');
insert into student values ('com.ST.th','PgD Software Technology pt. Thurs',5,NULL);
insert into student values ('com.ST.tu','PgD Software Technology pt. Tues',5,NULL);
--- tabstaff, 1, 50
insert into staff values ('co.ACg','Cumming, Andrew');
insert into staff values ('co.ACr','Crerar, Dr Alison');
insert into staff values ('co.AFA','Armitage, Dr Alistair');
insert into staff values ('co.AG','Groat, Anne');
insert into staff values ('co.AL','Lawson, Alistair');
insert into staff values ('co.AMn','Maclean, Aileen');
insert into staff values ('co.ASc','Scott, Andrea');
insert into staff values ('co.ASr','Soutar, Alastair');
insert into staff values ('co.AV','Varey, Alison');
insert into staff values ('co.BB','Buchanan, Dr Wm');
insert into staff values ('co.BC','Cowan, Bruce');
insert into staff values ('co.BD','Dupee, Dr Brian');
insert into staff values ('co.BDR','Ritchie, Bryden');
insert into staff values ('co.BP','Paechter, Ben');
insert into staff values ('co.CAD','Clem Douglas');
insert into staff values ('co.CAR','Rickard, Anne');
insert into staff values ('co.CG','Gregory, Chris');
insert into staff values ('co.CHd','Hand, Chris');
insert into staff values ('co.CHt','Hastie, Colin');
insert into staff values ('co.CM','Macaulay, Catriona');
insert into staff values ('co.CMD','Dougal, Colin');
insert into staff values ('co.DB','Benyon, Prof David');
insert into staff values ('co.ED','Davenport, Lissie');
insert into staff values ('co.EH','Hart, Emma');
insert into staff values ('co.FG','Greig, Frank');
insert into staff values ('co.GM','McCarra, Greg');
insert into staff values ('co.GR','Russell, Dr Gordon');
insert into staff values ('co.GS','Scott, Graham');
insert into staff values ('co.HH','Hall, Hazel');
insert into staff values ('co.IM','McGregor, Iain');
insert into staff values ('co.IS','Smith, Ian');
insert into staff values ('co.JB','Jyoti Bhardwaj');
insert into staff values ('co.JJ','Jackson, Jim');
insert into staff values ('co.JKg','Kerridge, Prof Jon');
insert into staff values ('co.JKy','Kennedy, Jessie');
insert into staff values ('co.JMc','McGowan, Joyce');
insert into staff values ('co.JMy','Murray, Jim');
insert into staff values ('co.JMz','Munoz, Dr Jose');
insert into staff values ('co.JO','Owens, Dr John');
insert into staff values ('co.JSv','Savage, Dr John');
insert into staff values ('co.KB','Barclay, Ken');
insert into staff values ('co.KC','Chisholm, Ken');
insert into staff values ('co.KH','Horton, Keith');
insert into staff values ('co.LM','Morss, Dr Les');
insert into staff values ('co.LS','Shearey, Lyn');
insert into staff values ('co.MR','Rutter, Malcolm');
insert into staff values ('co.MS','Smyth, Michael');
insert into staff values ('co.PTh','Thompson, Peter');
insert into staff values ('co.PTr','Turner, Phil');
insert into staff values ('co.RB','Bain, Dr Bob');
--- tabstaff, 51, 50
insert into staff values ('co.RD','Donald, Robert');
insert into staff values ('co.RK','Kemmer, Rob');
insert into staff values ('co.RM','McCall, Rod');
insert into staff values ('co.RR','Rankin, Bob');
insert into staff values ('co.SC','Cairncross, Sandra');
insert into staff values ('co.SL','Lawson, Shaun');
insert into staff values ('co.SM','Mathieson, Stuart');
insert into staff values ('co.SR','Raeburn, Scott');
insert into staff values ('co.SRM','Middleton, Steve');
insert into staff values ('co.SS','Smith, Sally');
insert into staff values ('co.ST','Turner, Susan');
insert into staff values ('co.TG','Goh, Teo');
insert into staff values ('co.TMc','McEwan, Tom');
insert into staff values ('co.TMu','Musson, Tim');
insert into staff values ('co.TP','Peng, Taoxin');
insert into staff values ('co.XL','Lui, Xiaodong');
insert into staff values ('co.ZZ1','z TBA1');
insert into staff values ('co.ZZ2','z TBA2');
insert into staff values ('co.ZZ4','z TBA4');
insert into staff values ('co.ZZ5','z TBA5');
insert into staff values ('co.ZZ6','z TBA6');
insert into staff values ('co.ZZ7','z TBA7');
insert into staff values ('co.ZZ8','z TBA8');
--- tabattends, 1, 50
insert into attends values ('co1.BAe','co12004.L01');
insert into attends values ('co1.CO','co12004.L01');
insert into attends values ('co1.IS','co12004.L01');
insert into attends values ('co1.SE.pt','co12004.L02');
insert into attends values ('co1.CO.a','co12004.T01');
insert into attends values ('co1.CO.c','co12004.T01');
insert into attends values ('co1.SE.pt','co12004.T01');
insert into attends values ('co1.CO.d','co12004.T02');
insert into attends values ('co1.CO.e','co12004.T02');
insert into attends values ('co1.CO.i','co12004.T03');
insert into attends values ('co1.CO.j','co12004.T03');
insert into attends values ('co1.IS.a','co12004.T04');
insert into attends values ('co1.IS.b','co12004.T04');
insert into attends values ('co1.BAe','co12004.T05');
insert into attends values ('co1.CO.f','co12004.T06');
insert into attends values ('co1.CO.h','co12004.T06');
insert into attends values ('co1.CO','co12005.L01');
insert into attends values ('co1.SE.pt','co12005.L01');
insert into attends values ('co1.CO','co12005.L02');
insert into attends values ('co1.CO.a','co12005.T01');
insert into attends values ('co1.CO.c','co12005.T01');
insert into attends values ('co1.CO.d','co12005.T02');
insert into attends values ('co1.CO.e','co12005.T02');
insert into attends values ('co1.CO.f','co12005.T03');
insert into attends values ('co1.CO.h','co12005.T03');
insert into attends values ('co1.CO.i','co12005.T04');
insert into attends values ('co1.CO.j','co12005.T04');
insert into attends values ('co1.SE.pt','co12005.T05');
insert into attends values ('co1.CO','co12006.L01');
insert into attends values ('co1.BAe','co12006.L02');
insert into attends values ('co2.SE.pt','co12006.L02');
insert into attends values ('co1.CO','co12006.L03');
insert into attends values ('co1.CO.a','co12006.T01');
insert into attends values ('co1.CO.c','co12006.T01');
insert into attends values ('co1.CO.d','co12006.T02');
insert into attends values ('co1.CO.e','co12006.T02');
insert into attends values ('co1.CO.f','co12006.T03');
insert into attends values ('co1.CO.h','co12006.T03');
insert into attends values ('co1.BAe','co12006.T04');
insert into attends values ('co1.CO.i','co12006.T04');
insert into attends values ('co1.CO.j','co12006.T04');
insert into attends values ('co1.SE.pt','co12006.T05');
insert into attends values ('co2.SE.pt','co12006.T06');
insert into attends values ('co.12008.Ea','co12008.L01');
insert into attends values ('co.12008.Eb','co12008.L01');
insert into attends values ('co.12008.Ea','co12008.T01');
insert into attends values ('co.12008.Eb','co12008.T02');
insert into attends values ('co1.BAe','co12011.L01');
insert into attends values ('co1.BAe','co12011.T01');
insert into attends values ('co.12012.E','co12012.L01');
--- tabattends, 51, 50
insert into attends values ('co.12012.E','co12012.T01');
insert into attends values ('co2.CO','co22005.L01');
insert into attends values ('co2.IS','co22005.L01');
insert into attends values ('co2.SE.pt','co22005.L01');
insert into attends values ('co2.CO.a','co22005.T01');
insert into attends values ('co2.CO.b','co22005.T01');
insert into attends values ('co2.CO.c','co22005.T02');
insert into attends values ('co2.CO.d','co22005.T02');
insert into attends values ('co2.CO.i','co22005.T03');
insert into attends values ('co2.CO.j','co22005.T03');
insert into attends values ('co2.CO.k','co22005.T04');
insert into attends values ('co2.IS','co22005.T04');
insert into attends values ('co2.CO.a','co22005.T05');
insert into attends values ('co2.CO.b','co22005.T05');
insert into attends values ('co2.CO.c','co22005.T06');
insert into attends values ('co2.CO.d','co22005.T06');
insert into attends values ('co2.CO.i','co22005.T07');
insert into attends values ('co2.CO.j','co22005.T07');
insert into attends values ('co2.CO.k','co22005.T08');
insert into attends values ('co2.IS','co22005.T08');
insert into attends values ('co2.CO.e','co22005.T09');
insert into attends values ('co2.SE.pt','co22005.T09');
insert into attends values ('co2.CO.e','co22005.T10');
insert into attends values ('co2.CO','co22006.L01');
insert into attends values ('co3.SE.pt','co22006.L02');
insert into attends values ('co3.SE.pt','co22006.L03');
insert into attends values ('co2.CO.a','co22006.T01');
insert into attends values ('co2.CO.e','co22006.T01');
insert into attends values ('co2.CO.b','co22006.T02');
insert into attends values ('co2.CO.i','co22006.T02');
insert into attends values ('co2.CO.c','co22006.T03');
insert into attends values ('co2.CO.j','co22006.T03');
insert into attends values ('co2.CO.d','co22006.T04');
insert into attends values ('co2.CO.k','co22006.T04');
insert into attends values ('co2.CO','co22007.L01');
insert into attends values ('co2.IS','co22007.L01');
insert into attends values ('co3.DMM','co22007.L01');
insert into attends values ('co2.CO.a','co22007.T01');
insert into attends values ('co2.CO.e','co22007.T01');
insert into attends values ('co2.CO.b','co22007.T02');
insert into attends values ('co2.CO.i','co22007.T02');
insert into attends values ('co2.CO.c','co22007.T03');
insert into attends values ('co2.CO.j','co22007.T03');
insert into attends values ('co2.CO.d','co22007.T04');
insert into attends values ('co2.CO.k','co22007.T04');
insert into attends values ('co2.SE.pt','co22007.T05');
insert into attends values ('co3.SE.pt','co22007.T05');
insert into attends values ('co2.IS','co22007.T06');
insert into attends values ('co3.DMM','co22007.T06');
insert into attends values ('co2.CO.i','co22009.L01');
--- tabattends, 101, 50
insert into attends values ('co2.CO.j','co22009.L01');
insert into attends values ('co2.CO.k','co22009.L01');
insert into attends values ('co2.CO.i','co22009.T01');
insert into attends values ('co2.CO.j','co22009.T01');
insert into attends values ('co2.CO.k','co22009.T02');
insert into attends values ('co2.NT.Ea','co22020.L01');
insert into attends values ('co2.NT.Eb','co22020.L01');
insert into attends values ('co2.NT.Ec','co22020.L01');
insert into attends values ('co2.NT.Ed','co22020.L01');
insert into attends values ('co2.NT.Ee','co22020.L01');
insert into attends values ('co2.NT.Ea','co22020.T01');
insert into attends values ('co2.NT.Eb','co22020.T02');
insert into attends values ('co2.NT.Ec','co22020.T03');
insert into attends values ('co2.NT.Ed','co22020.T04');
insert into attends values ('co2.NT.Ee','co22020.T05');
insert into attends values ('co.22022.E','co22022.L01');
insert into attends values ('co.22022.E','co22022.T01');
insert into attends values ('co3.DNC','co32003.L01');
insert into attends values ('co3.DNC','co32003.T01');
insert into attends values ('co3.DMM','co32005.L01');
insert into attends values ('co3.DNC','co32005.L01');
insert into attends values ('co3.DST','co32005.L01');
insert into attends values ('co3.DNC','co32005.T04');
insert into attends values ('co3.DMM','co32005.T05');
insert into attends values ('co3.DST','co32005.T05');
insert into attends values ('co3.CO','co32011.L01');
insert into attends values ('co3.MM','co32011.L01');
insert into attends values ('co3.ND','co32011.L01');
insert into attends values ('co3.SE','co32011.L01');
insert into attends values ('co3.SE.pt','co32011.L01');
insert into attends values ('co3.CO','co32011.L02');
insert into attends values ('co3.MM','co32011.L02');
insert into attends values ('co3.ND','co32011.L02');
insert into attends values ('co3.SE','co32011.L02');
insert into attends values ('co3.SE.pt','co32011.L02');
insert into attends values ('co3.CO','co32011.T01');
insert into attends values ('co3.SE.pt','co32011.T01');
insert into attends values ('co3.ND','co32011.T02');
insert into attends values ('co3.SE','co32011.T02');
insert into attends values ('co3.MM','co32011.T03');
insert into attends values ('co3.CO','co32014.L01');
insert into attends values ('co3.MM','co32014.L01');
insert into attends values ('co3.ND','co32014.L01');
insert into attends values ('co3.SE','co32014.L01');
insert into attends values ('co4.DNC','co32014.L01');
insert into attends values ('co4.SE.pt','co32014.L01');
insert into attends values ('co3.CO','co32014.T01');
insert into attends values ('co3.ND','co32014.T01');
insert into attends values ('co4.DNC','co32014.T01');
insert into attends values ('co3.SE','co32014.T02');
--- tabattends, 151, 50
insert into attends values ('co3.MM','co32014.T03');
insert into attends values ('co4.SE.pt','co32014.T03');
insert into attends values ('co4.CO','co32015.L01');
insert into attends values ('co4.CO','co32015.T01');
insert into attends values ('co3.CO','co32016.L01');
insert into attends values ('co3.MM','co32016.L01');
insert into attends values ('co3.ND','co32016.L01');
insert into attends values ('co3.SE','co32016.L01');
insert into attends values ('co4.SE.pt','co32016.L01');
insert into attends values ('co3.DMM','co32018.L01');
insert into attends values ('co3.DNC','co32018.L01');
insert into attends values ('co3.DST','co32018.L01');
insert into attends values ('co3.DMM','co32018.T01');
insert into attends values ('co3.DNC','co32018.T01');
insert into attends values ('co3.DST','co32018.T01');
insert into attends values ('co3.DMM','co32021.L01');
insert into attends values ('co3.DNC','co32021.L01');
insert into attends values ('co3.DST','co32021.L01');
insert into attends values ('co3.DST','co32023.L01');
insert into attends values ('co3.DST','co32023.T01');
insert into attends values ('co4.MM','co42001.L01');
insert into attends values ('co4.ND','co42001.L01');
insert into attends values ('co4.MM','co42001.T01');
insert into attends values ('co4.ND','co42001.T01');
insert into attends values ('co4.MM','co42002.L01');
insert into attends values ('co4.MM','co42002.T01');
insert into attends values ('co4.DNC','co42005.L01');
insert into attends values ('co4.IS','co42005.L01');
insert into attends values ('co4.MM','co42005.L01');
insert into attends values ('co4.DNC','co42005.T01');
insert into attends values ('co4.IS','co42005.T01');
insert into attends values ('co4.MM','co42005.T01');
insert into attends values ('co4.CO','co42009.L01');
insert into attends values ('co4.ND','co42009.L01');
insert into attends values ('co4.CO','co42009.T01');
insert into attends values ('co4.ND','co42009.T01');
insert into attends values ('co4.CO','co42010.L01');
insert into attends values ('co4.SE','co42010.L01');
insert into attends values ('co5.SE.pt','co42010.L01');
insert into attends values ('co4.SE','co42010.T01');
insert into attends values ('co4.CO','co42010.T02');
insert into attends values ('co5.SE.pt','co42010.T02');
insert into attends values ('co4.SE','co42013.L01');
insert into attends values ('co5.SE.pt','co42013.L01');
insert into attends values ('co4.SE','co42013.T01');
insert into attends values ('co5.SE.pt','co42013.T01');
insert into attends values ('co4.ND','co42015.L01');
insert into attends values ('co4.ND','co42015.T01');
insert into attends values ('co4.CO','co42019.L01');
insert into attends values ('co4.DNC','co42019.L01');
--- tabattends, 201, 50
insert into attends values ('co4.IS','co42019.L01');
insert into attends values ('co4.MM','co42019.L01');
insert into attends values ('co4.ND','co42019.L01');
insert into attends values ('co4.SE','co42019.L01');
insert into attends values ('co4.DNC','co42022.L01');
insert into attends values ('co4.DNC','co42022.T01');
insert into attends values ('com.ITFS','co72002.L01');
insert into attends values ('com.ITFS','co72002.T01');
insert into attends values ('com.ITFS','co72003.L01');
insert into attends values ('com.ITFS','co72003.T01');
insert into attends values ('com.MM.feb','co72004.L01');
insert into attends values ('com.MM.pt3','co72004.L01');
insert into attends values ('com.MM.feb','co72004.T01');
insert into attends values ('com.MM.pt3','co72004.T01');
insert into attends values ('com.MM.feb','co72006.L01');
insert into attends values ('com.MM.pt3','co72006.L01');
insert into attends values ('com.MM.feb','co72006.T01');
insert into attends values ('com.MM.pt3','co72006.T01');
insert into attends values ('com.ITeC.feb','co72011.L01');
insert into attends values ('com.MM','co72011.L01');
insert into attends values ('com.MM.pt2','co72011.L01');
insert into attends values ('com.MM.a','co72011.T01');
insert into attends values ('com.MM.b','co72011.T02');
insert into attends values ('com.MM.c','co72011.T03');
insert into attends values ('com.MM.d','co72011.T04');
insert into attends values ('com.MM.pt2','co72011.T04');
insert into attends values ('com.MM.a','co72011.T05');
insert into attends values ('com.MM.b','co72011.T06');
insert into attends values ('com.MM.c','co72011.T07');
insert into attends values ('com.MM.d','co72011.T08');
insert into attends values ('com.MM.pt2','co72011.T08');
insert into attends values ('com.ITeC.feb','co72011.T09');
insert into attends values ('com.IS','co72012.L01');
insert into attends values ('com.IS.th','co72012.L01');
insert into attends values ('com.IS.d','co72012.T01');
insert into attends values ('com.IS.a','co72012.T02');
insert into attends values ('com.IS.b','co72012.T02');
insert into attends values ('com.IS.e','co72012.T03');
insert into attends values ('com.IS.th','co72012.T03');
insert into attends values ('com.IS','co72013.L01');
insert into attends values ('com.ITeC.feb','co72013.L01');
insert into attends values ('com.SE','co72013.L01');
insert into attends values ('com.ST','co72013.L01');
insert into attends values ('com.IS.tu','co72013.L02');
insert into attends values ('com.ST.tu','co72013.L02');
insert into attends values ('com.IS.a','co72013.T01');
insert into attends values ('com.IS.b','co72013.T01');
insert into attends values ('com.IS.d','co72013.T02');
insert into attends values ('com.ITeC.feb','co72013.T02');
insert into attends values ('com.IS.tu','co72013.T03');
--- tabattends, 251, 50
insert into attends values ('com.ST.tu','co72013.T03');
insert into attends values ('com.ST','co72013.T04');
insert into attends values ('com.SE','co72013.T05');
insert into attends values ('com.IS.e','co72013.T06');
insert into attends values ('com.IS.b','co72016.L01');
insert into attends values ('com.ST.b','co72016.L01');
insert into attends values ('com.IS.b','co72016.T01');
insert into attends values ('com.ST.b','co72016.T01');
insert into attends values ('com.IS.e','co72017.L01');
insert into attends values ('com.IS.e','co72017.T01');
insert into attends values ('com.SE','co72018.L01');
insert into attends values ('com.SE.th','co72018.L01');
insert into attends values ('com.ST','co72018.L01');
insert into attends values ('com.ST.th','co72018.L01');
insert into attends values ('com.SE.th','co72018.T01');
insert into attends values ('com.ST','co72018.T01');
insert into attends values ('com.ST.th','co72018.T01');
insert into attends values ('com.SE','co72018.T02');
insert into attends values ('com.SE','co72021.L01');
insert into attends values ('com.SE','co72021.T01');
insert into attends values ('com.ITeC.feb','co72023.L01');
insert into attends values ('com.ITeC.pt2','co72023.L01');
insert into attends values ('com.MM','co72023.L01');
insert into attends values ('com.MM.pt2','co72023.L01');
insert into attends values ('com.ITeC.z1','co72023.L02');
insert into attends values ('com.ITeC.z2','co72023.L02');
insert into attends values ('com.MM.a','co72023.T01');
insert into attends values ('com.MM.b','co72023.T02');
insert into attends values ('com.ITeC.feb','co72023.T03');
insert into attends values ('com.MM.c','co72023.T03');
insert into attends values ('com.MM.d','co72023.T04');
insert into attends values ('com.MM.pt2','co72023.T04');
insert into attends values ('com.ITeC.pt2','co72023.T05');
insert into attends values ('com.ITeC.z1','co72023.T06');
insert into attends values ('com.ITeC.z2','co72023.T06');
insert into attends values ('com.ITeC','co72026.L01');
insert into attends values ('com.ITeC.z3','co72026.L02');
insert into attends values ('com.ITeC','co72026.T01');
insert into attends values ('com.ITeC.z3','co72026.T02');
insert into attends values ('com.IS.a','co72033.L01');
insert into attends values ('com.IS.tu','co72033.L01');
insert into attends values ('com.ST.a','co72033.L01');
insert into attends values ('com.ST.tu','co72033.L01');
insert into attends values ('com.IS.a','co72033.T01');
insert into attends values ('com.IS.tu','co72033.T01');
insert into attends values ('com.ST.a','co72033.T01');
insert into attends values ('com.ST.tu','co72033.T01');
insert into attends values ('coh.HND2','coh6412255.L01');
insert into attends values ('coh.HND2','coh6412255.T01');
insert into attends values ('coh.HND2','coh8412555.L01');
--- tabattends, 301, 50
insert into attends values ('coh.HND2','coh8412555.L02');
insert into attends values ('coh.HND2','coh8412555.T01');
insert into attends values ('coh.HND2','coh8412555.T02');
insert into attends values ('coh.HND2','coh8412575.L01');
insert into attends values ('coh.HND2','coh8412575.T01');
insert into attends values ('coh.HND2','coh8412575.T02');
insert into attends values ('coh.HND1','coh8412585.L01');
insert into attends values ('coh.HND1a','coh8412585.T01');
insert into attends values ('coh.HND1b','coh8412585.T02');
insert into attends values ('coh.HND1c','coh8412585.T03');
insert into attends values ('coh.HND1','coh8412605.L01');
insert into attends values ('coh.HND1a','coh8412605.T01');
insert into attends values ('coh.HND1b','coh8412605.T02');
insert into attends values ('coh.HND1c','coh8412605.T03');
insert into attends values ('coh.HND1','coh8412615.L01');
insert into attends values ('coh.HND1a','coh8412615.T01');
insert into attends values ('coh.HND1b','coh8412615.T02');
insert into attends values ('coh.HND1c','coh8412615.T03');
insert into attends values ('coh.HND1a','coh8412615.T04');
insert into attends values ('coh.HND1b','coh8412615.T05');
insert into attends values ('coh.HND1c','coh8412615.T06');
insert into attends values ('coh.HND1','coh8412635.L01');
insert into attends values ('coh.HND1','coh8412635.L02');
insert into attends values ('coh.HND1a','coh8412635.T01');
insert into attends values ('coh.HND1b','coh8412635.T02');
insert into attends values ('coh.HND1c','coh8412635.T03');
insert into attends values ('coh.HND1a','coh8412635.T04');
insert into attends values ('coh.HND1b','coh8412635.T05');
insert into attends values ('coh.HND1c','coh8412635.T06');
insert into attends values ('coh.HND2','coh8521005.L01');
insert into attends values ('coh.HND2a','coh8521005.T01');
insert into attends values ('coh.HND2b','coh8521005.T02');
insert into attends values ('coh.HND1','coh8560095.L01');
insert into attends values ('coh.HND1a','coh8560095.T01');
insert into attends values ('coh.HND1b','coh8560095.T02');
insert into attends values ('coh.HND1c','coh8560095.T03');
--- tabteaches, 1, 50
insert into teaches values ('co.AMn','co12004.L01');
insert into teaches values ('co.RK','co12004.L01');
insert into teaches values ('co.SRM','co12004.L01');
insert into teaches values ('co.RK','co12004.L02');
insert into teaches values ('co.SRM','co12004.L02');
insert into teaches values ('co.RK','co12004.T01');
insert into teaches values ('co.SRM','co12004.T02');
insert into teaches values ('co.SRM','co12004.T03');
insert into teaches values ('co.RK','co12004.T04');
insert into teaches values ('co.AMn','co12004.T05');
insert into teaches values ('co.RK','co12004.T06');
insert into teaches values ('co.KB','co12005.L01');
insert into teaches values ('co.KB','co12005.L02');
insert into teaches values ('co.GR','co12005.T01');
insert into teaches values ('co.KB','co12005.T02');
insert into teaches values ('co.CHt','co12005.T03');
insert into teaches values ('co.EH','co12005.T04');
insert into teaches values ('co.JSv','co12005.T05');
insert into teaches values ('co.ASr','co12006.L01');
insert into teaches values ('co.JJ','co12006.L01');
insert into teaches values ('co.ASr','co12006.L02');
insert into teaches values ('co.FG','co12006.L02');
insert into teaches values ('co.JJ','co12006.L02');
insert into teaches values ('co.ASr','co12006.L03');
insert into teaches values ('co.FG','co12006.L03');
insert into teaches values ('co.JJ','co12006.L03');
insert into teaches values ('co.FG','co12006.T01');
insert into teaches values ('co.ASr','co12006.T02');
insert into teaches values ('co.JJ','co12006.T03');
insert into teaches values ('co.ASr','co12006.T04');
insert into teaches values ('co.ASr','co12006.T05');
insert into teaches values ('co.FG','co12006.T06');
insert into teaches values ('co.JKg','co12008.L01');
insert into teaches values ('co.JKg','co12008.T01');
insert into teaches values ('co.JKg','co12008.T02');
insert into teaches values ('co.ZZ1','co12011.L01');
insert into teaches values ('co.ZZ1','co12011.T01');
insert into teaches values ('co.SM','co12012.L01');
insert into teaches values ('co.SS','co12012.L01');
insert into teaches values ('co.SM','co12012.T01');
insert into teaches values ('co.SS','co12012.T01');
insert into teaches values ('co.MS','co22005.L01');
insert into teaches values ('co.ST','co22005.L01');
insert into teaches values ('co.MS','co22005.T01');
insert into teaches values ('co.MS','co22005.T02');
insert into teaches values ('co.ST','co22005.T03');
insert into teaches values ('co.ST','co22005.T04');
insert into teaches values ('co.MS','co22005.T05');
insert into teaches values ('co.MS','co22005.T06');
insert into teaches values ('co.ST','co22005.T07');
--- tabteaches, 51, 50
insert into teaches values ('co.ST','co22005.T08');
insert into teaches values ('co.ST','co22005.T09');
insert into teaches values ('co.ST','co22005.T10');
insert into teaches values ('co.JSv','co22006.L01');
insert into teaches values ('co.KB','co22006.L01');
insert into teaches values ('co.KC','co22006.L01');
insert into teaches values ('co.JSv','co22006.L02');
insert into teaches values ('co.KB','co22006.L02');
insert into teaches values ('co.KC','co22006.L02');
insert into teaches values ('co.JSv','co22006.L03');
insert into teaches values ('co.KB','co22006.L03');
insert into teaches values ('co.KC','co22006.L03');
insert into teaches values ('co.KC','co22006.T01');
insert into teaches values ('co.KC','co22006.T02');
insert into teaches values ('co.KB','co22006.T03');
insert into teaches values ('co.JSv','co22006.T04');
insert into teaches values ('co.CM','co22007.L01');
insert into teaches values ('co.TMc','co22007.L01');
insert into teaches values ('co.TMc','co22007.T01');
insert into teaches values ('co.TMc','co22007.T02');
insert into teaches values ('co.CM','co22007.T03');
insert into teaches values ('co.CM','co22007.T04');
insert into teaches values ('co.TMc','co22007.T05');
insert into teaches values ('co.CM','co22007.T06');
insert into teaches values ('co.CMD','co22008.L01');
insert into teaches values ('co.XL','co22008.L01');
insert into teaches values ('co.XL','co22008.L02');
insert into teaches values ('co.CMD','co22008.T01');
insert into teaches values ('co.XL','co22008.T02');
insert into teaches values ('co.CMD','co22008.T03');
insert into teaches values ('co.CMD','co22008.T04');
insert into teaches values ('co.XL','co22008.T05');
insert into teaches values ('co.JMy','co22009.L01');
insert into teaches values ('co.JMy','co22009.T01');
insert into teaches values ('co.JMy','co22009.T02');
insert into teaches values ('co.AFA','co22020.L01');
insert into teaches values ('co.JMz','co22020.L01');
insert into teaches values ('co.JMz','co22020.T01');
insert into teaches values ('co.JMz','co22020.T02');
insert into teaches values ('co.JMz','co22020.T03');
insert into teaches values ('co.AFA','co22020.T04');
insert into teaches values ('co.AFA','co22020.T05');
insert into teaches values ('co.SM','co22022.L01');
insert into teaches values ('co.SM','co22022.T01');
insert into teaches values ('co.MS','co32003.L01');
insert into teaches values ('co.MS','co32003.T01');
insert into teaches values ('co.PTr','co32005.L01');
insert into teaches values ('co.ST','co32005.L01');
insert into teaches values ('co.ST','co32005.T04');
insert into teaches values ('co.PTr','co32005.T05');
--- tabteaches, 101, 50
insert into teaches values ('co.AL','co32011.L01');
insert into teaches values ('co.XL','co32011.L02');
insert into teaches values ('co.AL','co32011.T01');
insert into teaches values ('co.XL','co32011.T01');
insert into teaches values ('co.AL','co32011.T02');
insert into teaches values ('co.XL','co32011.T02');
insert into teaches values ('co.AL','co32011.T03');
insert into teaches values ('co.XL','co32011.T03');
insert into teaches values ('co.TMu','co32014.L01');
insert into teaches values ('co.TMu','co32014.T01');
insert into teaches values ('co.TMu','co32014.T02');
insert into teaches values ('co.TMu','co32014.T03');
insert into teaches values ('co.KB','co32015.L01');
insert into teaches values ('co.KB','co32015.T01');
insert into teaches values ('co.MR','co32016.L01');
insert into teaches values ('co.LM','co32018.L01');
insert into teaches values ('co.SL','co32018.L01');
insert into teaches values ('co.LM','co32018.T01');
insert into teaches values ('co.SL','co32018.T01');
insert into teaches values ('co.AV','co32021.L01');
insert into teaches values ('co.BC','co32023.L01');
insert into teaches values ('co.BC','co32023.T01');
insert into teaches values ('co.SL','co42001.L01');
insert into teaches values ('co.SL','co42001.T01');
insert into teaches values ('co.IS','co42002.L01');
insert into teaches values ('co.IS','co42002.T01');
insert into teaches values ('co.PTr','co42005.L01');
insert into teaches values ('co.PTr','co42005.T01');
insert into teaches values ('co.GR','co42009.L01');
insert into teaches values ('co.JKy','co42009.L01');
insert into teaches values ('co.JKy','co42009.T01');
insert into teaches values ('co.ACg','co42010.L01');
insert into teaches values ('co.ACg','co42010.T01');
insert into teaches values ('co.ACg','co42010.T02');
insert into teaches values ('co.ACg','co12005.T01');
insert into teaches values ('co.ACg','co72023.T02');
insert into teaches values ('co.TG','co42013.L01');
insert into teaches values ('co.TG','co42013.T01');
insert into teaches values ('co.ASc','co42015.L01');
insert into teaches values ('co.RR','co42015.L01');
insert into teaches values ('co.ASc','co42015.T01');
insert into teaches values ('co.RR','co42015.T01');
insert into teaches values ('co.AL','co42019.L01');
insert into teaches values ('co.LM','co42022.L01');
insert into teaches values ('co.SL','co42022.L01');
insert into teaches values ('co.LM','co42022.T01');
insert into teaches values ('co.SL','co42022.T01');
insert into teaches values ('co.JJ','co72002.L01');
insert into teaches values ('co.JJ','co72002.T01');
insert into teaches values ('co.BC','co72003.L01');
--- tabteaches, 151, 50
insert into teaches values ('co.RK','co72003.L01');
insert into teaches values ('co.BC','co72003.T01');
insert into teaches values ('co.RK','co72003.T01');
insert into teaches values ('co.SM','co72004.L01');
insert into teaches values ('co.SM','co72004.T01');
insert into teaches values ('co.CHt','co72006.L01');
insert into teaches values ('co.CHt','co72006.T01');
insert into teaches values ('co.CM','co72011.L01');
insert into teaches values ('co.ST','co72011.L01');
insert into teaches values ('co.CM','co72011.T01');
insert into teaches values ('co.ST','co72011.T02');
insert into teaches values ('co.CM','co72011.T03');
insert into teaches values ('co.ST','co72011.T04');
insert into teaches values ('co.CM','co72011.T05');
insert into teaches values ('co.ST','co72011.T06');
insert into teaches values ('co.CM','co72011.T07');
insert into teaches values ('co.ST','co72011.T08');
insert into teaches values ('co.ST','co72011.T09');
insert into teaches values ('co.RK','co72012.L01');
insert into teaches values ('co.RK','co72012.T01');
insert into teaches values ('co.RK','co72012.T02');
insert into teaches values ('co.RK','co72012.T03');
insert into teaches values ('co.ACg','co72013.L01');
insert into teaches values ('co.KC','co72013.L01');
insert into teaches values ('co.ACg','co72013.L02');
insert into teaches values ('co.KC','co72013.L02');
insert into teaches values ('co.KC','co72013.T01');
insert into teaches values ('co.KC','co72013.T02');
insert into teaches values ('co.ACg','co72013.T03');
insert into teaches values ('co.ACg','co72013.T04');
insert into teaches values ('co.ACg','co72013.T05');
insert into teaches values ('co.KC','co72013.T06');
insert into teaches values ('co.JMz','co72016.L01');
insert into teaches values ('co.RR','co72016.L01');
insert into teaches values ('co.JMz','co72016.T01');
insert into teaches values ('co.RR','co72016.T01');
insert into teaches values ('co.JO','co72017.L01');
insert into teaches values ('co.JO','co72017.T01');
insert into teaches values ('co.JO','co72018.L01');
insert into teaches values ('co.JO','co72018.T01');
insert into teaches values ('co.JO','co72018.T02');
insert into teaches values ('co.CHt','co72021.L01');
insert into teaches values ('co.CHt','co72021.T01');
insert into teaches values ('co.IS','co72023.L01');
insert into teaches values ('co.IS','co72023.L02');
insert into teaches values ('co.IS','co72023.T01');
insert into teaches values ('co.IS','co72023.T02');
insert into teaches values ('co.IS','co72023.T03');
insert into teaches values ('co.IS','co72023.T04');
insert into teaches values ('co.IS','co72023.T05');
--- tabteaches, 201, 50
insert into teaches values ('co.IS','co72023.T06');
insert into teaches values ('co.TP','co72026.L01');
insert into teaches values ('co.XL','co72026.L01');
insert into teaches values ('co.TP','co72026.L02');
insert into teaches values ('co.XL','co72026.T01');
insert into teaches values ('co.TP','co72026.T02');
insert into teaches values ('co.ACr','co72033.L01');
insert into teaches values ('co.ACr','co72033.T01');
insert into teaches values ('co.FG','coh2451.L01');
insert into teaches values ('co.FG','coh2451.T01');
insert into teaches values ('co.ZZ8','coh6412255.L01');
insert into teaches values ('co.ZZ8','coh6412255.T01');
insert into teaches values ('co.MR','coh8412555.L01');
insert into teaches values ('co.MR','coh8412555.L02');
insert into teaches values ('co.MR','coh8412555.T01');
insert into teaches values ('co.MR','coh8412555.T02');
insert into teaches values ('co.MR','coh8412575.L01');
insert into teaches values ('co.MR','coh8412575.T01');
insert into teaches values ('co.MR','coh8412575.T02');
insert into teaches values ('co.ASr','coh8412585.L01');
insert into teaches values ('co.ASr','coh8412585.T01');
insert into teaches values ('co.ASr','coh8412585.T02');
insert into teaches values ('co.ASr','coh8412585.T03');
insert into teaches values ('co.GS','coh8412605.L01');
insert into teaches values ('co.GS','coh8412605.T01');
insert into teaches values ('co.GS','coh8412605.T02');
insert into teaches values ('co.GS','coh8412605.T03');
insert into teaches values ('co.ASr','coh8412615.L01');
insert into teaches values ('co.ASr','coh8412615.T01');
insert into teaches values ('co.ASr','coh8412615.T02');
insert into teaches values ('co.ASr','coh8412615.T03');
insert into teaches values ('co.ASr','coh8412615.T04');
insert into teaches values ('co.ASr','coh8412615.T05');
insert into teaches values ('co.ASr','coh8412615.T06');
insert into teaches values ('co.RB','coh8412635.L01');
insert into teaches values ('co.RB','coh8412635.L02');
insert into teaches values ('co.RB','coh8412635.T01');
insert into teaches values ('co.RB','coh8412635.T02');
insert into teaches values ('co.RB','coh8412635.T03');
insert into teaches values ('co.RB','coh8412635.T04');
insert into teaches values ('co.RB','coh8412635.T05');
insert into teaches values ('co.RB','coh8412635.T06');
insert into teaches values ('co.ASr','coh8521005.L01');
insert into teaches values ('co.ASr','coh8521005.T01');
insert into teaches values ('co.ASr','coh8521005.T02');
insert into teaches values ('co.ZZ7','coh8560095.L01');
insert into teaches values ('co.ZZ7','coh8560095.T01');
insert into teaches values ('co.ZZ7','coh8560095.T02');
insert into teaches values ('co.ZZ7','coh8560095.T03');

COMMIT;
