SET search_path TO sqltutor;

DROP TABLE toky      CASCADE;
DROP TABLE stanice   CASCADE; 
DROP TABLE cleneni   CASCADE;
DROP TABLE limity_cm CASCADE;
DROP TABLE vodocty   CASCADE;

--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: toky; Type: TABLE; Schema: public; Owner: cepek; Tablespace: 
--

CREATE TABLE toky (
    id integer NOT NULL,
    jmeno character varying(30)
);


--
-- Data for Name: toky; Type: TABLE DATA; Schema: public; Owner: cepek
--

INSERT INTO toky VALUES (176, 'Berounka');
INSERT INTO toky VALUES (161, 'Bečva');
INSERT INTO toky VALUES (114, 'Blanice');
INSERT INTO toky VALUES (164, 'Brodečka');
INSERT INTO toky VALUES (193, 'Brtnice');
INSERT INTO toky VALUES (190, 'Bílina');
INSERT INTO toky VALUES (156, 'Bělá');
INSERT INTO toky VALUES (187, 'Chotýšanka');
INSERT INTO toky VALUES (168, 'Chrudimka');
INSERT INTO toky VALUES (139, 'Cidlina');
INSERT INTO toky VALUES (157, 'Desná');
INSERT INTO toky VALUES (135, 'Divoká Orlice');
INSERT INTO toky VALUES (180, 'Doubrava');
INSERT INTO toky VALUES (119, 'Dyje');
INSERT INTO toky VALUES (138, 'Dědina');
INSERT INTO toky VALUES (196, 'Dřevnice');
INSERT INTO toky VALUES (163, 'Hloučela');
INSERT INTO toky VALUES (121, 'Jevišovka');
INSERT INTO toky VALUES (126, 'Jihlava');
INSERT INTO toky VALUES (142, 'Jizera');
INSERT INTO toky VALUES (143, 'Jizerka');
INSERT INTO toky VALUES (144, 'Kamenice');
INSERT INTO toky VALUES (178, 'Klabava');
INSERT INTO toky VALUES (184, 'Kocába');
INSERT INTO toky VALUES (170, 'Křemelná');
INSERT INTO toky VALUES (131, 'Labe');
INSERT INTO toky VALUES (189, 'Litavka');
INSERT INTO toky VALUES (115, 'Lomnice');
INSERT INTO toky VALUES (154, 'Lomná');
INSERT INTO toky VALUES (122, 'Loučka/Bobrůvka');
INSERT INTO toky VALUES (166, 'Loučná');
INSERT INTO toky VALUES (148, 'Lubina');
INSERT INTO toky VALUES (145, 'Lužická Nisa');
INSERT INTO toky VALUES (108, 'Lužnice');
INSERT INTO toky VALUES (106, 'Malše');
INSERT INTO toky VALUES (183, 'Mastník');
INSERT INTO toky VALUES (133, 'Metuje');
INSERT INTO toky VALUES (118, 'Morava');
INSERT INTO toky VALUES (151, 'Moravice');
INSERT INTO toky VALUES (117, 'Moravská Dyje');
INSERT INTO toky VALUES (158, 'Moravská Sázava');
INSERT INTO toky VALUES (181, 'Mrlina');
INSERT INTO toky VALUES (172, 'Mže');
INSERT INTO toky VALUES (109, 'Nežárka');
INSERT INTO toky VALUES (167, 'Novohradka');
INSERT INTO toky VALUES (147, 'Odra');
INSERT INTO toky VALUES (127, 'Ohře');
INSERT INTO toky VALUES (197, 'Olšava');
INSERT INTO toky VALUES (153, 'Olše');
INSERT INTO toky VALUES (149, 'Opava');
INSERT INTO toky VALUES (150, 'Opavice');
INSERT INTO toky VALUES (137, 'Orlice');
INSERT INTO toky VALUES (160, 'Oskava');
INSERT INTO toky VALUES (125, 'Oslava');
INSERT INTO toky VALUES (155, 'Osoblaha');
INSERT INTO toky VALUES (152, 'Ostravice');
INSERT INTO toky VALUES (171, 'Ostružná');
INSERT INTO toky VALUES (111, 'Otava');
INSERT INTO toky VALUES (141, 'Ploučnice');
INSERT INTO toky VALUES (104, 'Polečnice');
INSERT INTO toky VALUES (174, 'Radbuza');
INSERT INTO toky VALUES (129, 'Rolava');
INSERT INTO toky VALUES (162, 'Romže (Valová)');
INSERT INTO toky VALUES (195, 'Rožnovská Bečva');
INSERT INTO toky VALUES (116, 'Skalice');
INSERT INTO toky VALUES (110, 'Smutná (Cedron)');
INSERT INTO toky VALUES (146, 'Smědá');
INSERT INTO toky VALUES (112, 'Spůlka');
INSERT INTO toky VALUES (107, 'Stropnice');
INSERT INTO toky VALUES (103, 'Studená Vltava');
INSERT INTO toky VALUES (140, 'Stěnava');
INSERT INTO toky VALUES (179, 'Střela');
INSERT INTO toky VALUES (128, 'Svatava');
INSERT INTO toky VALUES (124, 'Svitava');
INSERT INTO toky VALUES (123, 'Svratka');
INSERT INTO toky VALUES (185, 'Sázava');
INSERT INTO toky VALUES (192, 'Sázavka');
INSERT INTO toky VALUES (130, 'Teplá');
INSERT INTO toky VALUES (102, 'Teplá Vltava');
INSERT INTO toky VALUES (136, 'Tichá Orlice');
INSERT INTO toky VALUES (165, 'Třebovka');
INSERT INTO toky VALUES (159, 'Třebůvka');
INSERT INTO toky VALUES (101, 'Vltava');
INSERT INTO toky VALUES (113, 'Volyňka');
INSERT INTO toky VALUES (194, 'Vsetínská Bečva');
INSERT INTO toky VALUES (169, 'Vydra');
INSERT INTO toky VALUES (182, 'Výrovka');
INSERT INTO toky VALUES (134, 'Zdobnice');
INSERT INTO toky VALUES (175, 'Úhlava');
INSERT INTO toky VALUES (132, 'Úpa');
INSERT INTO toky VALUES (177, 'Úslava');
INSERT INTO toky VALUES (173, 'Úterský potok');
INSERT INTO toky VALUES (105, 'Černá');
INSERT INTO toky VALUES (188, 'Červený potok');
INSERT INTO toky VALUES (191, 'Šlapanka');
INSERT INTO toky VALUES (120, 'Želetavka');
INSERT INTO toky VALUES (186, 'Želivka');


--
-- Name: toky_pkey; Type: CONSTRAINT; Schema: public; Owner: cepek; Tablespace: 
--

ALTER TABLE ONLY toky
    ADD CONSTRAINT toky_pkey PRIMARY KEY (id);


--
-- PostgreSQL database dump complete
--

--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: stanice; Type: TABLE; Schema: public; Owner: cepek; Tablespace: 
--

CREATE TABLE stanice (
    id integer NOT NULL,
    nazev character varying(30)
);


--
-- Data for Name: stanice; Type: TABLE DATA; Schema: public; Owner: cepek
--

INSERT INTO stanice VALUES (1148, 'Bakov nad Jizerou');
INSERT INTO stanice VALUES (1183, 'Batelov');
INSERT INTO stanice VALUES (1024, 'Bechyně');
INSERT INTO stanice VALUES (1173, 'Benešov nad Ploučnicí');
INSERT INTO stanice VALUES (1166, 'Beroun');
INSERT INTO stanice VALUES (1028, 'Blanický mlýn');
INSERT INTO stanice VALUES (1026, 'Bohumilice');
INSERT INTO stanice VALUES (1096, 'Bohumín');
INSERT INTO stanice VALUES (1078, 'Bohuňovsko-Jesenný');
INSERT INTO stanice VALUES (1042, 'Božice');
INSERT INTO stanice VALUES (1150, 'Brandýs nad Labem');
INSERT INTO stanice VALUES (1092, 'Branka u Opavy');
INSERT INTO stanice VALUES (1186, 'Bransouze');
INSERT INTO stanice VALUES (1045, 'Brno - Poříčí');
INSERT INTO stanice VALUES (1185, 'Brtnice');
INSERT INTO stanice VALUES (1047, 'Bílovice nad Svitavou');
INSERT INTO stanice VALUES (1136, 'Bílá Hora');
INSERT INTO stanice VALUES (1083, 'Bílý Potok');
INSERT INTO stanice VALUES (1009, 'Březí');
INSERT INTO stanice VALUES (1118, 'Cerekvice nad Loučnou');
INSERT INTO stanice VALUES (1005, 'Chlum');
INSERT INTO stanice VALUES (1176, 'Chlístov');
INSERT INTO stanice VALUES (1068, 'Chábory');
INSERT INTO stanice VALUES (1181, 'Dalečín');
INSERT INTO stanice VALUES (1111, 'Dluhonice');
INSERT INTO stanice VALUES (1115, 'Dolní Libchavy');
INSERT INTO stanice VALUES (1043, 'Dolní Loučky');
INSERT INTO stanice VALUES (1033, 'Dolní Ostrovec');
INSERT INTO stanice VALUES (1077, 'Dolní Sytová');
INSERT INTO stanice VALUES (1076, 'Dolní Štěpanice');
INSERT INTO stanice VALUES (1184, 'Dvorce');
INSERT INTO stanice VALUES (1093, 'Děhylov');
INSERT INTO stanice VALUES (1197, 'Děčín');
INSERT INTO stanice VALUES (1018, 'Frahelž');
INSERT INTO stanice VALUES (1084, 'Frýdlant');
INSERT INTO stanice VALUES (1021, 'Hamr');
INSERT INTO stanice VALUES (1031, 'Heřmaň');
INSERT INTO stanice VALUES (1059, 'Horní Maršov');
INSERT INTO stanice VALUES (1165, 'Hořovice');
INSERT INTO stanice VALUES (1139, 'Hrádek');
INSERT INTO stanice VALUES (1082, 'Hrádek nad Nisou');
INSERT INTO stanice VALUES (1030, 'Husinec');
INSERT INTO stanice VALUES (1116, 'Hylváty');
INSERT INTO stanice VALUES (1174, 'Hřensko - Labe');
INSERT INTO stanice VALUES (1050, 'Ivančice');
INSERT INTO stanice VALUES (1075, 'Jablonec nad Jizerou');
INSERT INTO stanice VALUES (1097, 'Jablunkov');
INSERT INTO stanice VALUES (1035, 'Janov');
INSERT INTO stanice VALUES (1061, 'Jaroměř');
INSERT INTO stanice VALUES (1180, 'Jemnice');
INSERT INTO stanice VALUES (1070, 'Jičín');
INSERT INTO stanice VALUES (1177, 'Josefodol');
INSERT INTO stanice VALUES (1089, 'Karlovice');
INSERT INTO stanice VALUES (1057, 'Karlovy Vary - Drahovice');
INSERT INTO stanice VALUES (1025, 'Katovice');
INSERT INTO stanice VALUES (1022, 'Klenovice');
INSERT INTO stanice VALUES (1127, 'Kolinec');
INSERT INTO stanice VALUES (1151, 'Kostelec nad Labem');
INSERT INTO stanice VALUES (1065, 'Kostelec nad Orlicí');
INSERT INTO stanice VALUES (1138, 'Koterov');
INSERT INTO stanice VALUES (1090, 'Krnov');
INSERT INTO stanice VALUES (1191, 'Kroměříž');
INSERT INTO stanice VALUES (1063, 'Krčín');
INSERT INTO stanice VALUES (1157, 'Kácov');
INSERT INTO stanice VALUES (1052, 'Ladná');
INSERT INTO stanice VALUES (1004, 'Lenora');
INSERT INTO stanice VALUES (1046, 'Letovice');
INSERT INTO stanice VALUES (1133, 'Lhota');
INSERT INTO stanice VALUES (1081, 'Liberec');
INSERT INTO stanice VALUES (1160, 'Libež');
INSERT INTO stanice VALUES (1142, 'Liblín');
INSERT INTO stanice VALUES (1010, 'Ličov');
INSERT INTO stanice VALUES (1170, 'Louny');
INSERT INTO stanice VALUES (1158, 'Louňovice pod Blaníkem');
INSERT INTO stanice VALUES (1107, 'Loštice');
INSERT INTO stanice VALUES (1105, 'Lupěné');
INSERT INTO stanice VALUES (1020, 'Lásenice');
INSERT INTO stanice VALUES (1062, 'Maršov nad Metují');
INSERT INTO stanice VALUES (1072, 'Meziměstí');
INSERT INTO stanice VALUES (1101, 'Mikulovice');
INSERT INTO stanice VALUES (1074, 'Mimoň');
INSERT INTO stanice VALUES (1069, 'Mitrov');
INSERT INTO stanice VALUES (1123, 'Modrava');
INSERT INTO stanice VALUES (1106, 'Moravičany');
INSERT INTO stanice VALUES (1175, 'Mírovka');
INSERT INTO stanice VALUES (1169, 'Mělník');
INSERT INTO stanice VALUES (1120, 'Nemošice');
INSERT INTO stanice VALUES (1155, 'Nesměřice');
INSERT INTO stanice VALUES (1162, 'Nespeky');
INSERT INTO stanice VALUES (1140, 'Nová Huť');
INSERT INTO stanice VALUES (1016, 'Nová Ves nad Lužnicí');
INSERT INTO stanice VALUES (1071, 'Nový Bydžov');
INSERT INTO stanice VALUES (1146, 'Nymburk');
INSERT INTO stanice VALUES (1117, 'Němčice');
INSERT INTO stanice VALUES (1027, 'Němětice');
INSERT INTO stanice VALUES (1086, 'Odry');
INSERT INTO stanice VALUES (1109, 'Olomouc - Nové Sady');
INSERT INTO stanice VALUES (1091, 'Opava');
INSERT INTO stanice VALUES (1049, 'Oslavany');
INSERT INTO stanice VALUES (1100, 'Osoblaha');
INSERT INTO stanice VALUES (1095, 'Ostrava');
INSERT INTO stanice VALUES (1114, 'Otaslavice');
INSERT INTO stanice VALUES (1073, 'Otovice');
INSERT INTO stanice VALUES (1013, 'Pašinovice');
INSERT INTO stanice VALUES (1087, 'Petřvald');
INSERT INTO stanice VALUES (1017, 'Pilař');
INSERT INTO stanice VALUES (1141, 'Plasy');
INSERT INTO stanice VALUES (1147, 'Plaňany');
INSERT INTO stanice VALUES (1029, 'Podedvory');
INSERT INTO stanice VALUES (1037, 'Podhradí nad Dyjí');
INSERT INTO stanice VALUES (1011, 'Pořešín');
INSERT INTO stanice VALUES (1002, 'Praha - Chuchle');
INSERT INTO stanice VALUES (1003, 'Praha - Na Františku');
INSERT INTO stanice VALUES (1032, 'Písek');
INSERT INTO stanice VALUES (1085, 'Předlánce');
INSERT INTO stanice VALUES (1149, 'Předměřice nad Jizerou');
INSERT INTO stanice VALUES (1121, 'Přelouč');
INSERT INTO stanice VALUES (1196, 'Raabs');
INSERT INTO stanice VALUES (1161, 'Radonice I');
INSERT INTO stanice VALUES (1152, 'Radíč');
INSERT INTO stanice VALUES (1023, 'Rataje');
INSERT INTO stanice VALUES (1103, 'Raškov');
INSERT INTO stanice VALUES (1125, 'Rejštejn');
INSERT INTO stanice VALUES (1019, 'Rodvínov');
INSERT INTO stanice VALUES (1014, 'Roudné');
INSERT INTO stanice VALUES (1122, 'Rozhraní');
INSERT INTO stanice VALUES (1195, 'Schwarzenau');
INSERT INTO stanice VALUES (1064, 'Slatina nad Zdobnicí');
INSERT INTO stanice VALUES (1159, 'Slověnice');
INSERT INTO stanice VALUES (1156, 'Soutice');
INSERT INTO stanice VALUES (1193, 'Spytihněv');
INSERT INTO stanice VALUES (1167, 'Srbsko');
INSERT INTO stanice VALUES (1055, 'Stará Role');
INSERT INTO stanice VALUES (1132, 'Staňkov');
INSERT INTO stanice VALUES (1124, 'Stodůlky');
INSERT INTO stanice VALUES (1112, 'Stražisko');
INSERT INTO stanice VALUES (1036, 'Strážnice');
INSERT INTO stanice VALUES (1128, 'Stříbro');
INSERT INTO stanice VALUES (1126, 'Sušice');
INSERT INTO stanice VALUES (1054, 'Svatava');
INSERT INTO stanice VALUES (1094, 'Sviadnov');
INSERT INTO stanice VALUES (1088, 'Svinov');
INSERT INTO stanice VALUES (1178, 'Světlá nad Sázavou');
INSERT INTO stanice VALUES (1144, 'Sány');
INSERT INTO stanice VALUES (1134, 'Tajanov');
INSERT INTO stanice VALUES (1131, 'Tasnovice');
INSERT INTO stanice VALUES (1110, 'Teplice nad Bečvou');
INSERT INTO stanice VALUES (1172, 'Trmice');
INSERT INTO stanice VALUES (1129, 'Trpísty');
INSERT INTO stanice VALUES (1041, 'Trávní Dvůr');
INSERT INTO stanice VALUES (1067, 'Týniště nad Orlicí');
INSERT INTO stanice VALUES (1187, 'Třebíč - Ptáčov');
INSERT INTO stanice VALUES (1194, 'Uherský Brod');
INSERT INTO stanice VALUES (1108, 'Uničov');
INSERT INTO stanice VALUES (1056, 'VD Březová');
INSERT INTO stanice VALUES (1130, 'VD Hracholusky');
INSERT INTO stanice VALUES (1188, 'VD Mohelno');
INSERT INTO stanice VALUES (1051, 'VD Nové Mlýny');
INSERT INTO stanice VALUES (1113, 'VD Plumlov');
INSERT INTO stanice VALUES (1053, 'VD Skalka');
INSERT INTO stanice VALUES (1163, 'VD Vrané');
INSERT INTO stanice VALUES (1182, 'VD Vír');
INSERT INTO stanice VALUES (1040, 'VD Znojmo');
INSERT INTO stanice VALUES (1190, 'Valašské Meziříčí');
INSERT INTO stanice VALUES (1034, 'Varvažov');
INSERT INTO stanice VALUES (1145, 'Vestec');
INSERT INTO stanice VALUES (1058, 'Vestřev');
INSERT INTO stanice VALUES (1044, 'Veverská Bítýška');
INSERT INTO stanice VALUES (1102, 'Vlaské');
INSERT INTO stanice VALUES (1039, 'Vranov - Hamry');
INSERT INTO stanice VALUES (1168, 'Vraňany');
INSERT INTO stanice VALUES (1189, 'Vsetín');
INSERT INTO stanice VALUES (1038, 'Vysočany');
INSERT INTO stanice VALUES (1007, 'Vyšší Brod');
INSERT INTO stanice VALUES (1099, 'Věřňovice');
INSERT INTO stanice VALUES (1164, 'Zbečno');
INSERT INTO stanice VALUES (1001, 'Zbraslav');
INSERT INTO stanice VALUES (1192, 'Zlín');
INSERT INTO stanice VALUES (1154, 'Zruč nad Sázavou');
INSERT INTO stanice VALUES (1119, 'Úhřetice');
INSERT INTO stanice VALUES (1171, 'Ústí nad Labem');
INSERT INTO stanice VALUES (1066, 'Čermná nad Orlicí');
INSERT INTO stanice VALUES (1006, 'Černý Kříž');
INSERT INTO stanice VALUES (1080, 'Česká Lípa');
INSERT INTO stanice VALUES (1060, 'Česká Skalice');
INSERT INTO stanice VALUES (1015, 'České Budějovice');
INSERT INTO stanice VALUES (1008, 'Český Krumlov');
INSERT INTO stanice VALUES (1098, 'Český Těšín');
INSERT INTO stanice VALUES (1012, 'Římov');
INSERT INTO stanice VALUES (1153, 'Štěchovice');
INSERT INTO stanice VALUES (1135, 'Štěnovice');
INSERT INTO stanice VALUES (1104, 'Šumperk');
INSERT INTO stanice VALUES (1137, 'Ždírec');
INSERT INTO stanice VALUES (1079, 'Železný Brod');
INSERT INTO stanice VALUES (1179, 'Želiv');
INSERT INTO stanice VALUES (1048, 'Židlochovice');
INSERT INTO stanice VALUES (1143, 'Žleby');


--
-- Name: stanice_pkey; Type: CONSTRAINT; Schema: public; Owner: cepek; Tablespace: 
--

ALTER TABLE ONLY stanice
    ADD CONSTRAINT stanice_pkey PRIMARY KEY (id);


--
-- PostgreSQL database dump complete
--

--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: cleneni; Type: TABLE; Schema: public; Owner: cepek; Tablespace: 
--

CREATE TABLE cleneni (
    tok_id integer,
    stanice_id integer,
    kraj character varying(31),
    pobocka character varying(32),
    povodi character varying(33)
);


--
-- Data for Name: cleneni; Type: TABLE DATA; Schema: public; Owner: cepek
--

INSERT INTO cleneni VALUES (101, 1001, 'Hlavní město Praha', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (101, 1002, 'Hlavní město Praha', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (101, 1003, 'Hlavní město Praha', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (101, 1007, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (101, 1009, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (101, 1015, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (101, 1163, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (101, 1168, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (102, 1004, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (102, 1005, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (103, 1006, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (104, 1008, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (105, 1010, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (106, 1011, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (106, 1012, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (106, 1014, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (107, 1013, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (108, 1016, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (108, 1017, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (108, 1018, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (108, 1022, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (108, 1024, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (109, 1019, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (109, 1020, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (109, 1021, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (110, 1023, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (111, 1025, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (111, 1032, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (111, 1125, 'Plzeňský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (111, 1126, 'Plzeňský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (112, 1026, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (113, 1027, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (114, 1028, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (114, 1029, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (114, 1030, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (114, 1031, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (114, 1158, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (114, 1161, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (115, 1033, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (116, 1034, 'Jihočeský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (117, 1035, 'Jihočeský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (118, 1036, 'Jihomoravský kraj', 'Brno', 'Morava');
INSERT INTO cleneni VALUES (118, 1102, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (118, 1103, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (118, 1106, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (118, 1109, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (118, 1191, 'Zlínský kraj', 'Brno', 'Morava');
INSERT INTO cleneni VALUES (118, 1193, 'Zlínský kraj', 'Brno', 'Morava');
INSERT INTO cleneni VALUES (119, 1037, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (119, 1039, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (119, 1040, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (119, 1041, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (119, 1051, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (119, 1052, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (119, 1195, NULL, 'Brno', NULL);
INSERT INTO cleneni VALUES (119, 1196, NULL, 'Brno', NULL);
INSERT INTO cleneni VALUES (120, 1038, 'Jihomoravský kraj', 'Brno', NULL);
INSERT INTO cleneni VALUES (120, 1180, 'Vysočina', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (121, 1042, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (122, 1043, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (123, 1044, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (123, 1045, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (123, 1048, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (123, 1181, 'Vysočina', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (123, 1182, 'Vysočina', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (124, 1046, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (124, 1047, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (124, 1122, 'Pardubický kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (125, 1049, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (126, 1050, 'Jihomoravský kraj', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (126, 1183, 'Vysočina', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (126, 1184, 'Vysočina', 'Brno', NULL);
INSERT INTO cleneni VALUES (126, 1186, 'Vysočina', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (126, 1187, 'Vysočina', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (126, 1188, 'Vysočina', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (127, 1053, 'Karlovarský kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (127, 1057, 'Karlovarský kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (127, 1170, 'Ústecký kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (128, 1054, 'Karlovarský kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (129, 1055, 'Karlovarský kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (130, 1056, 'Karlovarský kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (131, 1058, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (131, 1061, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (131, 1117, 'Pardubický kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (131, 1121, 'Pardubický kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (131, 1146, 'Středočeský kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (131, 1150, 'Středočeský kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (131, 1151, 'Středočeský kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (131, 1169, 'Středočeský kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (131, 1171, 'Ústecký kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (131, 1174, 'Ústecký kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (131, 1197, NULL, 'Praha', 'Labe');
INSERT INTO cleneni VALUES (132, 1059, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (132, 1060, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (133, 1062, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (133, 1063, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (134, 1064, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (135, 1065, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (136, 1066, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (136, 1115, 'Pardubický kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (137, 1067, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (138, 1068, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (138, 1069, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (139, 1070, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (139, 1071, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (139, 1144, 'Středočeský kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (140, 1072, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (140, 1073, 'Královéhradecký kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (141, 1074, 'Liberecký kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (141, 1080, 'Liberecký kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (141, 1173, 'Ústecký kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (142, 1075, 'Liberecký kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (142, 1077, 'Liberecký kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (142, 1079, 'Liberecký kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (142, 1148, 'Středočeský kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (142, 1149, 'Středočeský kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (143, 1076, 'Liberecký kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (144, 1078, 'Liberecký kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (145, 1081, 'Liberecký kraj', 'Ústí nad Labem', 'Labe');
INSERT INTO cleneni VALUES (145, 1082, 'Liberecký kraj', 'Ústí nad Labem', 'Labe');
INSERT INTO cleneni VALUES (146, 1083, 'Liberecký kraj', 'Ústí nad Labem', 'Labe');
INSERT INTO cleneni VALUES (146, 1084, 'Liberecký kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (146, 1085, 'Liberecký kraj', 'Ústí nad Labem', 'Labe');
INSERT INTO cleneni VALUES (147, 1086, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (147, 1088, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (147, 1096, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (148, 1087, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (149, 1089, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (149, 1090, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (149, 1091, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (149, 1093, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (150, 1090, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (151, 1092, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (152, 1094, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (152, 1095, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (153, 1097, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (153, 1098, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (153, 1099, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (154, 1097, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (155, 1100, 'Moravskoslezský kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (156, 1101, 'Olomoucký kraj', 'Ostrava', 'Odra');
INSERT INTO cleneni VALUES (157, 1104, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (158, 1105, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (159, 1107, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (160, 1108, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (161, 1110, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (161, 1111, 'Olomoucký kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (162, 1112, 'Olomoucký kraj', 'Brno', 'Morava');
INSERT INTO cleneni VALUES (163, 1113, 'Olomoucký kraj', 'Brno', 'Morava');
INSERT INTO cleneni VALUES (164, 1114, 'Olomoucký kraj', 'Brno', 'Morava');
INSERT INTO cleneni VALUES (165, 1116, 'Pardubický kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (166, 1118, 'Pardubický kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (167, 1119, 'Pardubický kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (168, 1120, 'Pardubický kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (169, 1123, 'Plzeňský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (170, 1124, 'Plzeňský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (171, 1127, 'Plzeňský kraj', 'České Budějovice', 'Horní Vltava');
INSERT INTO cleneni VALUES (172, 1128, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (172, 1130, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (173, 1129, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (174, 1131, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (174, 1132, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (174, 1133, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (175, 1134, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (175, 1135, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (176, 1136, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (176, 1142, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (176, 1164, 'Středočeský kraj', 'Praha', 'Berounka');
INSERT INTO cleneni VALUES (176, 1166, 'Středočeský kraj', 'Praha', 'Berounka');
INSERT INTO cleneni VALUES (176, 1167, 'Středočeský kraj', 'Praha', 'Berounka');
INSERT INTO cleneni VALUES (177, 1137, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (177, 1138, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (178, 1139, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (178, 1140, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (179, 1141, 'Plzeňský kraj', 'Plzeň', 'Berounka');
INSERT INTO cleneni VALUES (180, 1143, 'Středočeský kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (181, 1145, 'Středočeský kraj', 'Hradec Králové', 'Labe');
INSERT INTO cleneni VALUES (182, 1147, 'Středočeský kraj', 'Praha', 'Labe');
INSERT INTO cleneni VALUES (183, 1152, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (184, 1153, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (185, 1154, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (185, 1157, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (185, 1162, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (185, 1176, 'Vysočina', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (185, 1178, 'Vysočina', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (186, 1155, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (186, 1156, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (186, 1179, 'Vysočina', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (187, 1159, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (187, 1160, 'Středočeský kraj', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (188, 1165, 'Středočeský kraj', 'Praha', 'Berounka');
INSERT INTO cleneni VALUES (189, 1166, 'Středočeský kraj', 'Praha', 'Berounka');
INSERT INTO cleneni VALUES (190, 1172, 'Ústecký kraj', 'Ústí nad Labem', 'Ohře');
INSERT INTO cleneni VALUES (191, 1175, 'Vysočina', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (192, 1177, 'Vysočina', 'Praha', 'Dolní Vltava');
INSERT INTO cleneni VALUES (193, 1185, 'Vysočina', 'Brno', 'Dyje');
INSERT INTO cleneni VALUES (194, 1189, 'Zlínský kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (195, 1190, 'Zlínský kraj', 'Ostrava', 'Morava');
INSERT INTO cleneni VALUES (196, 1192, 'Zlínský kraj', 'Brno', 'Morava');
INSERT INTO cleneni VALUES (197, 1194, 'Zlínský kraj', 'Brno', 'Morava');


--
-- Name: cleneni_stanice_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: cepek
--

ALTER TABLE ONLY cleneni
    ADD CONSTRAINT cleneni_stanice_id_fkey FOREIGN KEY (stanice_id) REFERENCES stanice(id);


--
-- Name: cleneni_tok_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: cepek
--

ALTER TABLE ONLY cleneni
    ADD CONSTRAINT cleneni_tok_id_fkey FOREIGN KEY (tok_id) REFERENCES toky(id);


--
-- PostgreSQL database dump complete
--

--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: limity_cm; Type: TABLE; Schema: public; Owner: cepek; Tablespace: 
--

CREATE TABLE limity_cm (
    tok_id integer,
    stanice_id integer,
    bdelost real,
    pohotovost real,
    ohrozeni real
);


--
-- Data for Name: limity_cm; Type: TABLE DATA; Schema: public; Owner: cepek
--

INSERT INTO limity_cm VALUES (102, 1004, 120, 155, 190);
INSERT INTO limity_cm VALUES (102, 1005, 190, 230, 265);
INSERT INTO limity_cm VALUES (103, 1006, 175, 200, 250);
INSERT INTO limity_cm VALUES (101, 1007, 185, 210, 260);
INSERT INTO limity_cm VALUES (104, 1008, 100, 140, 170);
INSERT INTO limity_cm VALUES (101, 1009, 170, 200, 230);
INSERT INTO limity_cm VALUES (105, 1010, 100, 140, 170);
INSERT INTO limity_cm VALUES (106, 1011, 110, 155, 190);
INSERT INTO limity_cm VALUES (107, 1013, 150, 200, 250);
INSERT INTO limity_cm VALUES (106, 1014, 160, 210, 270);
INSERT INTO limity_cm VALUES (101, 1015, 220, 250, 400);
INSERT INTO limity_cm VALUES (108, 1016, 150, 180, 210);
INSERT INTO limity_cm VALUES (108, 1017, 300, 350, 400);
INSERT INTO limity_cm VALUES (108, 1018, 170, 200, 240);
INSERT INTO limity_cm VALUES (109, 1019, 100, 130, 160);
INSERT INTO limity_cm VALUES (109, 1020, 150, 190, 230);
INSERT INTO limity_cm VALUES (109, 1021, 270, 320, 350);
INSERT INTO limity_cm VALUES (108, 1022, 190, 240, 300);
INSERT INTO limity_cm VALUES (110, 1023, 170, 210, 250);
INSERT INTO limity_cm VALUES (108, 1024, 240, 290, 330);
INSERT INTO limity_cm VALUES (111, 1025, 180, 220, 280);
INSERT INTO limity_cm VALUES (112, 1026, 210, 250, 290);
INSERT INTO limity_cm VALUES (113, 1027, 190, 230, 270);
INSERT INTO limity_cm VALUES (114, 1028, 120, 160, 180);
INSERT INTO limity_cm VALUES (114, 1029, 110, 140, 160);
INSERT INTO limity_cm VALUES (114, 1030, 95, 115, 130);
INSERT INTO limity_cm VALUES (114, 1031, 110, 150, 180);
INSERT INTO limity_cm VALUES (111, 1032, 250, 320, 380);
INSERT INTO limity_cm VALUES (115, 1033, 145, 175, 220);
INSERT INTO limity_cm VALUES (116, 1034, 150, 180, 250);
INSERT INTO limity_cm VALUES (117, 1035, 150, 180, 220);
INSERT INTO limity_cm VALUES (118, 1036, 450, 550, 650);
INSERT INTO limity_cm VALUES (119, 1037, 150, 200, 250);
INSERT INTO limity_cm VALUES (120, 1038, 100, 150, 180);
INSERT INTO limity_cm VALUES (119, 1039, 150, 180, 230);
INSERT INTO limity_cm VALUES (119, 1040, 195, 230, 290);
INSERT INTO limity_cm VALUES (119, 1041, 300, 400, 500);
INSERT INTO limity_cm VALUES (121, 1042, 210, 250, 290);
INSERT INTO limity_cm VALUES (122, 1043, 180, 230, 280);
INSERT INTO limity_cm VALUES (123, 1044, 190, 240, 300);
INSERT INTO limity_cm VALUES (123, 1045, 100, 160, 260);
INSERT INTO limity_cm VALUES (124, 1046, 100, 130, 170);
INSERT INTO limity_cm VALUES (124, 1047, 200, 270, 350);
INSERT INTO limity_cm VALUES (123, 1048, 250, 300, 350);
INSERT INTO limity_cm VALUES (125, 1049, 200, 230, 260);
INSERT INTO limity_cm VALUES (126, 1050, 270, 320, 380);
INSERT INTO limity_cm VALUES (128, 1054, 120, 250, 320);
INSERT INTO limity_cm VALUES (129, 1055, 160, 195, 220);
INSERT INTO limity_cm VALUES (127, 1057, 190, 230, 270);
INSERT INTO limity_cm VALUES (131, 1058, 110, 135, 160);
INSERT INTO limity_cm VALUES (132, 1059, 110, 130, 160);
INSERT INTO limity_cm VALUES (132, 1060, 150, 200, 260);
INSERT INTO limity_cm VALUES (133, 1062, 90, 120, 150);
INSERT INTO limity_cm VALUES (133, 1063, 110, 160, 210);
INSERT INTO limity_cm VALUES (134, 1064, 120, 145, 170);
INSERT INTO limity_cm VALUES (135, 1065, 180, 230, 280);
INSERT INTO limity_cm VALUES (136, 1066, 180, 250, 310);
INSERT INTO limity_cm VALUES (137, 1067, 300, 330, 360);
INSERT INTO limity_cm VALUES (138, 1068, 100, 130, 160);
INSERT INTO limity_cm VALUES (138, 1069, 180, 200, 230);
INSERT INTO limity_cm VALUES (139, 1070, 55, 70, 80);
INSERT INTO limity_cm VALUES (139, 1071, 150, 190, 230);
INSERT INTO limity_cm VALUES (140, 1072, 70, 90, 110);
INSERT INTO limity_cm VALUES (140, 1073, 140, 170, 200);
INSERT INTO limity_cm VALUES (141, 1074, 90, 120, 145);
INSERT INTO limity_cm VALUES (142, 1075, 150, 180, 210);
INSERT INTO limity_cm VALUES (143, 1076, 140, 165, 190);
INSERT INTO limity_cm VALUES (142, 1077, 180, 240, 320);
INSERT INTO limity_cm VALUES (142, 1079, 220, 310, 370);
INSERT INTO limity_cm VALUES (141, 1080, 70, 90, 110);
INSERT INTO limity_cm VALUES (145, 1081, 85, 125, 160);
INSERT INTO limity_cm VALUES (145, 1082, 175, 210, 240);
INSERT INTO limity_cm VALUES (146, 1083, 80, 100, 120);
INSERT INTO limity_cm VALUES (146, 1084, 130, 150, 160);
INSERT INTO limity_cm VALUES (146, 1085, 200, 220, 240);
INSERT INTO limity_cm VALUES (147, 1086, 200, 230, 260);
INSERT INTO limity_cm VALUES (148, 1087, 100, 150, 180);
INSERT INTO limity_cm VALUES (147, 1088, 280, 330, 380);
INSERT INTO limity_cm VALUES (149, 1089, 100, 150, 170);
INSERT INTO limity_cm VALUES (149, 1090, 120, 200, 220);
INSERT INTO limity_cm VALUES (150, 1090, 140, 170, 210);
INSERT INTO limity_cm VALUES (149, 1091, 200, 250, 300);
INSERT INTO limity_cm VALUES (151, 1092, 150, 200, 240);
INSERT INTO limity_cm VALUES (149, 1093, 210, 265, 320);
INSERT INTO limity_cm VALUES (152, 1094, 280, 330, 380);
INSERT INTO limity_cm VALUES (152, 1095, 230, 310, 530);
INSERT INTO limity_cm VALUES (147, 1096, 300, 400, 500);
INSERT INTO limity_cm VALUES (153, 1097, 220, 270, 320);
INSERT INTO limity_cm VALUES (154, 1097, 140, 170, 210);
INSERT INTO limity_cm VALUES (153, 1098, 280, 330, 400);
INSERT INTO limity_cm VALUES (153, 1099, 300, 430, 490);
INSERT INTO limity_cm VALUES (155, 1100, 190, 230, 270);
INSERT INTO limity_cm VALUES (156, 1101, 170, 190, 220);
INSERT INTO limity_cm VALUES (118, 1102, 190, 220, 250);
INSERT INTO limity_cm VALUES (118, 1103, 180, 220, 250);
INSERT INTO limity_cm VALUES (157, 1104, 170, 220, 260);
INSERT INTO limity_cm VALUES (158, 1105, 150, 200, 250);
INSERT INTO limity_cm VALUES (118, 1106, 200, 250, 300);
INSERT INTO limity_cm VALUES (159, 1107, 170, 200, 250);
INSERT INTO limity_cm VALUES (160, 1108, 250, 270, 300);
INSERT INTO limity_cm VALUES (118, 1109, 360, 390, 430);
INSERT INTO limity_cm VALUES (161, 1110, 260, 330, 400);
INSERT INTO limity_cm VALUES (161, 1111, 370, 450, 530);
INSERT INTO limity_cm VALUES (162, 1112, 50, 70, 90);
INSERT INTO limity_cm VALUES (163, 1113, 50, 70, 90);
INSERT INTO limity_cm VALUES (164, 1114, 150, 180, 200);
INSERT INTO limity_cm VALUES (136, 1115, 235, 280, 320);
INSERT INTO limity_cm VALUES (165, 1116, 120, 140, 160);
INSERT INTO limity_cm VALUES (131, 1117, 350, 400, 450);
INSERT INTO limity_cm VALUES (166, 1118, 100, 150, 200);
INSERT INTO limity_cm VALUES (167, 1119, 250, 280, 320);
INSERT INTO limity_cm VALUES (168, 1120, 150, 180, 220);
INSERT INTO limity_cm VALUES (131, 1121, 240, 330, 400);
INSERT INTO limity_cm VALUES (124, 1122, 90, 120, 150);
INSERT INTO limity_cm VALUES (169, 1123, 120, 140, 160);
INSERT INTO limity_cm VALUES (170, 1124, 100, 130, 160);
INSERT INTO limity_cm VALUES (111, 1125, 140, 160, 180);
INSERT INTO limity_cm VALUES (111, 1126, 120, 150, 175);
INSERT INTO limity_cm VALUES (171, 1127, 65, 80, 100);
INSERT INTO limity_cm VALUES (172, 1128, 150, 180, 220);
INSERT INTO limity_cm VALUES (173, 1129, 100, 130, 150);
INSERT INTO limity_cm VALUES (172, 1130, 200, 250, 300);
INSERT INTO limity_cm VALUES (174, 1131, 120, 150, 180);
INSERT INTO limity_cm VALUES (174, 1132, 160, 190, 220);
INSERT INTO limity_cm VALUES (174, 1133, 200, 260, 310);
INSERT INTO limity_cm VALUES (175, 1134, 200, 240, 290);
INSERT INTO limity_cm VALUES (175, 1135, 160, 220, 320);
INSERT INTO limity_cm VALUES (176, 1136, 250, 350, 450);
INSERT INTO limity_cm VALUES (177, 1137, 110, 160, 220);
INSERT INTO limity_cm VALUES (177, 1138, 120, 150, 200);
INSERT INTO limity_cm VALUES (178, 1139, 70, 90, 120);
INSERT INTO limity_cm VALUES (178, 1140, 120, 160, 200);
INSERT INTO limity_cm VALUES (179, 1141, 120, 160, 200);
INSERT INTO limity_cm VALUES (176, 1142, 180, 260, 340);
INSERT INTO limity_cm VALUES (180, 1143, 100, 200, 240);
INSERT INTO limity_cm VALUES (139, 1144, 190, 210, 230);
INSERT INTO limity_cm VALUES (181, 1145, 170, 210, 260);
INSERT INTO limity_cm VALUES (131, 1146, 230, 320, 370);
INSERT INTO limity_cm VALUES (182, 1147, 150, 200, 250);
INSERT INTO limity_cm VALUES (142, 1148, 480, 510, 540);
INSERT INTO limity_cm VALUES (131, 1150, 280, 380, 450);
INSERT INTO limity_cm VALUES (183, 1152, 100, 150, 180);
INSERT INTO limity_cm VALUES (185, 1154, 200, 250, 350);
INSERT INTO limity_cm VALUES (185, 1157, 240, 290, 380);
INSERT INTO limity_cm VALUES (187, 1160, 80, 180, 230);
INSERT INTO limity_cm VALUES (185, 1162, 230, 300, 380);
INSERT INTO limity_cm VALUES (176, 1164, 240, 320, 400);
INSERT INTO limity_cm VALUES (189, 1166, 150, 200, 250);
INSERT INTO limity_cm VALUES (101, 1168, 370, 510, 610);
INSERT INTO limity_cm VALUES (131, 1169, 400, 500, 550);
INSERT INTO limity_cm VALUES (127, 1170, 400, 440, 490);
INSERT INTO limity_cm VALUES (131, 1171, 450, 530, 600);
INSERT INTO limity_cm VALUES (190, 1172, 170, 190, 230);
INSERT INTO limity_cm VALUES (141, 1173, 140, 170, 190);
INSERT INTO limity_cm VALUES (191, 1175, 150, 180, 220);
INSERT INTO limity_cm VALUES (185, 1176, 100, 140, 180);
INSERT INTO limity_cm VALUES (192, 1177, 140, 170, 220);
INSERT INTO limity_cm VALUES (185, 1178, 160, 220, 280);
INSERT INTO limity_cm VALUES (120, 1180, 100, 150, 190);
INSERT INTO limity_cm VALUES (123, 1181, 120, 150, 180);
INSERT INTO limity_cm VALUES (123, 1182, 100, 140, 180);
INSERT INTO limity_cm VALUES (126, 1183, 120, 150, 170);
INSERT INTO limity_cm VALUES (126, 1184, 120, 160, 210);
INSERT INTO limity_cm VALUES (193, 1185, 100, 120, 150);
INSERT INTO limity_cm VALUES (126, 1186, 130, 160, 200);
INSERT INTO limity_cm VALUES (126, 1187, 220, 280, 330);
INSERT INTO limity_cm VALUES (126, 1188, 160, 190, 230);
INSERT INTO limity_cm VALUES (194, 1189, 280, 350, 400);
INSERT INTO limity_cm VALUES (195, 1190, 200, 250, 290);
INSERT INTO limity_cm VALUES (118, 1191, 400, 500, 600);
INSERT INTO limity_cm VALUES (196, 1192, 170, 200, 260);
INSERT INTO limity_cm VALUES (118, 1193, 400, 500, 600);
INSERT INTO limity_cm VALUES (197, 1194, 270, 400, 500);
INSERT INTO limity_cm VALUES (119, 1195, 185, 220, 270);
INSERT INTO limity_cm VALUES (119, 1196, 260, 350, 410);
INSERT INTO limity_cm VALUES (131, 1197, 400, 490, 560);


--
-- Name: limity_cm_stanice_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: cepek
--

ALTER TABLE ONLY limity_cm
    ADD CONSTRAINT limity_cm_stanice_id_fkey FOREIGN KEY (stanice_id) REFERENCES stanice(id);


--
-- Name: limity_cm_tok_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: cepek
--

ALTER TABLE ONLY limity_cm
    ADD CONSTRAINT limity_cm_tok_id_fkey FOREIGN KEY (tok_id) REFERENCES toky(id);


--
-- PostgreSQL database dump complete
--

--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: vodocty; Type: TABLE; Schema: public; Owner: cepek; Tablespace: 
--

CREATE TABLE vodocty (
    tok_id integer NOT NULL,
    stanice_id integer NOT NULL,
    cas timestamp without time zone NOT NULL,
    vodocet_cm real
);


--
-- Data for Name: vodocty; Type: TABLE DATA; Schema: public; Owner: cepek
--

INSERT INTO vodocty VALUES (124, 1122, '2007-09-10 13:00:00', 34);
INSERT INTO vodocty VALUES (124, 1122, '2007-09-09 16:00:00', 34);
INSERT INTO vodocty VALUES (124, 1122, '2007-09-08 13:00:00', 33);
INSERT INTO vodocty VALUES (124, 1122, '2007-09-07 13:00:00', 38);
INSERT INTO vodocty VALUES (124, 1122, '2007-09-06 13:00:00', 40);
INSERT INTO vodocty VALUES (124, 1122, '2007-09-05 13:00:00', 29);
INSERT INTO vodocty VALUES (111, 1125, '2007-09-10 14:30:00', 72);
INSERT INTO vodocty VALUES (111, 1125, '2007-09-09 14:30:00', 81);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-10 14:30:00', 48);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-09 15:00:00', 56);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-08 11:30:00', 53);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-07 12:30:00', 87);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-06 09:00:00', 46);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-05 17:00:00', 46);
INSERT INTO vodocty VALUES (111, 1125, '2007-09-06 09:00:00', 73);
INSERT INTO vodocty VALUES (111, 1125, '2007-09-05 17:00:00', 76);
INSERT INTO vodocty VALUES (111, 1125, '2007-09-08 11:30:00', 76);
INSERT INTO vodocty VALUES (111, 1125, '2007-09-07 11:30:00', 106);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-08 11:30:00', 145);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-07 11:30:00', 214);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-06 14:00:00', 88);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-05 17:00:00', 66);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-10 14:30:00', 111);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-09 14:30:00', 115);
INSERT INTO vodocty VALUES (111, 1025, '2007-09-06 14:00:00', 62);
INSERT INTO vodocty VALUES (111, 1025, '2007-09-05 17:00:00', 55);
INSERT INTO vodocty VALUES (108, 1024, '2007-09-10 14:30:00', 165);
INSERT INTO vodocty VALUES (111, 1025, '2007-09-08 11:30:00', 69);
INSERT INTO vodocty VALUES (108, 1024, '2007-09-09 15:00:00', 161);
INSERT INTO vodocty VALUES (111, 1025, '2007-09-07 11:30:00', 126);
INSERT INTO vodocty VALUES (108, 1024, '2007-09-08 11:30:00', 156);
INSERT INTO vodocty VALUES (111, 1025, '2007-09-10 14:00:00', 64);
INSERT INTO vodocty VALUES (108, 1024, '2007-09-07 11:30:00', 142);
INSERT INTO vodocty VALUES (111, 1025, '2007-09-09 14:30:00', 67);
INSERT INTO vodocty VALUES (108, 1024, '2007-09-06 14:00:00', 110);
INSERT INTO vodocty VALUES (108, 1024, '2007-09-05 17:00:00', 88);
INSERT INTO vodocty VALUES (114, 1031, '2007-09-10 14:30:00', 49);
INSERT INTO vodocty VALUES (123, 1045, '2007-09-10 14:00:00', 46);
INSERT INTO vodocty VALUES (125, 1049, '2007-09-10 14:00:00', 70);
INSERT INTO vodocty VALUES (114, 1031, '2007-09-09 14:30:00', 59);
INSERT INTO vodocty VALUES (123, 1045, '2007-09-09 14:30:00', 50);
INSERT INTO vodocty VALUES (125, 1049, '2007-09-09 14:30:00', 72);
INSERT INTO vodocty VALUES (112, 1026, '2007-09-10 14:30:00', 100);
INSERT INTO vodocty VALUES (114, 1030, '2007-09-10 14:30:00', 51);
INSERT INTO vodocty VALUES (116, 1034, '2007-09-10 14:30:00', 73);
INSERT INTO vodocty VALUES (123, 1044, '2007-09-10 14:00:00', 127);
INSERT INTO vodocty VALUES (112, 1026, '2007-09-09 14:30:00', 104);
INSERT INTO vodocty VALUES (114, 1030, '2007-09-09 15:00:00', 61);
INSERT INTO vodocty VALUES (116, 1034, '2007-09-09 14:30:00', 74);
INSERT INTO vodocty VALUES (123, 1044, '2007-09-09 14:30:00', 128);
INSERT INTO vodocty VALUES (113, 1027, '2007-09-10 14:30:00', 79);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-10 14:30:00', 57);
INSERT INTO vodocty VALUES (117, 1035, '2007-09-10 14:00:00', 44);
INSERT INTO vodocty VALUES (122, 1043, '2007-09-06 13:00:00', 96);
INSERT INTO vodocty VALUES (126, 1050, '2007-09-08 11:30:00', 130);
INSERT INTO vodocty VALUES (113, 1027, '2007-09-09 14:30:00', 82);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-09 14:30:00', 62);
INSERT INTO vodocty VALUES (117, 1035, '2007-09-09 14:30:00', 48);
INSERT INTO vodocty VALUES (122, 1043, '2007-09-05 13:00:00', 91);
INSERT INTO vodocty VALUES (126, 1050, '2007-09-07 11:30:00', 129);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-10 14:30:00', 60);
INSERT INTO vodocty VALUES (122, 1043, '2007-09-08 13:00:00', 102);
INSERT INTO vodocty VALUES (126, 1050, '2007-09-06 14:00:00', 123);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-09 15:00:00', 73);
INSERT INTO vodocty VALUES (122, 1043, '2007-09-07 13:00:00', 110);
INSERT INTO vodocty VALUES (126, 1050, '2007-09-05 17:00:00', 111);
INSERT INTO vodocty VALUES (113, 1027, '2007-09-06 14:00:00', 104);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-08 11:30:00', 79);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-06 09:00:00', 43);
INSERT INTO vodocty VALUES (117, 1035, '2007-09-06 14:00:00', 53);
INSERT INTO vodocty VALUES (122, 1043, '2007-09-10 13:00:00', 98);
INSERT INTO vodocty VALUES (113, 1027, '2007-09-05 17:00:00', 66);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 18:00:00', 102);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-05 17:00:00', 35);
INSERT INTO vodocty VALUES (117, 1035, '2007-09-05 17:00:00', 33);
INSERT INTO vodocty VALUES (122, 1043, '2007-09-09 16:00:00', 99);
INSERT INTO vodocty VALUES (113, 1027, '2007-09-08 11:30:00', 85);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-06 09:00:00', 52);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-08 11:30:00', 68);
INSERT INTO vodocty VALUES (117, 1035, '2007-09-08 11:30:00', 59);
INSERT INTO vodocty VALUES (121, 1042, '2007-09-06 13:00:00', 54);
INSERT INTO vodocty VALUES (126, 1050, '2007-09-10 14:30:00', 125);
INSERT INTO vodocty VALUES (113, 1027, '2007-09-07 11:30:00', 113);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-05 17:00:00', 32);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 18:00:00', 88);
INSERT INTO vodocty VALUES (117, 1035, '2007-09-07 11:30:00', 75);
INSERT INTO vodocty VALUES (121, 1042, '2007-09-05 13:00:00', 39);
INSERT INTO vodocty VALUES (126, 1050, '2007-09-09 14:30:00', 126);
INSERT INTO vodocty VALUES (112, 1026, '2007-09-08 11:30:00', 104);
INSERT INTO vodocty VALUES (114, 1030, '2007-09-08 11:30:00', 71);
INSERT INTO vodocty VALUES (114, 1031, '2007-09-06 14:00:00', 30);
INSERT INTO vodocty VALUES (116, 1034, '2007-09-08 11:30:00', 78);
INSERT INTO vodocty VALUES (123, 1044, '2007-09-08 11:30:00', 134);
INSERT INTO vodocty VALUES (123, 1045, '2007-09-06 12:30:00', 42);
INSERT INTO vodocty VALUES (125, 1049, '2007-09-06 12:30:00', 72);
INSERT INTO vodocty VALUES (112, 1026, '2007-09-07 11:30:00', 119);
INSERT INTO vodocty VALUES (114, 1030, '2007-09-07 11:30:00', 67);
INSERT INTO vodocty VALUES (114, 1031, '2007-09-05 17:00:00', 15);
INSERT INTO vodocty VALUES (116, 1034, '2007-09-07 11:30:00', 84);
INSERT INTO vodocty VALUES (123, 1044, '2007-09-07 11:30:00', 143);
INSERT INTO vodocty VALUES (123, 1045, '2007-09-05 17:00:00', 40);
INSERT INTO vodocty VALUES (125, 1049, '2007-09-05 17:00:00', 63);
INSERT INTO vodocty VALUES (112, 1026, '2007-09-06 12:30:00', 118);
INSERT INTO vodocty VALUES (114, 1030, '2007-09-06 14:00:00', 36);
INSERT INTO vodocty VALUES (114, 1031, '2007-09-08 11:30:00', 74);
INSERT INTO vodocty VALUES (116, 1034, '2007-09-06 14:00:00', 78);
INSERT INTO vodocty VALUES (123, 1044, '2007-09-06 12:30:00', 132);
INSERT INTO vodocty VALUES (123, 1045, '2007-09-08 11:30:00', 45);
INSERT INTO vodocty VALUES (125, 1049, '2007-09-08 11:30:00', 79);
INSERT INTO vodocty VALUES (112, 1026, '2007-09-05 17:00:00', 90);
INSERT INTO vodocty VALUES (114, 1030, '2007-09-05 17:00:00', 23);
INSERT INTO vodocty VALUES (114, 1031, '2007-09-07 11:30:00', 87);
INSERT INTO vodocty VALUES (116, 1034, '2007-09-05 17:00:00', 60);
INSERT INTO vodocty VALUES (123, 1044, '2007-09-05 17:00:00', 121);
INSERT INTO vodocty VALUES (123, 1045, '2007-09-07 11:30:00', 41);
INSERT INTO vodocty VALUES (125, 1049, '2007-09-07 11:30:00', 77);
INSERT INTO vodocty VALUES (115, 1033, '2007-09-06 14:00:00', 38);
INSERT INTO vodocty VALUES (123, 1048, '2007-09-08 11:30:00', 92);
INSERT INTO vodocty VALUES (124, 1046, '2007-09-08 11:30:00', 29);
INSERT INTO vodocty VALUES (124, 1047, '2007-09-06 13:30:00', 101);
INSERT INTO vodocty VALUES (115, 1033, '2007-09-05 17:00:00', 33);
INSERT INTO vodocty VALUES (123, 1048, '2007-09-07 11:30:00', 110);
INSERT INTO vodocty VALUES (124, 1046, '2007-09-07 11:30:00', 42);
INSERT INTO vodocty VALUES (124, 1047, '2007-09-05 17:00:00', 73);
INSERT INTO vodocty VALUES (115, 1033, '2007-09-08 11:30:00', 40);
INSERT INTO vodocty VALUES (123, 1048, '2007-09-06 14:00:00', 102);
INSERT INTO vodocty VALUES (124, 1046, '2007-09-06 12:30:00', 42);
INSERT INTO vodocty VALUES (124, 1047, '2007-09-08 11:00:00', 110);
INSERT INTO vodocty VALUES (115, 1033, '2007-09-07 11:30:00', 41);
INSERT INTO vodocty VALUES (123, 1048, '2007-09-05 17:00:00', 62);
INSERT INTO vodocty VALUES (124, 1046, '2007-09-05 17:00:00', 30);
INSERT INTO vodocty VALUES (124, 1047, '2007-09-07 11:00:00', 134);
INSERT INTO vodocty VALUES (115, 1033, '2007-09-10 14:30:00', 39);
INSERT INTO vodocty VALUES (124, 1047, '2007-09-10 14:00:00', 90);
INSERT INTO vodocty VALUES (115, 1033, '2007-09-09 14:30:00', 40);
INSERT INTO vodocty VALUES (124, 1047, '2007-09-09 14:00:00', 96);
INSERT INTO vodocty VALUES (123, 1048, '2007-09-10 14:30:00', 75);
INSERT INTO vodocty VALUES (124, 1046, '2007-09-10 14:00:00', 29);
INSERT INTO vodocty VALUES (123, 1048, '2007-09-09 14:30:00', 82);
INSERT INTO vodocty VALUES (124, 1046, '2007-09-09 14:30:00', 29);
INSERT INTO vodocty VALUES (120, 1038, '2007-09-08 09:00:00', 32);
INSERT INTO vodocty VALUES (120, 1038, '2007-09-07 09:00:00', 44);
INSERT INTO vodocty VALUES (120, 1038, '2007-09-06 09:00:00', 28);
INSERT INTO vodocty VALUES (120, 1038, '2007-09-05 12:00:00', 16);
INSERT INTO vodocty VALUES (120, 1038, '2007-09-10 12:00:00', 24);
INSERT INTO vodocty VALUES (120, 1038, '2007-09-09 12:00:00', 27);
INSERT INTO vodocty VALUES (128, 1054, '2007-09-08 10:00:00', 34);
INSERT INTO vodocty VALUES (146, 1083, '2007-09-06 10:00:00', 66);
INSERT INTO vodocty VALUES (146, 1085, '2007-09-10 13:00:00', 27);
INSERT INTO vodocty VALUES (163, 1113, '2007-09-06 12:30:00', 14);
INSERT INTO vodocty VALUES (180, 1143, '2007-09-06 07:00:00', 38);
INSERT INTO vodocty VALUES (192, 1177, '2007-09-10 11:00:00', 39);
INSERT INTO vodocty VALUES (128, 1054, '2007-09-07 10:00:00', 35);
INSERT INTO vodocty VALUES (146, 1083, '2007-09-05 13:00:00', 40);
INSERT INTO vodocty VALUES (146, 1085, '2007-09-09 13:00:00', 55);
INSERT INTO vodocty VALUES (163, 1113, '2007-09-05 17:00:00', 14);
INSERT INTO vodocty VALUES (180, 1143, '2007-09-05 13:00:00', 19);
INSERT INTO vodocty VALUES (192, 1177, '2007-09-09 11:00:00', 42);
INSERT INTO vodocty VALUES (128, 1054, '2007-09-06 10:00:00', 38);
INSERT INTO vodocty VALUES (145, 1082, '2007-09-10 13:00:00', 36);
INSERT INTO vodocty VALUES (146, 1083, '2007-09-08 10:00:00', 54);
INSERT INTO vodocty VALUES (146, 1084, '2007-09-10 13:00:00', 35);
INSERT INTO vodocty VALUES (163, 1113, '2007-09-08 11:30:00', 18);
INSERT INTO vodocty VALUES (180, 1143, '2007-09-08 10:00:00', 86);
INSERT INTO vodocty VALUES (128, 1054, '2007-09-05 13:00:00', 44);
INSERT INTO vodocty VALUES (145, 1082, '2007-09-09 13:00:00', 46);
INSERT INTO vodocty VALUES (146, 1083, '2007-09-07 10:00:00', 48);
INSERT INTO vodocty VALUES (146, 1084, '2007-09-09 13:00:00', 53);
INSERT INTO vodocty VALUES (163, 1113, '2007-09-07 11:30:00', 15);
INSERT INTO vodocty VALUES (145, 1082, '2007-09-08 10:00:00', 38);
INSERT INTO vodocty VALUES (146, 1083, '2007-09-10 13:00:00', 44);
INSERT INTO vodocty VALUES (146, 1084, '2007-09-08 10:00:00', 38);
INSERT INTO vodocty VALUES (146, 1085, '2007-09-06 10:00:00', 38);
INSERT INTO vodocty VALUES (163, 1113, '2007-09-10 14:30:00', 18);
INSERT INTO vodocty VALUES (180, 1143, '2007-09-10 13:00:00', 75);
INSERT INTO vodocty VALUES (192, 1177, '2007-09-06 15:00:00', 68);
INSERT INTO vodocty VALUES (145, 1082, '2007-09-07 10:00:00', 44);
INSERT INTO vodocty VALUES (146, 1083, '2007-09-09 13:00:00', 59);
INSERT INTO vodocty VALUES (146, 1084, '2007-09-07 10:00:00', 43);
INSERT INTO vodocty VALUES (146, 1085, '2007-09-05 13:00:00', 18);
INSERT INTO vodocty VALUES (163, 1113, '2007-09-09 15:00:00', 18);
INSERT INTO vodocty VALUES (180, 1143, '2007-09-09 13:00:00', 71);
INSERT INTO vodocty VALUES (192, 1177, '2007-09-05 15:00:00', 30);
INSERT INTO vodocty VALUES (128, 1054, '2007-09-10 13:00:00', 38);
INSERT INTO vodocty VALUES (145, 1082, '2007-09-06 10:00:00', 44);
INSERT INTO vodocty VALUES (146, 1084, '2007-09-06 10:00:00', 52);
INSERT INTO vodocty VALUES (146, 1085, '2007-09-08 10:00:00', 24);
INSERT INTO vodocty VALUES (192, 1177, '2007-09-08 15:00:00', 48);
INSERT INTO vodocty VALUES (128, 1054, '2007-09-09 13:00:00', 43);
INSERT INTO vodocty VALUES (145, 1082, '2007-09-05 13:00:00', 34);
INSERT INTO vodocty VALUES (146, 1084, '2007-09-05 13:00:00', 29);
INSERT INTO vodocty VALUES (146, 1085, '2007-09-07 10:00:00', 37);
INSERT INTO vodocty VALUES (192, 1177, '2007-09-07 15:00:00', 86);
INSERT INTO vodocty VALUES (129, 1055, '2007-09-10 13:00:00', 32);
INSERT INTO vodocty VALUES (145, 1081, '2007-09-06 10:00:00', 40);
INSERT INTO vodocty VALUES (129, 1055, '2007-09-09 13:00:00', 42);
INSERT INTO vodocty VALUES (145, 1081, '2007-09-05 13:00:00', 36);
INSERT INTO vodocty VALUES (145, 1081, '2007-09-08 10:00:00', 40);
INSERT INTO vodocty VALUES (162, 1112, '2007-09-10 14:30:00', 16);
INSERT INTO vodocty VALUES (145, 1081, '2007-09-07 10:00:00', 36);
INSERT INTO vodocty VALUES (162, 1112, '2007-09-09 15:00:00', 19);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-10 14:30:00', 71);
INSERT INTO vodocty VALUES (110, 1023, '2007-09-10 14:30:00', 81);
INSERT INTO vodocty VALUES (134, 1064, '2007-09-08 10:00:00', 68);
INSERT INTO vodocty VALUES (193, 1185, '2007-09-10 14:00:00', 23);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-09 14:30:00', 85);
INSERT INTO vodocty VALUES (110, 1023, '2007-09-09 15:00:00', 80);
INSERT INTO vodocty VALUES (134, 1064, '2007-09-07 10:00:00', 77);
INSERT INTO vodocty VALUES (193, 1185, '2007-09-09 14:00:00', 25);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-10 14:30:00', 133);
INSERT INTO vodocty VALUES (108, 1018, '2007-09-10 14:30:00', 69);
INSERT INTO vodocty VALUES (134, 1064, '2007-09-06 10:00:00', 78);
INSERT INTO vodocty VALUES (141, 1080, '2007-09-10 13:00:00', 19);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-09 15:00:00', 143);
INSERT INTO vodocty VALUES (108, 1018, '2007-09-09 15:00:00', 71);
INSERT INTO vodocty VALUES (134, 1064, '2007-09-05 13:00:00', 61);
INSERT INTO vodocty VALUES (141, 1080, '2007-09-09 13:00:00', 20);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-10 14:00:00', 73);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-06 09:00:00', 67);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-10 14:30:00', 244);
INSERT INTO vodocty VALUES (108, 1022, '2007-09-08 11:30:00', 86);
INSERT INTO vodocty VALUES (109, 1019, '2007-09-10 14:30:00', 23);
INSERT INTO vodocty VALUES (109, 1020, '2007-09-08 11:30:00', 77);
INSERT INTO vodocty VALUES (109, 1021, '2007-09-06 14:00:00', 100);
INSERT INTO vodocty VALUES (135, 1065, '2007-09-06 10:00:00', 18);
INSERT INTO vodocty VALUES (194, 1189, '2007-09-10 14:30:00', 187);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-09 14:30:00', 85);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-05 17:00:00', 18);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-09 15:00:00', 270);
INSERT INTO vodocty VALUES (108, 1022, '2007-09-07 11:30:00', 48);
INSERT INTO vodocty VALUES (109, 1019, '2007-09-09 15:00:00', 27);
INSERT INTO vodocty VALUES (109, 1020, '2007-09-07 11:30:00', 85);
INSERT INTO vodocty VALUES (109, 1021, '2007-09-05 17:00:00', 82);
INSERT INTO vodocty VALUES (135, 1065, '2007-09-05 13:00:00', 18);
INSERT INTO vodocty VALUES (194, 1189, '2007-09-09 14:30:00', 196);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-10 14:30:00', 53);
INSERT INTO vodocty VALUES (103, 1006, '2007-09-10 14:30:00', 50);
INSERT INTO vodocty VALUES (104, 1008, '2007-09-10 14:30:00', 16);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-10 14:30:00', 38);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-08 14:30:00', 93);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-10 14:30:00', 112);
INSERT INTO vodocty VALUES (108, 1022, '2007-09-06 14:00:00', 21);
INSERT INTO vodocty VALUES (109, 1020, '2007-09-06 14:00:00', 57);
INSERT INTO vodocty VALUES (109, 1021, '2007-09-08 11:30:00', 164);
INSERT INTO vodocty VALUES (135, 1065, '2007-09-08 10:00:00', 21);
INSERT INTO vodocty VALUES (195, 1190, '2007-09-10 16:00:00', 136);
INSERT INTO vodocty VALUES (196, 1192, '2007-09-10 14:00:00', 30);
INSERT INTO vodocty VALUES (197, 1194, '2007-09-10 14:00:00', 99);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-09 14:30:00', 58);
INSERT INTO vodocty VALUES (103, 1006, '2007-09-09 14:30:00', 57);
INSERT INTO vodocty VALUES (104, 1008, '2007-09-09 14:30:00', 20);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-09 14:30:00', 54);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-09 15:00:00', 122);
INSERT INTO vodocty VALUES (108, 1022, '2007-09-05 17:00:00', 12);
INSERT INTO vodocty VALUES (109, 1020, '2007-09-05 17:00:00', 32);
INSERT INTO vodocty VALUES (109, 1021, '2007-09-07 11:30:00', 140);
INSERT INTO vodocty VALUES (135, 1065, '2007-09-07 10:00:00', 28);
INSERT INTO vodocty VALUES (195, 1190, '2007-09-09 16:00:00', 152);
INSERT INTO vodocty VALUES (196, 1192, '2007-09-09 14:30:00', 35);
INSERT INTO vodocty VALUES (197, 1194, '2007-09-09 14:30:00', 107);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-08 11:30:00', 59);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-06 14:00:00', 98);
INSERT INTO vodocty VALUES (103, 1006, '2007-09-08 11:30:00', 72);
INSERT INTO vodocty VALUES (104, 1008, '2007-09-08 11:30:00', 26);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-08 11:30:00', 64);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-10 14:00:00', 62);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-08 20:00:00', 136);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-06 14:00:00', 130);
INSERT INTO vodocty VALUES (109, 1019, '2007-09-06 14:00:00', 29);
INSERT INTO vodocty VALUES (109, 1021, '2007-09-10 14:30:00', 180);
INSERT INTO vodocty VALUES (135, 1065, '2007-09-10 13:00:00', 22);
INSERT INTO vodocty VALUES (194, 1189, '2007-09-06 13:00:00', 208);
INSERT INTO vodocty VALUES (195, 1190, '2007-09-08 13:00:00', 176);
INSERT INTO vodocty VALUES (196, 1192, '2007-09-08 11:30:00', 61);
INSERT INTO vodocty VALUES (197, 1194, '2007-09-08 11:30:00', 156);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-07 14:00:00', 87);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-05 17:00:00', 48);
INSERT INTO vodocty VALUES (103, 1006, '2007-09-07 11:30:00', 144);
INSERT INTO vodocty VALUES (104, 1008, '2007-09-07 11:30:00', 68);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 21:00:00', 85);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-09 14:30:00', 74);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-05 17:00:00', 112);
INSERT INTO vodocty VALUES (109, 1019, '2007-09-05 17:00:00', 18);
INSERT INTO vodocty VALUES (109, 1021, '2007-09-09 15:00:00', 173);
INSERT INTO vodocty VALUES (135, 1065, '2007-09-09 13:00:00', 21);
INSERT INTO vodocty VALUES (194, 1189, '2007-09-05 13:00:00', 161);
INSERT INTO vodocty VALUES (196, 1192, '2007-09-07 11:30:00', 102);
INSERT INTO vodocty VALUES (197, 1194, '2007-09-07 11:30:00', 168);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-06 14:00:00', 81);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-08 11:30:00', 118);
INSERT INTO vodocty VALUES (103, 1006, '2007-09-06 14:00:00', 92);
INSERT INTO vodocty VALUES (104, 1008, '2007-09-06 14:00:00', 42);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-06 14:00:00', 96);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-08 03:00:00', 280);
INSERT INTO vodocty VALUES (108, 1022, '2007-09-10 14:30:00', 105);
INSERT INTO vodocty VALUES (109, 1019, '2007-09-08 11:30:00', 36);
INSERT INTO vodocty VALUES (109, 1020, '2007-09-10 14:30:00', 56);
INSERT INTO vodocty VALUES (194, 1189, '2007-09-08 11:30:00', 226);
INSERT INTO vodocty VALUES (195, 1190, '2007-09-06 13:00:00', 144);
INSERT INTO vodocty VALUES (196, 1192, '2007-09-06 14:00:00', 50);
INSERT INTO vodocty VALUES (197, 1194, '2007-09-06 14:00:00', 108);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-05 17:00:00', 44);
INSERT INTO vodocty VALUES (103, 1006, '2007-09-05 17:00:00', 34);
INSERT INTO vodocty VALUES (104, 1008, '2007-09-05 17:00:00', 7);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-05 17:00:00', 9);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-05 17:00:00', 69);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-07 11:30:00', 191);
INSERT INTO vodocty VALUES (108, 1022, '2007-09-09 15:00:00', 97);
INSERT INTO vodocty VALUES (109, 1019, '2007-09-07 11:30:00', 44);
INSERT INTO vodocty VALUES (109, 1020, '2007-09-09 15:00:00', 63);
INSERT INTO vodocty VALUES (194, 1189, '2007-09-07 18:00:00', 260);
INSERT INTO vodocty VALUES (195, 1190, '2007-09-05 13:00:00', 90);
INSERT INTO vodocty VALUES (196, 1192, '2007-09-05 17:00:00', 23);
INSERT INTO vodocty VALUES (197, 1194, '2007-09-05 17:00:00', 74);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-08 17:00:00', 149);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-06 14:00:00', 54);
INSERT INTO vodocty VALUES (108, 1018, '2007-09-08 11:30:00', 70);
INSERT INTO vodocty VALUES (110, 1023, '2007-09-06 14:00:00', 68);
INSERT INTO vodocty VALUES (141, 1080, '2007-09-08 10:00:00', 18);
INSERT INTO vodocty VALUES (193, 1185, '2007-09-06 12:30:00', 26);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 03:30:00', 153);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-05 17:00:00', 7);
INSERT INTO vodocty VALUES (108, 1018, '2007-09-07 11:30:00', 43);
INSERT INTO vodocty VALUES (110, 1023, '2007-09-05 17:00:00', 64);
INSERT INTO vodocty VALUES (141, 1080, '2007-09-07 10:00:00', 19);
INSERT INTO vodocty VALUES (193, 1185, '2007-09-05 17:00:00', 15);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-06 14:00:00', 80);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-08 11:30:00', 91);
INSERT INTO vodocty VALUES (108, 1018, '2007-09-06 12:30:00', 30);
INSERT INTO vodocty VALUES (110, 1023, '2007-09-08 11:30:00', 82);
INSERT INTO vodocty VALUES (134, 1064, '2007-09-10 13:00:00', 67);
INSERT INTO vodocty VALUES (141, 1080, '2007-09-06 10:00:00', 20);
INSERT INTO vodocty VALUES (193, 1185, '2007-09-08 11:00:00', 29);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-05 17:00:00', 15);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-07 11:30:00', 134);
INSERT INTO vodocty VALUES (108, 1018, '2007-09-05 17:00:00', 26);
INSERT INTO vodocty VALUES (110, 1023, '2007-09-07 11:30:00', 98);
INSERT INTO vodocty VALUES (134, 1064, '2007-09-09 13:00:00', 69);
INSERT INTO vodocty VALUES (141, 1080, '2007-09-05 13:00:00', 19);
INSERT INTO vodocty VALUES (193, 1185, '2007-09-07 11:30:00', 47);
INSERT INTO vodocty VALUES (132, 1059, '2007-09-10 13:00:00', 34);
INSERT INTO vodocty VALUES (132, 1060, '2007-09-08 10:00:00', 40);
INSERT INTO vodocty VALUES (133, 1062, '2007-09-08 10:00:00', 39);
INSERT INTO vodocty VALUES (133, 1063, '2007-09-06 10:00:00', 40);
INSERT INTO vodocty VALUES (142, 1079, '2007-09-10 14:30:00', 128);
INSERT INTO vodocty VALUES (132, 1059, '2007-09-09 13:00:00', 35);
INSERT INTO vodocty VALUES (132, 1060, '2007-09-07 10:00:00', 54);
INSERT INTO vodocty VALUES (133, 1062, '2007-09-07 10:00:00', 43);
INSERT INTO vodocty VALUES (133, 1063, '2007-09-05 13:00:00', 23);
INSERT INTO vodocty VALUES (142, 1079, '2007-09-09 15:00:00', 138);
INSERT INTO vodocty VALUES (132, 1060, '2007-09-06 10:00:00', 23);
INSERT INTO vodocty VALUES (133, 1062, '2007-09-06 10:00:00', 36);
INSERT INTO vodocty VALUES (133, 1063, '2007-09-08 10:00:00', 34);
INSERT INTO vodocty VALUES (143, 1076, '2007-09-10 14:30:00', 89);
INSERT INTO vodocty VALUES (132, 1060, '2007-09-05 13:00:00', 31);
INSERT INTO vodocty VALUES (133, 1062, '2007-09-05 13:00:00', 31);
INSERT INTO vodocty VALUES (133, 1063, '2007-09-07 10:00:00', 46);
INSERT INTO vodocty VALUES (143, 1076, '2007-09-09 14:30:00', 84);
INSERT INTO vodocty VALUES (140, 1073, '2007-09-10 13:00:00', 76);
INSERT INTO vodocty VALUES (142, 1075, '2007-09-06 14:00:00', 101);
INSERT INTO vodocty VALUES (142, 1077, '2007-09-10 14:30:00', 77);
INSERT INTO vodocty VALUES (140, 1073, '2007-09-09 13:00:00', 80);
INSERT INTO vodocty VALUES (142, 1075, '2007-09-05 17:00:00', 20);
INSERT INTO vodocty VALUES (142, 1077, '2007-09-09 14:30:00', 85);
INSERT INTO vodocty VALUES (140, 1072, '2007-09-10 13:00:00', 47);
INSERT INTO vodocty VALUES (141, 1074, '2007-09-10 13:00:00', 40);
INSERT INTO vodocty VALUES (142, 1075, '2007-09-08 11:30:00', 34);
INSERT INTO vodocty VALUES (140, 1072, '2007-09-09 13:00:00', 50);
INSERT INTO vodocty VALUES (141, 1074, '2007-09-09 13:00:00', 40);
INSERT INTO vodocty VALUES (142, 1075, '2007-09-07 11:30:00', 55);
INSERT INTO vodocty VALUES (140, 1072, '2007-09-08 10:00:00', 54);
INSERT INTO vodocty VALUES (140, 1073, '2007-09-06 10:00:00', 98);
INSERT INTO vodocty VALUES (141, 1074, '2007-09-08 10:00:00', 40);
INSERT INTO vodocty VALUES (142, 1075, '2007-09-10 14:30:00', 52);
INSERT INTO vodocty VALUES (142, 1077, '2007-09-06 14:00:00', 96);
INSERT INTO vodocty VALUES (140, 1072, '2007-09-07 10:00:00', 64);
INSERT INTO vodocty VALUES (140, 1073, '2007-09-05 13:00:00', 53);
INSERT INTO vodocty VALUES (141, 1074, '2007-09-07 10:00:00', 40);
INSERT INTO vodocty VALUES (142, 1075, '2007-09-09 14:30:00', 57);
INSERT INTO vodocty VALUES (142, 1077, '2007-09-05 17:00:00', 53);
INSERT INTO vodocty VALUES (140, 1072, '2007-09-06 07:00:00', 54);
INSERT INTO vodocty VALUES (140, 1073, '2007-09-08 10:00:00', 85);
INSERT INTO vodocty VALUES (141, 1074, '2007-09-06 10:00:00', 40);
INSERT INTO vodocty VALUES (142, 1077, '2007-09-08 11:30:00', 67);
INSERT INTO vodocty VALUES (140, 1072, '2007-09-05 13:00:00', 30);
INSERT INTO vodocty VALUES (140, 1073, '2007-09-07 10:00:00', 104);
INSERT INTO vodocty VALUES (141, 1074, '2007-09-05 13:00:00', 41);
INSERT INTO vodocty VALUES (142, 1077, '2007-09-07 11:30:00', 88);
INSERT INTO vodocty VALUES (132, 1059, '2007-09-06 10:00:00', 52);
INSERT INTO vodocty VALUES (133, 1063, '2007-09-10 13:00:00', 30);
INSERT INTO vodocty VALUES (142, 1079, '2007-09-06 14:00:00', 148);
INSERT INTO vodocty VALUES (143, 1076, '2007-09-08 11:30:00', 83);
INSERT INTO vodocty VALUES (132, 1059, '2007-09-05 13:00:00', 29);
INSERT INTO vodocty VALUES (133, 1063, '2007-09-09 13:00:00', 31);
INSERT INTO vodocty VALUES (142, 1079, '2007-09-05 17:00:00', 113);
INSERT INTO vodocty VALUES (143, 1076, '2007-09-07 11:30:00', 86);
INSERT INTO vodocty VALUES (132, 1059, '2007-09-08 10:00:00', 35);
INSERT INTO vodocty VALUES (132, 1060, '2007-09-10 13:00:00', 40);
INSERT INTO vodocty VALUES (133, 1062, '2007-09-10 13:00:00', 36);
INSERT INTO vodocty VALUES (142, 1079, '2007-09-08 11:30:00', 123);
INSERT INTO vodocty VALUES (143, 1076, '2007-09-06 14:00:00', 98);
INSERT INTO vodocty VALUES (132, 1059, '2007-09-07 10:00:00', 39);
INSERT INTO vodocty VALUES (132, 1060, '2007-09-09 13:00:00', 42);
INSERT INTO vodocty VALUES (133, 1062, '2007-09-09 13:00:00', 37);
INSERT INTO vodocty VALUES (142, 1079, '2007-09-07 11:30:00', 145);
INSERT INTO vodocty VALUES (143, 1076, '2007-09-05 17:00:00', 77);
INSERT INTO vodocty VALUES (173, 1129, '2007-09-10 16:00:00', 18);
INSERT INTO vodocty VALUES (173, 1129, '2007-09-09 16:00:00', 16);
INSERT INTO vodocty VALUES (172, 1130, '2007-09-10 07:00:00', 58);
INSERT INTO vodocty VALUES (169, 1123, '2007-09-10 14:30:00', 65);
INSERT INTO vodocty VALUES (171, 1127, '2007-09-10 14:30:00', 33);
INSERT INTO vodocty VALUES (174, 1131, '2007-09-06 13:00:00', 27);
INSERT INTO vodocty VALUES (174, 1133, '2007-09-10 16:00:00', 43);
INSERT INTO vodocty VALUES (175, 1135, '2007-09-10 16:00:00', 66);
INSERT INTO vodocty VALUES (169, 1123, '2007-09-09 15:00:00', 72);
INSERT INTO vodocty VALUES (171, 1127, '2007-09-09 15:00:00', 37);
INSERT INTO vodocty VALUES (174, 1131, '2007-09-05 13:00:00', 28);
INSERT INTO vodocty VALUES (174, 1133, '2007-09-09 16:00:00', 42);
INSERT INTO vodocty VALUES (175, 1135, '2007-09-09 16:00:00', 64);
INSERT INTO vodocty VALUES (168, 1120, '2007-09-10 13:00:00', 58);
INSERT INTO vodocty VALUES (170, 1124, '2007-09-10 14:30:00', 43);
INSERT INTO vodocty VALUES (172, 1128, '2007-09-10 16:00:00', 50);
INSERT INTO vodocty VALUES (174, 1131, '2007-09-08 13:00:00', 26);
INSERT INTO vodocty VALUES (174, 1132, '2007-09-10 16:00:00', 34);
INSERT INTO vodocty VALUES (175, 1134, '2007-09-10 16:00:00', 58);
INSERT INTO vodocty VALUES (168, 1120, '2007-09-09 13:00:00', 60);
INSERT INTO vodocty VALUES (170, 1124, '2007-09-09 15:00:00', 51);
INSERT INTO vodocty VALUES (172, 1128, '2007-09-09 16:00:00', 50);
INSERT INTO vodocty VALUES (174, 1131, '2007-09-07 13:00:00', 26);
INSERT INTO vodocty VALUES (174, 1132, '2007-09-09 16:00:00', 36);
INSERT INTO vodocty VALUES (175, 1134, '2007-09-09 16:00:00', 82);
INSERT INTO vodocty VALUES (168, 1120, '2007-09-08 10:00:00', 64);
INSERT INTO vodocty VALUES (169, 1123, '2007-09-06 09:00:00', 68);
INSERT INTO vodocty VALUES (170, 1124, '2007-09-08 11:30:00', 46);
INSERT INTO vodocty VALUES (171, 1127, '2007-09-06 14:00:00', 40);
INSERT INTO vodocty VALUES (172, 1128, '2007-09-08 13:00:00', 49);
INSERT INTO vodocty VALUES (174, 1131, '2007-09-10 16:00:00', 28);
INSERT INTO vodocty VALUES (174, 1132, '2007-09-08 13:00:00', 34);
INSERT INTO vodocty VALUES (174, 1133, '2007-09-06 13:00:00', 42);
INSERT INTO vodocty VALUES (175, 1134, '2007-09-08 13:00:00', 70);
INSERT INTO vodocty VALUES (175, 1135, '2007-09-06 13:00:00', 58);
INSERT INTO vodocty VALUES (168, 1120, '2007-09-07 10:00:00', 96);
INSERT INTO vodocty VALUES (169, 1123, '2007-09-05 17:00:00', 70);
INSERT INTO vodocty VALUES (170, 1124, '2007-09-07 11:30:00', 66);
INSERT INTO vodocty VALUES (171, 1127, '2007-09-05 17:00:00', 32);
INSERT INTO vodocty VALUES (172, 1128, '2007-09-07 13:00:00', 50);
INSERT INTO vodocty VALUES (174, 1131, '2007-09-09 16:00:00', 28);
INSERT INTO vodocty VALUES (174, 1132, '2007-09-07 13:00:00', 33);
INSERT INTO vodocty VALUES (174, 1133, '2007-09-05 13:00:00', 43);
INSERT INTO vodocty VALUES (175, 1134, '2007-09-07 13:00:00', 88);
INSERT INTO vodocty VALUES (175, 1135, '2007-09-05 13:00:00', 56);
INSERT INTO vodocty VALUES (168, 1120, '2007-09-06 10:00:00', 50);
INSERT INTO vodocty VALUES (169, 1123, '2007-09-08 11:30:00', 67);
INSERT INTO vodocty VALUES (170, 1124, '2007-09-06 09:00:00', 42);
INSERT INTO vodocty VALUES (171, 1127, '2007-09-08 11:30:00', 35);
INSERT INTO vodocty VALUES (172, 1128, '2007-09-06 13:00:00', 50);
INSERT INTO vodocty VALUES (174, 1132, '2007-09-06 13:00:00', 34);
INSERT INTO vodocty VALUES (174, 1133, '2007-09-08 13:00:00', 41);
INSERT INTO vodocty VALUES (175, 1134, '2007-09-06 13:00:00', 84);
INSERT INTO vodocty VALUES (175, 1135, '2007-09-08 13:00:00', 67);
INSERT INTO vodocty VALUES (168, 1120, '2007-09-05 13:00:00', 45);
INSERT INTO vodocty VALUES (169, 1123, '2007-09-07 11:30:00', 88);
INSERT INTO vodocty VALUES (170, 1124, '2007-09-05 17:00:00', 45);
INSERT INTO vodocty VALUES (171, 1127, '2007-09-07 11:30:00', 41);
INSERT INTO vodocty VALUES (172, 1128, '2007-09-05 13:00:00', 48);
INSERT INTO vodocty VALUES (174, 1132, '2007-09-05 13:00:00', 34);
INSERT INTO vodocty VALUES (174, 1133, '2007-09-07 13:00:00', 39);
INSERT INTO vodocty VALUES (175, 1134, '2007-09-05 13:00:00', 53);
INSERT INTO vodocty VALUES (175, 1135, '2007-09-07 13:00:00', 82);
INSERT INTO vodocty VALUES (173, 1129, '2007-09-06 13:00:00', 16);
INSERT INTO vodocty VALUES (172, 1130, '2007-09-07 07:00:00', 58);
INSERT INTO vodocty VALUES (173, 1129, '2007-09-05 13:00:00', 16);
INSERT INTO vodocty VALUES (172, 1130, '2007-09-06 07:00:00', 47);
INSERT INTO vodocty VALUES (173, 1129, '2007-09-08 13:00:00', 14);
INSERT INTO vodocty VALUES (172, 1130, '2007-09-05 07:00:00', 47);
INSERT INTO vodocty VALUES (173, 1129, '2007-09-07 13:00:00', 14);
INSERT INTO vodocty VALUES (136, 1066, '2007-09-10 13:00:00', 30);
INSERT INTO vodocty VALUES (136, 1066, '2007-09-09 13:00:00', 32);
INSERT INTO vodocty VALUES (137, 1067, '2007-09-10 13:00:00', 70);
INSERT INTO vodocty VALUES (138, 1069, '2007-09-10 13:00:00', 37);
INSERT INTO vodocty VALUES (139, 1071, '2007-09-10 13:00:00', 24);
INSERT INTO vodocty VALUES (137, 1067, '2007-09-09 12:00:00', 75);
INSERT INTO vodocty VALUES (138, 1069, '2007-09-09 13:00:00', 38);
INSERT INTO vodocty VALUES (139, 1071, '2007-09-09 13:00:00', 25);
INSERT INTO vodocty VALUES (138, 1068, '2007-09-10 13:00:00', 30);
INSERT INTO vodocty VALUES (139, 1070, '2007-09-10 13:00:00', 5);
INSERT INTO vodocty VALUES (138, 1068, '2007-09-09 13:00:00', 31);
INSERT INTO vodocty VALUES (139, 1070, '2007-09-09 13:00:00', 6);
INSERT INTO vodocty VALUES (137, 1067, '2007-09-06 09:30:00', 62);
INSERT INTO vodocty VALUES (138, 1068, '2007-09-08 10:00:00', 31);
INSERT INTO vodocty VALUES (138, 1069, '2007-09-06 10:00:00', 29);
INSERT INTO vodocty VALUES (139, 1070, '2007-09-08 10:00:00', 6);
INSERT INTO vodocty VALUES (139, 1071, '2007-09-06 10:00:00', 26);
INSERT INTO vodocty VALUES (137, 1067, '2007-09-05 12:00:00', 64);
INSERT INTO vodocty VALUES (138, 1068, '2007-09-07 10:00:00', 35);
INSERT INTO vodocty VALUES (138, 1069, '2007-09-05 13:00:00', 22);
INSERT INTO vodocty VALUES (139, 1070, '2007-09-07 07:00:00', 5);
INSERT INTO vodocty VALUES (139, 1071, '2007-09-05 13:00:00', 28);
INSERT INTO vodocty VALUES (137, 1067, '2007-09-08 09:30:00', 79);
INSERT INTO vodocty VALUES (138, 1068, '2007-09-06 10:00:00', 34);
INSERT INTO vodocty VALUES (138, 1069, '2007-09-08 10:00:00', 37);
INSERT INTO vodocty VALUES (139, 1070, '2007-09-06 10:00:00', 6);
INSERT INTO vodocty VALUES (139, 1071, '2007-09-08 10:00:00', 24);
INSERT INTO vodocty VALUES (137, 1067, '2007-09-07 10:00:00', 100);
INSERT INTO vodocty VALUES (138, 1068, '2007-09-05 13:00:00', 22);
INSERT INTO vodocty VALUES (138, 1069, '2007-09-07 10:00:00', 48);
INSERT INTO vodocty VALUES (139, 1070, '2007-09-05 13:00:00', 5);
INSERT INTO vodocty VALUES (139, 1071, '2007-09-07 10:00:00', 26);
INSERT INTO vodocty VALUES (136, 1066, '2007-09-08 10:00:00', 32);
INSERT INTO vodocty VALUES (136, 1066, '2007-09-07 10:00:00', 44);
INSERT INTO vodocty VALUES (136, 1066, '2007-09-06 10:00:00', 28);
INSERT INTO vodocty VALUES (136, 1066, '2007-09-05 13:00:00', 24);
INSERT INTO vodocty VALUES (136, 1115, '2007-09-10 13:00:00', 23);
INSERT INTO vodocty VALUES (136, 1115, '2007-09-09 13:00:00', 23);
INSERT INTO vodocty VALUES (136, 1115, '2007-09-06 10:00:00', 26);
INSERT INTO vodocty VALUES (136, 1115, '2007-09-05 13:00:00', 19);
INSERT INTO vodocty VALUES (136, 1115, '2007-09-08 10:00:00', 22);
INSERT INTO vodocty VALUES (136, 1115, '2007-09-07 10:00:00', 26);
INSERT INTO vodocty VALUES (126, 1184, '2007-09-08 11:30:00', 41);
INSERT INTO vodocty VALUES (126, 1184, '2007-09-07 11:30:00', 57);
INSERT INTO vodocty VALUES (126, 1184, '2007-09-06 14:00:00', 38);
INSERT INTO vodocty VALUES (126, 1184, '2007-09-05 17:00:00', 16);
INSERT INTO vodocty VALUES (126, 1186, '2007-09-08 11:30:00', 61);
INSERT INTO vodocty VALUES (126, 1187, '2007-09-06 14:00:00', 75);
INSERT INTO vodocty VALUES (126, 1186, '2007-09-07 11:30:00', 85);
INSERT INTO vodocty VALUES (126, 1187, '2007-09-05 17:00:00', 52);
INSERT INTO vodocty VALUES (126, 1186, '2007-09-06 14:00:00', 66);
INSERT INTO vodocty VALUES (126, 1187, '2007-09-08 11:30:00', 96);
INSERT INTO vodocty VALUES (126, 1188, '2007-09-10 07:00:00', 78);
INSERT INTO vodocty VALUES (126, 1186, '2007-09-05 17:00:00', 38);
INSERT INTO vodocty VALUES (126, 1187, '2007-09-07 11:30:00', 125);
INSERT INTO vodocty VALUES (126, 1188, '2007-09-09 07:00:00', 78);
INSERT INTO vodocty VALUES (126, 1187, '2007-09-10 14:00:00', 70);
INSERT INTO vodocty VALUES (126, 1188, '2007-09-08 07:00:00', 79);
INSERT INTO vodocty VALUES (126, 1187, '2007-09-09 14:30:00', 75);
INSERT INTO vodocty VALUES (126, 1188, '2007-09-07 07:00:00', 79);
INSERT INTO vodocty VALUES (126, 1186, '2007-09-10 14:00:00', 47);
INSERT INTO vodocty VALUES (126, 1188, '2007-09-06 07:00:00', 59);
INSERT INTO vodocty VALUES (126, 1186, '2007-09-09 14:30:00', 51);
INSERT INTO vodocty VALUES (126, 1188, '2007-09-05 07:00:00', 59);
INSERT INTO vodocty VALUES (126, 1184, '2007-09-10 14:00:00', 27);
INSERT INTO vodocty VALUES (126, 1184, '2007-09-09 14:30:00', 32);
INSERT INTO vodocty VALUES (126, 1183, '2007-09-10 14:30:00', 44);
INSERT INTO vodocty VALUES (126, 1183, '2007-09-09 14:30:00', 46);
INSERT INTO vodocty VALUES (142, 1148, '2007-09-10 14:30:00', 176);
INSERT INTO vodocty VALUES (142, 1148, '2007-09-09 15:00:00', 171);
INSERT INTO vodocty VALUES (142, 1148, '2007-09-08 11:30:00', 167);
INSERT INTO vodocty VALUES (142, 1148, '2007-09-07 11:30:00', 230);
INSERT INTO vodocty VALUES (142, 1148, '2007-09-06 14:00:00', 132);
INSERT INTO vodocty VALUES (142, 1148, '2007-09-05 17:00:00', 132);
INSERT INTO vodocty VALUES (126, 1183, '2007-09-06 12:30:00', 48);
INSERT INTO vodocty VALUES (126, 1183, '2007-09-05 17:00:00', 35);
INSERT INTO vodocty VALUES (126, 1183, '2007-09-08 11:30:00', 54);
INSERT INTO vodocty VALUES (126, 1183, '2007-09-07 11:30:00', 65);
INSERT INTO vodocty VALUES (120, 1180, '2007-09-08 11:30:00', 35);
INSERT INTO vodocty VALUES (123, 1181, '2007-09-10 13:00:00', 60);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-10 14:30:00', 96);
INSERT INTO vodocty VALUES (158, 1105, '2007-09-06 13:00:00', 32);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-06 13:00:00', 144);
INSERT INTO vodocty VALUES (120, 1180, '2007-09-07 11:30:00', 42);
INSERT INTO vodocty VALUES (123, 1181, '2007-09-09 16:00:00', 64);
INSERT INTO vodocty VALUES (158, 1105, '2007-09-05 13:00:00', 30);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-05 13:00:00', 119);
INSERT INTO vodocty VALUES (120, 1180, '2007-09-06 12:30:00', 33);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-10 14:30:00', 99);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-10 14:30:00', 71);
INSERT INTO vodocty VALUES (158, 1105, '2007-09-08 11:30:00', 33);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-08 11:30:00', 151);
INSERT INTO vodocty VALUES (120, 1180, '2007-09-05 17:00:00', 28);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-09 14:30:00', 103);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-09 14:30:00', 78);
INSERT INTO vodocty VALUES (158, 1105, '2007-09-07 14:00:00', 41);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-07 19:30:00', 164);
INSERT INTO vodocty VALUES (139, 1144, '2007-09-08 10:00:00', 30);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-10 22:00:00', 197);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-06 14:00:00', 132);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-08 23:00:00', 139);
INSERT INTO vodocty VALUES (139, 1144, '2007-09-07 10:00:00', 38);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-05 17:00:00', 61);
INSERT INTO vodocty VALUES (123, 1182, '2007-09-10 14:00:00', 46);
INSERT INTO vodocty VALUES (139, 1144, '2007-09-06 10:00:00', 18);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-10 14:30:00', 70);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-06 07:00:00', 95);
INSERT INTO vodocty VALUES (123, 1182, '2007-09-09 14:30:00', 46);
INSERT INTO vodocty VALUES (139, 1144, '2007-09-05 13:00:00', 17);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-09 14:30:00', 85);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 02:00:00', 207);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-05 13:00:00', 67);
INSERT INTO vodocty VALUES (123, 1182, '2007-09-08 11:30:00', 46);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-08 13:00:00', 109);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-06 14:00:00', 158);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-10 14:30:00', 195);
INSERT INTO vodocty VALUES (123, 1182, '2007-09-07 11:30:00', 49);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-05 17:00:00', 101);
INSERT INTO vodocty VALUES (123, 1182, '2007-09-06 12:30:00', 47);
INSERT INTO vodocty VALUES (139, 1144, '2007-09-10 13:00:00', 24);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-06 07:00:00', 14);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-10 14:30:00', 115);
INSERT INTO vodocty VALUES (123, 1182, '2007-09-05 17:00:00', 45);
INSERT INTO vodocty VALUES (139, 1144, '2007-09-09 13:00:00', 25);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-05 13:00:00', 1);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-09 14:30:00', 129);
INSERT INTO vodocty VALUES (123, 1181, '2007-09-06 19:00:00', 93);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-08 13:00:00', 129);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-08 11:30:00', 90);
INSERT INTO vodocty VALUES (158, 1105, '2007-09-10 14:30:00', 32);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-10 14:30:00', 133);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-05 17:00:00', 65);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-07 13:00:00', 127);
INSERT INTO vodocty VALUES (158, 1105, '2007-09-09 14:30:00', 33);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-09 14:30:00', 137);
INSERT INTO vodocty VALUES (120, 1180, '2007-09-10 14:00:00', 31);
INSERT INTO vodocty VALUES (123, 1181, '2007-09-08 13:00:00', 74);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-06 14:00:00', 114);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-06 14:00:00', 114);
INSERT INTO vodocty VALUES (120, 1180, '2007-09-09 14:30:00', 36);
INSERT INTO vodocty VALUES (123, 1181, '2007-09-07 19:00:00', 98);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-05 17:00:00', 70);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-05 17:00:00', 45);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-05 13:00:00', 110);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-08 16:00:00', 167);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-08 13:00:00', 236);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-06 13:00:00', 162);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-05 13:00:00', 66);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-06 13:00:00', 196);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-08 16:00:00', 199);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-05 13:00:00', 136);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-10 14:30:00', 162);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-09 14:30:00', 170);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-10 14:30:00', 196);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-09 14:30:00', 206);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-10 16:00:00', 150);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-09 16:00:00', 158);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-10 14:30:00', 169);
INSERT INTO vodocty VALUES (154, 1097, '2007-09-06 14:00:00', 74);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-09 14:30:00', 183);
INSERT INTO vodocty VALUES (154, 1097, '2007-09-05 17:00:00', 62);
INSERT INTO vodocty VALUES (154, 1097, '2007-09-08 11:30:00', 103);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-10 14:30:00', 138);
INSERT INTO vodocty VALUES (154, 1097, '2007-09-07 11:30:00', 118);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-09 14:30:00', 154);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-10 14:30:00', 234);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-09 14:30:00', 245);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-10 14:30:00', 211);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-09 14:30:00', 223);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-08 16:00:00', 252);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-06 13:00:00', 191);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-05 13:00:00', 88);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-06 13:00:00', 190);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-08 23:00:00', 277);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-05 13:00:00', 147);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-06 13:00:00', 137);
INSERT INTO vodocty VALUES (154, 1097, '2007-09-10 14:30:00', 92);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-08 20:00:00', 176);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-05 13:00:00', 107);
INSERT INTO vodocty VALUES (154, 1097, '2007-09-09 14:30:00', 97);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-08 13:00:00', 198);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-06 09:00:00', 119);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-05 17:00:00', 80);
INSERT INTO vodocty VALUES (141, 1173, '2007-09-06 10:00:00', 76);
INSERT INTO vodocty VALUES (141, 1173, '2007-09-05 13:00:00', 71);
INSERT INTO vodocty VALUES (141, 1173, '2007-09-08 10:00:00', 72);
INSERT INTO vodocty VALUES (141, 1173, '2007-09-07 10:00:00', 71);
INSERT INTO vodocty VALUES (141, 1173, '2007-09-10 13:00:00', 72);
INSERT INTO vodocty VALUES (141, 1173, '2007-09-09 13:00:00', 73);
INSERT INTO vodocty VALUES (185, 1176, '2007-09-10 14:30:00', 18);
INSERT INTO vodocty VALUES (185, 1176, '2007-09-09 14:30:00', 21);
INSERT INTO vodocty VALUES (183, 1152, '2007-09-08 07:00:00', 23);
INSERT INTO vodocty VALUES (191, 1175, '2007-09-10 14:30:00', 67);
INSERT INTO vodocty VALUES (183, 1152, '2007-09-07 10:00:00', 34);
INSERT INTO vodocty VALUES (191, 1175, '2007-09-09 14:30:00', 69);
INSERT INTO vodocty VALUES (183, 1152, '2007-09-06 10:00:00', 32);
INSERT INTO vodocty VALUES (185, 1178, '2007-09-10 14:30:00', 41);
INSERT INTO vodocty VALUES (190, 1172, '2007-09-10 13:00:00', 111);
INSERT INTO vodocty VALUES (183, 1152, '2007-09-05 13:00:00', 6);
INSERT INTO vodocty VALUES (185, 1178, '2007-09-09 14:30:00', 47);
INSERT INTO vodocty VALUES (190, 1172, '2007-09-09 13:00:00', 111);
INSERT INTO vodocty VALUES (185, 1178, '2007-09-08 11:30:00', 62);
INSERT INTO vodocty VALUES (190, 1172, '2007-09-08 10:00:00', 108);
INSERT INTO vodocty VALUES (191, 1175, '2007-09-06 14:00:00', 70);
INSERT INTO vodocty VALUES (185, 1178, '2007-09-07 11:30:00', 100);
INSERT INTO vodocty VALUES (190, 1172, '2007-09-07 10:00:00', 112);
INSERT INTO vodocty VALUES (191, 1175, '2007-09-05 17:00:00', 54);
INSERT INTO vodocty VALUES (183, 1152, '2007-09-10 13:00:00', 28);
INSERT INTO vodocty VALUES (185, 1178, '2007-09-06 14:00:00', 55);
INSERT INTO vodocty VALUES (190, 1172, '2007-09-06 10:00:00', 114);
INSERT INTO vodocty VALUES (191, 1175, '2007-09-08 11:30:00', 82);
INSERT INTO vodocty VALUES (183, 1152, '2007-09-09 07:00:00', 24);
INSERT INTO vodocty VALUES (185, 1178, '2007-09-05 17:00:00', 21);
INSERT INTO vodocty VALUES (190, 1172, '2007-09-05 13:00:00', 113);
INSERT INTO vodocty VALUES (191, 1175, '2007-09-07 11:30:00', 106);
INSERT INTO vodocty VALUES (185, 1176, '2007-09-08 11:30:00', 28);
INSERT INTO vodocty VALUES (185, 1176, '2007-09-07 11:30:00', 49);
INSERT INTO vodocty VALUES (185, 1176, '2007-09-06 14:00:00', 24);
INSERT INTO vodocty VALUES (185, 1176, '2007-09-05 17:00:00', 7);
INSERT INTO vodocty VALUES (189, 1166, '2007-09-08 11:30:00', 35);
INSERT INTO vodocty VALUES (189, 1166, '2007-09-07 11:30:00', 37);
INSERT INTO vodocty VALUES (189, 1166, '2007-09-06 14:00:00', 36);
INSERT INTO vodocty VALUES (189, 1166, '2007-09-05 17:00:00', 35);
INSERT INTO vodocty VALUES (185, 1157, '2007-09-06 14:00:00', 92);
INSERT INTO vodocty VALUES (185, 1157, '2007-09-05 17:00:00', 70);
INSERT INTO vodocty VALUES (185, 1154, '2007-09-10 14:30:00', 82);
INSERT INTO vodocty VALUES (185, 1157, '2007-09-08 11:30:00', 128);
INSERT INTO vodocty VALUES (185, 1154, '2007-09-09 14:30:00', 89);
INSERT INTO vodocty VALUES (185, 1157, '2007-09-07 11:30:00', 149);
INSERT INTO vodocty VALUES (185, 1154, '2007-09-08 11:30:00', 115);
INSERT INTO vodocty VALUES (185, 1157, '2007-09-10 14:30:00', 94);
INSERT INTO vodocty VALUES (185, 1154, '2007-09-07 11:30:00', 143);
INSERT INTO vodocty VALUES (185, 1157, '2007-09-09 14:30:00', 101);
INSERT INTO vodocty VALUES (185, 1154, '2007-09-06 14:00:00', 77);
INSERT INTO vodocty VALUES (185, 1154, '2007-09-05 17:00:00', 52);
INSERT INTO vodocty VALUES (189, 1166, '2007-09-10 14:00:00', 35);
INSERT INTO vodocty VALUES (189, 1166, '2007-09-09 14:30:00', 34);
INSERT INTO vodocty VALUES (187, 1160, '2007-09-08 07:00:00', 54);
INSERT INTO vodocty VALUES (187, 1160, '2007-09-07 13:00:00', 71);
INSERT INTO vodocty VALUES (185, 1162, '2007-09-10 14:30:00', 69);
INSERT INTO vodocty VALUES (187, 1160, '2007-09-06 10:00:00', 53);
INSERT INTO vodocty VALUES (185, 1162, '2007-09-09 14:30:00', 81);
INSERT INTO vodocty VALUES (187, 1160, '2007-09-05 13:00:00', 22);
INSERT INTO vodocty VALUES (185, 1162, '2007-09-08 11:30:00', 118);
INSERT INTO vodocty VALUES (185, 1162, '2007-09-07 11:30:00', 116);
INSERT INTO vodocty VALUES (185, 1162, '2007-09-06 14:00:00', 73);
INSERT INTO vodocty VALUES (187, 1160, '2007-09-10 13:00:00', 43);
INSERT INTO vodocty VALUES (185, 1162, '2007-09-05 17:00:00', 39);
INSERT INTO vodocty VALUES (187, 1160, '2007-09-09 07:00:00', 47);
INSERT INTO vodocty VALUES (160, 1108, '2007-09-08 11:30:00', 137);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-08 14:30:00', 215);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-06 13:00:00', 168);
INSERT INTO vodocty VALUES (177, 1137, '2007-09-10 13:00:00', 36);
INSERT INTO vodocty VALUES (179, 1141, '2007-09-10 16:00:00', 32);
INSERT INTO vodocty VALUES (160, 1108, '2007-09-07 11:30:00', 163);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 04:00:00', 176);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-05 13:00:00', 121);
INSERT INTO vodocty VALUES (177, 1137, '2007-09-09 13:00:00', 40);
INSERT INTO vodocty VALUES (179, 1141, '2007-09-09 16:00:00', 32);
INSERT INTO vodocty VALUES (160, 1108, '2007-09-06 14:00:00', 128);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-06 14:00:00', 150);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-08 16:00:00', 291);
INSERT INTO vodocty VALUES (164, 1114, '2007-09-10 14:30:00', 121);
INSERT INTO vodocty VALUES (166, 1118, '2007-09-10 13:00:00', 44);
INSERT INTO vodocty VALUES (160, 1108, '2007-09-05 17:00:00', 122);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-05 17:00:00', 67);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-07 07:00:00', 209);
INSERT INTO vodocty VALUES (164, 1114, '2007-09-09 15:00:00', 123);
INSERT INTO vodocty VALUES (166, 1118, '2007-09-09 13:00:00', 40);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-06 14:00:00', 54);
INSERT INTO vodocty VALUES (165, 1116, '2007-09-08 10:00:00', 28);
INSERT INTO vodocty VALUES (167, 1119, '2007-09-10 13:00:00', 57);
INSERT INTO vodocty VALUES (178, 1139, '2007-09-06 13:00:00', 10);
INSERT INTO vodocty VALUES (182, 1147, '2007-09-06 14:00:00', 23);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-05 17:00:00', 16);
INSERT INTO vodocty VALUES (165, 1116, '2007-09-07 10:00:00', 32);
INSERT INTO vodocty VALUES (167, 1119, '2007-09-09 13:00:00', 63);
INSERT INTO vodocty VALUES (178, 1139, '2007-09-05 13:00:00', 9);
INSERT INTO vodocty VALUES (182, 1147, '2007-09-05 17:00:00', 12);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-08 16:00:00', 80);
INSERT INTO vodocty VALUES (165, 1116, '2007-09-06 10:00:00', 28);
INSERT INTO vodocty VALUES (177, 1138, '2007-09-10 16:00:00', 22);
INSERT INTO vodocty VALUES (178, 1139, '2007-09-08 13:00:00', 10);
INSERT INTO vodocty VALUES (178, 1140, '2007-09-10 16:00:00', 26);
INSERT INTO vodocty VALUES (182, 1147, '2007-09-08 11:30:00', 22);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 02:30:00', 74);
INSERT INTO vodocty VALUES (165, 1116, '2007-09-05 13:00:00', 27);
INSERT INTO vodocty VALUES (177, 1138, '2007-09-09 16:00:00', 22);
INSERT INTO vodocty VALUES (178, 1139, '2007-09-07 13:00:00', 10);
INSERT INTO vodocty VALUES (178, 1140, '2007-09-09 16:00:00', 24);
INSERT INTO vodocty VALUES (182, 1147, '2007-09-07 11:30:00', 32);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-10 14:30:00', 45);
INSERT INTO vodocty VALUES (167, 1119, '2007-09-06 10:00:00', 42);
INSERT INTO vodocty VALUES (177, 1138, '2007-09-08 13:00:00', 23);
INSERT INTO vodocty VALUES (178, 1139, '2007-09-10 16:00:00', 10);
INSERT INTO vodocty VALUES (178, 1140, '2007-09-08 13:00:00', 24);
INSERT INTO vodocty VALUES (182, 1147, '2007-09-10 14:30:00', 18);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-09 14:30:00', 56);
INSERT INTO vodocty VALUES (167, 1119, '2007-09-05 13:00:00', 37);
INSERT INTO vodocty VALUES (177, 1138, '2007-09-07 13:00:00', 23);
INSERT INTO vodocty VALUES (178, 1139, '2007-09-09 16:00:00', 10);
INSERT INTO vodocty VALUES (178, 1140, '2007-09-07 13:00:00', 24);
INSERT INTO vodocty VALUES (182, 1147, '2007-09-09 14:30:00', 19);
INSERT INTO vodocty VALUES (165, 1116, '2007-09-10 13:00:00', 27);
INSERT INTO vodocty VALUES (167, 1119, '2007-09-08 10:00:00', 78);
INSERT INTO vodocty VALUES (177, 1138, '2007-09-06 13:00:00', 19);
INSERT INTO vodocty VALUES (178, 1140, '2007-09-06 13:00:00', 24);
INSERT INTO vodocty VALUES (165, 1116, '2007-09-09 13:00:00', 29);
INSERT INTO vodocty VALUES (167, 1119, '2007-09-07 10:00:00', 199);
INSERT INTO vodocty VALUES (177, 1138, '2007-09-05 13:00:00', 19);
INSERT INTO vodocty VALUES (178, 1140, '2007-09-05 13:00:00', 25);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-10 14:30:00', 183);
INSERT INTO vodocty VALUES (164, 1114, '2007-09-08 11:30:00', 135);
INSERT INTO vodocty VALUES (166, 1118, '2007-09-08 10:00:00', 40);
INSERT INTO vodocty VALUES (177, 1137, '2007-09-06 13:00:00', 28);
INSERT INTO vodocty VALUES (179, 1141, '2007-09-06 13:00:00', 32);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-09 14:30:00', 210);
INSERT INTO vodocty VALUES (164, 1114, '2007-09-07 11:30:00', 141);
INSERT INTO vodocty VALUES (166, 1118, '2007-09-07 10:00:00', 48);
INSERT INTO vodocty VALUES (177, 1137, '2007-09-05 13:00:00', 24);
INSERT INTO vodocty VALUES (179, 1141, '2007-09-05 13:00:00', 35);
INSERT INTO vodocty VALUES (160, 1108, '2007-09-10 14:30:00', 132);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-10 14:30:00', 129);
INSERT INTO vodocty VALUES (164, 1114, '2007-09-06 12:30:00', 132);
INSERT INTO vodocty VALUES (166, 1118, '2007-09-06 10:00:00', 39);
INSERT INTO vodocty VALUES (177, 1137, '2007-09-08 10:00:00', 40);
INSERT INTO vodocty VALUES (179, 1141, '2007-09-08 13:00:00', 35);
INSERT INTO vodocty VALUES (160, 1108, '2007-09-09 14:30:00', 134);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-09 14:30:00', 150);
INSERT INTO vodocty VALUES (164, 1114, '2007-09-05 17:00:00', 107);
INSERT INTO vodocty VALUES (166, 1118, '2007-09-05 13:00:00', 35);
INSERT INTO vodocty VALUES (177, 1137, '2007-09-07 13:00:00', 44);
INSERT INTO vodocty VALUES (179, 1141, '2007-09-07 13:00:00', 34);
INSERT INTO vodocty VALUES (129, 1055, '2007-09-06 10:00:00', 30);
INSERT INTO vodocty VALUES (145, 1081, '2007-09-10 13:00:00', 39);
INSERT INTO vodocty VALUES (162, 1112, '2007-09-08 11:30:00', 24);
INSERT INTO vodocty VALUES (129, 1055, '2007-09-05 13:00:00', 37);
INSERT INTO vodocty VALUES (145, 1081, '2007-09-09 13:00:00', 42);
INSERT INTO vodocty VALUES (162, 1112, '2007-09-07 11:30:00', 37);
INSERT INTO vodocty VALUES (129, 1055, '2007-09-08 10:00:00', 28);
INSERT INTO vodocty VALUES (162, 1112, '2007-09-06 12:30:00', 22);
INSERT INTO vodocty VALUES (129, 1055, '2007-09-07 10:00:00', 26);
INSERT INTO vodocty VALUES (162, 1112, '2007-09-05 17:00:00', 2);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-05 17:00:00', 88);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-06 09:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-06 19:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 02:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 03:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 04:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 05:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 06:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 07:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 08:00:00', 89);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 09:00:00', 89);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 10:00:00', 105);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 12:00:00', 105);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 15:00:00', 115);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 18:00:00', 76);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-07 21:00:00', 76);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-08 00:00:00', 76);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-08 03:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-08 06:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-08 09:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-08 11:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-08 17:00:00', 76);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-08 23:00:00', 76);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-09 07:00:00', 76);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-09 15:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-09 23:00:00', 76);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-10 07:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-10 15:00:00', 77);
INSERT INTO vodocty VALUES (101, 1007, '2007-09-10 22:00:00', 77);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-05 17:00:00', 43);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-06 09:00:00', 61);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-06 19:00:00', 104);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 02:00:00', 136);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 03:00:00', 138);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 04:00:00', 139);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 05:00:00', 139);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 06:00:00', 138);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 07:00:00', 136);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 08:00:00', 135);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 09:00:00', 134);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 10:00:00', 131);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 12:00:00', 124);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 15:00:00', 113);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 18:00:00', 105);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-07 21:00:00', 102);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-08 00:00:00', 103);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-08 03:00:00', 98);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-08 06:00:00', 83);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-08 09:00:00', 74);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-08 11:00:00', 72);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-08 17:00:00', 68);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-08 23:00:00', 65);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-09 07:00:00', 62);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-09 15:00:00', 60);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-09 22:00:00', 59);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-10 07:00:00', 57);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-10 15:00:00', 56);
INSERT INTO vodocty VALUES (101, 1009, '2007-09-10 22:00:00', 55);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-05 17:00:00', 22);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-06 09:00:00', 57);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-06 19:00:00', 128);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 02:00:00', 171);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 03:00:00', 180);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 04:00:00', 179);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 05:00:00', 179);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 06:00:00', 180);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 07:00:00', 177);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 08:00:00', 186);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 09:00:00', 189);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 10:00:00', 166);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 12:00:00', 177);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 15:00:00', 166);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 18:00:00', 160);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-07 21:00:00', 151);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-08 00:00:00', 146);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-08 03:00:00', 145);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-08 06:00:00', 120);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-08 09:00:00', 117);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-08 11:00:00', 112);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-08 17:00:00', 94);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-08 23:00:00', 102);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-09 07:00:00', 100);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-09 15:00:00', 95);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-09 22:00:00', 92);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-10 07:00:00', 89);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-10 15:00:00', 85);
INSERT INTO vodocty VALUES (101, 1015, '2007-09-10 22:00:00', 85);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-05 17:00:00', 108);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-06 09:00:00', 56);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-06 19:00:00', 103);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 02:00:00', 90);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 03:00:00', 90);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 04:00:00', 89);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 05:00:00', 88);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 06:00:00', 88);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 07:00:00', 75);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 08:00:00', 57);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 09:00:00', 88);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 10:00:00', 79);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 12:00:00', 71);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 15:00:00', 105);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 18:00:00', 96);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-07 21:00:00', 103);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-08 00:00:00', 107);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-08 03:00:00', 106);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-08 06:00:00', 105);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-08 09:00:00', 108);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-08 11:00:00', 92);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-08 17:00:00', 110);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-08 23:00:00', 104);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-09 07:00:00', 106);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-09 15:00:00', 104);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-09 22:00:00', 110);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-10 07:00:00', 104);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-10 15:00:00', 92);
INSERT INTO vodocty VALUES (101, 1168, '2007-09-10 22:00:00', 99);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-07 02:00:00', 133);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-07 03:00:00', 132);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-07 04:00:00', 131);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-07 05:00:00', 127);
INSERT INTO vodocty VALUES (102, 1004, '2007-09-07 06:00:00', 121);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 02:00:00', 193);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 03:00:00', 200);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 04:00:00', 204);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 05:00:00', 206);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 06:00:00', 208);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 07:00:00', 210);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 08:00:00', 212);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 09:00:00', 216);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 10:00:00', 219);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 12:00:00', 224);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 15:00:00', 223);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 18:00:00', 217);
INSERT INTO vodocty VALUES (102, 1005, '2007-09-07 21:00:00', 207);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-06 09:00:00', 111);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-06 19:00:00', 176);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 02:00:00', 194);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 03:00:00', 198);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 04:00:00', 202);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 05:00:00', 206);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 06:00:00', 210);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 07:00:00', 215);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 08:00:00', 217);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 09:00:00', 213);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 10:00:00', 208);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 12:00:00', 191);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 15:00:00', 148);
INSERT INTO vodocty VALUES (105, 1010, '2007-09-07 18:00:00', 107);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-06 16:00:00', 137);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 02:00:00', 192);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 04:00:00', 212);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 05:00:00', 218);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 06:00:00', 220);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 07:00:00', 222);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 08:00:00', 222);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 09:00:00', 221);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 10:00:00', 221);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 12:00:00', 217);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 15:00:00', 204);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 18:00:00', 177);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-07 21:00:00', 149);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-08 00:00:00', 130);
INSERT INTO vodocty VALUES (106, 1011, '2007-09-08 03:00:00', 115);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 06:00:00', 162);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 07:00:00', 161);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 08:00:00', 161);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 09:00:00', 161);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 10:00:00', 174);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 12:00:00', 176);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 15:00:00', 184);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 18:00:00', 189);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-07 21:00:00', 178);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-08 00:00:00', 171);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-08 03:00:00', 167);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-08 06:00:00', 163);
INSERT INTO vodocty VALUES (106, 1014, '2007-09-08 09:00:00', 160);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-07 05:00:00', 152);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-07 06:00:00', 155);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-07 07:00:00', 157);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-07 08:00:00', 156);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-07 09:00:00', 154);
INSERT INTO vodocty VALUES (107, 1013, '2007-09-07 10:00:00', 151);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 02:00:00', 163);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 03:00:00', 170);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 04:00:00', 175);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 05:00:00', 179);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 06:00:00', 183);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 07:00:00', 187);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 08:00:00', 189);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 09:00:00', 191);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 10:00:00', 194);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 12:00:00', 195);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 15:00:00', 196);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 18:00:00', 201);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-07 21:00:00', 198);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-08 00:00:00', 190);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-08 03:00:00', 180);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-08 06:00:00', 169);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-08 09:00:00', 157);
INSERT INTO vodocty VALUES (108, 1016, '2007-09-08 11:00:00', 151);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-08 09:00:00', 320);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-08 11:00:00', 329);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-08 17:00:00', 335);
INSERT INTO vodocty VALUES (108, 1017, '2007-09-08 23:00:00', 315);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-07 07:00:00', 255);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-07 08:00:00', 250);
INSERT INTO vodocty VALUES (111, 1032, '2007-09-07 09:00:00', 250);
INSERT INTO vodocty VALUES (111, 1125, '2007-09-06 19:00:00', 145);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-06 19:00:00', 120);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-07 02:00:00', 133);
INSERT INTO vodocty VALUES (111, 1126, '2007-09-07 03:00:00', 124);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-06 19:00:00', 155);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 02:00:00', 204);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 03:00:00', 198);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 04:00:00', 189);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 05:00:00', 179);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 06:00:00', 173);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 07:00:00', 164);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 08:00:00', 158);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 10:00:00', 145);
INSERT INTO vodocty VALUES (114, 1028, '2007-09-07 12:00:00', 130);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-06 19:00:00', 123);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 02:00:00', 173);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 03:00:00', 170);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 04:00:00', 164);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 05:00:00', 158);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 06:00:00', 152);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 07:00:00', 145);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 08:00:00', 137);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 09:00:00', 131);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 10:00:00', 125);
INSERT INTO vodocty VALUES (114, 1029, '2007-09-07 12:00:00', 113);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-05 17:00:00', 93);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-06 09:00:00', 177);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-06 19:00:00', 266);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 02:00:00', 283);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 03:00:00', 300);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 04:00:00', 311);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 05:00:00', 316);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 06:00:00', 319);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 07:00:00', 328);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 08:00:00', 385);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 09:00:00', 400);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 10:00:00', 397);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 12:00:00', 405);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 15:00:00', 459);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 18:00:00', 518);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-07 21:00:00', 570);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-08 00:00:00', 597);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-08 03:00:00', 607);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-08 06:00:00', 611);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-08 09:00:00', 616);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-08 11:00:00', 617);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-08 16:00:00', 604);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-08 23:00:00', 521);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-09 07:00:00', 432);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-09 15:00:00', 338);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-09 22:00:00', 305);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-10 06:00:00', 311);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-10 15:00:00', 298);
INSERT INTO vodocty VALUES (118, 1036, '2007-09-10 22:00:00', 292);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-05 17:00:00', 128);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-06 09:00:00', 157);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-06 19:00:00', 161);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 02:00:00', 170);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 03:00:00', 168);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 04:00:00', 166);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 05:00:00', 164);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 06:00:00', 162);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 07:00:00', 160);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 08:00:00', 159);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 09:00:00', 157);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 10:00:00', 155);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 12:00:00', 153);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 15:00:00', 151);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 18:00:00', 149);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-07 21:00:00', 147);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-08 00:00:00', 145);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-08 03:00:00', 145);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-08 06:00:00', 144);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-08 09:00:00', 143);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-08 11:00:00', 140);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-08 17:00:00', 142);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-08 23:00:00', 142);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-09 07:00:00', 147);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-09 15:00:00', 146);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-09 22:00:00', 144);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-10 07:00:00', 144);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-10 15:00:00', 143);
INSERT INTO vodocty VALUES (118, 1102, '2007-09-10 22:00:00', 143);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-05 13:00:00', 68);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-06 07:00:00', 118);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-06 19:00:00', 155);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-07 07:00:00', 151);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-07 12:00:00', 131);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-07 15:00:00', 125);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-07 18:00:00', 120);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-07 21:00:00', 117);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-08 00:00:00', 115);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-08 03:00:00', 114);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-08 06:00:00', 113);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-08 09:00:00', 112);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-08 11:00:00', 110);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-08 17:00:00', 107);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-08 23:00:00', 105);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-09 07:00:00', 107);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-09 15:00:00', 107);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-09 22:00:00', 104);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-10 07:00:00', 103);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-10 15:00:00', 99);
INSERT INTO vodocty VALUES (118, 1103, '2007-09-10 22:00:00', 99);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-05 13:00:00', 77);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-06 07:00:00', 77);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-06 19:00:00', 124);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-07 07:00:00', 171);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-07 12:00:00', 164);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-07 15:00:00', 165);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-07 18:00:00', 157);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-07 21:00:00', 138);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-08 00:00:00', 122);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-08 03:00:00', 111);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-08 06:00:00', 104);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-08 09:00:00', 104);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-08 11:00:00', 103);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-08 17:00:00', 102);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-08 23:00:00', 94);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-09 07:00:00', 92);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-09 15:00:00', 92);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-09 22:00:00', 91);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-10 07:00:00', 88);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-10 15:00:00', 88);
INSERT INTO vodocty VALUES (118, 1106, '2007-09-10 22:00:00', 86);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-05 13:00:00', 91);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-06 07:00:00', 90);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-06 19:00:00', 96);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-07 07:00:00', 211);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-07 12:00:00', 233);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-07 15:00:00', 246);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-07 18:00:00', 251);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-07 21:00:00', 253);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-08 00:00:00', 251);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-08 03:00:00', 245);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-08 06:00:00', 232);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-08 09:00:00', 211);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-08 11:00:00', 203);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-08 17:00:00', 180);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-08 23:00:00', 174);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-09 07:00:00', 163);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-09 15:00:00', 154);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-09 22:00:00', 151);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-10 07:00:00', 148);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-10 15:00:00', 142);
INSERT INTO vodocty VALUES (118, 1109, '2007-09-10 22:00:00', 138);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-05 17:00:00', 0);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-06 09:00:00', 0);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-06 19:00:00', 216);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 02:00:00', 202);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 03:00:00', 204);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 04:00:00', 206);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 05:00:00', 208);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 06:00:00', 211);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 07:00:00', 219);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 08:00:00', 224);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 09:00:00', 242);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 10:00:00', 282);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 12:00:00', 322);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 15:00:00', 411);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 18:00:00', 445);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-07 21:00:00', 458);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-08 00:00:00', 469);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-08 03:00:00', 474);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-08 06:00:00', 475);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-08 09:00:00', 455);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-08 11:00:00', 425);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-08 16:00:00', 365);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-08 23:00:00', 306);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-09 07:00:00', 261);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-09 15:00:00', 235);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-09 22:00:00', 228);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-10 06:00:00', 218);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-10 15:00:00', 213);
INSERT INTO vodocty VALUES (118, 1191, '2007-09-10 22:00:00', 198);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-05 17:00:00', 97);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-06 09:00:00', 138);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-06 19:00:00', 211);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 02:00:00', 246);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 03:00:00', 247);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 04:00:00', 248);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 05:00:00', 251);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 06:00:00', 258);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 07:00:00', 257);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 08:00:00', 243);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 09:00:00', 294);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 10:00:00', 323);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 12:00:00', 352);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 15:00:00', 427);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 18:00:00', 479);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-07 21:00:00', 473);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-08 00:00:00', 479);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-08 03:00:00', 482);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-08 06:00:00', 495);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-08 09:00:00', 497);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-08 11:00:00', 482);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-08 16:00:00', 414);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-08 23:00:00', 339);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-09 07:00:00', 303);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-09 15:00:00', 239);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-09 22:00:00', 240);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-10 06:00:00', 237);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-10 15:00:00', 228);
INSERT INTO vodocty VALUES (118, 1193, '2007-09-10 22:00:00', 211);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-05 17:00:00', 37);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-06 09:00:00', 55);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-06 19:00:00', 81);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 02:00:00', 114);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 03:00:00', 118);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 04:00:00', 125);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 05:00:00', 132);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 06:00:00', 138);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 07:00:00', 141);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 08:00:00', 144);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 09:00:00', 147);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 10:00:00', 149);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 12:00:00', 152);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 15:00:00', 152);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 18:00:00', 153);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-07 21:00:00', 152);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-08 00:00:00', 159);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-08 03:00:00', 163);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-08 06:00:00', 164);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-08 09:00:00', 163);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-08 11:00:00', 161);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-08 16:00:00', 143);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-08 23:00:00', 118);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-09 07:00:00', 108);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-09 15:00:00', 101);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-09 22:00:00', 97);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-10 06:00:00', 92);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-10 15:00:00', 86);
INSERT INTO vodocty VALUES (119, 1037, '2007-09-10 22:00:00', 82);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-05 17:00:00', 84);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-06 09:00:00', 89);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-06 19:00:00', 52);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 02:00:00', 52);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 03:00:00', 52);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 04:00:00', 52);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 05:00:00', 58);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 06:00:00', 59);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 07:00:00', 53);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 08:00:00', 81);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 09:00:00', 89);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 10:00:00', 89);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 12:00:00', 89);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 15:00:00', 80);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 18:00:00', 89);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-07 21:00:00', 83);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-08 00:00:00', 60);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-08 03:00:00', 52);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-08 06:00:00', 60);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-08 09:00:00', 71);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-08 11:00:00', 60);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-08 16:00:00', 85);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-08 23:00:00', 60);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-09 07:00:00', 52);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-09 15:00:00', 84);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-09 22:00:00', 85);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-10 06:00:00', 52);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-10 15:00:00', 84);
INSERT INTO vodocty VALUES (119, 1039, '2007-09-10 22:00:00', 60);
INSERT INTO vodocty VALUES (119, 1040, '2007-09-05 13:00:00', 70);
INSERT INTO vodocty VALUES (119, 1040, '2007-09-06 07:00:00', 70);
INSERT INTO vodocty VALUES (119, 1040, '2007-09-06 19:00:00', 75);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-05 17:00:00', 61);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-06 09:00:00', 75);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-06 19:00:00', 93);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 02:00:00', 91);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 03:00:00', 91);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 04:00:00', 92);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 05:00:00', 93);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 06:00:00', 93);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 07:00:00', 94);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 08:00:00', 94);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 09:00:00', 94);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 10:00:00', 93);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 12:00:00', 97);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 15:00:00', 102);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 18:00:00', 108);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-07 21:00:00', 117);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-08 00:00:00', 116);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-08 03:00:00', 114);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-08 06:00:00', 111);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-08 09:00:00', 109);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-08 11:00:00', 107);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-08 16:00:00', 104);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-08 23:00:00', 98);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-09 07:00:00', 95);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-09 15:00:00', 94);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-09 22:00:00', 90);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-10 06:00:00', 84);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-10 15:00:00', 83);
INSERT INTO vodocty VALUES (119, 1041, '2007-09-10 22:00:00', 83);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-05 17:00:00', 21.700001);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-06 09:00:00', 84.900002);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-06 21:00:00', 159);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-06 23:00:00', 170);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 00:00:00', 176.2);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 01:00:00', 184.8);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 03:00:00', 205.89999);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 04:00:00', 214.89999);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 05:00:00', 220.7);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 06:00:00', 222.89999);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 08:00:00', 223.39999);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 09:00:00', 225.89999);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 10:00:00', 233.10001);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 12:00:00', 242);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 15:00:00', 239.39999);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 18:00:00', 213.8);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-07 21:00:00', 179.39999);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-08 00:00:00', 160.60001);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-08 03:00:00', 145.3);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-08 06:00:00', 136.2);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-08 09:00:00', 127.9);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-08 10:00:00', 127.3);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-08 16:00:00', 116.7);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-08 23:00:00', 108.4);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-09 07:00:00', 101.8);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-09 14:00:00', 96.099998);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-09 22:00:00', 90.400002);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-10 06:00:00', 84.5);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-10 14:00:00', 80.099998);
INSERT INTO vodocty VALUES (119, 1195, '2007-09-10 22:00:00', 77.400002);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-06 21:00:00', 182);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-06 23:00:00', 197);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 00:00:00', 204);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 02:00:00', 218);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 03:00:00', 223);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 04:00:00', 228);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 05:00:00', 231);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 06:00:00', 234);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 07:00:00', 237);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 08:00:00', 240);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 09:00:00', 242);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 10:00:00', 244);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 12:00:00', 246);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 15:00:00', 249);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 18:00:00', 259);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-07 21:00:00', 274);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-08 00:00:00', 278);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-08 03:00:00', 281);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-08 06:00:00', 279);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-08 09:00:00', 266);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-08 10:00:00', 259);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-08 16:00:00', 214);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-08 23:00:00', 192);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-09 07:00:00', 180);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-09 14:00:00', 173);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-09 22:00:00', 167);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-10 06:00:00', 159);
INSERT INTO vodocty VALUES (119, 1196, '2007-09-10 12:00:00', 155);
INSERT INTO vodocty VALUES (123, 1181, '2007-09-07 07:00:00', 120);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-05 13:00:00', 65);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-06 07:00:00', 65);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-06 13:00:00', 64);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-07 07:00:00', 61);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-07 13:00:00', 60);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-08 07:00:00', 59);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-08 13:00:00', 58);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-09 13:00:00', 64);
INSERT INTO vodocty VALUES (127, 1057, '2007-09-10 13:00:00', 63);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-05 13:00:00', 188);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-06 07:00:00', 188);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-06 13:00:00', 188);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-07 07:00:00', 229);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-07 13:00:00', 227);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-08 07:00:00', 240);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-08 13:00:00', 239);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-09 13:00:00', 212);
INSERT INTO vodocty VALUES (127, 1170, '2007-09-10 13:00:00', 224);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-05 13:00:00', 30);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-06 07:00:00', 34);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-06 13:00:00', 95);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-07 07:00:00', 83);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-07 13:00:00', 49);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-08 07:00:00', 41);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-08 13:00:00', 42);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-09 13:00:00', 45);
INSERT INTO vodocty VALUES (131, 1058, '2007-09-10 13:00:00', 42);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-05 13:00:00', 79);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-06 07:00:00', 78);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-06 13:00:00', 77);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-07 07:00:00', 162);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-07 13:00:00', 163);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-08 07:00:00', 106);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-08 13:00:00', 92);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-09 13:00:00', 93);
INSERT INTO vodocty VALUES (131, 1117, '2007-09-10 13:00:00', 89);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-05 13:00:00', 57);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-06 07:00:00', 55);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-06 13:00:00', 58);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-07 07:00:00', 148);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-07 13:00:00', 141);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-08 07:00:00', 85);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-08 13:00:00', 73);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-09 13:00:00', 69);
INSERT INTO vodocty VALUES (131, 1121, '2007-09-10 13:00:00', 71);
INSERT INTO vodocty VALUES (131, 1146, '2007-09-05 07:00:00', 112);
INSERT INTO vodocty VALUES (131, 1146, '2007-09-06 07:00:00', 111);
INSERT INTO vodocty VALUES (131, 1146, '2007-09-07 07:00:00', 145);
INSERT INTO vodocty VALUES (131, 1146, '2007-09-08 07:00:00', 98);
INSERT INTO vodocty VALUES (131, 1146, '2007-09-09 07:00:00', 114);
INSERT INTO vodocty VALUES (131, 1146, '2007-09-10 07:00:00', 119);
INSERT INTO vodocty VALUES (131, 1150, '2007-09-05 07:00:00', 127);
INSERT INTO vodocty VALUES (131, 1150, '2007-09-06 07:00:00', 128);
INSERT INTO vodocty VALUES (131, 1150, '2007-09-07 07:00:00', 176);
INSERT INTO vodocty VALUES (131, 1150, '2007-09-08 07:00:00', 146);
INSERT INTO vodocty VALUES (131, 1150, '2007-09-09 07:00:00', 152);
INSERT INTO vodocty VALUES (131, 1150, '2007-09-10 07:00:00', 130);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-05 17:00:00', 253);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-06 09:00:00', 251);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-06 19:00:00', 249);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 02:00:00', 243);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 03:00:00', 244);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 04:00:00', 248);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 05:00:00', 250);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 06:00:00', 251);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 07:00:00', 251);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 08:00:00', 264);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 09:00:00', 274);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 10:00:00', 281);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 12:00:00', 281);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 15:00:00', 273);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 18:00:00', 277);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-07 21:00:00', 279);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-08 00:00:00', 271);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-08 03:00:00', 259);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-08 06:00:00', 260);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-08 09:00:00', 255);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-08 11:00:00', 258);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-08 17:00:00', 249);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-08 23:00:00', 256);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-09 07:00:00', 250);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-09 15:00:00', 252);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-09 23:00:00', 246);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-10 07:00:00', 248);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-10 15:00:00', 251);
INSERT INTO vodocty VALUES (131, 1169, '2007-09-10 22:00:00', 250);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-05 13:00:00', 156);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-06 09:00:00', 157);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-06 19:00:00', 163);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 02:00:00', 167);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 03:00:00', 167);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 04:00:00', 174);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 05:00:00', 193);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 06:00:00', 212);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 07:00:00', 215);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 08:00:00', 201);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 09:00:00', 193);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 10:00:00', 211);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 12:00:00', 216);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 15:00:00', 223);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 18:00:00', 305);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-07 21:00:00', 294);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-08 00:00:00', 276);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-08 03:00:00', 278);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-08 06:00:00', 277);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-08 09:00:00', 265);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-08 11:00:00', 226);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-08 16:00:00', 221);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-08 23:00:00', 191);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-09 07:00:00', 190);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-09 15:00:00', 190);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-09 22:00:00', 191);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-10 06:00:00', 205);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-10 15:00:00', 198);
INSERT INTO vodocty VALUES (131, 1171, '2007-09-10 22:00:00', 197);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-05 17:00:00', 129);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-06 09:00:00', 135);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-06 19:00:00', 135);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 02:00:00', 134);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 03:00:00', 134);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 04:00:00', 135);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 05:00:00', 136);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 06:00:00', 137);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 07:00:00', 138);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 08:00:00', 145);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 09:00:00', 154);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 10:00:00', 167);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 12:00:00', 175);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 15:00:00', 183);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 18:00:00', 195);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-07 21:00:00', 262);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-08 00:00:00', 267);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-08 03:00:00', 256);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-08 06:00:00', 254);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-08 09:00:00', 253);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-08 11:00:00', 251);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-08 17:00:00', 201);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-08 23:00:00', 190);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-09 07:00:00', 165);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-09 15:00:00', 163);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-09 22:00:00', 164);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-10 07:00:00', 177);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-10 15:00:00', 173);
INSERT INTO vodocty VALUES (131, 1197, '2007-09-10 22:00:00', 172);
INSERT INTO vodocty VALUES (140, 1072, '2007-09-06 13:00:00', 97);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-05 13:00:00', 76);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-06 07:00:00', 89);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-06 19:00:00', 120);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-07 07:00:00', 211);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-07 13:00:00', 250);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-07 19:00:00', 246);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-08 07:00:00', 203);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-08 13:00:00', 185);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-08 19:00:00', 171);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-09 13:00:00', 146);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-09 19:00:00', 139);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-10 13:00:00', 126);
INSERT INTO vodocty VALUES (147, 1086, '2007-09-10 19:00:00', 123);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-05 17:00:00', 116);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-06 09:00:00', 188);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-06 19:00:00', 218);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 02:00:00', 234);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 03:00:00', 244);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 04:00:00', 250);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 05:00:00', 262);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 06:00:00', 279);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 07:00:00', 299);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 08:00:00', 320);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 10:00:00', 348);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 12:00:00', 374);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 15:00:00', 395);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 18:00:00', 408);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-07 21:00:00', 417);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-08 00:00:00', 420);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-08 03:00:00', 424);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-08 06:00:00', 425);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-08 09:00:00', 422);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-08 11:00:00', 416);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-08 17:00:00', 397);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-08 23:00:00', 377);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-09 07:00:00', 347);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-09 15:00:00', 324);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-09 22:00:00', 307);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-10 07:00:00', 287);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-10 15:00:00', 269);
INSERT INTO vodocty VALUES (147, 1088, '2007-09-10 22:00:00', 251);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-05 13:00:00', 23);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-06 07:00:00', 139);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-06 19:00:00', 185);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-07 07:00:00', 311);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-07 13:00:00', 430);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-07 19:00:00', 444);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-08 07:00:00', 450);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-08 13:00:00', 435);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-08 19:00:00', 413);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-09 13:00:00', 342);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-09 19:00:00', 319);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-10 13:00:00', 244);
INSERT INTO vodocty VALUES (147, 1096, '2007-09-10 19:00:00', 228);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 04:00:00', 103);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 05:00:00', 122);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 06:00:00', 130);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 07:00:00', 136);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 08:00:00', 148);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 09:00:00', 160);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 10:00:00', 170);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 12:00:00', 168);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 15:00:00', 156);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 18:00:00', 138);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-07 21:00:00', 137);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-08 00:00:00', 120);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-08 03:00:00', 107);
INSERT INTO vodocty VALUES (148, 1087, '2007-09-08 06:00:00', 100);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-06 09:00:00', 122);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-06 19:00:00', 155);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 02:00:00', 188);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 03:00:00', 174);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 04:00:00', 166);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 05:00:00', 157);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 06:00:00', 151);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 07:00:00', 145);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 08:00:00', 140);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 09:00:00', 136);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 10:00:00', 132);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 12:00:00', 126);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 15:00:00', 120);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 18:00:00', 116);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-07 21:00:00', 111);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-08 00:00:00', 110);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-08 03:00:00', 114);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-08 06:00:00', 114);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-08 09:00:00', 111);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-08 11:00:00', 109);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-08 17:00:00', 106);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-08 23:00:00', 104);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-09 07:00:00', 104);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-09 15:00:00', 102);
INSERT INTO vodocty VALUES (149, 1089, '2007-09-09 22:00:00', 100);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-06 19:00:00', 133);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-07 07:00:00', 230);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-07 12:00:00', 186);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-07 15:00:00', 157);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-07 18:00:00', 141);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-07 21:00:00', 129);
INSERT INTO vodocty VALUES (149, 1090, '2007-09-08 00:00:00', 121);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 02:00:00', 248);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 03:00:00', 254);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 04:00:00', 257);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 05:00:00', 263);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 06:00:00', 272);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 07:00:00', 281);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 08:00:00', 291);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 09:00:00', 330);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 10:00:00', 373);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 12:00:00', 403);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 15:00:00', 412);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 18:00:00', 401);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-07 21:00:00', 379);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-08 00:00:00', 354);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-08 03:00:00', 333);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-08 06:00:00', 317);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-08 09:00:00', 305);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-08 11:00:00', 298);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-08 17:00:00', 291);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-08 23:00:00', 276);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-09 07:00:00', 252);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-09 15:00:00', 236);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-09 22:00:00', 224);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-10 07:00:00', 213);
INSERT INTO vodocty VALUES (149, 1091, '2007-09-10 15:00:00', 205);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 03:00:00', 213);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 04:00:00', 217);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 05:00:00', 221);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 06:00:00', 224);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 07:00:00', 228);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 08:00:00', 233);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 09:00:00', 237);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 10:00:00', 240);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 12:00:00', 245);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 15:00:00', 252);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 18:00:00', 256);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-07 21:00:00', 304);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-08 00:00:00', 370);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-08 03:00:00', 409);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-08 06:00:00', 405);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-08 09:00:00', 387);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-08 11:00:00', 373);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-08 17:00:00', 339);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-08 23:00:00', 317);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-09 07:00:00', 297);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-09 15:00:00', 274);
INSERT INTO vodocty VALUES (149, 1093, '2007-09-09 22:00:00', 243);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-06 19:00:00', 190);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-07 07:00:00', 232);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-07 12:00:00', 206);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-07 15:00:00', 198);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-07 18:00:00', 193);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-07 21:00:00', 179);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-08 00:00:00', 173);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-08 03:00:00', 175);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-08 06:00:00', 171);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-08 09:00:00', 164);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-08 11:00:00', 158);
INSERT INTO vodocty VALUES (150, 1090, '2007-09-08 17:00:00', 150);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 02:00:00', 160);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 03:00:00', 168);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 04:00:00', 171);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 05:00:00', 172);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 06:00:00', 172);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 07:00:00', 173);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 08:00:00', 174);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 09:00:00', 181);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 10:00:00', 190);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 12:00:00', 202);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 15:00:00', 191);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 18:00:00', 174);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-07 21:00:00', 161);
INSERT INTO vodocty VALUES (151, 1092, '2007-09-08 00:00:00', 151);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-07 07:00:00', 324);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-07 12:00:00', 326);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-07 15:00:00', 313);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-07 18:00:00', 316);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-07 21:00:00', 324);
INSERT INTO vodocty VALUES (152, 1094, '2007-09-08 00:00:00', 297);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-07 07:00:00', 291);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-07 12:00:00', 371);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-07 15:00:00', 360);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-07 18:00:00', 339);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-07 21:00:00', 341);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-08 00:00:00', 319);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-08 03:00:00', 277);
INSERT INTO vodocty VALUES (152, 1095, '2007-09-08 06:00:00', 246);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-07 07:00:00', 315);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-07 12:00:00', 267);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-07 15:00:00', 250);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-07 18:00:00', 244);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-07 21:00:00', 235);
INSERT INTO vodocty VALUES (153, 1097, '2007-09-08 00:00:00', 232);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-07 07:00:00', 399);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-07 12:00:00', 376);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-07 15:00:00', 338);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-07 18:00:00', 349);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-07 21:00:00', 346);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-08 00:00:00', 315);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-08 03:00:00', 300);
INSERT INTO vodocty VALUES (153, 1098, '2007-09-08 06:00:00', 289);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-07 07:00:00', 331);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-07 12:00:00', 430);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-07 15:00:00', 508);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-07 18:00:00', 520);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-07 21:00:00', 502);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-08 00:00:00', 501);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-08 03:00:00', 480);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-08 06:00:00', 434);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-08 09:00:00', 400);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-08 11:00:00', 381);
INSERT INTO vodocty VALUES (153, 1099, '2007-09-08 17:00:00', 317);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-06 19:00:00', 248);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 02:00:00', 370);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 03:00:00', 355);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 04:00:00', 364);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 05:00:00', 360);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 06:00:00', 350);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 07:00:00', 340);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 08:00:00', 329);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 09:00:00', 313);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 10:00:00', 301);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 12:00:00', 281);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 15:00:00', 257);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 18:00:00', 240);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-07 21:00:00', 227);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-08 00:00:00', 219);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-08 03:00:00', 214);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-08 06:00:00', 207);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-08 09:00:00', 199);
INSERT INTO vodocty VALUES (155, 1100, '2007-09-08 11:00:00', 194);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-06 07:00:00', 199);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-06 19:00:00', 249);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-07 07:00:00', 214);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-07 13:00:00', 192);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-07 19:00:00', 182);
INSERT INTO vodocty VALUES (156, 1101, '2007-09-08 07:00:00', 177);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-07 02:00:00', 196);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-07 03:00:00', 187);
INSERT INTO vodocty VALUES (157, 1104, '2007-09-07 04:00:00', 174);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-07 07:00:00', 188);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-07 12:00:00', 178);
INSERT INTO vodocty VALUES (159, 1107, '2007-09-07 15:00:00', 171);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 07:00:00', 286);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 08:00:00', 310);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 09:00:00', 320);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 10:00:00', 327);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 12:00:00', 348);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 15:00:00', 380);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 18:00:00', 401);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-07 21:00:00', 355);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-08 00:00:00', 309);
INSERT INTO vodocty VALUES (161, 1110, '2007-09-08 03:00:00', 272);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-07 12:00:00', 405);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-07 15:00:00', 452);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-07 18:00:00', 486);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-07 21:00:00', 508);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-08 00:00:00', 501);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-08 03:00:00', 447);
INSERT INTO vodocty VALUES (161, 1111, '2007-09-08 06:00:00', 376);
INSERT INTO vodocty VALUES (163, 1113, '2007-09-08 09:00:00', 72);
INSERT INTO vodocty VALUES (163, 1113, '2007-09-08 11:00:00', 71);
INSERT INTO vodocty VALUES (169, 1123, '2007-09-06 19:00:00', 126);
INSERT INTO vodocty VALUES (170, 1124, '2007-09-06 19:00:00', 111);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-05 13:00:00', 102);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-06 07:00:00', 102);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-06 19:00:00', 101);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-07 07:00:00', 107);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-07 13:00:00', 123);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-07 19:00:00', 135);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-08 07:00:00', 122);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-08 13:00:00', 129);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-08 19:00:00', 117);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-09 13:00:00', 111);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-09 19:00:00', 112);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-10 13:00:00', 117);
INSERT INTO vodocty VALUES (176, 1136, '2007-09-10 19:00:00', 114);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-05 13:00:00', 27);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-06 07:00:00', 34);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-06 19:00:00', 30);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-07 07:00:00', 31);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-07 13:00:00', 36);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-07 19:00:00', 37);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-08 07:00:00', 51);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-08 13:00:00', 48);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-08 19:00:00', 47);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-09 13:00:00', 37);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-09 19:00:00', 37);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-10 13:00:00', 38);
INSERT INTO vodocty VALUES (176, 1142, '2007-09-10 19:00:00', 40);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-05 17:00:00', 109);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-06 09:00:00', 119);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-06 19:00:00', 125);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 02:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 03:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 04:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 05:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 06:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 07:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 08:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 09:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 10:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 12:00:00', 121);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 15:00:00', 120);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 18:00:00', 118);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-07 21:00:00', 120);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-08 00:00:00', 123);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-08 03:00:00', 126);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-08 06:00:00', 129);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-08 09:00:00', 133);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-08 11:00:00', 136);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-08 17:00:00', 136);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-08 23:00:00', 134);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-09 07:00:00', 134);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-09 15:00:00', 132);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-09 22:00:00', 128);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-10 07:00:00', 126);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-10 15:00:00', 126);
INSERT INTO vodocty VALUES (176, 1164, '2007-09-10 22:00:00', 126);
INSERT INTO vodocty VALUES (180, 1143, '2007-09-06 13:00:00', 115);
INSERT INTO vodocty VALUES (180, 1143, '2007-09-07 07:00:00', 171);
INSERT INTO vodocty VALUES (180, 1143, '2007-09-07 13:00:00', 140);
INSERT INTO vodocty VALUES (187, 1160, '2007-09-07 07:00:00', 82);
INSERT INTO vodocty VALUES (194, 1189, '2007-09-07 07:00:00', 294);
INSERT INTO vodocty VALUES (194, 1189, '2007-09-07 12:00:00', 295);
INSERT INTO vodocty VALUES (195, 1190, '2007-09-07 07:00:00', 281);
INSERT INTO vodocty VALUES (195, 1190, '2007-09-07 13:00:00', 254);
INSERT INTO vodocty VALUES (195, 1190, '2007-09-07 19:00:00', 222);


--
-- Name: vodocty_pkey; Type: CONSTRAINT; Schema: public; Owner: cepek; Tablespace: 
--

ALTER TABLE ONLY vodocty
    ADD CONSTRAINT vodocty_pkey PRIMARY KEY (tok_id, stanice_id, cas);


--
-- Name: vodocty_stanice_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: cepek
--

ALTER TABLE ONLY vodocty
    ADD CONSTRAINT vodocty_stanice_id_fkey FOREIGN KEY (stanice_id) REFERENCES stanice(id);


--
-- Name: vodocty_tok_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: cepek
--

ALTER TABLE ONLY vodocty
    ADD CONSTRAINT vodocty_tok_id_fkey FOREIGN KEY (tok_id) REFERENCES toky(id);


--
-- PostgreSQL database dump complete
--

