SET search_path TO sqltutor;

DROP TABLE unesco_wh CASCADE;

CREATE TABLE unesco_wh (
   description  VARCHAR(200) NOT NULL,
   category     VARCHAR(20)  NOT NULL,
   country      VARCHAR(60)  NOT NULL,
   region       VARCHAR(50)  NOT NULL,
   inscription  INTEGER      NOT NULL,
   extension    VARCHAR(30)  NULL
);

BEGIN;

--  http://whc.unesco.org/en/list/   2007

INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Royal Palaces of Abomey', 'cultural', 'Benin', 'Africa', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tsodilo', 'cultural', 'Botswana', 'Africa', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock-Hewn Churches, Lalibela', 'cultural', 'Ethiopia', 'Africa', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fasil Ghebbi, Gondar Region', 'cultural', 'Ethiopia', 'Africa', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Aksum', 'cultural', 'Ethiopia', 'Africa', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lower Valley of the Awash', 'cultural', 'Ethiopia', 'Africa', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lower Valley of the Omo', 'cultural', 'Ethiopia', 'Africa', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tiya', 'cultural', 'Ethiopia', 'Africa', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Harar Jugol, the Fortified Historic Town', 'cultural', 'Ethiopia', 'Africa', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'James Island and Related Sites', 'cultural', 'Gambia', 'Africa', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Stone Circles of Senegambia', 'cultural', 'Gambia', 'Africa', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Forts and Castles, Volta, Greater Accra, Central and Western Regions', 'cultural', 'Ghana', 'Africa', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Asante Traditional Buildings', 'cultural', 'Ghana', 'Africa', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lamu Old Town', 'cultural', 'Kenya', 'Africa', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Royal Hill of Ambohimanga', 'cultural', 'Madagascar', 'Africa', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Chongoni Rock-Art Area', 'cultural', 'Malawi', 'Africa', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Towns of Djenné', 'cultural', 'Mali', 'Africa', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Timbuktu', 'cultural', 'Mali', 'Africa', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tomb of Askia', 'cultural', 'Mali', 'Africa', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Aapravasi Ghat', 'cultural', 'Mauritius', 'Africa', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Island of Mozambique', 'cultural', 'Mozambique', 'Africa', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Twyfelfontein or /Ui-//aes', 'cultural', 'Namibia', 'Africa', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sukur Cultural Landscape', 'cultural', 'Nigeria', 'Africa', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Osun-Osogbo Sacred Grove', 'cultural', 'Nigeria', 'Africa', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Island of Gorée', 'cultural', 'Senegal', 'Africa', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Island of Saint-Louis', 'cultural', 'Senegal', 'Africa', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Stone Circles of Senegambia', 'cultural', 'Senegal', 'Africa', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fossil Hominid Sites of Sterkfontein, Swartkrans, Kromdraai, and Environs', 'cultural', 'South Africa', 'Africa', 1999, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Robben Island', 'cultural', 'South Africa', 'Africa', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mapungubwe Cultural Landscape', 'cultural', 'South Africa', 'Africa', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Richtersveld Cultural and Botanical Landscape', 'cultural', 'South Africa', 'Africa', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Koutammakou, the Land of the Batammariba', 'cultural', 'Togo', 'Africa', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tombs of Buganda Kings at Kasubi', 'cultural', 'Uganda', 'Africa', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ruins of Kilwa Kisiwani and Ruins of Songo Mnara', 'cultural', 'United Republic of Tanzania', 'Africa', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Stone Town of Zanzibar', 'cultural', 'United Republic of Tanzania', 'Africa', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kondoa Rock-Art Sites', 'cultural', 'United Republic of Tanzania', 'Africa', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Great Zimbabwe National Monument', 'cultural', 'Zimbabwe', 'Africa', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Khami Ruins National Monument', 'cultural', 'Zimbabwe', 'Africa', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Matobo Hills', 'cultural', 'Zimbabwe', 'Africa', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Al Qal\'a of Beni Hammad', 'cultural', 'Algeria', 'Arab States', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Djémila', 'cultural', 'Algeria', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'M\'Zab Valley', 'cultural', 'Algeria', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Timgad', 'cultural', 'Algeria', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tipasa', 'cultural', 'Algeria', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kasbah of Algiers', 'cultural', 'Algeria', 'Arab States', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Qal’at al-Bahrain – Ancient Harbour and Capital of Dilmun', 'cultural', 'Bahrain', 'Arab States', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Abu Mena', 'cultural', 'Egypt', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient Thebes with its Necropolis', 'cultural', 'Egypt', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Cairo', 'cultural', 'Egypt', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Memphis and its Necropolis – the Pyramid Fields from Giza to Dahshur', 'cultural', 'Egypt', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Nubian Monuments from Abu Simbel to Philae', 'cultural', 'Egypt', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Saint Catherine Area', 'cultural', 'Egypt', 'Arab States', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hatra', 'cultural', 'Iraq', 'Arab States', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ashur (Qal\'at Sherqat)', 'cultural', 'Iraq', 'Arab States', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Samarra Archaeological City', 'cultural', 'Iraq', 'Arab States', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old City of Jerusalem and its Walls', 'cultural', 'Jerusalem (Site proposed by Jordan)', 'Arab States', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Petra', 'cultural', 'Jordan', 'Arab States', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Quseir Amra', 'cultural', 'Jordan', 'Arab States', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Um er-Rasas (Kastrom Mefa\'a)', 'cultural', 'Jordan', 'Arab States', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Anjar', 'cultural', 'Lebanon', 'Arab States', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Baalbek', 'cultural', 'Lebanon', 'Arab States', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Byblos', 'cultural', 'Lebanon', 'Arab States', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tyre', 'cultural', 'Lebanon', 'Arab States', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ouadi Qadisha (the Holy Valley) and the Forest of the Cedars of God (Horsh Arz el-Rab)', 'cultural', 'Lebanon', 'Arab States', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Cyrene', 'cultural', 'Libyan Arab Jamahiriya', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Leptis Magna', 'cultural', 'Libyan Arab Jamahiriya', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Sabratha', 'cultural', 'Libyan Arab Jamahiriya', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock-Art Sites of Tadrart Acacus', 'cultural', 'Libyan Arab Jamahiriya', 'Arab States', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Town of Ghadamès', 'cultural', 'Libyan Arab Jamahiriya', 'Arab States', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient Ksour of Ouadane, Chinguetti, Tichitt and Oualata', 'cultural', 'Mauritania', 'Arab States', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medina of Fez', 'cultural', 'Morocco', 'Arab States', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medina of Marrakesh', 'cultural', 'Morocco', 'Arab States', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ksar of Ait-Ben-Haddou', 'cultural', 'Morocco', 'Arab States', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic City of Meknes', 'cultural', 'Morocco', 'Arab States', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Volubilis', 'cultural', 'Morocco', 'Arab States', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medina of Tétouan (formerly known as Titawin)', 'cultural', 'Morocco', 'Arab States', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medina of Essaouira (formerly Mogador)', 'cultural', 'Morocco', 'Arab States', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Portuguese City of Mazagan (El Jadida)', 'cultural', 'Morocco', 'Arab States', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bahla Fort', 'cultural', 'Oman', 'Arab States', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Sites of Bat, Al-Khutm and Al-Ayn', 'cultural', 'Oman', 'Arab States', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Land of Frankincense', 'cultural', 'Oman', 'Arab States', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Aflaj Irrigation Systems of Oman', 'cultural', 'Oman', 'Arab States', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gebel Barkal and the Sites of the Napatan Region', 'cultural', 'Sudan', 'Arab States', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient City of Damascus', 'cultural', 'Syrian Arab Republic', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient City of Bosra', 'cultural', 'Syrian Arab Republic', 'Arab States', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Site of Palmyra', 'cultural', 'Syrian Arab Republic', 'Arab States', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient City of Aleppo', 'cultural', 'Syrian Arab Republic', 'Arab States', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Crac des Chevaliers and Qal’at Salah El-Din', 'cultural', 'Syrian Arab Republic', 'Arab States', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Amphitheatre of El Jem', 'cultural', 'Tunisia', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medina of Tunis', 'cultural', 'Tunisia', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Site of Carthage', 'cultural', 'Tunisia', 'Arab States', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Punic Town of Kerkuane and its Necropolis', 'cultural', 'Tunisia', 'Arab States', 1985, '1986' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kairouan', 'cultural', 'Tunisia', 'Arab States', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medina of Sousse', 'cultural', 'Tunisia', 'Arab States', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Dougga / Thugga', 'cultural', 'Tunisia', 'Arab States', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Walled City of Shibam', 'cultural', 'Yemen', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old City of Sana\'a', 'cultural', 'Yemen', 'Arab States', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Town of Zabid', 'cultural', 'Yemen', 'Arab States', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Minaret and Archaeological Remains of Jam', 'cultural', 'Afghanistan', 'Asia and the Pacific', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cultural Landscape and Archaeological Remains of the Bamiyan Valley', 'cultural', 'Afghanistan', 'Asia and the Pacific', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Royal Exhibition Building and Carlton Gardens', 'cultural', 'Australia', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sydney Opera House', 'cultural', 'Australia', 'Asia and the Pacific', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Mosque City of Bagerhat', 'cultural', 'Bangladesh', 'Asia and the Pacific', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ruins of the Buddhist Vihara at Paharpur', 'cultural', 'Bangladesh', 'Asia and the Pacific', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Angkor', 'cultural', 'Cambodia', 'Asia and the Pacific', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Imperial Palaces of the Ming and Qing Dynasties in Beijing and Shenyang', 'cultural', 'China', 'Asia and the Pacific', 1987, '2004' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mausoleum of the First Qin Emperor', 'cultural', 'China', 'Asia and the Pacific', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mogao Caves', 'cultural', 'China', 'Asia and the Pacific', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Peking Man Site at Zhoukoudian', 'cultural', 'China', 'Asia and the Pacific', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'The Great Wall', 'cultural', 'China', 'Asia and the Pacific', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient Building Complex in the Wudang Mountains', 'cultural', 'China', 'Asia and the Pacific', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Ensemble of the Potala Palace, Lhasa', 'cultural', 'China', 'Asia and the Pacific', 1994, '2000, 2001' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mountain Resort and its Outlying Temples, Chengde', 'cultural', 'China', 'Asia and the Pacific', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Temple and Cemetery of Confucius and the Kong Family Mansion in Qufu', 'cultural', 'China', 'Asia and the Pacific', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lushan National Park', 'cultural', 'China', 'Asia and the Pacific', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient City of Ping Yao', 'cultural', 'China', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Classical Gardens of Suzhou', 'cultural', 'China', 'Asia and the Pacific', 1997, '2000' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Town of Lijiang', 'cultural', 'China', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Summer Palace, an Imperial Garden in Beijing', 'cultural', 'China', 'Asia and the Pacific', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Temple of Heaven: an Imperial Sacrificial Altar in Beijing', 'cultural', 'China', 'Asia and the Pacific', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Dazu Rock Carvings', 'cultural', 'China', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient Villages in Southern Anhui – Xidi and Hongcun', 'cultural', 'China', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Imperial Tombs of the Ming and Qing Dynasties', 'cultural', 'China', 'Asia and the Pacific', 2000, '2003, 2004' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Longmen Grottoes', 'cultural', 'China', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Qingcheng and the Dujiangyan Irrigation System', 'cultural', 'China', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Yungang Grottoes', 'cultural', 'China', 'Asia and the Pacific', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Capital Cities and Tombs of the Ancient Koguryo Kingdom', 'cultural', 'China', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Macao', 'cultural', 'China', 'Asia and the Pacific', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Yin Xu', 'cultural', 'China', 'Asia and the Pacific', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kaiping Diaolou and Villages', 'cultural', 'China', 'Asia and the Pacific', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Complex of Koguryo Tombs', 'cultural', 'Democratic People\'s Republic of Korea', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Agra Fort', 'cultural', 'India', 'Asia and the Pacific', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ajanta Caves', 'cultural', 'India', 'Asia and the Pacific', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ellora Caves', 'cultural', 'India', 'Asia and the Pacific', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Taj Mahal', 'cultural', 'India', 'Asia and the Pacific', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Group of Monuments at Mahabalipuram', 'cultural', 'India', 'Asia and the Pacific', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sun Temple, Konârak', 'cultural', 'India', 'Asia and the Pacific', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Churches and Convents of Goa', 'cultural', 'India', 'Asia and the Pacific', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fatehpur Sikri', 'cultural', 'India', 'Asia and the Pacific', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Group of Monuments at Hampi', 'cultural', 'India', 'Asia and the Pacific', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Khajuraho Group of Monuments', 'cultural', 'India', 'Asia and the Pacific', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Elephanta Caves', 'cultural', 'India', 'Asia and the Pacific', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Great Living Chola Temples', 'cultural', 'India', 'Asia and the Pacific', 1987, '2004' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Group of Monuments at Pattadakal', 'cultural', 'India', 'Asia and the Pacific', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Buddhist Monuments at Sanchi', 'cultural', 'India', 'Asia and the Pacific', 1989, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Humayun\'s Tomb, Delhi', 'cultural', 'India', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Qutb Minar and its Monuments, Delhi', 'cultural', 'India', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mountain Railways of India', 'cultural', 'India', 'Asia and the Pacific', 1999, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mahabodhi Temple Complex at Bodh Gaya', 'cultural', 'India', 'Asia and the Pacific', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock Shelters of Bhimbetka', 'cultural', 'India', 'Asia and the Pacific', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Champaner-Pavagadh Archaeological Park', 'cultural', 'India', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Chhatrapati Shivaji Terminus (formerly Victoria Terminus)', 'cultural', 'India', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Red Fort Complex', 'cultural', 'India', 'Asia and the Pacific', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Borobudur Temple Compounds', 'cultural', 'Indonesia', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Prambanan Temple Compounds', 'cultural', 'Indonesia', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sangiran Early Man Site', 'cultural', 'Indonesia', 'Asia and the Pacific', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Meidan Emam, Esfahan', 'cultural', 'Iran (Islamic Republic of)', 'Asia and the Pacific', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Persepolis', 'cultural', 'Iran (Islamic Republic of)', 'Asia and the Pacific', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tchogha Zanbil', 'cultural', 'Iran (Islamic Republic of)', 'Asia and the Pacific', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Takht-e Soleyman', 'cultural', 'Iran (Islamic Republic of)', 'Asia and the Pacific', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bam and its Cultural Landscape', 'cultural', 'Iran (Islamic Republic of)', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pasargadae', 'cultural', 'Iran (Islamic Republic of)', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Soltaniyeh', 'cultural', 'Iran (Islamic Republic of)', 'Asia and the Pacific', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bisotun', 'cultural', 'Iran (Islamic Republic of)', 'Asia and the Pacific', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Buddhist Monuments in the Horyu-ji Area', 'cultural', 'Japan', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Himeji-jo', 'cultural', 'Japan', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Monuments of Ancient Kyoto (Kyoto, Uji and Otsu Cities)', 'cultural', 'Japan', 'Asia and the Pacific', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Villages of Shirakawa-go and Gokayama', 'cultural', 'Japan', 'Asia and the Pacific', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hiroshima Peace Memorial (Genbaku Dome)', 'cultural', 'Japan', 'Asia and the Pacific', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Itsukushima Shinto Shrine', 'cultural', 'Japan', 'Asia and the Pacific', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Monuments of Ancient Nara', 'cultural', 'Japan', 'Asia and the Pacific', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Shrines and Temples of Nikko', 'cultural', 'Japan', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gusuku Sites and Related Properties of the Kingdom of Ryukyu', 'cultural', 'Japan', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sacred Sites and Pilgrimage Routes in the Kii Mountain Range', 'cultural', 'Japan', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Iwami Ginzan Silver Mine and its Cultural Landscape', 'cultural', 'Japan', 'Asia and the Pacific', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mausoleum of Khoja Ahmed Yasawi', 'cultural', 'Kazakhstan', 'Asia and the Pacific', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Petroglyphs within the Archaeological Landscape of Tamgaly', 'cultural', 'Kazakhstan', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Town of Luang Prabang', 'cultural', 'Lao People\'s Democratic Republic', 'Asia and the Pacific', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vat Phou and Associated Ancient Settlements within the Champasak Cultural Landscape', 'cultural', 'Lao People\'s Democratic Republic', 'Asia and the Pacific', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Orkhon Valley Cultural Landscape', 'cultural', 'Mongolia', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kathmandu Valley', 'cultural', 'Nepal', 'Asia and the Pacific', 1979, '2006' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lumbini, the Birthplace of the Lord Buddha', 'cultural', 'Nepal', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Ruins at Moenjodaro', 'cultural', 'Pakistan', 'Asia and the Pacific', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Buddhist Ruins of Takht-i-Bahi and Neighbouring City Remains at Sahr-i-Bahlol', 'cultural', 'Pakistan', 'Asia and the Pacific', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Taxila', 'cultural', 'Pakistan', 'Asia and the Pacific', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fort and Shalamar Gardens in Lahore', 'cultural', 'Pakistan', 'Asia and the Pacific', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historical Monuments of Thatta', 'cultural', 'Pakistan', 'Asia and the Pacific', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rohtas Fort', 'cultural', 'Pakistan', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Baroque Churches of the Philippines', 'cultural', 'Philippines', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rice Terraces of the Philippine Cordilleras', 'cultural', 'Philippines', 'Asia and the Pacific', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Town of Vigan', 'cultural', 'Philippines', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Haeinsa Temple Janggyeong Panjeon, the Depositories for the Tripitaka Koreana Woodblocks', 'cultural', 'Republic of Korea', 'Asia and the Pacific', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jongmyo Shrine', 'cultural', 'Republic of Korea', 'Asia and the Pacific', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Seokguram Grotto and Bulguksa Temple', 'cultural', 'Republic of Korea', 'Asia and the Pacific', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Changdeokgung Palace Complex', 'cultural', 'Republic of Korea', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hwaseong Fortress', 'cultural', 'Republic of Korea', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gochang, Hwasun and Ganghwa Dolmen Sites', 'cultural', 'Republic of Korea', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gyeongju Historic Areas', 'cultural', 'Republic of Korea', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient City of Polonnaruwa', 'cultural', 'Sri Lanka', 'Asia and the Pacific', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient City of Sigiriya', 'cultural', 'Sri Lanka', 'Asia and the Pacific', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sacred City of Anuradhapura', 'cultural', 'Sri Lanka', 'Asia and the Pacific', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Town of Galle and its Fortifications', 'cultural', 'Sri Lanka', 'Asia and the Pacific', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sacred City of Kandy', 'cultural', 'Sri Lanka', 'Asia and the Pacific', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Golden Temple of Dambulla', 'cultural', 'Sri Lanka', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic City of Ayutthaya', 'cultural', 'Thailand', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Town of Sukhothai and Associated Historic Towns', 'cultural', 'Thailand', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ban Chiang Archaeological Site', 'cultural', 'Thailand', 'Asia and the Pacific', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'State Historical and Cultural Park "Ancient Merv"', 'cultural', 'Turkmenistan', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kunya-Urgench', 'cultural', 'Turkmenistan', 'Asia and the Pacific', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Parthian Fortresses of Nisa', 'cultural', 'Turkmenistan', 'Asia and the Pacific', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Itchan Kala', 'cultural', 'Uzbekistan', 'Asia and the Pacific', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Bukhara', 'cultural', 'Uzbekistan', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Shakhrisyabz', 'cultural', 'Uzbekistan', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Samarkand – Crossroads of Cultures', 'cultural', 'Uzbekistan', 'Asia and the Pacific', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Complex of Hué Monuments', 'cultural', 'Viet Nam', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hoi An Ancient Town', 'cultural', 'Viet Nam', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'My Son Sanctuary', 'cultural', 'Viet Nam', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Butrint', 'cultural', 'Albania', 'Europe and North America', 1992, '1999' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Museum-City of Gjirokastra', 'cultural', 'Albania', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Madriu-Perafita-Claror Valley', 'cultural', 'Andorra', 'Europe and North America', 2004, '2006' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monasteries of Haghpat and Sanahin', 'cultural', 'Armenia', 'Europe and North America', 1996, '2000' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cathedral and Churches of Echmiatsin and the Archaeological Site of Zvartnots', 'cultural', 'Armenia', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monastery of Geghard and the Upper Azat Valley', 'cultural', 'Armenia', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of the City of Salzburg', 'cultural', 'Austria', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Palace and Gardens of Schönbrunn', 'cultural', 'Austria', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hallstatt-Dachstein Salzkammergut Cultural Landscape', 'cultural', 'Austria', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Semmering Railway', 'cultural', 'Austria', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Graz - Historic Centre', 'cultural', 'Austria', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wachau Cultural Landscape', 'cultural', 'Austria', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fertö / Neusiedlersee Cultural Landscape', 'cultural', 'Austria', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Vienna', 'cultural', 'Austria', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Walled City of Baku with the Shirvanshah\'s Palace and Maiden Tower', 'cultural', 'Azerbaijan', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gobustan Rock Art Cultural Landscape', 'cultural', 'Azerbaijan', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mir Castle Complex', 'cultural', 'Belarus', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Architectural, Residential and Cultural Complex of the Radziwill Family at Nesvizh', 'cultural', 'Belarus', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Belarus', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Flemish Béguinages', 'cultural', 'Belgium', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'La Grand-Place, Brussels', 'cultural', 'Belgium', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'The Four Lifts on the Canal du Centre and their Environs, La Louvière and Le Roeulx (Hainault)', 'cultural', 'Belgium', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Belfries of Belgium and France', 'cultural', 'Belgium', 'Europe and North America', 1999, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Brugge', 'cultural', 'Belgium', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Major Town Houses of the Architect Victor Horta (Brussels)', 'cultural', 'Belgium', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Neolithic Flint Mines at Spiennes (Mons)', 'cultural', 'Belgium', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Notre-Dame Cathedral in Tournai', 'cultural', 'Belgium', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Plantin-Moretus House-Workshops-Museum Complex', 'cultural', 'Belgium', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Bridge Area of the Old City of Mostar', 'cultural', 'Bosnia and Herzegovina', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mehmed Paša Sokolović Bridge in Višegrad', 'cultural', 'Bosnia and Herzegovina', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Boyana Church', 'cultural', 'Bulgaria', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Madara Rider', 'cultural', 'Bulgaria', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock-Hewn Churches of Ivanovo', 'cultural', 'Bulgaria', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Thracian Tomb of Kazanlak', 'cultural', 'Bulgaria', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient City of Nessebar', 'cultural', 'Bulgaria', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rila Monastery', 'cultural', 'Bulgaria', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Thracian Tomb of Sveshtari', 'cultural', 'Bulgaria', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'L’Anse aux Meadows National Historic Site', 'cultural', 'Canada', 'Europe and North America', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Head-Smashed-In Buffalo Jump', 'cultural', 'Canada', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'SGang Gwaay', 'cultural', 'Canada', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic District of Old Québec', 'cultural', 'Canada', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Town Lunenburg', 'cultural', 'Canada', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rideau Canal', 'cultural', 'Canada', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historical Complex of Split with the Palace of Diocletian', 'cultural', 'Croatia', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old City of Dubrovnik', 'cultural', 'Croatia', 'Europe and North America', 1979, '1994' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Episcopal Complex of the Euphrasian Basilica in the Historic Centre of Poreč', 'cultural', 'Croatia', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic City of Trogir', 'cultural', 'Croatia', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'The Cathedral of St James in Šibenik', 'cultural', 'Croatia', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Paphos', 'cultural', 'Cyprus', 'Europe and North America', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Painted Churches in the Troodos Region', 'cultural', 'Cyprus', 'Europe and North America', 1985, '2001' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Choirokoitia', 'cultural', 'Cyprus', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Český Krumlov', 'cultural', 'Czech Republic', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Prague', 'cultural', 'Czech Republic', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Telč', 'cultural', 'Czech Republic', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pilgrimage Church of St John of Nepomuk at Zelená Hora', 'cultural', 'Czech Republic', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kutná Hora: Historical Town Centre with the Church of St Barbara and the Cathedral of Our Lady at Sedlec', 'cultural', 'Czech Republic', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lednice-Valtice Cultural Landscape', 'cultural', 'Czech Republic', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gardens and Castle at Kroměříž', 'cultural', 'Czech Republic', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Holašovice Historical Village Reservation', 'cultural', 'Czech Republic', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Litomyšl Castle', 'cultural', 'Czech Republic', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Holy Trinity Column in Olomouc', 'cultural', 'Czech Republic', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tugendhat Villa in Brno', 'cultural', 'Czech Republic', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jewish Quarter and St Procopius\' Basilica in Třebíč', 'cultural', 'Czech Republic', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jelling Mounds, Runic Stones and Church', 'cultural', 'Denmark', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Roskilde Cathedral', 'cultural', 'Denmark', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kronborg Castle', 'cultural', 'Denmark', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre (Old Town) of Tallinn', 'cultural', 'Estonia', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Estonia', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fortress of Suomenlinna', 'cultural', 'Finland', 'Europe and North America', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Rauma', 'cultural', 'Finland', 'Europe and North America', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Petäjävesi Old Church', 'cultural', 'Finland', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Verla Groundwood and Board Mill', 'cultural', 'Finland', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bronze Age Burial Site of Sammallahdenmäki', 'cultural', 'Finland', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Finland', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Chartres Cathedral', 'cultural', 'France', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mont-Saint-Michel and its Bay', 'cultural', 'France', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Palace and Park of Versailles', 'cultural', 'France', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Prehistoric Sites and Decorated Caves of the Vézère Valley', 'cultural', 'France', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vézelay, Church and Hill', 'cultural', 'France', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Amiens Cathedral', 'cultural', 'France', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Arles, Roman and Romanesque Monuments', 'cultural', 'France', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cistercian Abbey of Fontenay', 'cultural', 'France', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Palace and Park of Fontainebleau', 'cultural', 'France', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Roman Theatre and its Surroundings and the "Triumphal Arch" of Orange', 'cultural', 'France', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Royal Saltworks of Arc-et-Senans', 'cultural', 'France', 'Europe and North America', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Abbey Church of Saint-Savin sur Gartempe', 'cultural', 'France', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Place Stanislas, Place de la Carrière and Place d\'Alliance in Nancy', 'cultural', 'France', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pont du Gard (Roman Aqueduct)', 'cultural', 'France', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Strasbourg – Grande île', 'cultural', 'France', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cathedral of Notre-Dame, Former Abbey of Saint-Remi and Palace of Tau, Reims', 'cultural', 'France', 'Europe and North America', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Paris, Banks of the Seine', 'cultural', 'France', 'Europe and North America', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bourges Cathedral', 'cultural', 'France', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Avignon: Papal Palace, Episcopal Ensemble and Avignon Bridge', 'cultural', 'France', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Canal du Midi', 'cultural', 'France', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Fortified City of Carcassonne', 'cultural', 'France', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Site of Lyons', 'cultural', 'France', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Routes of Santiago de Compostela in France', 'cultural', 'France', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Belfries of Belgium and France', 'cultural', 'France', 'Europe and North America', 1999, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jurisdiction of Saint-Emilion', 'cultural', 'France', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'The Loire Valley between Sully-sur-Loire and Chalonnes', 'cultural', 'France', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Provins, Town of Medieval Fairs', 'cultural', 'France', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Le Havre, the City Rebuilt by Auguste Perret', 'cultural', 'France', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bordeaux, Port of the Moon', 'cultural', 'France', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bagrati Cathedral and Gelati Monastery', 'cultural', 'Georgia', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historical Monuments of Mtskheta', 'cultural', 'Georgia', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Upper Svaneti', 'cultural', 'Georgia', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Aachen Cathedral', 'cultural', 'Germany', 'Europe and North America', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Speyer Cathedral', 'cultural', 'Germany', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Würzburg Residence with the Court Gardens and Residence Square', 'cultural', 'Germany', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pilgrimage Church of Wies', 'cultural', 'Germany', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Castles of Augustusburg and Falkenlust at Brühl', 'cultural', 'Germany', 'Europe and North America', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'St Mary\'s Cathedral and St Michael\'s Church at Hildesheim', 'cultural', 'Germany', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Roman Monuments, Cathedral of St Peter and Church of Our Lady in Trier', 'cultural', 'Germany', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Frontiers of the Roman Empire', 'cultural', 'Germany', 'Europe and North America', 1987, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hanseatic City of Lübeck', 'cultural', 'Germany', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Palaces and Parks of Potsdam and Berlin', 'cultural', 'Germany', 'Europe and North America', 1990, '1992, 1999' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Abbey and Altenmünster of Lorsch', 'cultural', 'Germany', 'Europe and North America', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mines of Rammelsberg and Historic Town of Goslar', 'cultural', 'Germany', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Maulbronn Monastery Complex', 'cultural', 'Germany', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Town of Bamberg', 'cultural', 'Germany', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Collegiate Church, Castle, and Old Town of Quedlinburg', 'cultural', 'Germany', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Völklingen Ironworks', 'cultural', 'Germany', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bauhaus and its Sites in Weimar and Dessau', 'cultural', 'Germany', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cologne Cathedral', 'cultural', 'Germany', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Luther Memorials in Eisleben and Wittenberg', 'cultural', 'Germany', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Classical Weimar', 'cultural', 'Germany', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Museumsinsel (Museum Island), Berlin', 'cultural', 'Germany', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wartburg Castle', 'cultural', 'Germany', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Garden Kingdom of Dessau-Wörlitz', 'cultural', 'Germany', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monastic Island of Reichenau', 'cultural', 'Germany', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Zollverein Coal Mine Industrial Complex in Essen', 'cultural', 'Germany', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centres of Stralsund and Wismar', 'cultural', 'Germany', 'Europe and North America', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Upper Middle Rhine Valley', 'cultural', 'Germany', 'Europe and North America', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Dresden Elbe Valley', 'cultural', 'Germany', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Muskauer Park / Park Muzakowski', 'cultural', 'Germany', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Town Hall and Roland on the Marketplace of Bremen', 'cultural', 'Germany', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old town of Regensburg with Stadtamhof', 'cultural', 'Germany', 'Europe and North America', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Temple of Apollo Epicurius at Bassae', 'cultural', 'Greece', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Acropolis, Athens', 'cultural', 'Greece', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Delphi', 'cultural', 'Greece', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medieval City of Rhodes', 'cultural', 'Greece', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Paleochristian and Byzantine Monuments of Thessalonika', 'cultural', 'Greece', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sanctuary of Asklepios at Epidaurus', 'cultural', 'Greece', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Mystras', 'cultural', 'Greece', 'Europe and North America', 1989, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Olympia', 'cultural', 'Greece', 'Europe and North America', 1989, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Delos', 'cultural', 'Greece', 'Europe and North America', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monasteries of Daphni, Hosios Loukas and Nea Moni of Chios', 'cultural', 'Greece', 'Europe and North America', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pythagoreion and Heraion of Samos', 'cultural', 'Greece', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Aigai (modern name Vergina)', 'cultural', 'Greece', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Sites of Mycenae and Tiryns', 'cultural', 'Greece', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre (Chorá) with the Monastery of Saint John "the Theologian" and the Cave of the Apocalypse on the Island of Pátmos', 'cultural', 'Greece', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Town of Corfu', 'cultural', 'Greece', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Rome, the Properties of the Holy See in that City Enjoying Extraterritorial Rights and San Paolo Fuori le Mura', 'cultural', 'Holy See', 'Europe and North America', 1980, '1990' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vatican City', 'cultural', 'Holy See', 'Europe and North America', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Budapest, including the Banks of the Danube, the Buda Castle Quarter and Andrássy Avenue', 'cultural', 'Hungary', 'Europe and North America', 1987, '2002' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Village of Hollókö and its Surroundings', 'cultural', 'Hungary', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Millenary Benedictine Abbey of Pannonhalma and its Natural Environment', 'cultural', 'Hungary', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hortobágy National Park - the Puszta', 'cultural', 'Hungary', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Early Christian Necropolis of Pécs (Sopianae)', 'cultural', 'Hungary', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fertö / Neusiedlersee Cultural Landscape', 'cultural', 'Hungary', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tokaj Wine Region Historic Cultural Landscape', 'cultural', 'Hungary', 'Europe and North America', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Þingvellir National Park', 'cultural', 'Iceland', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Ensemble of the Bend of the Boyne', 'cultural', 'Ireland', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Skellig Michael', 'cultural', 'Ireland', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Masada', 'cultural', 'Israel', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old City of Acre', 'cultural', 'Israel', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'White City of Tel-Aviv -- the Modern Movement', 'cultural', 'Israel', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Biblical Tels - Megiddo, Hazor, Beer Sheba', 'cultural', 'Israel', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Incense Route - Desert Cities in the Negev', 'cultural', 'Israel', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock Drawings in Valcamonica', 'cultural', 'Italy', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Church and Dominican Convent of Santa Maria delle Grazie with', 'cultural', 'Italy', 'Europe and North America', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Rome, the Properties of the Holy See in that City Enjoying Extraterritorial Rights and San Paolo Fuori le Mura', 'cultural', 'Italy', 'Europe and North America', 1980, '1990' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Florence', 'cultural', 'Italy', 'Europe and North America', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Piazza del Duomo, Pisa', 'cultural', 'Italy', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Venice and its Lagoon', 'cultural', 'Italy', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of San Gimignano', 'cultural', 'Italy', 'Europe and North America', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'The Sassi and the park of the Rupestrian Churches of Matera', 'cultural', 'Italy', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Vicenza and the Palladian Villas of the Veneto', 'cultural', 'Italy', 'Europe and North America', 1994, '1996' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Crespi d\'Adda', 'cultural', 'Italy', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ferrara, City of the Renaissance, and its Po Delta', 'cultural', 'Italy', 'Europe and North America', 1995, '1999' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Naples', 'cultural', 'Italy', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Siena', 'cultural', 'Italy', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Castel del Monte', 'cultural', 'Italy', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Early Christian Monuments of Ravenna', 'cultural', 'Italy', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of the City of Pienza', 'cultural', 'Italy', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'The Trulli of Alberobello', 'cultural', 'Italy', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( '18th-Century Royal Palace at Caserta with the Park, the Aqueduct of Vanvitelli, and the San Leucio Complex', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Area of Agrigento', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Areas of Pompei, Herculaneum and Torre Annunziata', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Botanical Garden (Orto Botanico), Padua', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cathedral, Torre Civica and Piazza Grande, Modena', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Costiera Amalfitana', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Portovenere, Cinque Terre, and the Islands (Palmaria, Tino and Tinetto)', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Residences of the Royal House of Savoy', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Su Nuraxi di Barumini', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Villa Romana del Casale', 'cultural', 'Italy', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Area and the Patriarchal Basilica of Aquileia', 'cultural', 'Italy', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cilento and Vallo di Diano National Park with the Archeological sites of Paestum and Velia, and the Certosa di Padula', 'cultural', 'Italy', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Urbino', 'cultural', 'Italy', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Villa Adriana (Tivoli)', 'cultural', 'Italy', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Assisi, the Basilica of San Francesco and Other Franciscan Sites', 'cultural', 'Italy', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Verona', 'cultural', 'Italy', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Villa d\'Este, Tivoli', 'cultural', 'Italy', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Late Baroque Towns of the Val di Noto (South-Eastern Sicily)', 'cultural', 'Italy', 'Europe and North America', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sacri Monti of Piedmont and Lombardy', 'cultural', 'Italy', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Etruscan Necropolises of Cerveteri and Tarquinia', 'cultural', 'Italy', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Val d\'Orcia', 'cultural', 'Italy', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Syracuse and the Rocky Necropolis of Pantalica', 'cultural', 'Italy', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Genoa: Le Strade Nuove and the system of the Palazzi dei Rolli', 'cultural', 'Italy', 'Europe and North America', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Riga', 'cultural', 'Latvia', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Latvia', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vilnius Historic Centre', 'cultural', 'Lithuania', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Curonian Spit', 'cultural', 'Lithuania', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kernavė Archaeological Site (Cultural Reserve of Kernavė)', 'cultural', 'Lithuania', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Lithuania', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Luxembourg: its Old Quarters and Fortifications', 'cultural', 'Luxembourg', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Valletta', 'cultural', 'Malta', 'Europe and North America', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hal Saflieni Hypogeum', 'cultural', 'Malta', 'Europe and North America', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Megalithic Temples of Malta', 'cultural', 'Malta', 'Europe and North America', 1980, '1992' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Natural and Culturo-Historical Region of Kotor', 'cultural', 'Montenegro', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Schokland and Surroundings', 'cultural', 'Netherlands', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Defence Line of Amsterdam', 'cultural', 'Netherlands', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Area of Willemstad, Inner City and Harbour, Netherlands Antilles', 'cultural', 'Netherlands', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mill Network at Kinderdijk-Elshout', 'cultural', 'Netherlands', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ir.D.F. Woudagemaal (D.F. Wouda Steam Pumping Station)', 'cultural', 'Netherlands', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Droogmakerij de Beemster (Beemster Polder)', 'cultural', 'Netherlands', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rietveld Schröderhuis (Rietveld Schröder House)', 'cultural', 'Netherlands', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bryggen', 'cultural', 'Norway', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Urnes Stave Church', 'cultural', 'Norway', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Røros Mining Town', 'cultural', 'Norway', 'Europe and North America', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock Art of Alta', 'cultural', 'Norway', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vegaøyan -- The Vega Archipelago', 'cultural', 'Norway', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Norway', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cracow\'s Historic Centre', 'cultural', 'Poland', 'Europe and North America', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wieliczka Salt Mine', 'cultural', 'Poland', 'Europe and North America', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Auschwitz Birkenau German Nazi Concentration and Extermination Camp (1940-1945)', 'cultural', 'Poland', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Warsaw', 'cultural', 'Poland', 'Europe and North America', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old City of Zamość', 'cultural', 'Poland', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Castle of the Teutonic Order in Malbork', 'cultural', 'Poland', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medieval Town of Toruń', 'cultural', 'Poland', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kalwaria Zebrzydowska: the Mannerist Architectural and Park Landscape Complex and Pilgrimage Park', 'cultural', 'Poland', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Churches of Peace in Jawor and Swidnica', 'cultural', 'Poland', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wooden Churches of Southern Little Poland', 'cultural', 'Poland', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Muskauer Park / Park Muzakowski', 'cultural', 'Poland', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Centennial Hall in Wroclaw', 'cultural', 'Poland', 'Europe and North America', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Central Zone of the Town of Angra do Heroismo in the Azores', 'cultural', 'Portugal', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Convent of Christ in Tomar', 'cultural', 'Portugal', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monastery of Batalha', 'cultural', 'Portugal', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monastery of the Hieronymites and Tower of Belém in Lisbon', 'cultural', 'Portugal', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Évora', 'cultural', 'Portugal', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monastery of Alcobaça', 'cultural', 'Portugal', 'Europe and North America', 1989, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cultural Landscape of Sintra', 'cultural', 'Portugal', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Oporto', 'cultural', 'Portugal', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Prehistoric Rock-Art Sites in the Côa Valley', 'cultural', 'Portugal', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Alto Douro Wine Region', 'cultural', 'Portugal', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Guimarães', 'cultural', 'Portugal', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Landscape of the Pico Island Vineyard Culture', 'cultural', 'Portugal', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Republic of Moldova', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Churches of Moldavia', 'cultural', 'Romania', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monastery of Horezu', 'cultural', 'Romania', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Villages with Fortified Churches in Transylvania', 'cultural', 'Romania', 'Europe and North America', 1993, '1999' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Dacian Fortresses of the Orastie Mountains', 'cultural', 'Romania', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Sighişoara', 'cultural', 'Romania', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wooden Churches of Maramureş', 'cultural', 'Romania', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Saint Petersburg and Related Groups of Monuments', 'cultural', 'Russian Federation', 'Europe and North America', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kizhi Pogost', 'cultural', 'Russian Federation', 'Europe and North America', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kremlin and Red Square, Moscow', 'cultural', 'Russian Federation', 'Europe and North America', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cultural and Historic Ensemble of the Solovetsky Islands', 'cultural', 'Russian Federation', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Monuments of Novgorod and Surroundings', 'cultural', 'Russian Federation', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'White Monuments of Vladimir and Suzdal', 'cultural', 'Russian Federation', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Architectural Ensemble of the Trinity Sergius Lavra in Sergiev Posad', 'cultural', 'Russian Federation', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Church of the Ascension, Kolomenskoye', 'cultural', 'Russian Federation', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Curonian Spit', 'cultural', 'Russian Federation', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ensemble of the Ferrapontov Monastery', 'cultural', 'Russian Federation', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic and Architectural Complex of the Kazan Kremlin', 'cultural', 'Russian Federation', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Citadel, Ancient City and Fortress Buildings of Derbent', 'cultural', 'Russian Federation', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ensemble of the Novodevichy Convent', 'cultural', 'Russian Federation', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historical Centre of the City of Yaroslavl', 'cultural', 'Russian Federation', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Russian Federation', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Stari Ras and Sopoćani', 'cultural', 'Serbia', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Studenica Monastery', 'cultural', 'Serbia', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Medieval Monuments in Kosovo', 'cultural', 'Serbia', 'Europe and North America', 2004, '2006' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gamzigrad-Romuliana, Palace of Galerius', 'cultural', 'Serbia', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Town of Banská Štiavnica and the Technical Monuments in its Vicinity', 'cultural', 'Slovakia', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Spišský Hrad and its Associated Cultural Monuments', 'cultural', 'Slovakia', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vlkolínec', 'cultural', 'Slovakia', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bardejov Town Conservation Reserve', 'cultural', 'Slovakia', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Alhambra, Generalife and Albayzín, Granada', 'cultural', 'Spain', 'Europe and North America', 1984, '1994' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Burgos Cathedral', 'cultural', 'Spain', 'Europe and North America', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Cordoba', 'cultural', 'Spain', 'Europe and North America', 1984, '1994' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monastery and Site of the Escurial, Madrid', 'cultural', 'Spain', 'Europe and North America', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Works of Antoni Gaudí', 'cultural', 'Spain', 'Europe and North America', 1984, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Altamira Cave', 'cultural', 'Spain', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monuments of Oviedo and the Kingdom of the Asturias', 'cultural', 'Spain', 'Europe and North America', 1985, '1998' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Town of Ávila with its Extra-Muros Churches', 'cultural', 'Spain', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Town of Segovia and its Aqueduct', 'cultural', 'Spain', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Santiago de Compostela (Old Town)', 'cultural', 'Spain', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic City of Toledo', 'cultural', 'Spain', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mudejar Architecture of Aragon', 'cultural', 'Spain', 'Europe and North America', 1986, '2001' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Town of Cáceres', 'cultural', 'Spain', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cathedral, Alcázar and Archivo de Indias in Seville', 'cultural', 'Spain', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old City of Salamanca', 'cultural', 'Spain', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Poblet Monastery', 'cultural', 'Spain', 'Europe and North America', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Ensemble of Mérida', 'cultural', 'Spain', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Route of Santiago de Compostela', 'cultural', 'Spain', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Royal Monastery of Santa María de Guadalupe', 'cultural', 'Spain', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Walled Town of Cuenca', 'cultural', 'Spain', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'La Lonja de la Seda de Valencia', 'cultural', 'Spain', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Las Médulas', 'cultural', 'Spain', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Palau de la Música Catalana and Hospital de Sant Pau, Barcelona', 'cultural', 'Spain', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'San Millán Yuso and Suso Monasteries', 'cultural', 'Spain', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock Art of the Mediterranean Basin on the Iberian Peninsula', 'cultural', 'Spain', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'University and Historic Precinct of Alcalá de Henares', 'cultural', 'Spain', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'San Cristóbal de La Laguna', 'cultural', 'Spain', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Ensemble of Tárraco', 'cultural', 'Spain', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Atapuerca', 'cultural', 'Spain', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Catalan Romanesque Churches of the Vall de Boí', 'cultural', 'Spain', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Palmeral of Elche', 'cultural', 'Spain', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Roman Walls of Lugo', 'cultural', 'Spain', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Aranjuez Cultural Landscape', 'cultural', 'Spain', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Renaissance Monumental Ensembles of Úbeda and Baeza', 'cultural', 'Spain', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vizcaya Bridge', 'cultural', 'Spain', 'Europe and North America', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Royal Domain of Drottningholm', 'cultural', 'Sweden', 'Europe and North America', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Birka and Hovgården', 'cultural', 'Sweden', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Engelsberg Ironworks', 'cultural', 'Sweden', 'Europe and North America', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock Carvings in Tanum', 'cultural', 'Sweden', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Skogskyrkogården', 'cultural', 'Sweden', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hanseatic Town of Visby', 'cultural', 'Sweden', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Church Village of Gammelstad, Luleå', 'cultural', 'Sweden', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Naval Port of Karlskrona', 'cultural', 'Sweden', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Agricultural Landscape of Southern Öland', 'cultural', 'Sweden', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mining Area of the Great Copper Mountain in Falun', 'cultural', 'Sweden', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Varberg Radio Station', 'cultural', 'Sweden', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Sweden', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Benedictine Convent of St John at Müstair', 'cultural', 'Switzerland', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Convent of St Gall', 'cultural', 'Switzerland', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old City of Berne', 'cultural', 'Switzerland', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Three Castles, Defensive Wall and Ramparts of the Market-Town of Bellinzone', 'cultural', 'Switzerland', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lavaux, Vineyard Terraces', 'cultural', 'Switzerland', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Great Mosque and Hospital of Divriği', 'cultural', 'Turkey', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Areas of Istanbul', 'cultural', 'Turkey', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hattusha: the Hittite Capital', 'cultural', 'Turkey', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Nemrut Dağ', 'cultural', 'Turkey', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Xanthos-Letoon', 'cultural', 'Turkey', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Safranbolu', 'cultural', 'Turkey', 'Europe and North America', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Troy', 'cultural', 'Turkey', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kiev: Saint-Sophia Cathedral and Related Monastic Buildings, Kiev-Pechersk Lavra', 'cultural', 'Ukraine', 'Europe and North America', 1990, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'L\'viv – the Ensemble of the Historic Centre', 'cultural', 'Ukraine', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Struve Geodetic Arc', 'cultural', 'Ukraine', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Castles and Town Walls of King Edward in Gwynedd', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Durham Castle and Cathedral', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ironbridge Gorge', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Stonehenge, Avebury and Associated Sites', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Studley Royal Park including the Ruins of Fountains Abbey', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Blenheim Palace', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Bath', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Frontiers of the Roman Empire', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1987, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Westminster Palace, Westminster Abbey and Saint Margaret\'s Church', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Canterbury Cathedral, St Augustine\'s Abbey, and St Martin\'s Church', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tower of London', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old and New Towns of Edinburgh', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Maritime Greenwich', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Heart of Neolithic Orkney', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Blaenavon Industrial Landscape', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Town of St George and Related Fortifications, Bermuda', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Derwent Valley Mills', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'New Lanark', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Saltaire', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Royal Botanic Gardens, Kew', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Liverpool – Maritime Mercantile City', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cornwall and West Devon Mining Landscape', 'cultural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mesa Verde National Park', 'cultural', 'United States of America', 'Europe and North America', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Independence Hall', 'cultural', 'United States of America', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cahokia Mounds State Historic Site', 'cultural', 'United States of America', 'Europe and North America', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'La Fortaleza and San Juan National Historic Site in Puerto Rico', 'cultural', 'United States of America', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Statue of Liberty', 'cultural', 'United States of America', 'Europe and North America', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Chaco Culture', 'cultural', 'United States of America', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monticello and the University of Virginia in Charlottesville', 'cultural', 'United States of America', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pueblo de Taos', 'cultural', 'United States of America', 'Europe and North America', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jesuit Missions of the Guaranis: San Ignacio Mini, Santa Ana, Nuestra Señora de Loreto and Santa Maria Mayor (Argentina), Ruins of Sao Miguel das Missoes (Brazil)', 'cultural', 'Argentina', 'Latin America and the Caribbean', 1983, '1984' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cueva de las Manos, Río Pinturas', 'cultural', 'Argentina', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jesuit Block and Estancias of Córdoba', 'cultural', 'Argentina', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Quebrada de Humahuaca', 'cultural', 'Argentina', 'Latin America and the Caribbean', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Potosí', 'cultural', 'Bolivia', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jesuit Missions of the Chiquitos', 'cultural', 'Bolivia', 'Latin America and the Caribbean', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic City of Sucre', 'cultural', 'Bolivia', 'Latin America and the Caribbean', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fuerte de Samaipata', 'cultural', 'Bolivia', 'Latin America and the Caribbean', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tiwanaku: Spiritual and Political Centre of the Tiwanaku Culture', 'cultural', 'Bolivia', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Town of Ouro Preto', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of the Town of Olinda', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jesuit Missions of the Guaranis: San Ignacio Mini, Santa Ana, Nuestra Señora de Loreto and Santa Maria Mayor (Argentina), Ruins of Sao Miguel das Missoes (Brazil)', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1983, '1984' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Salvador de Bahia', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sanctuary of Bom Jesus do Congonhas', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Brasilia', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Serra da Capivara National Park', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of São Luís', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of the Town of Diamantina', 'cultural', 'Brazil', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of the Town of Goiás', 'cultural', 'Brazil', 'Latin America and the Caribbean', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rapa Nui National Park', 'cultural', 'Chile', 'Latin America and the Caribbean', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Churches of Chiloé', 'cultural', 'Chile', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Quarter of the Seaport City of Valparaíso', 'cultural', 'Chile', 'Latin America and the Caribbean', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Humberstone and Santa Laura Saltpeter Works', 'cultural', 'Chile', 'Latin America and the Caribbean', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sewell Mining Town', 'cultural', 'Chile', 'Latin America and the Caribbean', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Port, Fortresses and Group of Monuments, Cartagena', 'cultural', 'Colombia', 'Latin America and the Caribbean', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Santa Cruz de Mompox', 'cultural', 'Colombia', 'Latin America and the Caribbean', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'National Archeological Park of Tierradentro', 'cultural', 'Colombia', 'Latin America and the Caribbean', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'San Agustín Archeological Park', 'cultural', 'Colombia', 'Latin America and the Caribbean', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Old Havana and its Fortifications', 'cultural', 'Cuba', 'Latin America and the Caribbean', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Trinidad and the Valley de los Ingenios', 'cultural', 'Cuba', 'Latin America and the Caribbean', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'San Pedro de la Roca Castle, Santiago de Cuba', 'cultural', 'Cuba', 'Latin America and the Caribbean', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Viñales Valley', 'cultural', 'Cuba', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Landscape of the First Coffee Plantations in the South-East of Cuba', 'cultural', 'Cuba', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Urban Historic Centre of Cienfuegos', 'cultural', 'Cuba', 'Latin America and the Caribbean', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Colonial City of Santo Domingo', 'cultural', 'Dominican Republic', 'Latin America and the Caribbean', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Quito', 'cultural', 'Ecuador', 'Latin America and the Caribbean', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Santa Ana de los Ríos de Cuenca', 'cultural', 'Ecuador', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Joya de Ceren Archaeological Site', 'cultural', 'El Salvador', 'Latin America and the Caribbean', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Antigua Guatemala', 'cultural', 'Guatemala', 'Latin America and the Caribbean', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Park and Ruins of Quirigua', 'cultural', 'Guatemala', 'Latin America and the Caribbean', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'National History Park – Citadel, Sans Souci, Ramiers', 'cultural', 'Haiti', 'Latin America and the Caribbean', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Maya Site of Copan', 'cultural', 'Honduras', 'Latin America and the Caribbean', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Mexico City and Xochimilco', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Oaxaca and Archaeological Site of Monte Albán', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Puebla', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pre-Hispanic City and National Park of Palenque', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pre-Hispanic City of Teotihuacan', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Town of Guanajuato and Adjacent Mines', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pre-Hispanic City of Chichen-Itza', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Morelia', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'El Tajin, Pre-Hispanic City', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Zacatecas', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rock Paintings of the Sierra de San Francisco', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Earliest 16th-Century Monasteries on the Slopes of Popocatepetl', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Monuments Zone of Querétaro', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pre-Hispanic Town of Uxmal', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hospicio Cabañas, Guadalajara', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archeological Zone of Paquimé, Casas Grandes', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Monuments Zone of Tlacotalpan', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Monuments Zone of Xochicalco', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Fortified Town of Campeche', 'cultural', 'Mexico', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ancient Maya City of Calakmul, Campeche', 'cultural', 'Mexico', 'Latin America and the Caribbean', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Franciscan Missions in the Sierra Gorda of Querétaro', 'cultural', 'Mexico', 'Latin America and the Caribbean', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Luis Barragán House and Studio', 'cultural', 'Mexico', 'Latin America and the Caribbean', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Agave Landscape and Ancient Industrial Facilities of Tequila', 'cultural', 'Mexico', 'Latin America and the Caribbean', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Central University City Campus of the Universidad Nacional Autónoma de México (UNAM)', 'cultural', 'Mexico', 'Latin America and the Caribbean', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ruins of León Viejo', 'cultural', 'Nicaragua', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fortifications on the Caribbean Side of Panama: Portobelo-San Lorenzo', 'cultural', 'Panama', 'Latin America and the Caribbean', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Archaeological Site of Panamá Viejo and Historic District of Panamá', 'cultural', 'Panama', 'Latin America and the Caribbean', 1997, '2003' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jesuit Missions of La Santísima Trinidad de Paraná and Jesús de Tavarangue', 'cultural', 'Paraguay', 'Latin America and the Caribbean', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'City of Cuzco', 'cultural', 'Peru', 'Latin America and the Caribbean', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Chavin (Archaeological Site)', 'cultural', 'Peru', 'Latin America and the Caribbean', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Chan Chan Archaeological Zone', 'cultural', 'Peru', 'Latin America and the Caribbean', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Centre of Lima', 'cultural', 'Peru', 'Latin America and the Caribbean', 1988, '1991' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lines and Geoglyphs of Nasca and Pampas de Jumana', 'cultural', 'Peru', 'Latin America and the Caribbean', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historical Centre of the City of Arequipa', 'cultural', 'Peru', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Brimstone Hill Fortress National Park', 'cultural', 'Saint Kitts and Nevis', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Inner City of Paramaribo', 'cultural', 'Suriname', 'Latin America and the Caribbean', 2002, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Quarter of the City of Colonia del Sacramento', 'cultural', 'Uruguay', 'Latin America and the Caribbean', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Coro and its Port', 'cultural', 'Venezuela (Bolivarian Republic of)', 'Latin America and the Caribbean', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ciudad Universitaria de Caracas', 'cultural', 'Venezuela (Bolivarian Republic of)', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ecosystem and Relict Cultural Landscape of Lopé-Okanda', 'mixed', 'Gabon', 'Africa', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cliff of Bandiagara (Land of the Dogons)', 'mixed', 'Mali', 'Africa', 1989, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'uKhahlamba / Drakensberg Park', 'mixed', 'South Africa', 'Africa', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tassili n\'Ajjer', 'mixed', 'Algeria', 'Arab States', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kakadu National Park', 'mixed', 'Australia', 'Asia and the Pacific', 1981, '1987, 1992' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Willandra Lakes Region', 'mixed', 'Australia', 'Asia and the Pacific', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tasmanian Wilderness', 'mixed', 'Australia', 'Asia and the Pacific', 1982, '1989' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Uluru-Kata Tjuta National Park', 'mixed', 'Australia', 'Asia and the Pacific', 1987, '1994' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Taishan', 'mixed', 'China', 'Asia and the Pacific', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Huangshan', 'mixed', 'China', 'Asia and the Pacific', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Emei Scenic Area, including Leshan Giant Buddha Scenic Area', 'mixed', 'China', 'Asia and the Pacific', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Wuyi', 'mixed', 'China', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tongariro National Park', 'mixed', 'New Zealand', 'Asia and the Pacific', 1990, '1993' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pyrénées - Mont Perdu', 'mixed', 'France', 'Europe and North America', 1997, '1999' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Meteora', 'mixed', 'Greece', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Athos', 'mixed', 'Greece', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pyrénées - Mont Perdu', 'mixed', 'Spain', 'Europe and North America', 1997, '1999' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ibiza, Biodiversity and Culture', 'mixed', 'Spain', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Laponian Area', 'mixed', 'Sweden', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Natural and Cultural Heritage of the Ohrid region', 'mixed', 'the Former Yugoslav Republic of Macedonia', 'Europe and North America', 1979, '1980' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Göreme National Park and the Rock Sites of Cappadocia', 'mixed', 'Turkey', 'Europe and North America', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hierapolis-Pamukkale', 'mixed', 'Turkey', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'St Kilda', 'mixed', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1986, '2004, 2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tikal National Park', 'mixed', 'Guatemala', 'Latin America and the Caribbean', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Historic Sanctuary of Machu Picchu', 'mixed', 'Peru', 'Latin America and the Caribbean', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Río Abiseo National Park', 'mixed', 'Peru', 'Latin America and the Caribbean', 1990, '1992' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Dja Faunal Reserve', 'natural', 'Cameroon', 'Africa', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Manovo-Gounda St Floris National Park', 'natural', 'Central African Republic', 'Africa', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Nimba Strict Nature Reserve', 'natural', 'Côte d\'Ivoire', 'Africa', 1981, '1982' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Taï National Park', 'natural', 'Côte d\'Ivoire', 'Africa', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Comoé National Park', 'natural', 'Côte d\'Ivoire', 'Africa', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Virunga National Park', 'natural', 'Democratic Republic of the Congo', 'Africa', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Garamba National Park', 'natural', 'Democratic Republic of the Congo', 'Africa', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kahuzi-Biega National Park', 'natural', 'Democratic Republic of the Congo', 'Africa', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Salonga National Park', 'natural', 'Democratic Republic of the Congo', 'Africa', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Okapi Wildlife Reserve', 'natural', 'Democratic Republic of the Congo', 'Africa', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Simien National Park', 'natural', 'Ethiopia', 'Africa', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Nimba Strict Nature Reserve', 'natural', 'Guinea', 'Africa', 1981, '1982' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lake Turkana National Parks', 'natural', 'Kenya', 'Africa', 1997, '2001' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mount Kenya National Park/Natural Forest', 'natural', 'Kenya', 'Africa', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tsingy de Bemaraha Strict Nature Reserve', 'natural', 'Madagascar', 'Africa', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rainforests of the Atsinanana', 'natural', 'Madagascar', 'Africa', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lake Malawi National Park', 'natural', 'Malawi', 'Africa', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Air and Ténéré Natural Reserves', 'natural', 'Niger', 'Africa', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'W National Park of Niger', 'natural', 'Niger', 'Africa', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Djoudj National Bird Sanctuary', 'natural', 'Senegal', 'Africa', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Niokolo-Koba National Park', 'natural', 'Senegal', 'Africa', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Aldabra Atoll', 'natural', 'Seychelles', 'Africa', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vallée de Mai Nature Reserve', 'natural', 'Seychelles', 'Africa', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Greater St Lucia Wetland Park', 'natural', 'South Africa', 'Africa', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cape Floral Region Protected Areas', 'natural', 'South Africa', 'Africa', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Vredefort Dome', 'natural', 'South Africa', 'Africa', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Bwindi Impenetrable National Park', 'natural', 'Uganda', 'Africa', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Rwenzori Mountains National Park', 'natural', 'Uganda', 'Africa', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ngorongoro Conservation Area', 'natural', 'United Republic of Tanzania', 'Africa', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Serengeti National Park', 'natural', 'United Republic of Tanzania', 'Africa', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Selous Game Reserve', 'natural', 'United Republic of Tanzania', 'Africa', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kilimanjaro National Park', 'natural', 'United Republic of Tanzania', 'Africa', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mosi-oa-Tunya / Victoria Falls', 'natural', 'Zambia', 'Africa', 1989, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mana Pools National Park, Sapi and Chewore Safari Areas', 'natural', 'Zimbabwe', 'Africa', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mosi-oa-Tunya / Victoria Falls', 'natural', 'Zimbabwe', 'Africa', 1989, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wadi Al-Hitan (Whale Valley)', 'natural', 'Egypt', 'Arab States', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Banc d\'Arguin National Park', 'natural', 'Mauritania', 'Arab States', 1989, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ichkeul National Park', 'natural', 'Tunisia', 'Arab States', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Great Barrier Reef', 'natural', 'Australia', 'Asia and the Pacific', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lord Howe Island Group', 'natural', 'Australia', 'Asia and the Pacific', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Central Eastern Rainforests Reserves (Australia)', 'natural', 'Australia', 'Asia and the Pacific', 1986, '1994' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wet Tropics of Queensland', 'natural', 'Australia', 'Asia and the Pacific', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Shark Bay, Western Australia', 'natural', 'Australia', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Fraser Island', 'natural', 'Australia', 'Asia and the Pacific', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Australian Fossil Mammal Sites (Riversleigh / Naracoorte)', 'natural', 'Australia', 'Asia and the Pacific', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Heard and McDonald Islands', 'natural', 'Australia', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Macquarie Island', 'natural', 'Australia', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Greater Blue Mountains Area', 'natural', 'Australia', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Purnululu National Park', 'natural', 'Australia', 'Asia and the Pacific', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'The Sundarbans', 'natural', 'Bangladesh', 'Asia and the Pacific', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Huanglong Scenic and Historic Interest Area', 'natural', 'China', 'Asia and the Pacific', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jiuzhaigou Valley Scenic and Historic Interest Area', 'natural', 'China', 'Asia and the Pacific', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wulingyuan Scenic and Historic Interest Area', 'natural', 'China', 'Asia and the Pacific', 1992, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Three Parallel Rivers of Yunnan Protected Areas', 'natural', 'China', 'Asia and the Pacific', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sichuan Giant Panda Sanctuaries', 'natural', 'China', 'Asia and the Pacific', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'South China Karst', 'natural', 'China', 'Asia and the Pacific', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kaziranga National Park', 'natural', 'India', 'Asia and the Pacific', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Keoladeo National Park', 'natural', 'India', 'Asia and the Pacific', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Manas Wildlife Sanctuary', 'natural', 'India', 'Asia and the Pacific', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sundarbans National Park', 'natural', 'India', 'Asia and the Pacific', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Nanda Devi and Valley of Flowers National Parks', 'natural', 'India', 'Asia and the Pacific', 1988, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Komodo National Park', 'natural', 'Indonesia', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ujung Kulon National Park', 'natural', 'Indonesia', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lorentz National Park', 'natural', 'Indonesia', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tropical Rainforest Heritage of Sumatra', 'natural', 'Indonesia', 'Asia and the Pacific', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Shirakami-Sanchi', 'natural', 'Japan', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Yakushima', 'natural', 'Japan', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Shiretoko', 'natural', 'Japan', 'Asia and the Pacific', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gunung Mulu National Park', 'natural', 'Malaysia', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kinabalu Park', 'natural', 'Malaysia', 'Asia and the Pacific', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Uvs Nuur Basin', 'natural', 'Mongolia', 'Asia and the Pacific', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sagarmatha National Park', 'natural', 'Nepal', 'Asia and the Pacific', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Royal Chitwan National Park', 'natural', 'Nepal', 'Asia and the Pacific', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Te Wahipounamu – South West New Zealand', 'natural', 'New Zealand', 'Asia and the Pacific', 1990, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'New Zealand Sub-Antarctic Islands', 'natural', 'New Zealand', 'Asia and the Pacific', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Tubbataha Reef Marine Park', 'natural', 'Philippines', 'Asia and the Pacific', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Puerto-Princesa Subterranean River National Park', 'natural', 'Philippines', 'Asia and the Pacific', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jeju Volcanic Island and Lava Tubes', 'natural', 'Republic of Korea', 'Asia and the Pacific', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'East Rennell', 'natural', 'Solomon Islands', 'Asia and the Pacific', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sinharaja Forest Reserve', 'natural', 'Sri Lanka', 'Asia and the Pacific', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Thungyai-Huai Kha Khaeng Wildlife Sanctuaries', 'natural', 'Thailand', 'Asia and the Pacific', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Dong Phayayen-Khao Yai Forest Complex', 'natural', 'Thailand', 'Asia and the Pacific', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ha Long Bay', 'natural', 'Viet Nam', 'Asia and the Pacific', 1994, '2000' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Phong Nha-Ke Bang National Park', 'natural', 'Viet Nam', 'Asia and the Pacific', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Belovezhskaya Pushcha / Białowieża Forest', 'natural', 'Belarus', 'Europe and North America', 1979, '1992' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pirin National Park', 'natural', 'Bulgaria', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Srebarna Nature Reserve', 'natural', 'Bulgaria', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Nahanni National Park', 'natural', 'Canada', 'Europe and North America', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Dinosaur Provincial Park', 'natural', 'Canada', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kluane / Wrangell-St Elias / Glacier Bay / Tatshenshini-Alsek', 'natural', 'Canada', 'Europe and North America', 1979, '1992, 1994' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Wood Buffalo National Park', 'natural', 'Canada', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Canadian Rocky Mountain Parks', 'natural', 'Canada', 'Europe and North America', 1984, '1990' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gros Morne National Park', 'natural', 'Canada', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Waterton Glacier International Peace Park', 'natural', 'Canada', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Miguasha National Park', 'natural', 'Canada', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Plitvice Lakes National Park', 'natural', 'Croatia', 'Europe and North America', 1979, '2000' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ilulissat Icefjord', 'natural', 'Denmark', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kvarken Archipelago / High Coast', 'natural', 'Finland', 'Europe and North America', 2000, '2006' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gulf of Porto: Calanche of Piana, Gulf of Girolata, Scandola Reserve', 'natural', 'France', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Messel Pit Fossil Site', 'natural', 'Germany', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Caves of Aggtelek Karst and Slovak Karst', 'natural', 'Hungary', 'Europe and North America', 1995, '2000' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Isole Eolie (Aeolian Islands)', 'natural', 'Italy', 'Europe and North America', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Durmitor National Park', 'natural', 'Montenegro', 'Europe and North America', 1980, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'West Norwegian Fjords – Geirangerfjord and Nærøyfjord', 'natural', 'Norway', 'Europe and North America', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Belovezhskaya Pushcha / Białowieża Forest', 'natural', 'Poland', 'Europe and North America', 1979, '1992' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Laurisilva of Madeira', 'natural', 'Portugal', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Danube Delta', 'natural', 'Romania', 'Europe and North America', 1991, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Virgin Komi Forests', 'natural', 'Russian Federation', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Lake Baikal', 'natural', 'Russian Federation', 'Europe and North America', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Volcanoes of Kamchatka', 'natural', 'Russian Federation', 'Europe and North America', 1996, '2001' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Golden Mountains of Altai', 'natural', 'Russian Federation', 'Europe and North America', 1998, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Western Caucasus', 'natural', 'Russian Federation', 'Europe and North America', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Central Sikhote-Alin', 'natural', 'Russian Federation', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Uvs Nuur Basin', 'natural', 'Russian Federation', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Natural System of Wrangel Island Reserve', 'natural', 'Russian Federation', 'Europe and North America', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Caves of Aggtelek Karst and Slovak Karst', 'natural', 'Slovakia', 'Europe and North America', 1995, '2000' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Primeval Beech Forests of the Carpathians', 'natural', 'Slovakia', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Škocjan Caves', 'natural', 'Slovenia', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Doñana National Park', 'natural', 'Spain', 'Europe and North America', 1984, '2005' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Garajonay National Park', 'natural', 'Spain', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Teide National Park', 'natural', 'Spain', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kvarken Archipelago / High Coast', 'natural', 'Sweden', 'Europe and North America', 2000, '2006' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Jungfrau-Aletsch-Bietschhorn', 'natural', 'Switzerland', 'Europe and North America', 2001, '2007' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Monte San Giorgio', 'natural', 'Switzerland', 'Europe and North America', 2003, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Primeval Beech Forests of the Carpathians', 'natural', 'Ukraine', 'Europe and North America', 2007, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Giant\'s Causeway and Causeway Coast', 'natural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Henderson Island', 'natural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1988, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Gough and Inaccessible Islands', 'natural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 1995, '2004' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Dorset and East Devon Coast', 'natural', 'United Kingdom of Great Britain and Northern Ireland', 'Europe and North America', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Yellowstone National Park', 'natural', 'United States of America', 'Europe and North America', 1978, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Everglades National Park', 'natural', 'United States of America', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Grand Canyon National Park', 'natural', 'United States of America', 'Europe and North America', 1979, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Kluane / Wrangell-St Elias / Glacier Bay / Tatshenshini-Alsek', 'natural', 'United States of America', 'Europe and North America', 1979, '1992, 1994' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Redwood National and State Parks', 'natural', 'United States of America', 'Europe and North America', 1980, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Mammoth Cave National Park', 'natural', 'United States of America', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Olympic National Park', 'natural', 'United States of America', 'Europe and North America', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Great Smoky Mountains National Park', 'natural', 'United States of America', 'Europe and North America', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Yosemite National Park', 'natural', 'United States of America', 'Europe and North America', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Hawaii Volcanoes National Park', 'natural', 'United States of America', 'Europe and North America', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Carlsbad Caverns National Park', 'natural', 'United States of America', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Waterton Glacier International Peace Park', 'natural', 'United States of America', 'Europe and North America', 1995, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Los Glaciares', 'natural', 'Argentina', 'Latin America and the Caribbean', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Iguazu National Park', 'natural', 'Argentina', 'Latin America and the Caribbean', 1984, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Península Valdés', 'natural', 'Argentina', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Ischigualasto / Talampaya Natural Parks', 'natural', 'Argentina', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Belize Barrier Reef Reserve System', 'natural', 'Belize', 'Latin America and the Caribbean', 1996, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Noel Kempff Mercado National Park', 'natural', 'Bolivia', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Iguaçu National Park', 'natural', 'Brazil', 'Latin America and the Caribbean', 1986, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Atlantic Forest South-East Reserves', 'natural', 'Brazil', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Discovery Coast Atlantic Forest Reserves', 'natural', 'Brazil', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Central Amazon Conservation Complex', 'natural', 'Brazil', 'Latin America and the Caribbean', 2000, '2003' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pantanal Conservation Area', 'natural', 'Brazil', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Brazilian Atlantic Islands: Fernando de Noronha and Atol das Rocas Reserves', 'natural', 'Brazil', 'Latin America and the Caribbean', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cerrado Protected Areas: Chapada dos Veadeiros and Emas National Parks', 'natural', 'Brazil', 'Latin America and the Caribbean', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Los Katíos National Park', 'natural', 'Colombia', 'Latin America and the Caribbean', 1994, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Malpelo Fauna and Flora Sanctuary', 'natural', 'Colombia', 'Latin America and the Caribbean', 2006, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Talamanca Range-La Amistad Reserves / La Amistad National Park', 'natural', 'Costa Rica', 'Latin America and the Caribbean', 1983, '1990' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Cocos Island National Park', 'natural', 'Costa Rica', 'Latin America and the Caribbean', 1997, '2002' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Area de Conservación Guanacaste', 'natural', 'Costa Rica', 'Latin America and the Caribbean', 1999, '2004' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Desembarco del Granma National Park', 'natural', 'Cuba', 'Latin America and the Caribbean', 1999, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Alejandro de Humboldt National Park', 'natural', 'Cuba', 'Latin America and the Caribbean', 2001, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Morne Trois Pitons National Park', 'natural', 'Dominica', 'Latin America and the Caribbean', 1997, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Galápagos Islands', 'natural', 'Ecuador', 'Latin America and the Caribbean', 1978, '2001' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sangay National Park', 'natural', 'Ecuador', 'Latin America and the Caribbean', 1983, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Río Plátano Biosphere Reserve', 'natural', 'Honduras', 'Latin America and the Caribbean', 1982, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Sian Ka\'an', 'natural', 'Mexico', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Whale Sanctuary of El Vizcaino', 'natural', 'Mexico', 'Latin America and the Caribbean', 1993, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Islands and Protected Areas of the Gulf of California', 'natural', 'Mexico', 'Latin America and the Caribbean', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Darien National Park', 'natural', 'Panama', 'Latin America and the Caribbean', 1981, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Talamanca Range-La Amistad Reserves / La Amistad National Park', 'natural', 'Panama', 'Latin America and the Caribbean', 1983, '1990' );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Coiba National Park and its Special Zone of Marine Protection', 'natural', 'Panama', 'Latin America and the Caribbean', 2005, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Huascarán National Park', 'natural', 'Peru', 'Latin America and the Caribbean', 1985, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Manú National Park', 'natural', 'Peru', 'Latin America and the Caribbean', 1987, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Pitons Management Area', 'natural', 'Saint Lucia', 'Latin America and the Caribbean', 2004, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Central Suriname Nature Reserve', 'natural', 'Suriname', 'Latin America and the Caribbean', 2000, NULL );
INSERT INTO unesco_wh (description, category, country, region, inscription, extension) VALUES ( 'Canaima National Park', 'natural', 'Venezuela (Bolivarian Republic of)', 'Latin America and the Caribbean', 1994, NULL );

COMMIT;
