/* Sprite32 - small, cross-platform sprite library
 * Copyright (c) 1996-2003 Jeffrey T. Read
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <X11/Xlib.h>
#include "sprite.h"
#include "mfsprite.h"
#define IMAGE(x) ((XImage *)x)

void MultiframeSprite::RenderSprite(SpriteImage *si) {
    char *td = IMAGE(simg->img)->data;
    IMAGE(simg->img)->data = IMAGE(simg->img)->data + (cy * frame * IMAGE(simg->img)->bytes_per_line);
    Sprite::RenderSprite(si);
    IMAGE(simg->img)->data = td;
}


void MultiframeSprite::MoveSprite(float newx,float newy) {
  Sprite::MoveSprite(newx,newy);
  if(auto_animate) {
    count++; if(count >= delay) {
      count = 0;
      frame++; frame %= maxframes;
    }
  }
}

MultiframeSprite::MultiframeSprite(SpriteAppWin *sw,float _x,float _y,
				   SpriteImage *si,unsigned int mf,
				   unsigned int d)
  : Sprite(sw,_x,_y,si) {
    maxframes = mf;
    frame = 0;
    count = 0;
    delay = d;
    CalculateSize();
    auto_animate = 0;
}

void MultiframeSprite::CalculateSize() {
    cy = simg->cy;
    cy /= maxframes;
}

void MultiframeSprite::SetMaxFrames(unsigned int m) {
  maxframes = m;
  CalculateSize();
}

void MultiframeSprite::ChangeSpriteShape(SpriteImage *si) {
  Sprite::ChangeSpriteShape(si);
  CalculateSize();
}

