/* Sprite32 - small, cross-platform sprite library
 * Copyright (c) 1996-2003 Jeffrey T. Read
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <X11/keysym.h>

#ifndef __SPRITEEVENT
#define __SPRITEEVENT

typedef struct tagSpriteEvent {
  int type;
  int x,y;
  union {
    int code;
    void *ptr;
  } param;
} SpriteEvent;

#define S32_NullEvent -1
#define S32_RefreshEvent 0
#define S32_KeyPressEvent 1
#define S32_KeyReleaseEvent 2
#define S32_MouseMoveEvent 3
#define S32_GameMoveEvent 4

#define S32_Key_F1 0x101
#define S32_Key_F2 0x102
#define S32_Key_F3 0x103
#define S32_Key_F4 0x104
#define S32_Key_F5 0x105
#define S32_Key_F6 0x106
#define S32_Key_F7 0x107
#define S32_Key_F8 0x108
#define S32_Key_F9 0x109
#define S32_Key_F10 0x10a
#define S32_Key_F11 0x10b
#define S32_Key_F12 0x10c
#define S32_Key_Up 0x120
#define S32_Key_Down 0x121
#define S32_Key_Left 0x122
#define S32_Key_Right 0x123
#define S32_Key_Home 0x124
#define S32_Key_End 0x125
#define S32_Key_PgUp 0x126
#define S32_Key_PgDn 0x127
#define S32_Key_Ins 0x128
#define S32_Key_Del 0x129

#define S32_Key_BS 0x08
#define S32_Key_Tab 0x09
#define S32_Key_Enter 0x0d
#define S32_Key_Newline 0x0a
#define S32_Key_Escape 0x1b

#define S32_Key_Button1 0x1000
#define S32_Key_Button2 0x1001
#define S32_Key_Button3 0x1002
#define S32_Key_Button4 0x1003
#define S32_Key_WheelUp 0x1003
#define S32_Key_Button5 0x1004
#define S32_Key_WheelDown 0x1004
#define S32_Key_Button6 0x1005
#define S32_Key_Button7 0x1006
#define S32_Key_Button8 0x1007

#define S32_Key_GameBtn1 0x3000
#define S32_Key_GameBtn2 0x3001
#define S32_Key_GameBtn3 0x3002
#define S32_Key_GameBtn4 0x3003
#define S32_Key_GameBtn5 0x3004
#define S32_Key_GameBtn6 0x3005
#define S32_Key_GameBtn7 0x3006
#define S32_Key_GameBtn8 0x3007
#define S32_Key_GameBtn9 0x3008
#define S32_Key_GameBtn10 0x3009
#define S32_Key_GameBtn11 0x300a
#define S32_Key_GameBtn12 0x300b
#define S32_Key_GameBtn13 0x300c
#define S32_Key_GameBtn14 0x300d
#define S32_Key_GameBtn15 0x300e
#define S32_Key_GameBtn16 0x300f

#define S32_Key_Shift 0x2000
#define S32_Key_Ctrl  0x2001
#define S32_Key_Alt   0x2002
#define S32_Key_Meta  0x2003
#define S32_Key_Feature 0x2003

  
#endif /* __SPRITEEVENT */

