/* Sprite32 - small, cross-platform sprite library
 * Copyright (c) 1996-2003 Jeffrey T. Read
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "spriteevent.h"
#ifndef __SPRITE32
#define __SPRITE32

#define RENDER_PIXMAP 0
#define RENDER_IMAGE 1
#ifndef HAVE_DGA
#ifdef __SPRITE_DGA
#undef __SPRITE_DGA
#endif
#endif


#define SIMG_FLIP_HORZ 1
#define SIMG_FLIP_VERT 2
#define SIMG_USE_KEY 4
#define SIMG_USE_ALPHA 8

typedef struct tagSpriteImage {
  unsigned int cx;
  unsigned int cy;
  unsigned int depth;
  unsigned int scan_length;
  unsigned int endian;
  void *bits;
  void *img;
} SpriteImage;

#ifdef __cplusplus
extern "C" {
#endif

void ImageCopy(SpriteImage *,SpriteImage *,int,int,int,int,int,int,int,long);

#ifdef __cplusplus
}



class SpriteAppWin {
  friend class Sprite;
protected:
  int renback;
  int quitting;
  int rentype;
  long int clock_delay;
  long int frameskip;
  long int dyn_frameskip;
  SpriteImage Back,Buf;
  Sprite *first;
  Sprite *iter,*iter2;
  int cx,cy;
  char *name,*title;
  void *extra;
  void _spriteLoop();
  void _massageEvent(void *);
public:
  SpriteAppWin(char * _title,int _cx,int _cy);
  virtual ~SpriteAppWin();
  void run();
  void quit();
  virtual void handleEvent(SpriteEvent *);
  int loadSpriteImage(char *data,SpriteImage *si);
  void destroySpriteImage(SpriteImage *si);
  void addSprite(Sprite *s);
  void deleteSprite(Sprite *s);
  Sprite *lastSprite();
  Sprite *firstSprite() {return first;}
  void placeSpriteBehind(Sprite *s1,Sprite *s2);
  void setRenderBack(int rb) {renback = rb;}
  int renderBack() {return renback;}
  SpriteImage* background() {return &Back;}
  SpriteImage* buffer() {return &Buf;}
  int xSize() {return cx;}
  int ySize() {return cy;}
  int getRenType() {return rentype;}
};

class Sprite {
  friend class SpriteAppWin;
protected:
  SpriteAppWin *host;
  Sprite *next,*prev;
  float x,y,vx,vy;
  int cx,cy;
  int hx,hy;
  SpriteImage *simg;
  long key;
  int auto_hittest;
  unsigned int frame;
  unsigned int maxframes;
  unsigned int delay,count;
  int auto_animate;
public:
  Sprite(SpriteAppWin *sw,float _x,float _y,SpriteImage *si,unsigned int mf=1,unsigned int d=0);
  virtual ~Sprite();
  virtual void move();
  void moveTo(float newx,float newy);
  void setMotion(float _vx,float _vy);
  virtual void render(SpriteImage *si);
  void calculateSize();
  virtual void changeShape(SpriteImage *si);
  void goBehind(Sprite *s) {host->placeSpriteBehind(this,s);}
  void setAutoColTest(int n) {auto_hittest = n;}
  int autoColTest() {return auto_hittest;}
  int collisionTest(Sprite *s);
  virtual void onCollision(Sprite *);
  void setMaxFrames(unsigned int m) {maxframes = m; calculateSize();}
  void setAutoAnimate(int a) {auto_animate = a;}
  void setFrame(unsigned int f) {frame = f % maxframes;}
  void setDelay(unsigned int d) {delay = d;}
  void setHotspot(int _hx,int _hy) {hx = _hx; hy = _hy;}
  void nuke();
  float xPos() {return x;}
  float yPos() {return y;}
  int xSize() {return cx;}
  int ySize() {return cy;}
  int xHotspot() {return hx;}
  int yHotspot() {return hy;}
  float xVel() {return vx;}
  float yVel() {return vy;}
  Sprite *nextSprite() {return next;}
  Sprite *prevSprite() {return prev;}
  SpriteAppWin *hostWin() {return host;}
};
#endif /* __cplusplus */

#endif /* __SPRITE32 */


