/*
# Copyright (C) 2009-2011
# Raffaele Granito <raffaele.granito@tiscali.it>
#
# This file is part of GnuLibXML :
# Other XML Library ;)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "libSpiderXML.h"

/*
.------------------------------------------------------------.  
|                                                            |
'------------------------------------------------------------' */
int main(int argc, char **argv)
{

    tPharse rPharse ; 

    char *fileXML   = "doc/samples/sample.TOMCAT.xml\0"; 
    int debug_level = 0;

    if ( argc == 2 ) { 
         fileXML = malloc (strlen(argv[1]));
         strcpy ( fileXML, argv[1] ); 
    };

    rPharse = pharseXML(fileXML, debug_level);
    if (rPharse.return_code < 0) 
    {    
        switch(rPharse.return_code) 
        {
            case  -1: printf("Error -1: fileXML not found or you havent permission"); 
                      break; 

            case  -2: printf("Error -2: overflow buffering"); 
                      break; 

            case  -3: printf("Error -3: [%s:%d] found a remark into delimiter tag",  
                              fileXML, rPharse.row_error);
                      break; 

            case  -4: printf("Error -4: [%s:%d] unknown token [%s] on left the remark",
                              fileXML, rPharse.row_error,rPharse.token_unknown); 
                      break; 
            
            case  -5: printf("Error -5: [%s:%d] unknown token [%s] on left the XML delimiter", 
                              fileXML, rPharse.row_error,rPharse.token_unknown); 
                      break;

            case  -6: printf("Error -6: [%s:%d] initial delimiter xml not found",
                              fileXML, rPharse.row_error);
                      break;

            case  -7: printf("Error -7: [%s:%d] unknown token [%s] on left the XML delimiter",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case  -8: printf("Error -8: [%s:%d] unknown token [%s] on left the XML delimiter",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case  -9: printf("Error -9: [%s:%d] found more tag delimiter [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -10: printf("Error -10: [%s:%d] not found close delimiter for tag [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;
   
            case -11: printf("Error -11: [%s:%d] a previous definition tag [%s] is open",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;
   
            case -12: printf("Error -12: [%s:%d] a previuos tag [%s] is not close",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;
   
            case -13: printf("Error -13: [%s:%d] found another root node [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -14: printf("Error -14: [%s:%d] Unknown token [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -15: printf("Error -15: [%s:%d] a previous definition tag xml is open [%s]", 
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -16: printf("Error -16: [%s:%d] found XML TAG after DATE TAG [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -17: printf("Error -17: [%s:%d] Unknown token [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -18: printf("Error -18: [%s:%d] Unknown token [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -19: printf("Error -19: [%s:%d] found tail tag but there arent heads.",
                              fileXML, rPharse.row_error);
                      break;

            case -20: printf("Error -20: [%s:%d] a previous head tag [%s] is not close.",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -21: printf("Error -21: [%s:%d] a previous tail tag [%s] is not close.",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -22: printf("Error -22: [%s:%d] delimiter tail tag but missing father",
                              fileXML, rPharse.row_error);
                      break;

            case -23: printf("Error -23: [%s:%d] Not found open delimiter remark [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -24: printf("Error -24: [%s:%d] I not found tag XML dirst row but remark [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -25: printf("Error -25: [%s:%d] found a remark into delimiter tag XML [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -26: printf("Error -26: [%s:%d] Unknown token [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -27: printf("Error -27: [%s:%d] ??? [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -28: printf("Error -28: [%s:%d] ??? [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -29: printf("Error -29: [%s:%d] ??? [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -30: printf("Error -30: [%s:%d] XML file is EMPTY.",
                              fileXML, rPharse.row_error);
                      break;

            case -31: printf("Error -31: [%s:%d] It isnt XML file. Not found TAG. [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -32: printf("Error -32: [%s:%d] XML File incomplete. TAG XML not Close. [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -33: printf("Error -33: [%s:%d] XML File incomplete. TAG not Close. [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -34: printf("Error -34: [%s:%d] Not found open delimiter tail TAG [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -35: printf("Error -35: [%s:%d] found tag delimiter close but no tag",
                              fileXML, rPharse.row_error);
                      break;

            case -36: printf("Error -36: [%s:%d] found tag delimiter close but no tag open",
                              fileXML, rPharse.row_error);
                      break;

            case -37: printf("Error -37: [%s:%d] not found ASSIGN but unknown token [%s].",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -38: printf("Error -38: [%s:%d] not found ASSIGN but unknown token XML [%s].",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -39: printf("Error -39: [%s:%d] not found ASSIGN but unknown token [%s].",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -40: printf("Error -40: [%s:%d] not found XML head",
                              fileXML, rPharse.row_error);
                      break;

            case -41: printf("Error -41: [%s:%d] Unknown token [%s].",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -42: printf("Error -42: [%s:%d] not found ASSIGN but unknown token [%s].",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -43: printf("Error -43: [%s:%d] the TAG close have not a name.",
                              fileXML, rPharse.row_error);
                      break;

            case -44: printf("Error -44: [%s:%d] the TAG close have variable not definition. [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -45: printf("Error -45: [%s:%d] missing intestation XML.",
                              fileXML, rPharse.row_error);
                      break;

            case -46: printf("Error -46: [%s:%d] Last TAG XML [%s] isnt close.",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -47: printf("Error -47: [%s:%d] delimiter close tag but there isnt tag",
                              fileXML, rPharse.row_error);
                      break;

            case -48: printf("Error -48: [%s:%d] delimiter close tag but there isnt tag open",
                              fileXML, rPharse.row_error);
                      break;

            case -49: printf("Error -49: [%s:%d] missing delimiter close for tag [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -50: printf("Error -50: [%s:%d] missing tag name",
                              fileXML, rPharse.row_error);
                      break;

            case -51: printf("Error -51: [%s:%d] missing assign and value for var [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -52: printf("Error -52: [%s:%d] missing assign for var [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -53: printf("Error -53: [%s:%d] unknown token [%s] on left the XML delimiter",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -54: printf("Error -54: [%s:%d] found more tag delimiter [%s]",
                              fileXML, rPharse.row_error,rPharse.token_unknown);
                      break;

            case -55: printf("Error -55: [%s:%d] not found close delimiter for tag [%s]",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -56: printf("Error -56: [%s:%d] It isnt XML file. Not found TAG.",
                              fileXML, rPharse.row_error);
                      break;

            case -57: printf("Error -57: [%s:%d] found token assign. Last TAG is TAIL close.",
                              fileXML, rPharse.row_error);
                      break;

            case -58: printf("Error -58: [%s:%d] last tag found have not a name.",
                              fileXML, rPharse.row_error);
                      break;

            case -59: printf("Error -59: [%s:%d] not found var for token assign.",
                              fileXML, rPharse.row_error);
                      break;

            case -60: printf("Error -60: [%s:%d] *Unknown Token* [%s] left token assign.",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -61: printf("Error -61: [%s:%d] replicate token assign for var [%s].",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -62: printf("Error -62: [%s:%d] last tag found have not a name.",
                              fileXML, rPharse.row_error);
                      break;

            case -63: printf("Error -63: [%s:%d] not found var for token assign.",
                              fileXML, rPharse.row_error);
                      break;

            case -64: printf("Error -64: [%s:%d] *Unknown Token* [%s] left token assign.",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -65: printf("Error -65: [%s:%d] duplicate token assign for var [%s].",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -66: printf("Error -66: [%s:%d] found token assign. Last TAG is HEAD close.",
                              fileXML, rPharse.row_error);
                      break;

            case -67: printf("Error -67: [%s:%d] found token assign. Last TAG is TAIL open.",
                              fileXML, rPharse.row_error);
                      break;

            case -68: printf("Error -68: [%s:%d] found token assign. Last TAG is TAIL close.",
                              fileXML, rPharse.row_error);
                      break;

            case -69: printf("Error -69: [%s:%d] not found XML head.",
                              fileXML, rPharse.row_error);
                      break;

            case -70: printf("Error -70: [%s:%d] Last TAG XML isnt close [%s]",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -71: printf("Error -71: [%s:%d] Found delimiter close but no TAG open.",
                              fileXML, rPharse.row_error);
                      break;

            case -72: printf("Error -72: [%s:%d] delimiter close but TAG havent name.",
                              fileXML, rPharse.row_error);
                      break;

            case -73: printf("Error -73: [%s:%d] delimiter close but missing assign var [%s]",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -74: printf("Error -74: [%s:%d] delimiter close but missing value var [%s]",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -75: printf("Error -75: [%s:%d] delimiter close but missing assign var [%s]",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -76: printf("Error -76: [%s:%d] delimiter close but missing value var [%s]",
                              fileXML, rPharse.row_error, rPharse.token_unknown);
                      break;

            case -77: printf("Error -77: [%s:%d] Found delimiter close but no TAG open.",
                              fileXML, rPharse.row_error);
                      break;

            case -78: printf("Error -78: [%s:%d] unknown token on left the XML delimiter.",
                              fileXML, rPharse.row_error);
                      break;

            case -79: printf("Error -79: [%s:%d] found more tag delimiter.",
                              fileXML, rPharse.row_error);
                      break;

            case -80: printf("Error -80: [%s:%d] not found close delimiter for tag",
                              fileXML, rPharse.row_error);
                      break;

            default : printf("Error -??: [%s:%d] errore sconosciuto",
                              fileXML, rPharse.row_error);
                      break; 
        }; 
        printf("\n\n");
        return -1; 
    };


    printf("parsed [%s] Ok.\n\n", fileXML);
    return 0;



//==== to be continued 

    printf("\n================================ ============ ============ ============");
    printf("\n                                                                 Numero");
    printf("\n                             Tag        Level        Stato    Variabili");
    printf("\n-------------------------------- ------------ ------------ ------------");
    int j=0;
    while (j<rPharse.iTabTagXML) {
           printf("\n[%30s] [%10d] [%10d] [%10d]",
           rPharse.rTabTagXML[j].tag,  
           rPharse.rTabTagXML[j].level,
           rPharse.rTabTagXML[j].stato,
           rPharse.rTabTagXML[j].dimTabVar );
/*

           int i=0;
           while (i<rPharse.rTabTagXML[j].dimTabVar) {
                  printf("\n[%s] = [%s]", rPharse.rTabTagXML[j].rTabVar[i].var, rPharse.rTabTagXML[j].rTabVar[i].value);
                  i++;
           };

*/
           j++;
    };
    printf("\n\n");

    printf("\n================================ ============ ============ ============");
    printf("\n                                                                 Numero");
    printf("\n                             Tag        Level        Stato    Variabili"); 
    printf("\n-------------------------------- ------------ ------------ ------------");
    j=0;
    while (j<rPharse.iTabTag) {
           printf("\n[%30s] [%10d] [%10d] [%10d]",
           rPharse.rTabTag[j].tag,  
           rPharse.rTabTag[j].level,
           rPharse.rTabTag[j].stato,
           rPharse.rTabTag[j].dimTabVar );
/*

           int i=0;
           while (i<rPharse.rTabTag[j].dimTabVar) {
                  printf("\n[%s] = [%s]", rPharse.rTabTag[j].rTabVar[i].var, rPharse.rTabTag[j].rTabVar[i].value);
                  i++;
           };

*/
           j++;
    };
    printf("\n\n");

    return 0;
};

