#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
# generated by wxGlade 0.6.8 on Fri Jan 24 22:15:31 2014
#

import wx

# begin wxGlade: dependencies
import gettext
# end wxGlade
from specmate_settings import *
#-----------------------------------------------------------------------------------------
# begin class "specmate_refWindow"
#-----------------------------------------------------------------------------------------
class specmate_refWindow(wx.Frame):
	"""
	Implements "popup" window to manage the different references.
	"""

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onSomethingChanged(self,refNum=0):
		if self.coeff[refNum] > RAISE_UPPER_LIMIT_AT*self.maxCoeff[refNum]:
			self.maxCoeff[refNum]=2.0*self.coeff[refNum]	
		if self.coeff[refNum] < LOWER_UPPER_LIMIT_AT*self.maxCoeff[refNum]:
			if not self.coeff[refNum]==0.0:
				self.maxCoeff[refNum]=2.0*self.coeff[refNum]
		if float(self.textCtrlValue[refNum].GetValue())!=self.coeff[refNum]:
			self.textCtrlValue[refNum].SetValue('%.4g' % (self.coeff[refNum]))
		if (self.minCoeff[refNum]+(self.maxCoeff[refNum]-self.minCoeff[refNum])*float(self.slider[refNum].GetValue())/SLIDER_RES)!=self.coeff[refNum]:
			self.slider[refNum].SetValue(self.coeff[refNum]*SLIDER_RES/(self.maxCoeff[refNum]-self.minCoeff[refNum])-self.minCoeff[refNum])
		self.parent.backend.updateReference(refNum,self.coeff[refNum],self.maxCoeff[refNum],self.minCoeff[refNum],self.name[refNum],True)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onSliderMovement(self,event):
		refNum=self.sliderIds.index(event.GetId())
		self.coeff[refNum]=self.minCoeff[refNum]+(self.maxCoeff[refNum]-self.minCoeff[refNum])*float(self.slider[refNum].GetValue())/SLIDER_RES
		self._onSomethingChanged(refNum)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onTextChange(self,event):
		refNum=self.textCtrlValueIds.index(event.GetId())
		self.coeff[refNum]=float(self.textCtrlValue[refNum].GetValue())
		self._onSomethingChanged(refNum)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onRemoveButton(self,event):
		refNum=self.removeButtonIds.index(event.GetId())
        	dial = wx.MessageDialog(None, 'Sure to remove reference spectrum?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_YES:
			self.parent.backend.deleteReference(refNum)
			self.parent.backend.unlock('references')
			self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onSubstractButton(self,event):
		refNum=self.substractButtonIds.index(event.GetId())
		self.parent.backend.dataBackup(['spectrum','references'])
		self.parent.backend.substractFromSpectrum('reference',refNum)
		self.parent.backend.deleteReference(refNum)
        	dial = wx.MessageDialog(None, 'Do you like the result?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_NO:
			self.parent.backend.restoreDataBackup()
		else:
			self.parent.backend.unlock('references')
			self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
    	def _onNameChange(self, event):  # wxGlade: manageRef_template.<event_handler>
		refNum=self.textCtrlNameIds.index(event.GetId())
		self.name[refNum]=unicode(self.textCtrlName[refNum].GetValue())
		self.parent.backend.updateRefNames(self.name)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
    	def _onCheckbox(self, event):  # wxGlade: manageRef_template.<event_handler>
    	    print "Event handler '_onCheckbox' not implemented!"
    	    event.Skip()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onOK(self,event):
		self._onSomethingChanged()
		self.parent.backend.unlock('references')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onCancel(self,event):
		self.parent.backend.restoreDataBackup()
		self.parent.backend.unlock('references')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _initFrameContents(self):
		panelHeight=160*len(self.coeff)
		if panelHeight>500:
			panelHeight=500
        	self.mainPanel = wx.ScrolledWindow(self, wx.ID_ANY, style=wx.TAB_TRAVERSAL)
        	self.mainPanel.SetMinSize((535, panelHeight))
        	self.mainPanel.SetScrollRate(10, 10)
        	winSizer = wx.FlexGridSizer(2, 1, 0, 0)
        	buttonSizer = wx.BoxSizer(wx.HORIZONTAL)
        	mainVertSizer = wx.BoxSizer(wx.VERTICAL)

       		staticBoxSizer = []
        	vertSizer = []
        	horSizer3 = []
        	horSizer2 = []
        	horSizer1 = []

        	self.textCtrlName = []
        	self.checkboxActive = []
        	self.slider = []
        	self.textCtrlValue = []
        	self.substractButton = []
        	self.removeButton = []
        	self.staticBoxSizer_staticbox = []
		self.removeButtonIds=[]	
		self.substractButtonIds=[]	
		self.textCtrlNameIds=[]	
		self.textCtrlValueIds=[]	
		self.checkboxActiveIds=[]	
		self.sliderIds=[]	
		self.substractButtonIds=[]	
		for i in xrange(0,len(self.coeff)):
        		self.textCtrlName.append(wx.TextCtrl(self.mainPanel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER))
        		self.checkboxActive.append(wx.CheckBox(self.mainPanel, wx.ID_ANY, "active"))
        		self.slider.append(wx.Slider(self.mainPanel, wx.ID_ANY,self.coeff[i]*SLIDER_RES,0,SLIDER_RES,size=(400,21),style=wx.SL_HORIZONTAL | wx.SL_AUTOTICKS ))
        		self.textCtrlValue.append(wx.TextCtrl(self.mainPanel, wx.ID_ANY, "",style=wx.TE_PROCESS_ENTER))
        		self.substractButton.append(wx.Button(self.mainPanel, wx.ID_ANY, "Substract from Spectrum"))
        		self.removeButton.append(wx.Button(self.mainPanel, wx.ID_ANY, "Delete Reference"))
        		self.staticBoxSizer_staticbox.append(wx.StaticBox(self.mainPanel, wx.ID_ANY, "Reference Spectrum 1"))
        		self.textCtrlName[-1].SetMinSize((250, 33))
        		self.checkboxActive[-1].SetValue(1)
        		#self.slider[-1].SetMinSize((400, 21))
        		self.staticBoxSizer_staticbox[-1].Lower()

       			staticBoxSizer.append(wx.StaticBoxSizer(self.staticBoxSizer_staticbox[-1], wx.HORIZONTAL))
        		vertSizer.append(wx.BoxSizer(wx.VERTICAL))
        		horSizer3.append(wx.BoxSizer(wx.HORIZONTAL))
        		horSizer2.append(wx.BoxSizer(wx.HORIZONTAL))
       		 	horSizer1.append(wx.BoxSizer(wx.HORIZONTAL))
        		horSizer1[-1].Add(self.textCtrlName[-1], 0, wx.ALL, 5)
        		horSizer1[-1].Add(self.checkboxActive[-1], 0, wx.ALL | wx.EXPAND | wx.ALIGN_RIGHT | wx.ALIGN_CENTER_VERTICAL, 5)
        		vertSizer[-1].Add(horSizer1[-1], 1, wx.EXPAND, 0)
        		horSizer2[-1].Add(self.slider[-1], 0, wx.ALL | wx.ALIGN_CENTER_HORIZONTAL | wx.ALIGN_CENTER_VERTICAL, 5)
        		horSizer2[-1].Add(self.textCtrlValue[-1], 0, wx.ALL | wx.ALIGN_CENTER_HORIZONTAL | wx.ALIGN_CENTER_VERTICAL, 5)
        		vertSizer[-1].Add(horSizer2[-1], 1, wx.EXPAND, 0)
        		horSizer3[-1].Add(self.substractButton[-1], 0, wx.ALL, 5)
        		horSizer3[-1].Add(self.removeButton[-1], 0, wx.ALL, 5)
        		vertSizer[-1].Add(horSizer3[-1], 1, wx.EXPAND, 0)
        		staticBoxSizer[-1].Add(vertSizer[-1], 1, wx.EXPAND, 0)
        		mainVertSizer.Add(staticBoxSizer[-1], 0, wx.ALL, 5)

			self.sliderIds.append(self.slider[-1].GetId())
			self.textCtrlValueIds.append(self.textCtrlValue[-1].GetId())
			self.textCtrlNameIds.append(self.textCtrlName[-1].GetId())
			self.textCtrlValue[i].SetValue("%.3f" % (self.coeff[i]))
			self.textCtrlName[i].SetValue(self.name[i])
			self.removeButtonIds.append(self.removeButton[i].GetId())
			self.substractButtonIds.append(self.substractButton[i].GetId())

			self.Bind(wx.EVT_SCROLL_THUMBRELEASE, self._onSliderMovement,self.slider[i])	
			self.Bind(wx.EVT_TEXT_ENTER,self._onTextChange,self.textCtrlValue[i])
			self.Bind(wx.EVT_TEXT_ENTER,self._onNameChange,self.textCtrlName[i])
			self.Bind(wx.EVT_BUTTON,self._onRemoveButton,self.removeButton[i])
			self.Bind(wx.EVT_BUTTON,self._onSubstractButton,self.substractButton[i])

        	self.mainPanel.SetSizer(mainVertSizer)
        	winSizer.Add(self.mainPanel, 1, wx.EXPAND, 5)
        	self.okButton = wx.Button(self, wx.ID_ANY, "OK")
       		self.cancelButton = wx.Button(self, wx.ID_ANY, "Cancel")
        	buttonSizer.Add(self.okButton, 0, wx.ALL | wx.ALIGN_CENTER_VERTICAL, 5)
        	buttonSizer.Add(self.cancelButton, 0, wx.ALL | wx.ALIGN_CENTER_VERTICAL, 5)

		self.okButton.Bind(wx.EVT_BUTTON, self._onOK)
 		self.cancelButton.Bind(wx.EVT_BUTTON, self._onCancel)
        	
		winSizer.Add(buttonSizer, 1, 0, 0)
        	self.SetSizer(winSizer)
        	winSizer.Fit(self)
        	self.Layout()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def __init__(self,parent,id,title,**kwds):
		"""
		Constructor: ...

		"""
        	#kwds["style"] = wx.CAPTION | wx.CLOSE_BOX | wx.MINIMIZE_BOX | wx.MAXIMIZE_BOX | wx.STAY_ON_TOP | wx.SYSTEM_MENU | wx.RESIZE_BORDER | wx.TAB_TRAVERSAL | wx.CLIP_CHILDREN
		wx.Frame.__init__(self,parent,id,title, style=wx.CAPTION | wx.CLOSE_BOX | wx.MINIMIZE_BOX | wx.MAXIMIZE_BOX | wx.STAY_ON_TOP | wx.SYSTEM_MENU | wx.RESIZE_BORDER | wx.TAB_TRAVERSAL | wx.CLIP_CHILDREN, **kwds)
        	#wx.Frame.__init__(self, *args, **kwds)
		self.parent=parent
		self.Bind(wx.EVT_CLOSE,self._onCancel)
		self.parent.backend.lock('references')

		self.coeff=[]
		self.maxCoeff=[]
		self.minCoeff=[]
		self.name=[]
		for each in self.parent.backend.refSpectra:
			self.coeff.append(each.coeff)
			self.maxCoeff.append(each.maxCoeff)
			self.minCoeff.append(each.minCoeff)
			self.name.append(each.name)
		self._initFrameContents()
		self.SetTitle(title+' <'+self.parent.backend.specData.name+'>')
                self.scroll = wx.ScrolledWindow(self, id)
                self.scroll.SetScrollbars(1, 1, 2000, 1500)
		self.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------


# end of class manageRef_template
if __name__ == "__main__":
    gettext.install("app") # replace with the appropriate catalog name

    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    manageRefsWindow = manageRef_template(None, wx.ID_ANY, "")
    app.SetTopWindow(manageRefsWindow)
    manageRefsWindow.Show()
    app.MainLoop()
