#!/usr/bin/python -O
# -*- coding: iso-8859-15 -*-

##    Copyright 2012, Momme Winkelnkemper <specmate@posteo.de>
##
##    This file is part of SpecMate.
##
##    SpecMate is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Specmate is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with SpecMate.  If not, see <http://www.gnu.org/licenses/>.

"""
This Module implements the the main window of the "SpecMate" application.
"""

#----------------------------------------------------------------------------
# packages to import
#----------------------------------------------------------------------------
import sys,os
import copy
import time
import warnings
try:
	import wx
except:
	print "Please install wxPython!"
	sys.exit(1)

#try:
#	import wxmpl
#except:
#	print "It seems that you don't have wxmpl installed, I'll try to use a copy distributed along with SpecMate."
import copy_of_wxmpl as wxmpl

try:
	import numpy as na
except:
	print "Please install numpy!"
	sys.exit(1)
try:
	from matplotlib.backends.backend_wx import NavigationToolbar2Wx
	from matplotlib import rcParams
except:
	print "Please install matplotlib!"
	sys.exit(1)

from specmate_datasets import specmate_singleDataset
from specmate_menubar import specmate_menubar
from specmate_backend import specmate_backend
#from specmate_globals import *
from specmate_globals import appName
#from specmate_frontend_popups import specmate_editNamesWindow, specmate_refWindow,specmate_comboboxWindow 
from specmate_frontend_popups import specmate_editNamesWindow,specmate_comboboxWindow 
from specmate_refWindow import specmate_refWindow 
#from specmate_addPeakWindow import specmate_addPeakWindow
from specmate_addPeakWindow import specmate_modPeakWindow
from specmate_fitWindow import specmate_fitWindow
from specmate_settings import TXT_WILDCARD, PROJECT_WILDCARD
from specmate_BGWindow import specmate_createBGWindow
from specmate_shiftWindow import specmate_shiftSpectrumWindow
#----------------------------------------------------------------------------
#----------------------------------------------------------------------------


#-----------------------------------------------------------------------------------------
# begin customized matplotlib-toolbar
#-----------------------------------------------------------------------------------------
class CustomToolbar(NavigationToolbar2Wx):
	"""
	Customized toolbar for the PlotPanel. 
	@ivar parent: parent instance, should have event handler ".onButtonHome(event)" implemented.
	@type parent: python class
	"""
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def __init__(self,canvas,parent):
		"""
		@param canvas: matplotlib plotting canvas object.
		@param parent: instance of a class that has at least an instance named "onButtonHome(self,event)".
		"""
	    	self.toolitems = (
        			('Home', 'Reset original view', 'home', 'home'),
        			#('Back', 'Back to  previous view', 'back', 'back'),
        			#('Forward', 'Forward to next view', 'forward', 'forward'),
        			#(None, None, None, None),
        			('Pan', 'Pan axes with left mouse, zoom with right', 'move', 'pan'),
        			('Zoom', 'Zoom to rectangle', 'zoom_to_rect', 'zoom'),
        			#(None, None, None, None),
        			#('Subplots', 'Configure subplots', 'subplots', 'configure_subplots'),
        			('Save', 'Save the figure', 'filesave', 'save_figure'),
      				)
		NavigationToolbar2Wx.__init__(self,canvas)
		self.parent=parent
	###--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------

	###--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	def set_history_buttons(self):
        	"""
		Enable or disable back/forward button
		"""
        	pass
	###--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	###--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	def home(self,event):
		"""
		reimplement event handler "NavigationToolbar2Wx.home()" to call parent.onButtonHome(event) when the "home"-Button is pressed.
		"""
		self.parent.onButtonHome(event)
	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------

	###--------------------------------------------------------------------------------
	###--------------------------------------------------------------------------------
	#def pan(self,event):
	#	"""
	#	reimplement event handler "NavigationToolbar2Wx.pan()" to call parent.onButtonHome(event) when the "pan"-Button is pressed.
	#	"""
	#	self.parent.onButtonHome(event)
	###--------------------------------------------------------------------------------
	###--------------------------------------------------------------------------------

	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	def configure_subplot(self,event):
		"""
		reimplement event handler "NavigationToolbar2Wx.configure_subplot()" to do nothing when the "configure subplot"-Button is pressed.
		"""
		print "function: 'configure subplot' not implemented!"
	##--------------------------------------------------------------------------------
	##--------------------------------------------------------------------------------
	###--------------------------------------------------------------------------------
	###--------------------------------------------------------------------------------
	#def zoom(self,event):
	#	"""
	#	reimplement event handler "NavigationToolbar2Wx.configure_subplot()" to do nothing when the "configure subplot"-Button is pressed.
	#	"""
	#	print "function: 'zoom' not implemented!"
	###--------------------------------------------------------------------------------
	###--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
##-----------------------------------------------------------------------------------------
## begin customized matplotlib-toolbar
##-----------------------------------------------------------------------------------------
#class CustomToolbar(NavigationToolbar2Wx):
#	"""
#	Customized toolbar for the PlotPanel. 
#	@ivar parent: parent instance, should have event handler ".onButtonHome(event)" implemented.
#	@type parent: python class
#	"""
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#	def __init__(self,canvas,parent):
#		"""
#		@param canvas: matplotlib plotting canvas object.
#		@param parent: instance of a class that has at least an instance named "onButtonHome(self,event)".
#		"""
#		NavigationToolbar2Wx.__init__(self,canvas)
#		self.parent=parent
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#	
#	def _load_bitmap(self,filename):
#    		"""
#		This function is copied(and modified) from matplotlib's backend_wx.py.
#
#    		Load a bitmap file from the backends/images subdirectory in which the
#    		matplotlib library is installed. The filename parameter should not
#    		contain any path information as this is determined automatically.
#
#    		Returns a wx.Bitmap object
#    		"""
#
#    		basedir = os.path.join(rcParams['datapath'],'images')
#
#    		bmpFilename = os.path.normpath(os.path.join(basedir, filename))
#    		if not os.path.exists(bmpFilename):
#        		raise IOError('Could not find bitmap file "%s"; dying'%bmpFilename)
#
#    		bmp = wx.Bitmap(bmpFilename)
#    		return bmp
#
#	def save2(self, *args):
#		try:
#			self.save_figure(*args)
#		except:
#			self.save(*args)
#
#	def _init_toolbar(self):
#    		"""
#		This function is copied(and modified) from matplotlib's backend_wx.py.
#
#    		"""
#		#DEBUG_MSG("_init_toolbar", 1, self)
#		self._parent = self.canvas.GetParent()
#		_NTB2_HOME	=wx.NewId()
#		self._NTB2_BACK	=wx.NewId()
#		self._NTB2_FORWARD =wx.NewId()
#		self._NTB2_PAN	 =wx.NewId()
#		#self._NTB2_ZOOM	=wx.NewId()
#		_NTB2_SAVE	= wx.NewId()
#		#_NTB2_SUBPLOT	=wx.NewId()
#
#		self.SetToolBitmapSize(wx.Size(24,24))
#
#		self.AddSimpleTool(_NTB2_HOME, self._load_bitmap('home.png'),
#						   'Reset Original View', 'Reset original view')
#		self.AddSimpleTool(self._NTB2_BACK, self._load_bitmap('back.png'),
#						   'Back', 'Back navigation view')
#		self.AddSimpleTool(self._NTB2_FORWARD, self._load_bitmap('forward.png'),
#						   'Forward', 'Forward navigation view')
#		# todo: get new bitmap
#		self.AddCheckTool(self._NTB2_PAN, self._load_bitmap('move.png'),
#						   shortHelp='Pan',
#						   longHelp='Pan with left, zoom with right')
#		#self.AddCheckTool(self._NTB2_ZOOM, self._load_bitmap('zoom_to_rect.png'),
#		#				   shortHelp='Zoom', longHelp='Zoom to rectangle')
#
#		self.AddSeparator()
#		#self.AddSimpleTool(_NTB2_SUBPLOT, self._load_bitmap('subplots.png'),
#		#				   'Configure subplots', 'Configure subplot parameters')
#
#		self.AddSimpleTool(_NTB2_SAVE, self._load_bitmap('filesave.png'),
#						   'Export Image to File', 'Save plot contents to file')
#
#		self.Bind( wx.EVT_TOOL, self.home, id=_NTB2_HOME)
#		self.Bind( wx.EVT_TOOL, self.forward, id=self._NTB2_FORWARD)
#		self.Bind( wx.EVT_TOOL, self.back, id=self._NTB2_BACK)
#		#self.Bind( wx.EVT_TOOL, self.zoom, id=self._NTB2_ZOOM)
#		self.Bind( wx.EVT_TOOL, self.pan, id=self._NTB2_PAN)
#		#self.Bind( wx.EVT_TOOL, self.configure_subplot, id=_NTB2_SUBPLOT)
#		self.Bind( wx.EVT_TOOL, self.save2, id=_NTB2_SAVE)
#
#		self.Realize()
#
#	
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#	def home(self,event):
#		"""
#		reimplement event handler "NavigationToolbar2Wx.home()" to call parent.onButtonHome(event) when the "home"-Button is pressed.
#		"""
#		self.parent.onButtonHome(event)
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#	def pan(self,event):
#		"""
#		reimplement event handler "NavigationToolbar2Wx.pan()" to call parent.onButtonHome(event) when the "pan"-Button is pressed.
#		"""
#		self.parent.onButtonHome(event)
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
#	def configure_subplot(self,event):
#		"""
#		reimplement event handler "NavigationToolbar2Wx.configure_subplot()" to do nothing when the "configure subplot"-Button is pressed.
#		"""
#		print "function: 'configure subplot' not implemented!"
#	#--------------------------------------------------------------------------------
#	#--------------------------------------------------------------------------------
##-----------------------------------------------------------------------------------------
##-----------------------------------------------------------------------------------------

##-----------------------------------------------------------------------------------------
##-----------------------------------------------------------------------------------------
#class MainWindow_basics(wx.Frame):
#	self.level=0
#	self.messages_level1=[]
#	self.messages_level2=[]

#-----------------------------------------------------------------------------------------
# begin class "MainWindow_helperFunctions"
#----------------------------------------------------------------------------------------
class MainWindow_helperFunctions(wx.Frame):
	"""
	This class implements some helper functions for the main window of the "SpecMate" application.
	"""
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def complain(self,message):
		"""
		Show an info box with message "message"
		@param message: message to be displayed
		@type message: string
		"""
		dialog=wx.MessageBox(message, 'Info', wx.OK | wx.ICON_INFORMATION)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def complain_io(self,filename,rw='r'):
		"""
		Show an info box that a file operation did not succeed
		@param filename: file that couldn't be opened/written
		@type filename: string
		@param rw: read or write operation("r"/"w")
		@type rw: string ("r"/"w")
		"""
		if rw=='r':
			message="Couldn't open file: "+filename
		if rw=='rm':
			message="Couldn't open files."#,filename
		elif rw=='w':
			message="Couldn't write file: "+filename
		else:
			return(1)
		self.complain(message)
		#dialog=wx.MessageBox(message, 'Info', wx.OK | wx.ICON_INFORMATION)
		return(0)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def question(self,question):
		"""
		Show a message dialog with YES/NO buttons
		@param question: question to be displayed
		@type qeustion: string
		@return: True(YES)/False(erverything else)
		@rtype: bool
		"""
        	dial = wx.MessageDialog(None, question, 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_YES:
			return(True)
		return(False)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def checkLocked(self,datasets=[]):
		"""
		Check if any of the datasets in the list is locked. Return 0 if non is locked and 1 if at least one is locked.
		@param datasets: datasets to be checked ("peaks", "references","spectrum","background")
		@type datasets: list of strings
		@return: 1/0
		@rtype: int
		"""
		for each in datasets:
			if self.backend.isLocked(each):
				self.complain("Dataset '"+each+"' is locked by another process!")
				return(1)
		return(0)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def fileDialog(self,message,backendFunction=None,defaultDir=None,defaultFile=None, wildcard=TXT_WILDCARD,style='r',default_ext='None'):
		"""
		Open a file open (style='r') or save (style="w") dialog and return the selected filename. If backendFunction is given it will be called with the selected filename as parameter.
		@param message: message to be shown in the file dialog.
		@type message: string
		@param backendFunction: function to be called with the selected filename as parameter. (Default: None)
		@type backendFunction: python function
		@param wildcard: wildcards for the file dialog
		@type wildcard: string
		@return: filename chosen by the user / None if something went wrong
		@rtype: string (or None-pointer in case of an error)
		...
		...
		...
		"""
		wx_style=wx.OPEN
		if style=='rm':
			wx_style=wx.OPEN|wx.MULTIPLE
		if style=='w':
			wx_style=wx.SAVE
		if defaultDir==None:
			defaultDir=os.getcwd()
		if defaultFile==None:
			openDialog=wx.FileDialog(self,message=message,defaultDir=defaultDir,wildcard=wildcard,style=wx_style|wx.CHANGE_DIR)
		else:
			openDialog=wx.FileDialog(self,message=message,defaultDir=defaultDir,defaultFile=defaultFile,wildcard=wildcard,style=wx_style|wx.CHANGE_DIR)
		if openDialog.ShowModal()!=wx.ID_OK:
			return(None)
		if style=='rm':
			filename=openDialog.GetPaths()
		else:
			filename=openDialog.GetPath()
		if ((style=="w") and (default_ext!='None') and (len(filename.split('.'))<2)):
			filename=filename+"."+default_ext
		if ((style=="w") and os.path.exists(filename)):
			if not self.question('File already exists. Sure to overwrite?'):
				return(None)
        		#dial = wx.MessageDialog(None, 'File already exists. Sure to overwrite?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
			#if dial.ShowModal()!=wx.ID_YES:
			#	return(None)
		if backendFunction!=None:
			if backendFunction(filename)!=0:
				self.complain_io(filename,style)
				return(None)
		return(filename)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
# end class "MainWindow_helperFunctions"
#----------------------------------------------------------------------------------------


#-----------------------------------------------------------------------------------------
# begin class "MainWindow_windowContents"
#----------------------------------------------------------------------------------------
class MainWindow_windowContents(MainWindow_helperFunctions):
	"""
	This class implements the contents of the main window..
	"""

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def onButtonHome(self,event):
		"""
		Event handler: Button "Home"; used by the customized toolbar.
		Autoscale the plot.
		"""
		self.replot(autoscale=True)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def add_toolbar(self):
		"""
		adds the navigation tools to the plot-panel
		The code is taken from the matplotlib usage examples at matplotlib.org.
		"""
	        #self.toolbar = NavigationToolbar2Wx(self.plotPanel)
	        self.toolbar = CustomToolbar(self.plotPanel,self)
	        self.toolbar.Realize()
	        if wx.Platform == '__WXMAC__':
	            # Mac platform (OSX 10.3, MacPython) does not seem to cope with
	            # having a toolbar in a sizer. This work-around gets the buttons
	            # back, but at the expense of having the toolbar at the top
	            self.SetToolBar(self.toolbar)
	        else:
	            # On Windows platform, default window size is incorrect, so set
	            # toolbar width to figure width.
	            tw, th = self.toolbar.GetSizeTuple()
	            fw, fh = self.plotPanel.GetSizeTuple()
	            # By adding toolbar in sizer, we are able to put it at the bottom
	            # of the frame - so appearance is closer to GTK version.
	            # As noted above, doesn't work for Mac.
	            self.toolbar.SetSize(wx.Size(fw, th))
	            self.sizer.Add(self.toolbar, 0, wx.LEFT | wx.EXPAND)
	        # update the axes menu on the toolbar
		self.toolbar.update()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _initFrameContents(self):
		"""
		Put the wxmpl-PlotPanel and Navigation-Tollbar in Main-Window
		"""
		self.plotPanel	=	wxmpl.PlotPanel(self,-1,size=(10.0,6.17))
		wxmpl.EVT_POINT(self.plotPanel, -1, self._handleMouseClicks)
	        self.sizer = wx.BoxSizer(wx.VERTICAL)
	        self.sizer.Add(self.plotPanel, 1, wx.EXPAND, 5)
		self.add_toolbar()
	        self.SetSizer(self.sizer)
	        self.Fit()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
       	def _handleMouseClicks(self, event):
		"""
		Handler for left mouse click events in the PlotPanel.
		If self.mouseClickReceiver is set, x- and y- coordinate of the click are passed on to this function.
		@param event: event from which the mouse coordinates are extracted. 
		@type event: wxmpl.EVT_POINT
		"""
		
		if self.mouseClickReceiver=='None':
			print event.xdata, event.ydata
		else:
			self.mouseClickReceiver(event.xdata,event.ydata)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def getPlotLimits(self):
		"""
		...
		"""
		axes = self.plotPanel.get_figure().gca()
		return tuple(axes.get_xlim()), tuple(axes.get_ylim())
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def replot(self,autoscale=False):
		"""
		Replot the plot canvas. Is to be called whenever something in the plot data/parameters has changed.
		@param autoscale: whether or not the plot axis should be rescaled again
		@type autoscale: Boolean
		"""
		#self._calcDiff()
		
		fig = self.plotPanel.get_figure()
		axes = fig.gca()
		
		# store the current zoom limits
		# NB: MPL 0.98.1 returns the underlying array objects of the limits
		xlim,ylim=self.getPlotLimits()
		
		# clear the axes and replot everything
		axes.cla()
		#if self.backend.specData.hasData:
		#	axes.plot(self.backend.specData.X(),self.backend.specData.Y(), self.backend.specData.linestyle,linewidth=self.backend.specData.linewidth, label=self.backend.specData.name)
		for i in xrange(0,len(self.backend.plotData)):
			axes.plot(self.backend.plotData[i][0],self.backend.plotData[i][1], self.backend.plotData[i][4],linewidth=self.backend.plotData[i][3], label=self.backend.plotData[i][2])
		if self.backend.background.hasData:
			axes.plot(self.backend.background.data[:,0],self.backend.background.data[:,1], 'ko')#,label=self.backend.background.name)
			axes.plot(self.backend.background.interpData[:,0],self.backend.background.interpData[:,1], 'k-')

		#axes.plot(t, s, linewidth=1.0)#, label='sin')
		
		axes.set_xlabel(self.backend.namesAndLabels['Axis Label (X)'])
		axes.set_ylabel(self.backend.namesAndLabels['Axis Label (Y)'])
		if self.backend.namesAndLabels['Graph Title']!="None":
			axes.set_title(self.backend.namesAndLabels['Graph Title'])
		if len(self.backend.plotData)>0 or self.backend.background.hasData:
			axes.legend(loc="best")
		axes.grid()
		
		# restore the zoom limits (unless they're for an empty plot)
		if autoscale:
			axes.autoscale()
			if self.backend.specData.hasData:
				axes.set_xlim(na.min(self.backend.specData.X()),na.max(self.backend.specData.X()))
			#axes.set_xlim(self.backend.xMin,self.backend.xMax)
		elif xlim != (0.0, 1.0) or ylim != (0.0, 1.0):
			axes.set_xlim(xlim)
			axes.set_ylim(ylim)
		
		# redraw the disply
		self.plotPanel.draw()
		self.setTitle()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def setTitle(self):
		if self.backend.specData.hasData:
			self.SetTitle(appName+' <'+self.backend.specData.name+'>')
			return
		self.SetTitle(appName)

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#Constructor
	#--------------------------------------------------------------------------------
	def __init__(self,parent,id,title,backend, **kwds):
		"""
		Constructor: calls _initMenuBar(), _initFrameContents(), and replot()
		@param backend: backend on which all operations are to be executed.
		@type backend: specmate_backend
		"""
		self.backend=backend
		self.backend.frontend=self
		#specmate_menubar.__init__(self,parent,id,title,style=wx.DEFAULT_FRAME_STYLE | wx.TAB_TRAVERSAL, **kwds)
		self.mouseClickReceiver='None'
		self._initFrameContents()
		self.replot()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
# end class "MainWindow_windowContents"
#----------------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# begin class "MainWindow_unsortedEventHandlers"
#----------------------------------------------------------------------------------------
class MainWindow_unsortedEventHandlers(specmate_menubar,MainWindow_windowContents):
	"""
	This class implements the main window of the "SpecMate" application.
	"""
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuReadSpectrum(self,event):
		"""
		Event handler: File Menu "Open Spectrum"
		Opens a file-open dialog and trys to open the result as "spectrum" using self.backend.readSpectrum 
		"""
		defDir=''
		if self.backend.specData.filename!="None":
			defDir=os.path.dirname(self.backend.specData.filename)
		if defDir=='':
			defDir=os.getcwd()
		self.fileDialog("Select a spectrum to analyze",self.backend.readSpectrum,defDir,wildcard=TXT_WILDCARD,style="r",default_ext="None")
		self.setTitle()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuShiftSpectrum(self,event):
		"""
		Event handler: File Menu "Shift Spectrum"
		...
		"""
		if not self.backend.specData.hasData:
			self.complain("You don't have a spectrum to shift!")
			return
		if self.checkLocked(['spectrum'])!=0:
			return
		self.backend.dataBackup(['spectrum'])
		shiftWindow=specmate_shiftSpectrumWindow(self,-1,'Shift X-Axis')
		shiftWindow.Show()

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuExportDataset(self,event):
		"""
		Event handler: File Menu "Export single dataset"
		"""
		allDatasets=[]
		if self.backend.specData.hasData:
			allDatasets.append('Spectrum: '+self.backend.specData.name)
		i=0
		for each in self.backend.refSpectra:
			i+=1
			if each.hasData:
				allDatasets.append('Ref. Spec. %d: %s' % (i,each.name))
		i=0
		for each in self.backend.peakSpectra:
			i+=1
			if each.hasInterpData:
				allDatasets.append('Peak %d: %s' % (i,each.name))
		if self.backend.background.hasData:
			allDatasets.append('Baseline: '+self.backend.background.name)
		if self.backend.diffData.hasData:
			allDatasets.append('Residual: '+self.backend.diffData.name)
		listOfDatasets=['Dataset',allDatasets[-2],allDatasets]
		xAxisList=['X-Axis','Interpolated X-Axis',['Interpolated X-Axis','Original X-Axis']]	
		comboWindow=specmate_comboboxWindow(self,[listOfDatasets,xAxisList],self.exportDatasetCallback,-1,'Export Single Dataset')
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuExportAllDatasets(self,event):
		"""
		Event handler: File Menu "Export all datasets"
		"""
		self.fileDialog("Select filename for data export",self.backend.saveAllSets,wildcard=TXT_WILDCARD,style="w",default_ext="dat")
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def exportDatasetCallback(self,names):
		filename=self.fileDialog("Select filename for data export",None,wildcard=TXT_WILDCARD,style="w",default_ext="dat")
		if filename==None:
			return(1)
		descriptor=names[0][1].split(':')[0]
		num=-1
		if descriptor=='Spectrum':
			whichSet='spectrum'
		elif descriptor=='Residual':
			whichSet='residual'
		elif descriptor=='Baseline':
			whichSet='background'
		elif descriptor.split('.')[0]=='Ref':
			whichSet='reference'
			num=int(descriptor.split(' ')[-1])-1
		elif descriptor.split(' ')[0]=='Peak':
			whichSet='peak'
			num=int(descriptor.split(' ')[-1])-1
		descriptor=names[1][1].split(' ')[0]
		if descriptor=='Interpolated':
			intType='interpolated'
		elif descriptor=='Original':
			intType='original'
		if self.backend.saveSingleSet(filename,which=whichSet,number=num,which_data=intType)!=0:
			self.complain_io(filename,'w')
			return(1)
		return(0)

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuSave(self,event):
		self.fileDialog("Select filename for your project",self.backend.saveProject,wildcard=PROJECT_WILDCARD,style="w",default_ext="spm")
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuOpen(self,event):
		self.fileDialog("Select project to open",self.backend.openProject,wildcard=PROJECT_WILDCARD,style="r")
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuNew(self,event):
		newBackend=specmate_backend()
		newMainFrame = MainWindow(None,-1,appName,newBackend)
		newMainFrame.Show()
        	#dial = wx.MessageDialog(None, 'All unsaved data will be lost!\nSure to continue?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		#if dial.ShowModal()==wx.ID_YES:
		#	self.backend.initEmptyProject()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuDuplicate(self,event):
		newBackend=specmate_backend()
		newBackend.dict2Project(self.backend.project2Dict())
		newBackend.specData.name=newBackend.specData.name+' (dupl.)' 
		#newBackend.updateNamesAndLabels(['(dupl.)']) 
		newMainFrame = MainWindow(None,-1,appName,newBackend)
		newMainFrame.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuPrint(self,event):
		FigPrinter=wxmpl.FigurePrinter(self.plotPanel)
		openDialog=FigPrinter.printFigure(self.plotPanel.get_figure())

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuPreview(self,event):
		FigPrinter=wxmpl.FigurePrinter(self.plotPanel)
		openDialog=FigPrinter.previewFigure(self.plotPanel.get_figure())
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuNamesAndLabels(self,event):
		if self.checkLocked(['namesAndLabels'])!=0:
			return
		names=[]
		names.append(["Spectrum Name",self.backend.specData.name])
		names.append(["Residual Name",self.backend.diffData.name])
		for key,value in self.backend.namesAndLabels.items():
			names.append([key, value])
		editNamesWindow=specmate_editNamesWindow(self,names,self.backend.updateNamesAndLabels,-1,"Edit Names and Labels")
		editNamesWindow.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuStartFit(self,event):
		if not self.backend.specData.hasData:
			self.complain("You have to load a spectrum first!")
			return
		if ((len(self.backend.refSpectra)==0) and (len(self.backend.peakSpectra)==0)):
			self.complain("You have to add a peak and/or reference spectrum first!")
			return
		if self.checkLocked(['peaks','references'])!=0:
			return
		self.backend.initFitParams()
		self.backend.dataBackup(['peaks','references'])
		fitWindow=specmate_fitWindow(self)
		fitWindow.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#Constructor
	#--------------------------------------------------------------------------------
	def __init__(self,parent,id,title,backend, **kwds):
		"""
		Constructor:... 
		@param backend: backend on which all operations are to be executed.
		@type backend: specmate_backend
		"""
		specmate_menubar.__init__(self,parent,id,title,style=wx.DEFAULT_FRAME_STYLE | wx.TAB_TRAVERSAL, **kwds)
		MainWindow_windowContents.__init__(self,parent,id,title,backend,style=wx.DEFAULT_FRAME_STYLE | wx.TAB_TRAVERSAL, **kwds)	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#end class "MainWindow_unsortedEventHandlers"
#-----------------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# begin class "MainWindow_refFunctions"
#----------------------------------------------------------------------------------------
class MainWindow_refFunctions(MainWindow_unsortedEventHandlers):
	"""
	Implement the front-end part of reference spectra handling
	"""
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuAddRef(self,event):
		"""
		Event handler for the menu option.
		Open a file dialog and add a reference sprecturm to the plot
		"""
		if self.checkLocked(['references'])!=0:
			return
		defDir=''
		if len(self.backend.refSpectra)>0 and self.backend.refSpectra[-1].filename!="None":
			defDir=os.path.dirname(self.backend.refSpectra[-1].filename)
		if defDir=='' and self.backend.specData.filename!="None":
			defDir=os.path.dirname(self.backend.specData.filename)
		if defDir=='':
			defDir=os.getcwd()
		self.fileDialog("Select a referenc spectrum to open",self.backend.addReferences,defDir,wildcard=TXT_WILDCARD,style="rm",default_ext="None")
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuEditRefNames(self,event):
		"""
		Event handler for the menu option.
		Open the edit reference names sub window
		"""
		if self.checkLocked(['references'])!=0:
			return
		if len(self.backend.refSpectra)<1:
			self.complain("Please load a reference spectrum first!")
			return
		names=[]
		for i in xrange(0,len(self.backend.refSpectra)):
			names.append(["Reference Spectrum %d" % (i+1),self.backend.refSpectra[i].name])
		editNamesWindow=specmate_editNamesWindow(self,names,self.backend.updateRefNames,-1,"Edit Reference Names")
		editNamesWindow.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuManageRef(self,event):
		"""
		Event handler for the menu option.
		Open the manage references sub window
		@return: success(0)/fail(1)
		@rtype: int
		"""

		if self.checkLocked(['references'])!=0:
			return(1)
		if len(self.backend.refSpectra)>0:
			self.backend.dataBackup(['references'])
			manageRefWindow=specmate_refWindow(self,-1,"Manage References")
			manageRefWindow.Show()
		else:
			self.complain("You have to load a reference spectrum first!")
			return(1)
		return(0)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
# begin class "MainWindow_baselineFunctions"
#----------------------------------------------------------------------------------------
class MainWindow_baselineFunctions(MainWindow_unsortedEventHandlers):
	"""
	Implement the front-end part of baseline/background handling
	"""
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuCreateBackground(self,event):
		"""
		Event handler for the menu option.
		Open the create-background sub window.
		"""

		if not self.backend.specData.hasData:
			self.complain("You have to load a spectrum first!")
			return
		if self.checkLocked(['background'])!=0:
			return
		if self.mouseClickReceiver!='None':
			self.complain("Canvas clicks are already resevered for another process!")
			return
		self.backend.dataBackup(['background'])
		createBGWindow=specmate_createBGWindow(self,-1," Baseline")	
		createBGWindow.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuDeleteBackground(self,event):
		"""
		Event handler for the menu option.
		Clear background data after confirmation dialog.
		"""
		if self.checkLocked(['background'])!=0:
			return
		if not self.backend.background.hasData:
			self.complain("You have no baseline to delete!")
			return
        	dial = wx.MessageDialog(None, 'Really delete baseline data?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_YES:
			self.backend.clearBackground()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuSubstractBackground(self,event):
		"""
		Event handler for the menu option.
		Substract background from spectrum, clear background afterwards. 
		"""
		if not self.backend.specData.hasData:
			self.complain("You have to load a spectrum first!")
			return
		if not self.backend.background.hasData:
			self.complain("You have create a baseline first!")
			return
		if self.checkLocked(['background','spectrum'])!=0:
			return
		if self.backend.background.hasData!=True:
			self.complain("Please enter baseline data first!")
			return
		self.backend.dataBackup(['background','spectrum'])
		self.backend.substractFromSpectrum('background')
		self.backend.clearBackground()
        	dial = wx.MessageDialog(None, 'Do you like the result?', 'Question', wx.YES_NO | wx.NO_DEFAULT | wx.ICON_QUESTION)
		if dial.ShowModal()==wx.ID_YES:
			return
		self.backend.restoreDataBackup()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuExportBGPoints(self,event):
		"""
		Event handler for the menu option.
		Export background as point data. 
		"""
		if not self.backend.background.hasData:
			self.complain("You have create a baseline first!")
			return
		filename=self.fileDialog("Select filename for data export",None,wildcard=TXT_WILDCARD,style="w",default_ext="dat")
		if filename==None:
			return
		if self.backend.saveSingleSet(filename,which='background',which_data='original')!=0:
			self.complain_io(filename,"w")
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuExportBGLine(self,event):
		"""
		Event handler for the menu option.
		Export background as interpolated data. 
		"""
		if not self.backend.background.hasData:
			self.complain("You have create a baseline first!")
			return
		filename=self.fileDialog("Select filename for data export",None,wildcard=TXT_WILDCARD,style="w",default_ext="dat")
		if filename==None:
			return
		if self.backend.saveSingleSet(filename,which='background',which_data='interpolated')!=0:
			self.complain_io(filename,'w')
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuImportBGPoints(self,event):
		"""
		Event handler for the menu option.
		Import background data from ascii file 
		"""
		if self.checkLocked(['background'])!=0:
			return
		defDir=''
		if self.backend.background.filename!="None":
			defDir=os.path.dirname(self.backend.background.filename)
		if defDir=='' and self.backend.specData.filename!="None":
			defDir=os.path.dirname(self.backend.specData.filename)
		if defDir=='':
			defDir=os.getcwd()
		self.fileDialog("Select a datafile to open",self.backend.readBackground,defDir,wildcard=TXT_WILDCARD,style="r",default_ext="None")

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#end class "MainWindow_baselineFunctions"
#-----------------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# begin class "MainWindow_peakFunctions"
#----------------------------------------------------------------------------------------
class MainWindow_peakFunctions(MainWindow_unsortedEventHandlers):
	"""
	Implement the front-end part of peak handling
	"""
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuAddPeak(self,event):
		"""
		Event handler for the menu option.
		Add a peak to the plot and open the modify peak sub window.
		"""
		if self.checkLocked(['peaks'])!=0:
			return
		if not self.backend.specData.hasData:
			self.complain("You have to load a spectrum first!")
			return
		self.backend.dataBackup(['peaks'])
		self.backend.addPeak()
		addPeakWindow=specmate_modPeakWindow(self,-1,"Add Peak")
		addPeakWindow.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onMenuManagePeaks(self,event):
		"""
		Event handler for the menu option.
		Open the modify peak sub window.
		"""
		if self.checkLocked(['peaks'])!=0:
			return
		if len(self.backend.peakSpectra)<1:
			self.complain("Please create a peak first!")
			return
		self.backend.dataBackup(['peaks'])
		addPeakWindow=specmate_modPeakWindow(self,-1,"Modify Peaks")
		addPeakWindow.Show()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#end class "MainWindow_peakFunctions"
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
# begin class "specmate_MainWindow_peakFunctions"
#----------------------------------------------------------------------------------------
class MainWindow(MainWindow_peakFunctions,MainWindow_baselineFunctions,MainWindow_refFunctions):
	def dummy(self):
		print "..."
	#...
#-----------------------------------------------------------------------------------------
#end class "MainWindow"
#-----------------------------------------------------------------------------------------

