#!/usr/bin/python -O
# -*- coding: iso-8859-15 -*-

##    Copyright 2012, Momme Winkelnkemper <specmate@posteo.de>
##
##    This file is part of SpecMate.
##
##    SpecMate is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Specmate is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with SpecMate.  If not, see <http://www.gnu.org/licenses/>.

import wx
from math import sqrt
"""
This Module implements the popup window for "Start Fit".
"""

#from glade_classes.addPeakWindow import specmate_addPeakWindow_template
from fitWindow_template2 import fitWindow_template
from specmate_settings import DEFAULT_EXP_FORMAT

#------------------------------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------------------------------
class specmate_fitWindow(fitWindow_template):
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def __init__(self,parent, *args, **kwds):
		self.parent=parent
		fitWindow_template.__init__(self,parent,style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL)
		for i in xrange(0,len(parent.backend.peakSpectra)):
			self.choicePeakSelect.Append('Peak %d: %s' % (i+1,parent.backend.peakSpectra[i].name))
		self.peak=len(parent.backend.peakSpectra)-1
		if self.peak!=-1:
			self.choicePeakSelect.SetSelection(self.peak)
		for i in xrange(0,len(parent.backend.refSpectra)):
			self.choiceReferenceSelect.Append('Ref. Spec. %d: %s' % (i+1,parent.backend.refSpectra[i].name))
		self.ref=len(parent.backend.refSpectra)-1
		if self.ref!=-1:
			self.choiceReferenceSelect.SetSelection(self.peak)
		##----------------------------
		for i in xrange(0,len(parent.backend.fitModels)):
			self.choiceAlgo.Append(parent.backend.fitModels[i])
		self.choiceAlgo.SetSelection(0)
		self.loadData()
		self.setCtrls()	
		self.Bind(wx.EVT_CLOSE,self._onDone)
		self.parent.backend.lock('peaks')
		self.parent.backend.lock('references')
		self.SetTitle('Fit <'+self.parent.backend.specData.name+'>')
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def loadPeakData(self):
		self.peakInclude=self.parent.backend.peakSpectra[self.peak].fitParam['include']
		self.x0=self.parent.backend.peakSpectra[self.peak].x0
		self.x0Max=self.parent.backend.peakSpectra[self.peak].fitParam['x0']['max']
		self.x0Min=self.parent.backend.peakSpectra[self.peak].fitParam['x0']['min']
		self.x0Include=self.parent.backend.peakSpectra[self.peak].fitParam['x0']['include']
		self.y0=self.parent.backend.peakSpectra[self.peak].y0
		self.y0Max=self.parent.backend.peakSpectra[self.peak].fitParam['y0']['max']
		self.y0Min=self.parent.backend.peakSpectra[self.peak].fitParam['y0']['min']
		self.y0Include=self.parent.backend.peakSpectra[self.peak].fitParam['y0']['include']
		self.FWHM=self.parent.backend.peakSpectra[self.peak].FWHM
		self.FWHMMax=self.parent.backend.peakSpectra[self.peak].fitParam['FWHM']['max']
		self.FWHMMin=self.parent.backend.peakSpectra[self.peak].fitParam['FWHM']['min']
		self.FWHMInclude=self.parent.backend.peakSpectra[self.peak].fitParam['FWHM']['include']
		self.shape=self.parent.backend.peakSpectra[self.peak].shape
		self.shapeMax=self.parent.backend.peakSpectra[self.peak].fitParam['shape']['max']
		self.shapeMin=self.parent.backend.peakSpectra[self.peak].fitParam['shape']['min']
		self.shapeInclude=self.parent.backend.peakSpectra[self.peak].fitParam['shape']['include']
		self.peakType=self.parent.backend.peakSpectra[self.peak].peakType
		self.name=self.parent.backend.peakSpectra[self.peak].name
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def loadRefData(self):
		self.refInclude=self.parent.backend.refSpectra[self.ref].fitParam['include']
		self.coeff=self.parent.backend.refSpectra[self.ref].coeff
		self.coeffMax=self.parent.backend.refSpectra[self.ref].fitParam['coeff']['max']
		self.coeffMin=self.parent.backend.refSpectra[self.ref].fitParam['coeff']['min']
		self.coeffInclude=self.parent.backend.refSpectra[self.ref].fitParam['coeff']['include']
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def loadData(self):
		self.rangesStart=self.parent.backend.generalFitParam['fitMin']
		self.rangesEnd=self.parent.backend.generalFitParam['fitMax']
		if self.peak!=-1:
			self.loadPeakData()
		if self.ref!=-1:
			self.loadRefData()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def writePeakData(self):
		self.parent.backend.modifyPeak(self.peak,self.x0,self.y0,self.FWHM,self.shape,self.peakType,self.name)
		self.parent.backend.peakSpectra[self.peak].fitParam['include']=self.peakInclude
		self.parent.backend.peakSpectra[self.peak].fitParam['x0']['max']=self.x0Max
		self.parent.backend.peakSpectra[self.peak].fitParam['x0']['min']=self.x0Min
		self.parent.backend.peakSpectra[self.peak].fitParam['x0']['include']=self.x0Include
		self.parent.backend.peakSpectra[self.peak].fitParam['y0']['max']=self.y0Max
		self.parent.backend.peakSpectra[self.peak].fitParam['y0']['min']=self.y0Min
		self.parent.backend.peakSpectra[self.peak].fitParam['y0']['include']=self.y0Include
		self.parent.backend.peakSpectra[self.peak].fitParam['FWHM']['max']=self.FWHMMax
		self.parent.backend.peakSpectra[self.peak].fitParam['FWHM']['min']=self.FWHMMin
		self.parent.backend.peakSpectra[self.peak].fitParam['FWHM']['include']=self.FWHMInclude
		self.parent.backend.peakSpectra[self.peak].fitParam['shape']['max']=self.shapeMax
		self.parent.backend.peakSpectra[self.peak].fitParam['shape']['min']=self.shapeMin
		self.parent.backend.peakSpectra[self.peak].fitParam['shape']['include']=self.shapeInclude
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def writeRefData(self):
		self.parent.backend.updateReference(self.ref,self.coeff,self.parent.backend.refSpectra[self.ref].maxCoeff,self.parent.backend.refSpectra[self.ref].minCoeff)
		self.parent.backend.refSpectra[self.ref].fitParam['include']=self.refInclude
		self.parent.backend.refSpectra[self.ref].fitParam['coeff']['max']=self.coeffMax
		self.parent.backend.refSpectra[self.ref].fitParam['coeff']['min']=self.coeffMin
		self.parent.backend.refSpectra[self.ref].fitParam['coeff']['include']=self.coeffInclude
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def writeData(self):
		self.parent.backend.generalFitParam['fitMin']=self.rangesStart
		self.parent.backend.generalFitParam['fitMax']=self.rangesEnd
		if self.peak!=-1:
			self.writePeakData()
		if self.ref!=-1:
			self.writeRefData()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def setPeakCtrls(self):
		self.checkboxIncludePeak.SetValue(self.peakInclude)
		self.textCtrlX0Initial.SetValue(DEFAULT_EXP_FORMAT % (self.x0))
		self.textCtrlX0Min.SetValue(DEFAULT_EXP_FORMAT % (self.x0Min))
		self.textCtrlX0Max.SetValue(DEFAULT_EXP_FORMAT % (self.x0Max))
		self.checkboxIncludeX0.SetValue(self.x0Include)
		self.textCtrlY0Initial.SetValue(DEFAULT_EXP_FORMAT % (self.y0))
		self.textCtrlY0Min.SetValue(DEFAULT_EXP_FORMAT % (self.y0Min))
		self.textCtrlY0Max.SetValue(DEFAULT_EXP_FORMAT % (self.y0Max))
		self.checkboxIncludeY0.SetValue(self.y0Include)
		self.textCtrlFWHMInitial.SetValue(DEFAULT_EXP_FORMAT % (self.FWHM))
		self.textCtrlFWHMMin.SetValue(DEFAULT_EXP_FORMAT % (self.FWHMMin))
		self.textCtrlFWHMMax.SetValue(DEFAULT_EXP_FORMAT % (self.FWHMMax))
		self.checkboxIncludeFWHM.SetValue(self.FWHMInclude)
		self.textCtrlShapeInitial.SetValue(DEFAULT_EXP_FORMAT % (self.shape))
		self.textCtrlShapeMin.SetValue(DEFAULT_EXP_FORMAT % (self.shapeMin))
		self.textCtrlShapeMax.SetValue(DEFAULT_EXP_FORMAT % (self.shapeMax))
		self.checkboxIncludeShape.SetValue(self.shapeInclude)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def setRefCtrls(self):
		self.checkboxIncludeReference.SetValue(self.refInclude)
		self.textCtrlCoeffInitial.SetValue(DEFAULT_EXP_FORMAT % (self.coeff))
		self.textCtrlCoeffMin.SetValue(DEFAULT_EXP_FORMAT % (self.coeffMin))
		self.textCtrlCoeffMax.SetValue(DEFAULT_EXP_FORMAT % (self.coeffMax))
		self.checkboxIncludeCoeff.SetValue(self.coeffInclude)
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def setCtrls(self):
		self.textCtrlRangesStart.SetValue(DEFAULT_EXP_FORMAT % (self.rangesStart))
		self.textCtrlRangesEnd.SetValue(DEFAULT_EXP_FORMAT % (self.rangesEnd))
		if self.peak!=-1:
			self.setPeakCtrls()
		if self.ref!=-1:
			self.setRefCtrls()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def readPeakCtrls(self):
		self.peakInclude=self.checkboxIncludePeak.GetValue()
		try:
			self.x0=float(self.textCtrlX0Initial.GetValue())
		except:
			self.textCtrlX0Initial.SetValue(DEFAULT_EXP_FORMAT % (self.x0))
		try:
			self.x0Min=float(self.textCtrlX0Min.GetValue())
		except:
			self.textCtrlX0Min.SetValue(DEFAULT_EXP_FORMAT % (self.x0Min))
		try:
			self.x0Max=float(self.textCtrlX0Max.GetValue())
		except:
			self.textCtrlX0Max.SetValue(DEFAULT_EXP_FORMAT % (self.x0Max))
		self.x0Include=self.checkboxIncludeX0.GetValue()
		try:
			self.y0=float(self.textCtrlY0Initial.GetValue())
		except:
			self.textCtrlY0Initial.SetValue(DEFAULT_EXP_FORMAT % (self.y0))
		try:
			self.y0Min=float(self.textCtrlY0Min.GetValue())
		except:
			self.textCtrlY0Min.SetValue(DEFAULT_EXP_FORMAT % (self.y0Min))
		try:
			self.y0Max=float(self.textCtrlY0Max.GetValue())
		except:
			self.textCtrlY0Max.SetValue(DEFAULT_EXP_FORMAT % (self.y0Max))
		self.y0Include=self.checkboxIncludeY0.GetValue()
		try:
			self.FWHM=float(self.textCtrlFWHMInitial.GetValue())
		except:
			self.textCtrlFWHMInitial.SetValue(DEFAULT_EXP_FORMAT % (self.FWHM))
		try:
			self.FWHMMin=float(self.textCtrlFWHMMin.GetValue())
		except:
			self.textCtrlFWHMMin.SetValue(DEFAULT_EXP_FORMAT % (self.FWHMMin))
		try:
			self.FWHMMax=float(self.textCtrlFWHMMax.GetValue())
		except:
			self.textCtrlFWHMMax.SetValue(DEFAULT_EXP_FORMAT % (self.FWHMMax))
		self.FWHMInclude=self.checkboxIncludeFWHM.GetValue()
		try:
			self.shape=float(self.textCtrlShapeInitial.GetValue())
		except:
			self.textCtrlShapeInitial.SetValue(DEFAULT_EXP_FORMAT % (self.shape))
		try:
			self.shapeMin=float(self.textCtrlShapeMin.GetValue())
		except:
			self.textCtrlShapeMin.SetValue(DEFAULT_EXP_FORMAT % (self.shapeMin))
		try:
			self.shapeMax=float(self.textCtrlShapeMax.GetValue())
		except:
			self.textCtrlShapeMax.SetValue(DEFAULT_EXP_FORMAT % (self.shapeMax))
		self.shapeInclude=self.checkboxIncludeShape.GetValue()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def readRefCtrls(self):
		self.refInclude=self.checkboxIncludeReference.GetValue()
		try:
			self.coeff=float(self.textCtrlCoeffInitial.GetValue())
		except:
			self.textCtrlCoeffInitial.SetValue(DEFAULT_EXP_FORMAT % (self.coeff))
		try:
			self.coeffMin=float(self.textCtrlCoeffMin.GetValue())
		except:
			self.textCtrlCoeffMin.SetValue(DEFAULT_EXP_FORMAT % (self.coeffMin))
		try:
			self.coeffMax=float(self.textCtrlCoeffMax.GetValue())
		except:
			self.textCtrlCoeffMax.SetValue(DEFAULT_EXP_FORMAT % (self.coeffMax))
		self.coeffInclude=self.checkboxIncludeCoeff.GetValue()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def readCtrls(self):
		try:
			self.rangesStart=float(self.textCtrlRangesStart.GetValue())
		except:
			self.textCtrlRangesStart.SetValue(DEFAULT_EXP_FORMAT % (self.rangesStart))
		try:
			self.rangesEnd=float(self.textCtrlRangesEnd.GetValue())
		except:
			self.textCtrlRangesEnd.SetValue(DEFAULT_EXP_FORMAT % (self.rangesEnd))
		if self.peak!=-1:
			self.readPeakCtrls()
		if self.ref!=-1:
			self.readRefCtrls()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onPeakSelected(self, event):  
		newPeak=self.choicePeakSelect.GetSelection()
		if newPeak!=self.peak:
			self.readPeakCtrls()
			self.writePeakData()
			self.peak=newPeak
			self.loadPeakData()
			self.setPeakCtrls()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onReferenceSelected(self, event):  
		newRef=self.choiceReferenceSelect.GetSelection()
		if newRef!=self.ref:
			self.readRefCtrls()
			self.writeRefData()
			self.ref=newRef
			self.loadRefData()
			self.setRefCtrls()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def receiver(self,x,y):
	    	if self.toggleButtonSelectStart.GetValue()==True:
			self.readCtrls()
	    		self.rangesStart=x
			self.toggleButtonSelectStart.SetValue(False)
			self.toggleButtonSelectEnd.SetValue(True)
			self.setCtrls()
		elif self.toggleButtonSelectEnd.GetValue()==True:
			self.readCtrls()
	    		self.rangesEnd=x
			self.toggleButtonSelectEnd.SetValue(False)
			self.parent.mouseClickReceiver="None"
			self.setCtrls()
		else:
			self.parent.mouseClickReceiver="None"
	    #--------------------------------------------------------------------------------
	    #--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onPickStart(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		if self.toggleButtonSelectStart.GetValue()==True:
			self.toggleButtonSelectEnd.SetValue(False)
	    		self.parent.mouseClickReceiver=self.receiver
		else:
			self.parent.mouseClickReceiver="None"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onPickEnd(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		if self.toggleButtonSelectEnd.GetValue()==True:
			self.toggleButtonSelectStart.SetValue(False)
	    		self.parent.mouseClickReceiver=self.receiver
		else:
			self.parent.mouseClickReceiver="None"
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onDone(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		if self.parent.backend.fitRunning:
			self.parent.backend.breakFit()
		else:
			self.readCtrls()
			self.writeData()
		self.parent.backend.unlock('peaks')
		self.parent.backend.unlock('references')
		self.parent.mouseClickReceiver="None"
	    	self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onBreak(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		if self.parent.backend.fitRunning:
			self.parent.backend.breakFit()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onStartFit(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		if not self.parent.backend.fitRunning:
			self.readCtrls()
			self.writeData()
			self.parent.backend.startFit(self.updateFitStatus)
			self.loadData()
			self.setCtrls()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onRestore(self, event):  # wxGlade: specmate_addPeakWindow.<event_handler>
		self.parent.backend.restoreDataBackup()
		self.parent.backend.dataBackup(['peaks','references'])
		self.loadData()
		self.setCtrls()
		#self.parent.mouseClickReceiver="None"
		#self.parent.backend.unlock('peaks')
		#self.parent.backend.unlock('references')
		#self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onAlgoSelected(self, event):  
		self.parent.backend.setFitModel(self.parent.backend.fitModels[self.choiceAlgo.GetSelection()])
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def updateFitStatus(self,status,residual):
			self.textCtrlStatus.SetValue(status)
			self.textCtrlResidual.SetValue(DEFAULT_EXP_FORMAT % (residual))
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------------------------------
