;; Basic funs to do SpcialK to Scheme translation

;; Copyright (C) 2004  Sylvain Beucler
;; Copyright (C) 2004  Julien Charles
;; Copyright (C) 2004  Pierre Chtel
;; Copyright (C) 2004  Cyril Rodas

;; This file is part of SpcialK.

;; SpcialK is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.

;; SpcialK is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SpcialK; if not, write to the Free Software Foundation,
;; Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

(module basic-translator
  mzscheme
  (require "special-k-structs.ss" "special-k-grammar.ss"
	   "special-k-opt.ss" "l10n.ss")
  (require (lib "lex.ss" "parser-tools"))
  (provide (all-defined))
  ;;SpcialK->Scheme translation 
  (define opt-jpr-enabled #t)
  (define (set-opt-jpr-enabled v)
    (set! opt-jpr-enabled v))
  (define (specialk-tab-get v is)
    (if (null? is) v
        `(vector-ref ,(specialk-tab-get v (cdr is)) ,(car is))))
  
  
  (define (get-pos-fun-span fun)
    (define (get-m-pos clauses current-min current-max)
      (cond 
        ((null? clauses) (cons current-min current-max))
        ((< (position-offset (get_start_pos_clause (car clauses))) (position-offset current-min))
         (get-m-pos (get_start_pos_clause (cdr clauses) (car (clauses))) current-max))
        ((> (position-offset (get_end_pos_clause (car clauses))) (position-offset current-max))
         (get-m-pos (cdr clauses) current-min (get_end_pos_clause (car clauses))))
        (else (get-m-pos (cdr clauses) current-min current-max))))
    (let* ((clauses (get_clauses fun)))
      (get-m-pos  (cdr clauses) (get_start_pos_clause (car clauses))
                  (get_end_pos_clause (car clauses)))))
  
  
  ;; generate a special k set! instruction
  ;; v is the vector
  ;; is are the indices list
  ;; val is the value to change for
  (define (specialk-tab-set! v is val)
    (let ((tab (gensym)))
    `(let ((,tab ,v))
       (vector-set! ,(specialk-tab-get tab (cdr is)) ,(car is) ,val)
            ,tab)))
  
  ;; generate a special k swap instruction
  ;; v is the vector
  ;; i1, i2 are the indices list to swap the tab...
  (define (specialk-tab-swap! v i1 i2)
    (define (tab-set! v is val)
      `(vector-set! ,(specialk-tab-get v (cdr is)) ,(car is) ,val))
    (let ((val (gensym))
          (tab (gensym)))
      `(let* ((,tab ,v)
              (,val ,(specialk-tab-get tab i2)))
         ,(tab-set! tab i2 (specialk-tab-get tab i1))
         ,(tab-set! tab i1 val)
         ,tab)))
  ;used to generate function's head
  (define (generate-args nb_args)
    (if (zero? nb_args)
        '()
        (cons (gensym) (generate-args (- nb_args 1)))))
  ;; la fun qui gnre le code de la garde; faudra ajouter des mthodes d'optimisations
  (define (get-guard-code fun-name fun-aux garde  nb-args)
    (if (pair? garde) ;(null? garde)
        (get-expr-code fun-name fun-aux garde  nb-args) #t))
  
  ;; la fun qui gnre le code des expr boolennes
  (define (get-bool-expr-code fun-name fun-aux expr  nb-args)
    (case (get_op expr)
      ((==) `(equal? ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
                  ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args)))
      ((>) `(> ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
               ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args)))
      ((<) `(< ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
               ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args)))
      ((>=) `(>= ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
                 ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args)))
      ((<=) `(<= ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
                 ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args)))
      ((<>) `(not (equal? ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
                       ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args))))
      ((&) `(and ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
                 ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args)))
      ((\|) `(or ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
                 ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args)))
      ((!) `(not ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)))
      ((true) #t)
      ((false) #f)
      (else (display (localized-message 'translator-error-bool (get_op expr)))'())))
  
  ;; la fun pour le code numrique
  (define (get-num-expr-code fun-name fun-aux expr nb-args)
    (case (get_op expr)
      ((+) `(+ ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args)
               ,(get-expr-code fun-name fun-aux (get_fd expr) nb-args)))
      ((mod) `(modulo ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args)
               ,(get-expr-code fun-name fun-aux (get_fd expr) nb-args)))
      ((div) `(quotient ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args)
               ,(get-expr-code fun-name fun-aux (get_fd expr) nb-args)))
      ((-) (if (binaire? expr)
               `(- ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args)
                   ,(get-expr-code fun-name fun-aux (get_fd expr) nb-args))
               `(- ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args))))
      ((*) `(* ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args)
               ,(get-expr-code fun-name fun-aux (get_fd expr) nb-args)))
      ((/) `(/ ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args)
               ,(get-expr-code fun-name fun-aux (get_fd expr) nb-args)))
      ((&) `(byte-and ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args)
                      ,(get-expr-code fun-name fun-aux (get_fd expr) nb-args)))
      ((\|) `(byte-or ,(get-expr-code fun-name fun-aux (get_fg expr) nb-args)
                      ,(get-expr-code fun-name fun-aux (get_fd expr) nb-args)))
      (else (get_op expr))))
  
  
  
  ;; le code des arguments
  (define (get-args-code fun-name fun-aux args nb-args)
    (if (null? args)
        '()
        (cons (get-expr-code fun-name fun-aux (car args) nb-args)
              (get-args-code fun-name fun-aux (cdr args) nb-args))))
  ;; le code du match
  (define (get-match-code fun-name fun-aux args nb-args)
    (if (null? args)
        '()
        (cons (get-match-expr-code fun-name fun-aux (car args) nb-args)
              (get-match-code fun-name fun-aux (cdr args) nb-args))))
  
  (define (get-match-expr-code fun-name fun-aux expr  nb-args)
    (cond 
      ((and (arbre? expr) (call_op? (get_op expr))) (get-fun-call-code fun-name fun-aux 
                                                                       expr  nb-args))
      ((and (arbre? expr) (eq? '\[\] (get_op expr))) 
       (get-acces-code fun-name fun-aux 
                       expr  nb-args))
      ((tab? expr)
         (if (eq? '\{\} (get_op expr))
          `(vector ,@(get-match-code fun-name fun-aux (get_fd expr) nb-args))))

      ((bool? expr) (get-bool-expr-code fun-name fun-aux expr  nb-args))
      ((k_string? expr) (substring (get_op expr) 1 (- (string-length (get_op expr)) 1)))
      ((or (numeric? expr)
           (int? expr) 
           (k_real? expr))(get-num-expr-code fun-name fun-aux expr  nb-args))
      ((var? expr) (get_op expr))
      ((k_list? expr) (if (feuille? expr)
                          '()
                          `( ,(get-match-expr-code fun-name fun-aux (get_fg expr)  nb-args)
                                . ,(get-match-expr-code fun-name fun-aux (get_fd expr)  nb-args))))
      
      (else (display (localized-message 'translator-error-tree expr))
            expr)))
  
  
  ;; le code des appels de fun
  (define (get-fun-call-code fun-name fun-aux expr nb-args)
    (let ((name (get_fg expr))
          (args (get-args-code fun-name fun-aux (get_fd expr) nb-args)))
      ;; l'optimisation 'jpr'
      (if (and opt-jpr-enabled (eq? fun-name name) (= (length args) nb-args))
          `(,fun-aux (list ,@args))
          `(,name ,@args))))
  
  (define (get-acces-code fun-name fun-aux expr nb-args)
    (specialk-tab-get (get-expr-code fun-name fun-aux (get_fg expr) nb-args)
                      (reverse (get-args-code fun-name fun-aux (get_fd expr) nb-args))))
  
  (define (get-affect-code fun-name fun-aux expr nb-args)
    (specialk-tab-set! (get-expr-code fun-name fun-aux (get_fg expr) nb-args)
                       (reverse (get-args-code fun-name fun-aux (get_fd expr) nb-args))
                       (get-expr-code fun-name fun-aux (get_fdd expr) nb-args)))
  (define (get-swap-code fun-name fun-aux expr nb-args)
    (specialk-tab-swap! (get-expr-code fun-name fun-aux (get_fg expr) nb-args)
                        (reverse (get-args-code fun-name fun-aux (get_fd expr) nb-args))
                        (reverse (get-args-code fun-name fun-aux (get_fdd expr) nb-args))))
  ;; redirige vers la bonne fun s'occupant de tel ou tel traitement
  (define (get-expr-code fun-name fun-aux expr  nb-args)
    (cond 
      ((and (arbre? expr) (call_op? (get_op expr))) (get-fun-call-code fun-name fun-aux 
                                                                       expr  nb-args))
      ((and (arbre? expr) (eq? '\[\] (get_op expr))) 
       (get-acces-code fun-name fun-aux 
                       expr  nb-args))
      ((tab? expr)
       (cond 
         ((eq? '\{\} (get_op expr))
          `(vector ,@(get-args-code fun-name fun-aux (get_fd expr) nb-args)))
         ((eq? '<- (get_op expr)) (get-affect-code fun-name fun-aux 
                                                   expr  nb-args))
         ((eq? '<-> (get_op expr)) (get-swap-code fun-name fun-aux 
                                                  expr  nb-args))))
      ((bool? expr) (get-bool-expr-code fun-name fun-aux expr  nb-args))
      ((k_string? expr) (substring (get_op expr) 1 (- (string-length (get_op expr)) 1)))
      ((eq? ':= (get_op expr))
       (let ((var (get-expr-code fun-name fun-aux (get_fg expr)  nb-args)))
       `(define ,var ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args))))
      ((or (numeric? expr)
           (int? expr) 
           (k_real? expr))(get-num-expr-code fun-name fun-aux expr  nb-args))
      ((var? expr) (get_op expr))
      ((k_list? expr) (if (feuille? expr)
                          '()
                          `(cons ,(get-expr-code fun-name fun-aux (get_fg expr)  nb-args)
                                 ,(get-expr-code fun-name fun-aux (get_fd expr)  nb-args))))
      
      (else (display (localized-message 'translator-error-tree expr))
            expr)))
  
  
  ;; fun to translate a solo right part
  ;; entity  the thing to use
  (define (rhsHandler entity output file)
    (let* ((start-pos (get_start_pos_expr_t entity))
           (end-pos (get_end_pos_expr_t entity)))
    (cons (datum->syntax-object #f 
                                (get-expr-code (gensym) 'fun-aux (get_expr entity) 23)
                                (list file (position-line start-pos) 
                                      (position-col start-pos) 
                                      (position-offset start-pos) 
                                      (- (position-offset end-pos)
                                               (position-offset start-pos))) #f) 
          output)))
  
  ;start at 0, if n>|args| then returns args's last element
  (define (get-arg args n)
    (if (or (zero? n) (null? (cdr args)))
        (car args)
        (get-arg (cdr args) (- n 1)))))
  
