// $Id: spotviewer.cpp,v 1.2 2005/02/25 12:22:16 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "spotviewer.hpp"

#include <ltiDraw.h>

SpotViewer::SpotViewer(const lti::rgbPixel& color)
    : m_color(color)
{
}

void
SpotViewer::apply(const SpotList& spot_list, lti::image& img)
{
    lti::draw< lti::rgbPixel > drawer;

    drawer.use(img);
    drawer.setColor(m_color);

    for (unsigned int i = 0; i < spot_list.spots.size(); ++i) {
        const lti::imatrix& mask(spot_list.spots[i].mask());
        const lti::ipoint& origin(spot_list.spots[i].origin());
#if 0
        lti::channel overlay;
        overlay.castFrom(spot_list.spots[i].mask());
        drawer.overlay(overlay, origin[1], origin[0]);
#endif
        for (int r = 1; r < mask.rows() - 1; ++r) {
            for (int c = 1; c < mask.columns() - 1; ++c) {
                if (mask[r][c] != 0) {
                    if (!mask[r-1][c] || !mask[r][c-1]
                        || !mask[r+1][c] || !mask[r][c+1]) {
                        drawer.set(c + origin[1], r + origin[0]);
                    }
                }
            }
        }
    }
}
