// $Id: spattertool.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "spattertool.hpp"

#include <iostream>

SpatterTool::SpatterTool(const char* tool_name,
                         const char* input_name,
                         const char* output_name,
                         const char* image_name)
    : m_tool_name(tool_name),
      m_input_name(input_name),
      m_output_name(output_name),
      m_image_name(image_name) {}

void
SpatterTool::print_usage() const
{
    std::cerr << "Usage: "
              << m_tool_name
              << " [-i "
              << m_input_name
              << "] [-o "
              << m_output_name
              << "] "
              << m_image_name
              << std::endl;
}

bool
SpatterTool::parse_arguments(int argc, char** argv)
{
    if (argc != 2 && argc != 4 && argc != 6) {
        print_usage();
        return false;
    }

    if (argc == 2) {
        m_image_fname = argv[1];
    } else if (argc == 4) {
        if (std::strcmp(argv[1], "-i") == 0) {
            m_input_fname = std::string(argv[2]);
        } else if (std::strcmp(argv[1], "-o") == 0) {
            m_output_fname = std::string(argv[2]);
        } else {
            print_usage();
            return false;
        }
        m_image_fname = std::string(argv[3]);
    } else if (argc == 6) {
        if (std::strcmp(argv[1], "-i") == 0) {
            m_input_fname = std::string(argv[2]);
            if (std::strcmp(argv[3], "-o") == 0) {
                m_output_fname = std::string(argv[4]);
            } else {
                print_usage();
                return false;
            }
        } else {
            print_usage();
            return false;
        }
        m_image_fname = std::string(argv[5]);
    }

    return true;
}

const std::string&
SpatterTool::input_fname() const
{
    return m_input_fname;
}

const std::string&
SpatterTool::image_fname() const
{
    return m_image_fname;
}

const std::string&
SpatterTool::output_fname() const
{
    return m_output_fname;
}
