// $Id: spatter-spotfinder.cpp,v 1.2 2005/02/25 11:42:48 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include <iostream>
#include <string>
#include <cstdlib>
#include <limits>

#include <ltiALLFunctor.h>
#include <ltiPoint.h>
#include <ltiMatrix.h>
#include <ltiImage.h>
#include <ltiDraw.h>

#include "grid.hpp"
#include "spotlist.hpp"
#include "spotter.hpp"
#include "spattertool.hpp"


int
main(int argc, char** argv)
{
    SpatterTool tool("spatter-spotfinder",
                     "gridfile",
                     "spotlistfile",
                     "imagefile");

    if (!tool.parse_arguments(argc, argv)) {
        return 0;
    }

    // Load the input data
    Grid grid;
    if (tool.input_fname().empty()) {
        grid.load(std::cin);
    } else {
        std::ifstream in(tool.input_fname().c_str());
        grid.load(in);
    }
    SpotList spots;

    try {
        // Load the image data
        lti::loadImage loader;
        lti::image img;
        loader.load(tool.image_fname(), img);

        // Run the tool
        spatter::spotlist_find(grid, img, spots);
    } catch (lti::exception& exp) {
        std::cerr << "An lti::exception was thrown: "
                  << exp.what() << std::endl;
        return 1;
    } catch (std::exception& exp) {
        std::cerr << "std::exception was thrown: "
                  << exp.what() << std::endl;
        return 1;
    } catch (...) {
        std::cerr << "Unknown exception thrown!"
                  << std::endl;
        return 1;
    }

    // Save the output data
    if (tool.output_fname().empty()) {
        spots.save(std::cout);
    } else {
        std::ofstream out(tool.output_fname().c_str());
        spots.save(out);
    }

    return 0;
}
