// $Id: gridviewer.cpp,v 1.1 2005/02/18 10:26:43 grosskur Exp $
//
// Copyright (C) 2003 Alan Grosskurth
//
// This file is part of Spatter.
//
// Spatter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Spatter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Spatter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#include "gridviewer.hpp"

#include <ltiDraw.h>

GridViewer::GridViewer(const lti::rgbPixel color)
    : m_color(color)
{
}

void
GridViewer::apply(const Grid& grid, lti::image& img)
{
    lti::draw< lti::rgbPixel > drawer;

    drawer.use(img);
    drawer.setColor(m_color);

    for (int i = 0; i < grid.size()[0]; ++i) {
        for (int j = 0; j < grid.size()[1]; ++j) {
            for (int r = 0; r < grid.subgrid_size()[0]; ++r) {
                for (int c = 0; c < grid.subgrid_size()[1]; ++c) {
                    // Top
                    drawer.line(grid.subgrid_node(i, j, r, c)[1],
                                grid.subgrid_node(i, j, r, c)[0],
                                grid.subgrid_node(i, j, r, c+1)[1],
                                grid.subgrid_node(i, j, r, c+1)[0]);

                    // Bottom
                    drawer.line(grid.subgrid_node(i, j, r+1, c)[1],
                                grid.subgrid_node(i, j, r+1, c)[0],
                                grid.subgrid_node(i, j, r+1, c+1)[1],
                                grid.subgrid_node(i, j, r+1, c+1)[0]);

                    // Left
                    drawer.line(grid.subgrid_node(i, j, r, c)[1],
                                grid.subgrid_node(i, j, r, c)[0],
                                grid.subgrid_node(i, j, r+1, c)[1],
                                grid.subgrid_node(i, j, r+1, c)[0]);

                    // Right
                    drawer.line(grid.subgrid_node(i, j, r, c+1)[1],
                                grid.subgrid_node(i, j, r, c+1)[0],
                                grid.subgrid_node(i, j, r+1, c+1)[1],
                                grid.subgrid_node(i, j, r+1, c+1)[0]);
                }
            }
        }
    }
}
